/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OffsetsForLeaderEpochRequestTest {
    @Test
    public void testForConsumerRequiresVersion3() {
        short version;
        OffsetsForLeaderEpochRequest.Builder builder = OffsetsForLeaderEpochRequest.Builder.forConsumer((OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection());
        for (version = 0; version < 3; version = (short)(version + 1)) {
            short v = version;
            Assertions.assertThrows(UnsupportedVersionException.class, () -> builder.build(v));
        }
        for (version = 3; version <= ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(); version = (short)(version + 1)) {
            OffsetsForLeaderEpochRequest request = builder.build(version);
            Assertions.assertEquals((int)-1, (int)request.replicaId());
        }
    }

    @Test
    public void testForFollower() {
        short version = 4;
        int replicaId = 1;
        OffsetsForLeaderEpochRequest.Builder builder = OffsetsForLeaderEpochRequest.Builder.forFollower((OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(), (int)replicaId);
        OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)builder.build();
        OffsetsForLeaderEpochRequest parsed = OffsetsForLeaderEpochRequest.parse((Readable)request.serialize(), (short)version);
        Assertions.assertEquals((int)replicaId, (int)parsed.replicaId());
    }
}

