/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ClientCredentialsRequestFormatter;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ClientCredentialsRequestFormatterTest
extends OAuthBearerTest {
    public static final String CLIENT_ID = "jdoe";
    public static final String CLIENT_SECRET = "secret";
    public static final String SCOPE = "everythingeverything";

    @Test
    public void testFormatAuthorizationHeaderEncoding() {
        this.assertAuthorizationHeaderEquals("SOME_RANDOM_LONG_USER_01234", "9Q|0`8i~ute-n9ksjLWb\\50\"AX@UUED5E", false, "Basic U09NRV9SQU5ET01fTE9OR19VU0VSXzAxMjM0OjlRfDBgOGl+dXRlLW45a3NqTFdiXDUwIkFYQFVVRUQ1RQ==");
        this.assertAuthorizationHeaderEquals("user!@~'", "secret-(*)!", true, "Basic dXNlciUyMSU0MCU3RSUyNzpzZWNyZXQtJTI4KiUyOSUyMQ==");
    }

    @ParameterizedTest
    @MethodSource(value={"testFormatterMissingValuesSource"})
    public void testFormatterMissingValues(String clientId, String clientSecret, boolean urlencode) {
        Assertions.assertThrows(ConfigException.class, () -> new ClientCredentialsRequestFormatter(clientId, clientSecret, SCOPE, urlencode));
    }

    @ParameterizedTest
    @MethodSource(value={"testScopeEscapingSource"})
    public void testScopeEscaping(String scope, boolean urlencode, String expectedScope) {
        String expected = "grant_type=client_credentials&scope=" + expectedScope;
        this.assertRequestBodyEquals(scope, urlencode, expected);
    }

    @ParameterizedTest
    @MethodSource(value={"testMissingScopesSource"})
    public void testMissingScopes(String scope, boolean urlencode) {
        String expected = "grant_type=client_credentials";
        this.assertRequestBodyEquals(scope, urlencode, expected);
    }

    private static Stream<Arguments> testFormatterMissingValuesSource() {
        String[] clientIds = new String[]{null, "", "  ", CLIENT_ID};
        String[] clientSecrets = new String[]{null, "", "  ", CLIENT_SECRET};
        boolean[] urlencodes = new boolean[]{true, false};
        ArrayList<Arguments> list = new ArrayList<Arguments>();
        for (String clientId : clientIds) {
            for (String clientSecret : clientSecrets) {
                for (boolean urlencode : urlencodes) {
                    if (CLIENT_ID.equals(clientId) && CLIENT_SECRET.equals(clientSecret)) continue;
                    list.add(Arguments.of((Object[])new Object[]{clientId, clientSecret, urlencode}));
                }
            }
        }
        return list.stream();
    }

    private static Stream<Arguments> testMissingScopesSource() {
        String[] scopes = new String[]{null, "", "  "};
        boolean[] urlencodes = new boolean[]{true, false};
        ArrayList<Arguments> list = new ArrayList<Arguments>();
        for (String scope : scopes) {
            for (boolean urlencode : urlencodes) {
                list.add(Arguments.of((Object[])new Object[]{scope, urlencode}));
            }
        }
        return list.stream();
    }

    private static Stream<Arguments> testScopeEscapingSource() {
        return Stream.of(Arguments.of((Object[])new Object[]{"test-scope", true, "test-scope"}), Arguments.of((Object[])new Object[]{"test-scope", false, "test-scope"}), Arguments.of((Object[])new Object[]{"earth is great!", true, "earth+is+great%21"}), Arguments.of((Object[])new Object[]{"earth is great!", false, "earth is great!"}), Arguments.of((Object[])new Object[]{"what on earth?!?!?", true, "what+on+earth%3F%21%3F%21%3F"}), Arguments.of((Object[])new Object[]{"what on earth?!?!?", false, "what on earth?!?!?"}));
    }

    private void assertRequestBodyEquals(String scope, boolean urlencode, String expected) {
        ClientCredentialsRequestFormatter formatter = new ClientCredentialsRequestFormatter(CLIENT_ID, CLIENT_SECRET, scope, urlencode);
        String actual = formatter.formatBody();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private void assertAuthorizationHeaderEquals(String clientId, String clientSecret, boolean urlencode, String expected) {
        ClientCredentialsRequestFormatter formatter = new ClientCredentialsRequestFormatter(clientId, clientSecret, SCOPE, urlencode);
        Map headers = formatter.formatHeaders();
        String actual = (String)headers.get("Authorization");
        Assertions.assertEquals((Object)expected, (Object)actual, (String)String.format("Expected the HTTP Authorization header generated for client ID \"%s\" and client secret \"%s\" to match", clientId, clientSecret));
    }
}

