/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;
import org.apache.kafka.common.security.oauthbearer.internals.secured.Retryable;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.lang.JoseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class OAuthBearerTest {
    protected ObjectMapper mapper = new ObjectMapper();

    protected void assertThrowsWithMessage(Class<? extends Exception> clazz, Executable executable, String substring) {
        this.assertErrorMessageContains(((Exception)Assertions.assertThrows(clazz, (Executable)executable)).getMessage(), substring);
    }

    protected void assertErrorMessageContains(String actual, String expectedSubstring) {
        Assertions.assertTrue((boolean)actual.contains(expectedSubstring), (String)String.format("Expected exception message (\"%s\") to contain substring (\"%s\")", actual, expectedSubstring));
    }

    protected String createBase64JsonJwtSection(Consumer<ObjectNode> c) {
        String json = this.createJsonJwtSection(c);
        try {
            return Utils.utf8((byte[])Base64.getEncoder().encode(Utils.utf8((String)json)));
        }
        catch (Throwable t) {
            Assertions.fail((Throwable)t);
            return null;
        }
    }

    protected String createJsonJwtSection(Consumer<ObjectNode> c) {
        ObjectNode node = this.mapper.createObjectNode();
        c.accept(node);
        try {
            return this.mapper.writeValueAsString((Object)node);
        }
        catch (Throwable t) {
            Assertions.fail((Throwable)t);
            return null;
        }
    }

    protected Retryable<String> createRetryable(Exception[] attempts) {
        Iterator<Exception> i = Arrays.asList(attempts).iterator();
        return () -> {
            Exception e;
            Exception exception = e = i.hasNext() ? (Exception)i.next() : null;
            if (e == null) {
                return "success!";
            }
            if (e instanceof IOException) {
                throw new ExecutionException(e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        };
    }

    protected HttpURLConnection createHttpURLConnection(String response) throws IOException {
        HttpURLConnection mockedCon = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)mockedCon.getURL()).thenReturn((Object)new URL("https://www.example.com"));
        Mockito.when((Object)mockedCon.getResponseCode()).thenReturn((Object)200);
        Mockito.when((Object)mockedCon.getOutputStream()).thenReturn((Object)new ByteArrayOutputStream());
        Mockito.when((Object)mockedCon.getInputStream()).thenReturn((Object)new ByteArrayInputStream(Utils.utf8((String)response)));
        return mockedCon;
    }

    protected Map<String, ?> getSaslConfigs(Map<String, ?> configs) {
        ConfigDef configDef = new ConfigDef();
        configDef.withClientSaslSupport();
        AbstractConfig sslClientConfig = new AbstractConfig(configDef, configs);
        return sslClientConfig.values();
    }

    protected Map<String, ?> getSaslConfigs(String name, Object value) {
        return this.getSaslConfigs(Collections.singletonMap(name, value));
    }

    protected Map<String, ?> getSaslConfigs() {
        return this.getSaslConfigs(Collections.emptyMap());
    }

    protected List<AppConfigurationEntry> getJaasConfigEntries() {
        return this.getJaasConfigEntries(Map.of());
    }

    protected List<AppConfigurationEntry> getJaasConfigEntries(Map<String, ?> options) {
        return List.of(new AppConfigurationEntry(OAuthBearerLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options));
    }

    protected PublicJsonWebKey createRsaJwk() throws JoseException {
        RsaJsonWebKey jwk = RsaJwkGenerator.generateJwk((int)2048);
        jwk.setKeyId("key-1");
        return jwk;
    }

    protected PublicJsonWebKey createEcJwk() throws JoseException {
        PublicJsonWebKey jwk = PublicJsonWebKey.Factory.newPublicJwk((String)"{  \"kty\": \"EC\",  \"d\": \"Tk7qzHNnSBMioAU7NwZ9JugFWmWbUCyzeBRjVcTp_so\",  \"use\": \"sig\",  \"crv\": \"P-256\",  \"kid\": \"key-1\",  \"x\": \"qqeGjWmYZU5M5bBrRw1zqZcbPunoFVxsfaa9JdA0R5I\",  \"y\": \"wnoj0YjheNP80XYh1SEvz1-wnKByEoHvb6KrDcjMuWc\"}");
        jwk.setKeyId("key-1");
        return jwk;
    }

    protected String createJwt(String header, String payload, String signature) {
        Base64.Encoder enc = Base64.getEncoder();
        header = enc.encodeToString(Utils.utf8((String)header));
        payload = enc.encodeToString(Utils.utf8((String)payload));
        signature = enc.encodeToString(Utils.utf8((String)signature));
        return String.format("%s.%s.%s", header, payload, signature);
    }

    protected String createJwt(String subject) {
        Time time = Time.SYSTEM;
        long nowSeconds = time.milliseconds() / 1000L;
        return this.createJwt("{}", String.format("{\"iat\":%s, \"exp\":%s, \"sub\":\"%s\"}", nowSeconds, nowSeconds + 300L, subject), "sign");
    }

    protected void assertClaims(PublicKey publicKey, String assertion) throws InvalidJwtException {
        JwtConsumer jwtConsumer = this.jwtConsumer(publicKey);
        jwtConsumer.processToClaims(assertion);
    }

    protected JwtContext assertContext(PublicKey publicKey, String assertion) throws InvalidJwtException {
        JwtConsumer jwtConsumer = this.jwtConsumer(publicKey);
        return jwtConsumer.process(assertion);
    }

    protected JwtConsumer jwtConsumer(PublicKey publicKey) {
        return new JwtConsumerBuilder().setVerificationKey((Key)publicKey).setRequireExpirationTime().setAllowedClockSkewInSeconds(30).build();
    }

    protected File generatePrivateKey(PrivateKey privateKey) throws IOException {
        File file = File.createTempFile("private-", ".key");
        byte[] bytes = Base64.getEncoder().encode(privateKey.getEncoded());
        try (FileChannel channel = FileChannel.open(file.toPath(), EnumSet.of(StandardOpenOption.WRITE), new FileAttribute[0]);){
            Utils.writeFully((FileChannel)channel, (ByteBuffer)ByteBuffer.wrap(bytes));
        }
        return file;
    }

    protected File generatePrivateKey() throws IOException {
        return this.generatePrivateKey(this.generateKeyPair().getPrivate());
    }

    protected KeyPair generateKeyPair() {
        return this.generateKeyPair("RSA");
    }

    protected KeyPair generateKeyPair(String algorithm) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
            keyGen.initialize(2048);
            return keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Received unexpected error during private key generation", e);
        }
    }
}

