/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils.annotation;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsProvider;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.Mockito;

public class ApiKeyVersionsProviderTest {
    @Test
    void testProvideArgumentsWithExplicitRange() {
        ApiKeyVersionsProvider provider = new ApiKeyVersionsProvider();
        ApiKeyVersionsSource mockSource = (ApiKeyVersionsSource)Mockito.mock(ApiKeyVersionsSource.class);
        Mockito.when((Object)mockSource.apiKey()).thenReturn((Object)ApiKeys.FETCH);
        Mockito.when((Object)mockSource.fromVersion()).thenReturn((Object)5);
        Mockito.when((Object)mockSource.toVersion()).thenReturn((Object)7);
        Mockito.when((Object)mockSource.enableUnstableLastVersion()).thenReturn((Object)false);
        provider.accept(mockSource);
        List versions = provider.provideArguments((ExtensionContext)Mockito.mock(ExtensionContext.class)).map(arg -> (Short)arg.get()[0]).collect(Collectors.toList());
        Assertions.assertEquals(List.of(Short.valueOf((short)5), Short.valueOf((short)6), Short.valueOf((short)7)), versions);
    }

    @Test
    void testProvideArgumentsWithDefaultRange() {
        ApiKeyVersionsProvider provider = new ApiKeyVersionsProvider();
        ApiKeyVersionsSource mockSource = (ApiKeyVersionsSource)Mockito.mock(ApiKeyVersionsSource.class);
        Mockito.when((Object)mockSource.apiKey()).thenReturn((Object)ApiKeys.METADATA);
        Mockito.when((Object)mockSource.fromVersion()).thenReturn((Object)-1);
        Mockito.when((Object)mockSource.toVersion()).thenReturn((Object)-1);
        Mockito.when((Object)mockSource.enableUnstableLastVersion()).thenReturn((Object)false);
        provider.accept(mockSource);
        short oldest = ApiKeys.METADATA.oldestVersion();
        short latest = ApiKeys.METADATA.latestVersion(false);
        List versions = provider.provideArguments((ExtensionContext)Mockito.mock(ExtensionContext.class)).map(arg -> (Short)arg.get()[0]).collect(Collectors.toList());
        List expected = IntStream.rangeClosed(oldest, latest).mapToObj(i -> (short)i).collect(Collectors.toList());
        Assertions.assertEquals(expected, versions);
    }

    @Test
    void testInvalidRangeThrowsExceptionFromGreaterThanTo() {
        ApiKeyVersionsProvider provider = new ApiKeyVersionsProvider();
        ApiKeyVersionsSource mockSource = (ApiKeyVersionsSource)Mockito.mock(ApiKeyVersionsSource.class);
        Mockito.when((Object)mockSource.apiKey()).thenReturn((Object)ApiKeys.FETCH);
        Mockito.when((Object)mockSource.fromVersion()).thenReturn((Object)10);
        Mockito.when((Object)mockSource.toVersion()).thenReturn((Object)5);
        Mockito.when((Object)mockSource.enableUnstableLastVersion()).thenReturn((Object)false);
        Assertions.assertThrows(IllegalArgumentException.class, () -> provider.accept(mockSource));
    }

    @Test
    void testFromVersionTooOldThrowsException() {
        ApiKeyVersionsProvider provider = new ApiKeyVersionsProvider();
        ApiKeyVersionsSource mockSource = (ApiKeyVersionsSource)Mockito.mock(ApiKeyVersionsSource.class);
        Mockito.when((Object)mockSource.apiKey()).thenReturn((Object)ApiKeys.FETCH);
        Mockito.when((Object)mockSource.fromVersion()).thenReturn((Object)((short)(ApiKeys.FETCH.oldestVersion() - 1)));
        Mockito.when((Object)mockSource.toVersion()).thenReturn((Object)10);
        Mockito.when((Object)mockSource.enableUnstableLastVersion()).thenReturn((Object)false);
        Assertions.assertThrows(IllegalArgumentException.class, () -> provider.accept(mockSource));
    }

    @Test
    void testToVersionTooNewThrowsException() {
        ApiKeyVersionsProvider provider = new ApiKeyVersionsProvider();
        ApiKeyVersionsSource mockSource = (ApiKeyVersionsSource)Mockito.mock(ApiKeyVersionsSource.class);
        Mockito.when((Object)mockSource.apiKey()).thenReturn((Object)ApiKeys.FETCH);
        Mockito.when((Object)mockSource.fromVersion()).thenReturn((Object)0);
        Mockito.when((Object)mockSource.toVersion()).thenReturn((Object)((short)(ApiKeys.FETCH.latestVersion(true) + 1)));
        Mockito.when((Object)mockSource.enableUnstableLastVersion()).thenReturn((Object)true);
        Assertions.assertThrows(IllegalArgumentException.class, () -> provider.accept(mockSource));
    }
}

