/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.internals.QuotaConfigs;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metadata.QuotaRecord;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;

public class ClientQuotaControlManager {
    private final SnapshotRegistry snapshotRegistry;
    final TimelineHashMap<ClientQuotaEntity, Map<String, Double>> clientQuotaData;

    ClientQuotaControlManager(SnapshotRegistry snapshotRegistry) {
        this.snapshotRegistry = snapshotRegistry;
        this.clientQuotaData = new TimelineHashMap(snapshotRegistry, 0);
    }

    ControllerResult<Map<ClientQuotaEntity, ApiError>> alterClientQuotas(Collection<ClientQuotaAlteration> quotaAlterations) {
        ArrayList<ApiMessageAndVersion> outputRecords = new ArrayList<ApiMessageAndVersion>();
        HashMap outputResults = new HashMap();
        quotaAlterations.forEach(quotaAlteration -> {
            HashMap<String, Double> alterations = new HashMap<String, Double>(quotaAlteration.ops().size());
            quotaAlteration.ops().forEach(op -> {
                if (alterations.containsKey(op.key())) {
                    outputResults.put(quotaAlteration.entity(), ApiError.fromThrowable((Throwable)new InvalidRequestException("Duplicate quota key " + op.key() + " not updating quota for this entity " + quotaAlteration.entity())));
                } else {
                    alterations.put(op.key(), op.value());
                }
            });
            if (outputResults.containsKey(quotaAlteration.entity())) {
                outputResults.put(quotaAlteration.entity(), ApiError.fromThrowable((Throwable)new InvalidRequestException("Ignoring duplicate entity " + quotaAlteration.entity())));
            } else {
                this.alterClientQuotaEntity(quotaAlteration.entity(), alterations, outputRecords, outputResults);
            }
        });
        return ControllerResult.atomicOf(outputRecords, outputResults);
    }

    public void replay(QuotaRecord record) {
        HashMap entityMap = new HashMap(2);
        record.entity().forEach(entityData -> entityMap.put(entityData.entityType(), entityData.entityName()));
        ClientQuotaEntity entity = new ClientQuotaEntity(entityMap);
        Map<String, Double> quotas = this.clientQuotaData.get(entity);
        if (quotas == null) {
            quotas = new TimelineHashMap<String, Double>(this.snapshotRegistry, 0);
            this.clientQuotaData.put(entity, quotas);
        }
        if (record.remove()) {
            quotas.remove(record.key());
            if (quotas.size() == 0) {
                this.clientQuotaData.remove(entity);
            }
        } else {
            quotas.put(record.key(), record.value());
        }
    }

    private void alterClientQuotaEntity(ClientQuotaEntity entity, Map<String, Double> newQuotaConfigs, List<ApiMessageAndVersion> outputRecords, Map<ClientQuotaEntity, ApiError> outputResults) {
        HashMap<String, String> validatedEntityMap = new HashMap<String, String>(3);
        ApiError error = this.validateEntity(entity, validatedEntityMap);
        if (error.isFailure()) {
            outputResults.put(entity, error);
            return;
        }
        HashMap<String, ConfigDef.ConfigKey> configKeys = new HashMap<String, ConfigDef.ConfigKey>(4);
        error = this.configKeysForEntityType(validatedEntityMap, configKeys);
        if (error.isFailure()) {
            outputResults.put(entity, error);
            return;
        }
        Supplier<List> recordEntitySupplier = () -> validatedEntityMap.entrySet().stream().map(mapEntry -> new QuotaRecord.EntityData().setEntityType((String)mapEntry.getKey()).setEntityName((String)mapEntry.getValue())).collect(Collectors.toList());
        ArrayList newRecords = new ArrayList(newQuotaConfigs.size());
        Map currentQuotas = this.clientQuotaData.getOrDefault(entity, Collections.emptyMap());
        newQuotaConfigs.forEach((key, newValue) -> {
            if (newValue == null) {
                if (currentQuotas.containsKey(key)) {
                    newRecords.add(new ApiMessageAndVersion(new QuotaRecord().setEntity((List)recordEntitySupplier.get()).setKey((String)key).setRemove(true), 0));
                }
            } else {
                ApiError validationError = this.validateQuotaKeyValue((Map<String, ConfigDef.ConfigKey>)configKeys, (String)key, (Double)newValue);
                if (validationError.isFailure()) {
                    outputResults.put(entity, validationError);
                } else {
                    Double currentValue = (Double)currentQuotas.get(key);
                    if (!Objects.equals(currentValue, newValue)) {
                        newRecords.add(new ApiMessageAndVersion(new QuotaRecord().setEntity((List)recordEntitySupplier.get()).setKey((String)key).setValue((double)newValue), 0));
                    }
                }
            }
        });
        outputRecords.addAll(newRecords);
        outputResults.put(entity, ApiError.NONE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ApiError configKeysForEntityType(Map<String, String> entity, Map<String, ConfigDef.ConfigKey> output) {
        Map configKeys;
        boolean hasUser = entity.containsKey("user");
        boolean hasClientId = entity.containsKey("client-id");
        boolean hasIp = entity.containsKey("ip");
        if (hasUser && hasClientId && !hasIp) {
            configKeys = QuotaConfigs.userConfigs().configKeys();
        } else if (hasUser && !hasClientId && !hasIp) {
            configKeys = QuotaConfigs.userConfigs().configKeys();
        } else if (!hasUser && hasClientId && !hasIp) {
            configKeys = QuotaConfigs.clientConfigs().configKeys();
        } else {
            if (hasUser || hasClientId || !hasIp) return new ApiError(Errors.INVALID_REQUEST, "Invalid empty client quota entity");
            if (!this.isValidIpEntity(entity.get("ip"))) return new ApiError(Errors.INVALID_REQUEST, entity.get("ip") + " is not a valid IP or resolvable host.");
            configKeys = QuotaConfigs.ipConfigs().configKeys();
        }
        output.putAll(configKeys);
        return ApiError.NONE;
    }

    private ApiError validateQuotaKeyValue(Map<String, ConfigDef.ConfigKey> validKeys, String key, Double value) {
        ConfigDef.ConfigKey configKey = validKeys.get(key);
        if (configKey == null) {
            return new ApiError(Errors.INVALID_REQUEST, "Invalid configuration key " + key);
        }
        switch (configKey.type()) {
            case DOUBLE: {
                break;
            }
            case LONG: {
                Double epsilon = 1.0E-6;
                Long longValue = Double.valueOf(value + epsilon).longValue();
                if (!(Math.abs(longValue.doubleValue() - value) > epsilon)) break;
                return new ApiError(Errors.INVALID_REQUEST, "Configuration " + key + " must be a Long value");
            }
            default: {
                return new ApiError(Errors.UNKNOWN_SERVER_ERROR, "Unexpected config type " + configKey.type() + " should be Long or Double");
            }
        }
        return ApiError.NONE;
    }

    private boolean isValidIpEntity(String ip) {
        if (Objects.nonNull(ip)) {
            try {
                InetAddress.getByName(ip);
                return true;
            }
            catch (UnknownHostException e) {
                return false;
            }
        }
        return true;
    }

    private ApiError validateEntity(ClientQuotaEntity entity, Map<String, String> validatedEntityMap) {
        if (entity.entries().isEmpty()) {
            return new ApiError(Errors.INVALID_REQUEST, "Invalid empty client quota entity");
        }
        for (Map.Entry entityEntry : entity.entries().entrySet()) {
            String entityType = (String)entityEntry.getKey();
            String entityName = (String)entityEntry.getValue();
            if (validatedEntityMap.containsKey(entityType)) {
                return new ApiError(Errors.INVALID_REQUEST, "Invalid empty client quota entity, duplicate entity entry " + entityType);
            }
            if (Objects.equals(entityType, "user")) {
                validatedEntityMap.put("user", entityName);
            } else if (Objects.equals(entityType, "client-id")) {
                validatedEntityMap.put("client-id", entityName);
            } else if (Objects.equals(entityType, "ip")) {
                validatedEntityMap.put("ip", entityName);
            } else {
                return new ApiError(Errors.INVALID_REQUEST, "Unhandled client quota entity type: " + entityType);
            }
            if (entityName == null || !entityName.isEmpty()) continue;
            return new ApiError(Errors.INVALID_REQUEST, "Empty " + entityType + " not supported");
        }
        return ApiError.NONE;
    }
}

