/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Collections;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.controller.ClusterControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineLong;
import org.apache.kafka.timeline.TimelineObject;

public class ProducerIdControlManager {
    private final ClusterControlManager clusterControlManager;
    private final TimelineObject<ProducerIdsBlock> nextProducerBlock;
    private final TimelineLong brokerEpoch;

    ProducerIdControlManager(ClusterControlManager clusterControlManager, SnapshotRegistry snapshotRegistry) {
        this.clusterControlManager = clusterControlManager;
        this.nextProducerBlock = new TimelineObject(snapshotRegistry, (Object)ProducerIdsBlock.EMPTY);
        this.brokerEpoch = new TimelineLong(snapshotRegistry);
    }

    ControllerResult<ProducerIdsBlock> generateNextProducerId(int brokerId, long brokerEpoch) {
        this.clusterControlManager.checkBrokerEpoch(brokerId, brokerEpoch);
        long firstProducerIdInBlock = ((ProducerIdsBlock)this.nextProducerBlock.get()).firstProducerId();
        if (firstProducerIdInBlock > 9223372036854774807L) {
            throw new UnknownServerException("Exhausted all producerIds as the next block's end producerId has exceeded the int64 type limit");
        }
        ProducerIdsBlock block = new ProducerIdsBlock(brokerId, firstProducerIdInBlock, 1000);
        long newNextProducerId = block.nextBlockFirstId();
        ProducerIdsRecord record = new ProducerIdsRecord().setNextProducerId(newNextProducerId).setBrokerId(brokerId).setBrokerEpoch(brokerEpoch);
        return ControllerResult.of(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)record, 0)), block);
    }

    ProducerIdsBlock nextProducerBlock() {
        return (ProducerIdsBlock)this.nextProducerBlock.get();
    }

    void replay(ProducerIdsRecord record) {
        ProducerIdsBlock nextBlock = (ProducerIdsBlock)this.nextProducerBlock.get();
        if (nextBlock != ProducerIdsBlock.EMPTY && record.nextProducerId() <= nextBlock.firstProducerId()) {
            throw new RuntimeException("Next Producer ID from replayed record (" + record.nextProducerId() + ") is not greater than current next Producer ID (" + nextBlock.firstProducerId() + ")");
        }
        this.nextProducerBlock.set((Object)new ProducerIdsBlock(record.brokerId(), record.nextProducerId(), 1000));
        this.brokerEpoch.set(record.brokerEpoch());
    }
}

