/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.raft.RaftMessage;

public abstract class RaftRequest
implements RaftMessage {
    protected final int correlationId;
    protected final ApiMessage data;
    protected final long createdTimeMs;

    public RaftRequest(int correlationId, ApiMessage data, long createdTimeMs) {
        this.correlationId = correlationId;
        this.data = data;
        this.createdTimeMs = createdTimeMs;
    }

    @Override
    public int correlationId() {
        return this.correlationId;
    }

    @Override
    public ApiMessage data() {
        return this.data;
    }

    public long createdTimeMs() {
        return this.createdTimeMs;
    }

    public static class Outbound
    extends RaftRequest {
        private final int destinationId;

        public Outbound(int correlationId, ApiMessage data, int destinationId, long createdTimeMs) {
            super(correlationId, data, createdTimeMs);
            this.destinationId = destinationId;
        }

        public int destinationId() {
            return this.destinationId;
        }

        public String toString() {
            return "OutboundRequest(correlationId=" + this.correlationId + ", data=" + this.data + ", createdTimeMs=" + this.createdTimeMs + ", destinationId=" + this.destinationId + ')';
        }
    }

    public static class Inbound
    extends RaftRequest {
        public Inbound(int correlationId, ApiMessage data, long createdTimeMs) {
            super(correlationId, data, createdTimeMs);
        }

        public String toString() {
            return "InboundRequest(correlationId=" + this.correlationId + ", data=" + this.data + ", createdTimeMs=" + this.createdTimeMs + ')';
        }
    }
}

