/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.timeline.Snapshot;
import org.apache.kafka.timeline.SnapshotRegistry;

public class TrackingSnapshotRegistry
extends SnapshotRegistry {
    private final List<String> operations = new ArrayList<String>();

    public TrackingSnapshotRegistry(LogContext logContext) {
        super(logContext);
    }

    public List<String> operations() {
        return new ArrayList<String>(this.operations);
    }

    public void revertToSnapshot(long targetEpoch) {
        this.operations.add("revert[" + targetEpoch + "]");
        super.revertToSnapshot(targetEpoch);
    }

    public void reset() {
        this.operations.add("reset");
        super.reset();
    }

    public Snapshot getOrCreateSnapshot(long epoch) {
        if (!this.hasSnapshot(epoch)) {
            this.operations.add("snapshot[" + epoch + "]");
        }
        return super.getOrCreateSnapshot(epoch);
    }
}

