/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;

@InterfaceStability.Evolving
public class RemoteLogSegmentMetadata
extends RemoteLogMetadata {
    private final RemoteLogSegmentId remoteLogSegmentId;
    private final long startOffset;
    private final long endOffset;
    private final long maxTimestampMs;
    private final NavigableMap<Integer, Long> segmentLeaderEpochs;
    private final int segmentSizeInBytes;
    private final RemoteLogSegmentState state;

    public RemoteLogSegmentMetadata(RemoteLogSegmentId remoteLogSegmentId, long startOffset, long endOffset, long maxTimestampMs, int brokerId, long eventTimestampMs, int segmentSizeInBytes, RemoteLogSegmentState state, Map<Integer, Long> segmentLeaderEpochs) {
        super(brokerId, eventTimestampMs);
        this.remoteLogSegmentId = Objects.requireNonNull(remoteLogSegmentId, "remoteLogSegmentId can not be null");
        this.state = Objects.requireNonNull(state, "state can not be null");
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.maxTimestampMs = maxTimestampMs;
        this.segmentSizeInBytes = segmentSizeInBytes;
        if (segmentLeaderEpochs == null || segmentLeaderEpochs.isEmpty()) {
            throw new IllegalArgumentException("segmentLeaderEpochs can not be null or empty");
        }
        this.segmentLeaderEpochs = Collections.unmodifiableNavigableMap(new TreeMap<Integer, Long>(segmentLeaderEpochs));
    }

    public RemoteLogSegmentMetadata(RemoteLogSegmentId remoteLogSegmentId, long startOffset, long endOffset, long maxTimestampMs, int brokerId, long eventTimestampMs, int segmentSizeInBytes, Map<Integer, Long> segmentLeaderEpochs) {
        this(remoteLogSegmentId, startOffset, endOffset, maxTimestampMs, brokerId, eventTimestampMs, segmentSizeInBytes, RemoteLogSegmentState.COPY_SEGMENT_STARTED, segmentLeaderEpochs);
    }

    public RemoteLogSegmentId remoteLogSegmentId() {
        return this.remoteLogSegmentId;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public int segmentSizeInBytes() {
        return this.segmentSizeInBytes;
    }

    public long maxTimestampMs() {
        return this.maxTimestampMs;
    }

    public NavigableMap<Integer, Long> segmentLeaderEpochs() {
        return this.segmentLeaderEpochs;
    }

    public RemoteLogSegmentState state() {
        return this.state;
    }

    public RemoteLogSegmentMetadata createWithUpdates(RemoteLogSegmentMetadataUpdate rlsmUpdate) {
        if (!this.remoteLogSegmentId.equals(rlsmUpdate.remoteLogSegmentId())) {
            throw new IllegalArgumentException("Given rlsmUpdate does not have this instance's remoteLogSegmentId.");
        }
        return new RemoteLogSegmentMetadata(this.remoteLogSegmentId, this.startOffset, this.endOffset, this.maxTimestampMs, rlsmUpdate.brokerId(), rlsmUpdate.eventTimestampMs(), this.segmentSizeInBytes, rlsmUpdate.state(), this.segmentLeaderEpochs);
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.remoteLogSegmentId.topicIdPartition();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteLogSegmentMetadata that = (RemoteLogSegmentMetadata)o;
        return this.startOffset == that.startOffset && this.endOffset == that.endOffset && this.maxTimestampMs == that.maxTimestampMs && this.segmentSizeInBytes == that.segmentSizeInBytes && Objects.equals(this.remoteLogSegmentId, that.remoteLogSegmentId) && Objects.equals(this.segmentLeaderEpochs, that.segmentLeaderEpochs) && this.state == that.state && this.eventTimestampMs() == that.eventTimestampMs() && this.brokerId() == that.brokerId();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.remoteLogSegmentId, this.startOffset, this.endOffset, this.brokerId(), this.maxTimestampMs, this.eventTimestampMs(), this.segmentLeaderEpochs, this.segmentSizeInBytes, this.state});
    }

    public String toString() {
        return "RemoteLogSegmentMetadata{remoteLogSegmentId=" + this.remoteLogSegmentId + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", brokerId=" + this.brokerId() + ", maxTimestampMs=" + this.maxTimestampMs + ", eventTimestampMs=" + this.eventTimestampMs() + ", segmentLeaderEpochs=" + this.segmentLeaderEpochs + ", segmentSizeInBytes=" + this.segmentSizeInBytes + ", state=" + (Object)((Object)this.state) + '}';
    }
}

