/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.AbstractStoreBuilder;
import org.apache.kafka.streams.state.internals.CachingSessionStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingSessionBytesStore;
import org.apache.kafka.streams.state.internals.MeteredSessionStore;

public class SessionStoreBuilder<K, V>
extends AbstractStoreBuilder<K, V, SessionStore<K, V>> {
    private final SessionBytesStoreSupplier storeSupplier;

    public SessionStoreBuilder(SessionBytesStoreSupplier storeSupplier, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        super(Objects.requireNonNull(storeSupplier, "supplier cannot be null").name(), keySerde, valueSerde, time);
        this.storeSupplier = storeSupplier;
    }

    @Override
    public SessionStore<K, V> build() {
        return new MeteredSessionStore(this.maybeWrapCaching(this.maybeWrapLogging((SessionStore)this.storeSupplier.get())), this.storeSupplier.metricsScope(), this.keySerde, this.valueSerde, this.time);
    }

    private SessionStore<Bytes, byte[]> maybeWrapCaching(SessionStore<Bytes, byte[]> inner) {
        if (!this.enableCaching) {
            return inner;
        }
        return new CachingSessionStore(inner, this.storeSupplier.segmentIntervalMs());
    }

    private SessionStore<Bytes, byte[]> maybeWrapLogging(SessionStore<Bytes, byte[]> inner) {
        if (!this.enableLogging) {
            return inner;
        }
        return new ChangeLoggingSessionBytesStore(inner);
    }

    public long retentionPeriod() {
        return this.storeSupplier.retentionPeriod();
    }
}

