/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.To;

class KStreamBranch<K, V>
implements ProcessorSupplier<K, V> {
    private final Predicate<K, V>[] predicates;
    private final String[] childNodes;

    KStreamBranch(Predicate<K, V>[] predicates, String[] childNodes) {
        this.predicates = predicates;
        this.childNodes = childNodes;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamBranchProcessor();
    }

    private class KStreamBranchProcessor
    extends AbstractProcessor<K, V> {
        private KStreamBranchProcessor() {
        }

        @Override
        public void process(K key, V value) {
            for (int i = 0; i < KStreamBranch.this.predicates.length; ++i) {
                if (!KStreamBranch.this.predicates[i].test(key, value)) continue;
                this.context().forward(key, value, To.child(KStreamBranch.this.childNodes[i]));
                break;
            }
        }
    }
}

