/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;

class KStreamFilter<K, V>
implements ProcessorSupplier<K, V, K, V> {
    private final Predicate<K, V> predicate;
    private final boolean filterNot;

    public KStreamFilter(Predicate<K, V> predicate, boolean filterNot) {
        this.predicate = predicate;
        this.filterNot = filterNot;
    }

    @Override
    public Processor<K, V, K, V> get() {
        return new KStreamFilterProcessor();
    }

    private class KStreamFilterProcessor
    extends ContextualProcessor<K, V, K, V> {
        private KStreamFilterProcessor() {
        }

        @Override
        public void process(Record<K, V> record) {
            if (KStreamFilter.this.filterNot ^ KStreamFilter.this.predicate.test(record.key(), record.value())) {
                this.context().forward(record);
            }
        }
    }
}

