/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Optional;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.internals.JoinWindowsInternal;
import org.apache.kafka.streams.kstream.internals.KStreamImplJoin;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.LeftOrRightValue;
import org.apache.kafka.streams.state.internals.TimestampedKeyAndJoinSide;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KStreamKStreamJoin<K, V1, V2, VOut>
implements ProcessorSupplier<K, V1, K, VOut> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamKStreamJoin.class);
    private final String otherWindowName;
    private final long joinBeforeMs;
    private final long joinAfterMs;
    private final long joinGraceMs;
    private final boolean enableSpuriousResultFix;
    private final boolean outer;
    private final boolean isLeftSide;
    private final Optional<String> outerJoinWindowName;
    private final ValueJoinerWithKey<? super K, ? super V1, ? super V2, ? extends VOut> joiner;
    private final KStreamImplJoin.TimeTracker sharedTimeTracker;

    KStreamKStreamJoin(boolean isLeftSide, String otherWindowName, JoinWindowsInternal windows, ValueJoinerWithKey<? super K, ? super V1, ? super V2, ? extends VOut> joiner, boolean outer, Optional<String> outerJoinWindowName, KStreamImplJoin.TimeTracker sharedTimeTracker) {
        this.isLeftSide = isLeftSide;
        this.otherWindowName = otherWindowName;
        if (isLeftSide) {
            this.joinBeforeMs = windows.beforeMs;
            this.joinAfterMs = windows.afterMs;
        } else {
            this.joinBeforeMs = windows.afterMs;
            this.joinAfterMs = windows.beforeMs;
        }
        this.joinGraceMs = windows.gracePeriodMs();
        this.enableSpuriousResultFix = windows.spuriousResultFixEnabled();
        this.joiner = joiner;
        this.outer = outer;
        this.outerJoinWindowName = outerJoinWindowName;
        this.sharedTimeTracker = sharedTimeTracker;
    }

    @Override
    public Processor<K, V1, K, VOut> get() {
        return new KStreamKStreamJoinProcessor();
    }

    private class KStreamKStreamJoinProcessor
    extends ContextualProcessor<K, V1, K, VOut> {
        private WindowStore<K, V2> otherWindowStore;
        private Sensor droppedRecordsSensor;
        private Optional<KeyValueStore<TimestampedKeyAndJoinSide<K>, LeftOrRightValue<V1, V2>>> outerJoinStore = Optional.empty();
        private InternalProcessorContext<K, VOut> internalProcessorContext;

        private KStreamKStreamJoinProcessor() {
        }

        @Override
        public void init(ProcessorContext<K, VOut> context) {
            super.init(context);
            this.internalProcessorContext = (InternalProcessorContext)context;
            StreamsMetricsImpl metrics = (StreamsMetricsImpl)context.metrics();
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), metrics);
            this.otherWindowStore = (WindowStore)context.getStateStore(KStreamKStreamJoin.this.otherWindowName);
            if (KStreamKStreamJoin.this.enableSpuriousResultFix) {
                this.outerJoinStore = KStreamKStreamJoin.this.outerJoinWindowName.map(context::getStateStore);
                KStreamKStreamJoin.this.sharedTimeTracker.setEmitInterval(StreamsConfig.InternalConfig.getLong(context.appConfigs(), "__emit.interval.ms.kstreams.outer.join.spurious.results.fix__", 1000L));
            }
        }

        @Override
        public void process(Record<K, V1> record) {
            if (record.key() == null || record.value() == null) {
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    LOG.warn("Skipping record due to null key or value. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                } else {
                    LOG.warn("Skipping record due to null key or value. Topic, partition, and offset not known.");
                }
                this.droppedRecordsSensor.record();
                return;
            }
            boolean needOuterJoin = KStreamKStreamJoin.this.outer;
            long inputRecordTimestamp = record.timestamp();
            long timeFrom = Math.max(0L, inputRecordTimestamp - KStreamKStreamJoin.this.joinBeforeMs);
            long timeTo = Math.max(0L, inputRecordTimestamp + KStreamKStreamJoin.this.joinAfterMs);
            KStreamKStreamJoin.this.sharedTimeTracker.advanceStreamTime(inputRecordTimestamp);
            if (inputRecordTimestamp == ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.streamTime) {
                this.outerJoinStore.ifPresent(this::emitNonJoinedOuterRecords);
            }
            try (WindowStoreIterator iter = this.otherWindowStore.fetch(record.key(), timeFrom, timeTo);){
                while (iter.hasNext()) {
                    needOuterJoin = false;
                    KeyValue otherRecord = (KeyValue)iter.next();
                    long otherRecordTimestamp = (Long)otherRecord.key;
                    this.outerJoinStore.ifPresent(store -> store.putIfAbsent(TimestampedKeyAndJoinSide.make(!KStreamKStreamJoin.this.isLeftSide, record.key(), otherRecordTimestamp), null));
                    this.context().forward(record.withValue(KStreamKStreamJoin.this.joiner.apply(record.key(), record.value(), otherRecord.value)).withTimestamp(Math.max(inputRecordTimestamp, otherRecordTimestamp)));
                }
                if (needOuterJoin) {
                    if (!this.outerJoinStore.isPresent() || timeTo < ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.streamTime) {
                        this.context().forward(record.withValue(KStreamKStreamJoin.this.joiner.apply(record.key(), record.value(), null)));
                    } else {
                        KStreamKStreamJoin.this.sharedTimeTracker.updatedMinTime(inputRecordTimestamp);
                        this.outerJoinStore.ifPresent(store -> store.put(TimestampedKeyAndJoinSide.make(KStreamKStreamJoin.this.isLeftSide, record.key(), inputRecordTimestamp), LeftOrRightValue.make(KStreamKStreamJoin.this.isLeftSide, record.value())));
                    }
                }
            }
        }

        private void emitNonJoinedOuterRecords(KeyValueStore<TimestampedKeyAndJoinSide<K>, LeftOrRightValue<V1, V2>> store) {
            if (((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.minTime >= ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.streamTime - KStreamKStreamJoin.this.joinAfterMs - KStreamKStreamJoin.this.joinGraceMs) {
                return;
            }
            if (this.internalProcessorContext.currentSystemTimeMs() < ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.nextTimeToEmit) {
                return;
            }
            if (((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.nextTimeToEmit == 0L) {
                ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.nextTimeToEmit = this.internalProcessorContext.currentSystemTimeMs();
            }
            KStreamKStreamJoin.this.sharedTimeTracker.advanceNextTimeToEmit();
            ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.minTime = Long.MAX_VALUE;
            try (KeyValueIterator it = store.all();){
                TimestampedKeyAndJoinSide prevKey = null;
                while (it.hasNext()) {
                    long timestamp;
                    KeyValue record = (KeyValue)it.next();
                    TimestampedKeyAndJoinSide timestampedKeyAndJoinSide = (TimestampedKeyAndJoinSide)record.key;
                    LeftOrRightValue value = (LeftOrRightValue)record.value;
                    Object key = timestampedKeyAndJoinSide.getKey();
                    ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.minTime = timestamp = timestampedKeyAndJoinSide.getTimestamp();
                    if (timestamp + KStreamKStreamJoin.this.joinAfterMs + KStreamKStreamJoin.this.joinGraceMs >= ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.streamTime) break;
                    Object nullJoinedValue = KStreamKStreamJoin.this.isLeftSide ? KStreamKStreamJoin.this.joiner.apply(key, value.getLeftValue(), value.getRightValue()) : KStreamKStreamJoin.this.joiner.apply(key, value.getRightValue(), value.getLeftValue());
                    this.context().forward(new Record(key, nullJoinedValue, timestamp));
                    if (prevKey != null && !prevKey.equals(timestampedKeyAndJoinSide)) {
                        store.put(prevKey, null);
                    }
                    prevKey = timestampedKeyAndJoinSide;
                }
                if (prevKey != null) {
                    store.put(prevKey, null);
                }
            }
        }
    }
}

