/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.EmitStrategy;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.AbstractKStreamTimeWindowAggregateProcessor;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamWindowAggregate<KIn, VIn, VAgg, W extends Window>
implements KStreamAggProcessorSupplier<KIn, VIn, Windowed<KIn>, VAgg> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String storeName;
    private final Windows<W> windows;
    private final Initializer<VAgg> initializer;
    private final Aggregator<? super KIn, ? super VIn, VAgg> aggregator;
    private final EmitStrategy emitStrategy;
    private boolean sendOldValues = false;

    public KStreamWindowAggregate(Windows<W> windows, String storeName, EmitStrategy emitStrategy, Initializer<VAgg> initializer, Aggregator<? super KIn, ? super VIn, VAgg> aggregator) {
        this.windows = windows;
        this.storeName = storeName;
        this.emitStrategy = emitStrategy;
        this.initializer = initializer;
        this.aggregator = aggregator;
        if (emitStrategy.type() == EmitStrategy.StrategyType.ON_WINDOW_CLOSE && !(windows instanceof TimeWindows)) {
            throw new IllegalArgumentException("ON_WINDOW_CLOSE strategy is only supported for TimeWindows and SlidingWindows for TimeWindowedKStream");
        }
    }

    @Override
    public Processor<KIn, VIn, Windowed<KIn>, Change<VAgg>> get() {
        return new KStreamWindowAggregateProcessor(this.storeName, this.emitStrategy, this.sendOldValues);
    }

    public Windows<W> windows() {
        return this.windows;
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<Windowed<KIn>, VAgg> view() {
        return new KTableValueGetterSupplier<Windowed<KIn>, VAgg>(){

            @Override
            public KTableValueGetter<Windowed<KIn>, VAgg> get() {
                return new KStreamWindowAggregateValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamWindowAggregate.this.storeName};
            }
        };
    }

    private class KStreamWindowAggregateValueGetter
    implements KTableValueGetter<Windowed<KIn>, VAgg> {
        private TimestampedWindowStore<KIn, VAgg> windowStore;

        private KStreamWindowAggregateValueGetter() {
        }

        @Override
        public void init(ProcessorContext<?, ?> context) {
            this.windowStore = (TimestampedWindowStore)context.getStateStore(KStreamWindowAggregate.this.storeName);
        }

        @Override
        public ValueAndTimestamp<VAgg> get(Windowed<KIn> windowedKey) {
            Object key = windowedKey.key();
            Window window = windowedKey.window();
            return (ValueAndTimestamp)this.windowStore.fetch(key, window.start());
        }
    }

    private class KStreamWindowAggregateProcessor
    extends AbstractKStreamTimeWindowAggregateProcessor<KIn, VIn, VAgg> {
        protected KStreamWindowAggregateProcessor(String storeName, EmitStrategy emitStrategy, boolean sendOldValues) {
            super(storeName, emitStrategy, sendOldValues);
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            if (record.key() == null) {
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    KStreamWindowAggregate.this.log.warn("Skipping record due to null key. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                } else {
                    KStreamWindowAggregate.this.log.warn("Skipping record due to null key. Topic, partition, and offset not known.");
                }
                this.droppedRecordsSensor.record();
                return;
            }
            long timestamp = record.timestamp();
            this.updateObservedStreamTime(timestamp);
            long windowCloseTime = this.observedStreamTime - KStreamWindowAggregate.this.windows.gracePeriodMs();
            Map matchedWindows = KStreamWindowAggregate.this.windows.windowsFor(timestamp);
            for (Map.Entry entry : matchedWindows.entrySet()) {
                Long windowStart = entry.getKey();
                long windowEnd = ((Window)entry.getValue()).end();
                if (windowEnd > windowCloseTime) {
                    long newTimestamp;
                    ValueAndTimestamp oldAggAndTimestamp = (ValueAndTimestamp)this.windowStore.fetch(record.key(), windowStart);
                    Object oldAgg = ValueAndTimestamp.getValueOrNull(oldAggAndTimestamp);
                    if (oldAgg == null) {
                        oldAgg = KStreamWindowAggregate.this.initializer.apply();
                        newTimestamp = record.timestamp();
                    } else {
                        newTimestamp = Math.max(record.timestamp(), oldAggAndTimestamp.timestamp());
                    }
                    Object newAgg = KStreamWindowAggregate.this.aggregator.apply(record.key(), record.value(), oldAgg);
                    this.windowStore.put(record.key(), ValueAndTimestamp.make(newAgg, newTimestamp), windowStart);
                    this.maybeForwardUpdate(record, (Window)entry.getValue(), oldAgg, newAgg, newTimestamp);
                    continue;
                }
                String windowString = "[" + windowStart + "," + windowEnd + ")";
                this.logSkippedRecordForExpiredWindow(KStreamWindowAggregate.this.log, record.timestamp(), windowCloseTime, windowString);
            }
            this.maybeForwardFinalResult(record, windowCloseTime);
        }

        @Override
        protected long emitRangeLowerBound(long windowCloseTime) {
            return this.lastEmitWindowCloseTime == -1L ? 0L : Math.max(0L, this.lastEmitWindowCloseTime - KStreamWindowAggregate.this.windows.size()) + 1L;
        }

        @Override
        protected long emitRangeUpperBound(long windowCloseTime) {
            return windowCloseTime - KStreamWindowAggregate.this.windows.size();
        }

        @Override
        protected boolean shouldRangeFetch(long emitRangeLowerBound, long emitRangeUpperBound) {
            Map matchedEmitWindows;
            Map matchedCloseWindows;
            if (this.lastEmitWindowCloseTime != -1L && (matchedCloseWindows = KStreamWindowAggregate.this.windows.windowsFor(emitRangeUpperBound)).equals(matchedEmitWindows = KStreamWindowAggregate.this.windows.windowsFor(emitRangeLowerBound - 1L))) {
                KStreamWindowAggregate.this.log.trace("No new windows to emit. LastEmitCloseTime={}, emitRangeLowerBound={}, emitRangeUpperBound={}", new Object[]{this.lastEmitWindowCloseTime, emitRangeLowerBound, emitRangeUpperBound});
                return false;
            }
            return true;
        }
    }
}

