/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query.internals;

import java.util.List;
import org.apache.kafka.streams.query.FailureReason;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.internals.AbstractQueryResult;

public final class SucceededQueryResult<R>
extends AbstractQueryResult<R>
implements QueryResult<R> {
    private final R result;

    public SucceededQueryResult(R result) {
        this.result = result;
    }

    SucceededQueryResult(R result, List<String> executionInfo, Position position) {
        super(executionInfo, position);
        this.result = result;
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public boolean isFailure() {
        return false;
    }

    @Override
    public FailureReason getFailureReason() {
        throw new IllegalArgumentException("Cannot get failure reason because this query did not fail.");
    }

    @Override
    public String getFailureMessage() {
        throw new IllegalArgumentException("Cannot get failure message because this query did not fail.");
    }

    @Override
    public R getResult() {
        return this.result;
    }

    public String toString() {
        return "SucceededQueryResult{result=" + this.result + ", executionInfo=" + this.getExecutionInfo() + ", position=" + this.getPosition() + '}';
    }
}

