/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.ConstrainedPrioritySet;
import org.slf4j.Logger;

final class StandbyTaskAssignmentUtils {
    private StandbyTaskAssignmentUtils() {
    }

    static ConstrainedPrioritySet createLeastLoadedPrioritySetConstrainedByAssignedTask(Map<UUID, ClientState> clients) {
        return new ConstrainedPrioritySet((client, t) -> !((ClientState)clients.get(client)).hasAssignedTask((TaskId)t), client -> ((ClientState)clients.get(client)).assignedTaskLoad());
    }

    static void pollClientAndMaybeAssignAndUpdateRemainingStandbyTasks(int numStandbyReplicas, Map<UUID, ClientState> clients, Map<TaskId, Integer> tasksToRemainingStandbys, ConstrainedPrioritySet standbyTaskClientsByTaskLoad, TaskId activeTaskId, Logger log) {
        UUID client;
        int numRemainingStandbys = tasksToRemainingStandbys.get(activeTaskId);
        while (numRemainingStandbys > 0 && (client = standbyTaskClientsByTaskLoad.poll(activeTaskId)) != null) {
            clients.get(client).assignStandby(activeTaskId);
            standbyTaskClientsByTaskLoad.offer(client);
            tasksToRemainingStandbys.put(activeTaskId, --numRemainingStandbys);
        }
        if (numRemainingStandbys > 0) {
            log.warn("Unable to assign {} of {} standby tasks for task [{}]. There is not enough available capacity. You should increase the number of application instances to maintain the requested number of standby replicas.", new Object[]{numRemainingStandbys, numStandbyReplicas, activeTaskId});
        }
    }

    static Map<TaskId, Integer> computeTasksToRemainingStandbys(int numStandbyReplicas, Set<TaskId> statefulTaskIds) {
        return statefulTaskIds.stream().collect(Collectors.toMap(Function.identity(), t -> numStandbyReplicas));
    }
}

