/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.util.Objects;

public class CombinedKey<KF, KP> {
    private final KF foreignKey;
    private final KP primaryKey;

    CombinedKey(KF foreignKey, KP primaryKey) {
        Objects.requireNonNull(primaryKey, "primaryKey can't be null");
        this.foreignKey = foreignKey;
        this.primaryKey = primaryKey;
    }

    public KF getForeignKey() {
        return this.foreignKey;
    }

    public KP getPrimaryKey() {
        return this.primaryKey;
    }

    public int hashCode() {
        return Objects.hash(this.foreignKey, this.primaryKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombinedKey that = (CombinedKey)o;
        return Objects.equals(this.foreignKey, that.foreignKey) && Objects.equals(this.primaryKey, that.primaryKey);
    }

    public String toString() {
        return "CombinedKey{foreignKey=" + this.foreignKey + ", primaryKey=" + this.primaryKey + '}';
    }
}

