/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Objects;
import org.apache.kafka.streams.processor.internals.ProcessorMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicPartitionMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(TopicPartitionMetadata.class);
    static final byte LATEST_MAGIC_BYTE = 2;
    private final long partitionTime;
    private final ProcessorMetadata processorMetadata;

    public TopicPartitionMetadata(long partitionTime, ProcessorMetadata processorMetadata) {
        Objects.requireNonNull(processorMetadata);
        this.partitionTime = partitionTime;
        this.processorMetadata = processorMetadata;
    }

    public long partitionTime() {
        return this.partitionTime;
    }

    public ProcessorMetadata processorMetadata() {
        return this.processorMetadata;
    }

    public String encode() {
        byte[] serializedMeta = this.processorMetadata.serialize();
        ByteBuffer buffer = ByteBuffer.allocate(9 + serializedMeta.length);
        buffer.put((byte)2);
        buffer.putLong(this.partitionTime);
        buffer.put(serializedMeta);
        return Base64.getEncoder().encodeToString(buffer.array());
    }

    public static TopicPartitionMetadata decode(String encryptedString) {
        long timestamp = -1L;
        ProcessorMetadata metadata = new ProcessorMetadata();
        if (encryptedString.isEmpty()) {
            return new TopicPartitionMetadata(timestamp, metadata);
        }
        try {
            ByteBuffer buffer = ByteBuffer.wrap(Base64.getDecoder().decode(encryptedString));
            byte version = buffer.get();
            switch (version) {
                case 1: {
                    timestamp = buffer.getLong();
                    break;
                }
                case 2: {
                    timestamp = buffer.getLong();
                    if (buffer.remaining() > 0) {
                        byte[] metaBytes = new byte[buffer.remaining()];
                        buffer.get(metaBytes);
                        metadata = ProcessorMetadata.deserialize(metaBytes);
                    }
                    break;
                }
                default: {
                    LOG.warn("Unsupported offset metadata version found. Supported version <= {}. Found version {}.", (Object)2, (Object)version);
                    break;
                }
            }
        }
        catch (Exception exception) {
            LOG.warn("Unsupported offset metadata found");
        }
        return new TopicPartitionMetadata(timestamp, metadata);
    }

    public int hashCode() {
        return Objects.hash(this.partitionTime, this.processorMetadata);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.partitionTime == ((TopicPartitionMetadata)obj).partitionTime && Objects.equals(this.processorMetadata, ((TopicPartitionMetadata)obj).processorMetadata);
    }
}

