/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;

public class VersionedChangelogTopicConfig
extends InternalTopicConfig {
    private static final Map<String, String> VERSIONED_STORE_CHANGELOG_TOPIC_DEFAULT_OVERRIDES;
    private static final long VERSIONED_STORE_CHANGE_LOG_ADDITIONAL_COMPACTION_LAG_MS = 86400000L;
    private final long minCompactionLagMs;

    VersionedChangelogTopicConfig(String name, Map<String, String> topicConfigs, long minCompactionLagMs) {
        super(name, topicConfigs);
        this.minCompactionLagMs = minCompactionLagMs;
    }

    @Override
    public Map<String, String> properties(Map<String, String> defaultProperties, long windowStoreAdditionalRetentionMs) {
        HashMap<String, String> topicConfig = new HashMap<String, String>(VERSIONED_STORE_CHANGELOG_TOPIC_DEFAULT_OVERRIDES);
        topicConfig.putAll(defaultProperties);
        topicConfig.putAll(this.topicConfigs);
        if (!this.topicConfigs.containsKey("min.compaction.lag.ms")) {
            long compactionLagValue;
            try {
                compactionLagValue = Math.addExact(this.minCompactionLagMs, 86400000L);
            }
            catch (ArithmeticException swallow) {
                compactionLagValue = Long.MAX_VALUE;
            }
            topicConfig.put("min.compaction.lag.ms", String.valueOf(compactionLagValue));
        }
        return topicConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedChangelogTopicConfig that = (VersionedChangelogTopicConfig)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.topicConfigs, that.topicConfigs) && Objects.equals(this.minCompactionLagMs, that.minCompactionLagMs) && Objects.equals(this.enforceNumberOfPartitions, that.enforceNumberOfPartitions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.topicConfigs, this.minCompactionLagMs, this.enforceNumberOfPartitions);
    }

    @Override
    public String toString() {
        return "VersionedChangelogTopicConfig(name=" + this.name + ", topicConfigs=" + String.valueOf(this.topicConfigs) + ", minCompactionLagMs=" + this.minCompactionLagMs + ", enforceNumberOfPartitions=" + this.enforceNumberOfPartitions + ")";
    }

    static {
        HashMap<String, String> tempTopicDefaultOverrides = new HashMap<String, String>(INTERNAL_TOPIC_DEFAULT_OVERRIDES);
        tempTopicDefaultOverrides.put("cleanup.policy", "compact");
        VERSIONED_STORE_CHANGELOG_TOPIC_DEFAULT_OVERRIDES = Collections.unmodifiableMap(tempTopicDefaultOverrides);
    }
}

