/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.test.junit;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.network.SocketServer;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.KafkaClusterTestKit;
import org.apache.kafka.common.test.TestKitNodes;
import org.apache.kafka.common.test.TestUtils;
import org.apache.kafka.common.test.api.ClusterConfig;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.common.test.junit.ClusterInstanceParameterResolver;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.storage.FormatterException;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandlerException;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;

public class RaftClusterInvocationContext
implements TestTemplateInvocationContext {
    private final String baseDisplayName;
    private final ClusterConfig clusterConfig;
    private final boolean isCombined;

    public RaftClusterInvocationContext(String baseDisplayName, ClusterConfig clusterConfig, boolean isCombined) {
        this.baseDisplayName = baseDisplayName;
        this.clusterConfig = clusterConfig;
        this.isCombined = isCombined;
    }

    public String getDisplayName(int invocationIndex) {
        return String.format("%s [%d] Type=Raft-%s, %s", this.baseDisplayName, invocationIndex, this.isCombined ? "Combined" : "Isolated", String.join((CharSequence)",", this.clusterConfig.displayTags()));
    }

    public List<Extension> getAdditionalExtensions() {
        RaftClusterInstance clusterInstance = new RaftClusterInstance(this.clusterConfig, this.isCombined);
        return List.of(context -> {
            clusterInstance.format();
            if (this.clusterConfig.isAutoStart()) {
                clusterInstance.start();
            }
        }, context -> clusterInstance.stop(), new ClusterInstanceParameterResolver(clusterInstance));
    }

    private static class RaftClusterInstance
    implements ClusterInstance {
        private final ClusterConfig clusterConfig;
        final AtomicBoolean started = new AtomicBoolean(false);
        final AtomicBoolean stopped = new AtomicBoolean(false);
        final AtomicBoolean formated = new AtomicBoolean(false);
        private KafkaClusterTestKit clusterTestKit;
        private final boolean isCombined;
        private final ListenerName listenerName;

        RaftClusterInstance(ClusterConfig clusterConfig, boolean isCombined) {
            this.clusterConfig = clusterConfig;
            this.isCombined = isCombined;
            this.listenerName = clusterConfig.brokerListenerName();
        }

        @Override
        public String bootstrapServers() {
            return this.clusterTestKit.bootstrapServers();
        }

        @Override
        public String bootstrapControllers() {
            return this.clusterTestKit.bootstrapControllers();
        }

        @Override
        public ListenerName clientListener() {
            return this.listenerName;
        }

        @Override
        public ListenerName controllerListenerName() {
            return new ListenerName((String)this.controllers().values().iterator().next().config().controllerListenerNames().get(0));
        }

        @Override
        public Collection<SocketServer> controllerSocketServers() {
            return this.controllers().values().stream().map(ControllerServer::socketServer).collect(Collectors.toList());
        }

        @Override
        public String clusterId() {
            return Stream.concat(this.controllers().values().stream().map(ControllerServer::clusterId), this.brokers().values().stream().map(KafkaBroker::clusterId)).findFirst().orElseThrow(() -> new RuntimeException("No controllers or brokers!"));
        }

        @Override
        public Type type() {
            return this.isCombined ? Type.CO_KRAFT : Type.KRAFT;
        }

        @Override
        public ClusterConfig config() {
            return this.clusterConfig;
        }

        @Override
        public Set<Integer> controllerIds() {
            return this.controllers().keySet();
        }

        public KafkaClusterTestKit getUnderlying() {
            return this.clusterTestKit;
        }

        @Override
        public void start() {
            try {
                this.format();
                if (this.started.compareAndSet(false, true)) {
                    this.clusterTestKit.startup();
                    TestUtils.waitForCondition(() -> this.clusterTestKit.brokers().values().stream().allMatch(brokers -> brokers.brokerState() == BrokerState.RUNNING), "Broker never made it to RUNNING state.");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to start Raft server", e);
            }
        }

        @Override
        public boolean started() {
            return this.started.get();
        }

        @Override
        public void stop() {
            if (this.stopped.compareAndSet(false, true)) {
                Utils.closeQuietly((AutoCloseable)this.clusterTestKit, (String)"cluster");
            }
        }

        @Override
        public boolean stopped() {
            return this.stopped.get();
        }

        @Override
        public void shutdownBroker(int brokerId) {
            this.findBrokerOrThrow(brokerId).shutdown();
        }

        @Override
        public void startBroker(int brokerId) {
            this.findBrokerOrThrow(brokerId).startup();
        }

        @Override
        public Optional<FaultHandlerException> firstFatalException() {
            return Optional.ofNullable(this.clusterTestKit.fatalFaultHandler().firstException());
        }

        @Override
        public Optional<FaultHandlerException> firstNonFatalException() {
            return Optional.ofNullable(this.clusterTestKit.nonFatalFaultHandler().firstException());
        }

        @Override
        public void waitForReadyBrokers() throws InterruptedException {
            try {
                this.clusterTestKit.waitForReadyBrokers();
            }
            catch (ExecutionException e) {
                throw new AssertionError("Failed while waiting for brokers to become ready", e);
            }
        }

        @Override
        public Map<Integer, KafkaBroker> brokers() {
            return this.clusterTestKit.brokers().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        @Override
        public Map<Integer, ControllerServer> controllers() {
            return Collections.unmodifiableMap(this.clusterTestKit.controllers());
        }

        public void format() throws Exception {
            if (this.formated.compareAndSet(false, true)) {
                short level;
                String featureName;
                TreeMap nameToSupportedFeature = new TreeMap();
                Feature.PRODUCTION_FEATURES.forEach(feature -> nameToSupportedFeature.put(feature.featureName(), feature));
                TreeMap<String, Short> newFeatureLevels = new TreeMap<String, Short>();
                for (Map.Entry entry : this.clusterConfig.features().entrySet()) {
                    featureName = ((Feature)entry.getKey()).featureName();
                    level = (Short)entry.getValue();
                    if (!featureName.equals("metadata.version") && !nameToSupportedFeature.containsKey(featureName)) {
                        throw new FormatterException("Unsupported feature: " + featureName + ". Supported features are: " + String.join((CharSequence)", ", nameToSupportedFeature.keySet()));
                    }
                    newFeatureLevels.put(featureName, level);
                }
                newFeatureLevels.put("metadata.version", this.clusterConfig.metadataVersion().featureLevel());
                Feature.PRODUCTION_FEATURES.forEach(supportedFeature -> {
                    if (!newFeatureLevels.containsKey(supportedFeature.featureName())) {
                        newFeatureLevels.put(supportedFeature.featureName(), supportedFeature.defaultLevel(this.clusterConfig.metadataVersion()));
                    }
                });
                for (Map.Entry entry : newFeatureLevels.entrySet()) {
                    featureName = (String)entry.getKey();
                    if (featureName.equals("metadata.version")) continue;
                    level = (Short)entry.getValue();
                    Feature supportedFeature2 = (Feature)nameToSupportedFeature.get(featureName);
                    FeatureVersion featureVersion = supportedFeature2.fromFeatureLevel(level, true);
                    Feature.validateVersion((FeatureVersion)featureVersion, newFeatureLevels);
                }
                TestKitNodes nodes = new TestKitNodes.Builder().setBootstrapMetadata(BootstrapMetadata.fromVersions((MetadataVersion)this.clusterConfig.metadataVersion(), newFeatureLevels, (String)"testkit")).setCombined(this.isCombined).setNumBrokerNodes(this.clusterConfig.numBrokers()).setNumDisksPerBroker(this.clusterConfig.numDisksPerBroker()).setPerServerProperties(this.clusterConfig.perServerOverrideProperties()).setNumControllerNodes(this.clusterConfig.numControllers()).setBrokerListenerName(this.listenerName).setBrokerSecurityProtocol(this.clusterConfig.brokerSecurityProtocol()).setControllerListenerName(this.clusterConfig.controllerListenerName()).setControllerSecurityProtocol(this.clusterConfig.controllerSecurityProtocol()).build();
                KafkaClusterTestKit.Builder builder = new KafkaClusterTestKit.Builder(nodes);
                this.clusterConfig.serverProperties().forEach(builder::setConfigProp);
                this.clusterTestKit = builder.build();
                this.clusterTestKit.format();
            }
        }

        private BrokerServer findBrokerOrThrow(int brokerId) {
            return Optional.ofNullable(this.clusterTestKit.brokers().get(brokerId)).orElseThrow(() -> new IllegalArgumentException("Unknown brokerId " + brokerId));
        }
    }
}

