/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.coordinator;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.kafka.trogdor.coordinator.Coordinator;
import org.apache.kafka.trogdor.rest.CoordinatorFaultsResponse;
import org.apache.kafka.trogdor.rest.CoordinatorStatusResponse;
import org.apache.kafka.trogdor.rest.CreateCoordinatorFaultRequest;
import org.apache.kafka.trogdor.rest.Empty;

@Path(value="/coordinator")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CoordinatorRestResource {
    private final AtomicReference<Coordinator> coordinator = new AtomicReference();
    @Context
    private ServletContext context;

    public void setCoordinator(Coordinator myCoordinator) {
        this.coordinator.set(myCoordinator);
    }

    @GET
    @Path(value="/status")
    public CoordinatorStatusResponse getStatus() throws Throwable {
        return new CoordinatorStatusResponse(this.coordinator().startTimeMs());
    }

    @GET
    @Path(value="/faults")
    public CoordinatorFaultsResponse getCoordinatorFaults() throws Throwable {
        return this.coordinator().getFaults();
    }

    @PUT
    @Path(value="/fault")
    public Empty putCoordinatorFault(CreateCoordinatorFaultRequest request) throws Throwable {
        this.coordinator().createFault(request);
        return Empty.INSTANCE;
    }

    @PUT
    @Path(value="/shutdown")
    public Empty shutdown() throws Throwable {
        this.coordinator().beginShutdown();
        return Empty.INSTANCE;
    }

    private Coordinator coordinator() {
        Coordinator myCoordinator = this.coordinator.get();
        if (myCoordinator == null) {
            throw new RuntimeException("CoordinatorRestResource has not been initialized yet.");
        }
        return myCoordinator;
    }
}

