/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.coordinator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.agent.AgentClient;
import org.apache.kafka.trogdor.common.Node;
import org.apache.kafka.trogdor.fault.DoneState;
import org.apache.kafka.trogdor.fault.Fault;
import org.apache.kafka.trogdor.fault.SendingState;
import org.apache.kafka.trogdor.rest.AgentStatusResponse;
import org.apache.kafka.trogdor.rest.CreateAgentFaultRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeManager {
    private static final Logger log = LoggerFactory.getLogger(NodeManager.class);
    private final Time time;
    private final Node node;
    private final AgentClient client;
    private final long heartbeatMs;
    private boolean shutdown = false;
    private final NodeManagerRunnable runnable;
    private final KafkaThread thread;
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();
    private final List<Fault> faultQueue = new ArrayList<Fault>();
    private long lastContactMs = 0L;

    NodeManager(Time time, Node node) {
        this.time = time;
        this.node = node;
        this.client = new AgentClient(node.hostname(), Node.Util.getTrogdorAgentPort(node));
        this.heartbeatMs = Node.Util.getIntConfig(node, "trogdor.coordinator.heartbeat.ms", 60000);
        this.runnable = new NodeManagerRunnable();
        this.thread = new KafkaThread("NodeManagerThread(" + node.name() + ")", (Runnable)this.runnable, false);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendFault(long now, Fault fault) {
        try {
            this.client.putFault(new CreateAgentFaultRequest(fault.id(), fault.spec()));
        }
        catch (Exception e) {
            log.warn("{}: error sending fault to {}.", new Object[]{this.node.name(), this.client.target(), e});
            return false;
        }
        this.lock.lock();
        try {
            this.lastContactMs = now;
        }
        finally {
            this.lock.unlock();
        }
        SendingState state = (SendingState)fault.state();
        if (state.completeSend(this.node.name())) {
            fault.setState(new DoneState(now, ""));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHeartbeat(long now) {
        AgentStatusResponse status = null;
        try {
            status = this.client.getStatus();
        }
        catch (Exception e) {
            log.warn("{}: error sending heartbeat to {}.", new Object[]{this.node.name(), this.client.target(), e});
            return;
        }
        this.lock.lock();
        try {
            this.lastContactMs = now;
        }
        finally {
            this.lock.unlock();
        }
        log.debug("{}: got heartbeat status {}.", (Object)this.node.name(), (Object)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginShutdown() {
        this.lock.lock();
        try {
            if (this.shutdown) {
                return;
            }
            log.trace("{}: beginning shutdown.", (Object)this.node.name());
            this.shutdown = true;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void waitForShutdown() {
        log.trace("waiting for NodeManager({}) shutdown.", (Object)this.node.name());
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            log.error("{}: Interrupted while waiting for thread shutdown", (Object)this.node.name(), (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeStatus status() {
        this.lock.lock();
        try {
            NodeStatus nodeStatus = new NodeStatus(this.node.name(), this.lastContactMs);
            return nodeStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueFault(Fault fault) {
        this.lock.lock();
        try {
            log.trace("{}: added {} to fault queue.", (Object)this.node.name(), (Object)fault);
            this.faultQueue.add(fault);
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    static /* synthetic */ Time access$000(NodeManager x0) {
        return x0.time;
    }

    static /* synthetic */ boolean access$100(NodeManager x0, long x1, Fault x2) {
        return x0.sendFault(x1, x2);
    }

    static /* synthetic */ long access$200(NodeManager x0) {
        return x0.heartbeatMs;
    }

    static /* synthetic */ void access$300(NodeManager x0, long x1) {
        x0.sendHeartbeat(x1);
    }

    static /* synthetic */ Lock access$400(NodeManager x0) {
        return x0.lock;
    }

    static /* synthetic */ boolean access$500(NodeManager x0) {
        return x0.shutdown;
    }

    static /* synthetic */ Condition access$600(NodeManager x0) {
        return x0.cond;
    }

    static /* synthetic */ Node access$700(NodeManager x0) {
        return x0.node;
    }

    static /* synthetic */ Logger access$800() {
        return log;
    }

    static /* synthetic */ List access$900(NodeManager x0) {
        return x0.faultQueue;
    }

    class NodeManagerRunnable
    implements Runnable {
        NodeManagerRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                fault = null;
                lastCommAttemptMs = 0L;
                while (true) lbl-1000:
                // 4 sources

                {
                    now = NodeManager.access$000(NodeManager.this).milliseconds();
                    if (fault != null) {
                        lastCommAttemptMs = now;
                        if (NodeManager.access$100(NodeManager.this, now, fault)) {
                            fault = null;
                        }
                    }
                    if (now < (nextCommAttemptMs = lastCommAttemptMs + NodeManager.access$200(NodeManager.this))) {
                        lastCommAttemptMs = now;
                        NodeManager.access$300(NodeManager.this, now);
                    }
                    waitMs = Math.max(0L, nextCommAttemptMs - now);
                    NodeManager.access$400(NodeManager.this).lock();
                    try {
                        if (NodeManager.access$500(NodeManager.this)) {
                            return;
                        }
                        try {
                            NodeManager.access$600(NodeManager.this).await(waitMs, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            NodeManager.access$800().info("{}: NodeManagerRunnable got InterruptedException", (Object)NodeManager.access$700(NodeManager.this).name());
                            Thread.currentThread().interrupt();
                        }
                        if (fault != null || NodeManager.access$900(NodeManager.this).isEmpty()) ** GOTO lbl-1000
                        fault = (Fault)NodeManager.access$900(NodeManager.this).remove(0);
                    }
                    finally {
                        NodeManager.access$400(NodeManager.this).unlock();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                NodeManager.access$800().warn("{}: exiting NodeManagerRunnable with exception", (Object)NodeManager.access$700(NodeManager.this).name(), (Object)e);
            }
            ** GOTO lbl-1000
        }
    }

    public static class NodeStatus {
        private final String nodeName;
        private final long lastContactMs;

        NodeStatus(String nodeName, long lastContactMs) {
            this.nodeName = nodeName;
            this.lastContactMs = lastContactMs;
        }

        public String nodeName() {
            return this.nodeName;
        }

        public long lastContactMs() {
            return this.lastContactMs;
        }
    }
}

