/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.trogdor.fault.FaultState;

public class SendingState
extends FaultState {
    private final TreeMap<String, Boolean> nodes = new TreeMap();
    private int remainingNodes;

    public SendingState(@JsonProperty(value="nodeNames") Set<String> nodeNames) {
        for (String nodeName : nodeNames) {
            this.nodes.put(nodeName, false);
        }
        this.remainingNodes = nodeNames.size();
    }

    @JsonProperty
    public synchronized Set<String> nodeNames() {
        return this.nodes.keySet();
    }

    public synchronized boolean completeSend(String nodeName) {
        if (!this.nodes.containsKey(nodeName)) {
            throw new RuntimeException("Node " + nodeName + " was not to supposed to " + "receive this fault.  The fault was scheduled on nodes: " + Utils.join(this.nodes.keySet(), (String)", "));
        }
        if (this.nodes.put(nodeName, true).booleanValue()) {
            throw new RuntimeException("Node " + nodeName + " already received this fault.");
        }
        --this.remainingNodes;
        return this.remainingNodes == 0;
    }
}

