/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.CompletedTxn;
import kafka.log.LazyIndex;
import kafka.log.LogConfig;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.LogSegment$$anonfun$recover$1$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.RollParams;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0011-a\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001b\u0001\u0001\u0003\u0006\u0004%\t!F\u000b\u0002-A\u0011q#I\u0007\u00021)\u0011\u0011DG\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u0006;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0003DA\u0006GS2,'+Z2pe\u0012\u001c\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\t1|w\r\t\u0005\tM\u0001\u0011)\u0019!C\u0001O\u0005yA.\u0019>z\u001f\u001a47/\u001a;J]\u0012,\u00070F\u0001)!\rI#\u0006L\u0007\u0002\u0005%\u00111F\u0001\u0002\n\u0019\u0006T\u00180\u00138eKb\u0004\"!K\u0017\n\u00059\u0012!aC(gMN,G/\u00138eKbD\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0011Y\u0006T\u0018p\u00144gg\u0016$\u0018J\u001c3fq\u0002B\u0001B\r\u0001\u0003\u0006\u0004%\taM\u0001\u000eY\u0006T\u0018\u0010V5nK&sG-\u001a=\u0016\u0003Q\u00022!\u000b\u00166!\tIc'\u0003\u00028\u0005\tIA+[7f\u0013:$W\r\u001f\u0005\ts\u0001\u0011\t\u0011)A\u0005i\u0005qA.\u0019>z)&lW-\u00138eKb\u0004\u0003\u0002C\u001e\u0001\u0005\u000b\u0007I\u0011\u0001\u001f\u0002\u0011QDh.\u00138eKb,\u0012!\u0010\t\u0003SyJ!a\u0010\u0002\u0003!Q\u0013\u0018M\\:bGRLwN\\%oI\u0016D\b\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\u0002\u0013QDh.\u00138eKb\u0004\u0003\u0002C\"\u0001\u0005\u000b\u0007I\u0011\u0001#\u0002\u0015\t\f7/Z(gMN,G/F\u0001F!\tIa)\u0003\u0002H\u0015\t!Aj\u001c8h\u0011!I\u0005A!A!\u0002\u0013)\u0015a\u00032bg\u0016|eMZ:fi\u0002B\u0001b\u0013\u0001\u0003\u0006\u0004%\t\u0001T\u0001\u0013S:$W\r_%oi\u0016\u0014h/\u00197CsR,7/F\u0001N!\tIa*\u0003\u0002P\u0015\t\u0019\u0011J\u001c;\t\u0011E\u0003!\u0011!Q\u0001\n5\u000b1#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fg\u0002B\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001R\u0001\re>dGNS5ui\u0016\u0014Xj\u001d\u0005\t+\u0002\u0011\t\u0011)A\u0005\u000b\u0006i!o\u001c7m\u0015&$H/\u001a:Ng\u0002B\u0001b\u0016\u0001\u0003\u0006\u0004%\t\u0001W\u0001\u0005i&lW-F\u0001Z!\tQF,D\u0001\\\u0015\t\t\"$\u0003\u0002^7\n!A+[7f\u0011!y\u0006A!A!\u0002\u0013I\u0016!\u0002;j[\u0016\u0004\u0003BB1\u0001\t\u0003\u0011!-\u0001\u0004=S:LGO\u0010\u000b\nG\u0012,gm\u001a5jU.\u0004\"!\u000b\u0001\t\u000b\r\u0001\u0007\u0019\u0001\f\t\u000b\u0019\u0002\u0007\u0019\u0001\u0015\t\u000bI\u0002\u0007\u0019\u0001\u001b\t\u000bm\u0002\u0007\u0019A\u001f\t\u000b\r\u0003\u0007\u0019A#\t\u000b-\u0003\u0007\u0019A'\t\u000bM\u0003\u0007\u0019A#\t\u000b]\u0003\u0007\u0019A-\t\u000b5\u0004A\u0011\u00018\u0002\u0017=4gm]3u\u0013:$W\r_\u000b\u0002Y!)\u0001\u000f\u0001C\u0001c\u0006IA/[7f\u0013:$W\r_\u000b\u0002k!)1\u000f\u0001C\u0001i\u0006Q1\u000f[8vY\u0012\u0014v\u000e\u001c7\u0015\u0005UD\bCA\u0005w\u0013\t9(BA\u0004C_>dW-\u00198\t\u000be\u0014\b\u0019\u0001>\u0002\u0015I|G\u000e\u001c)be\u0006l7\u000f\u0005\u0002*w&\u0011AP\u0001\u0002\u000b%>dG\u000eU1sC6\u001c\b\"\u0002@\u0001\t\u0003y\u0018!\u0004:fg&TX-\u00138eKb,7\u000f\u0006\u0003\u0002\u0002\u0005\u001d\u0001cA\u0005\u0002\u0004%\u0019\u0011Q\u0001\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u0013i\b\u0019A'\u0002\tML'0\u001a\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0003-\u0019\u0018M\\5us\u000eCWmY6\u0015\t\u0005\u0005\u0011\u0011\u0003\u0005\b\u0003'\tY\u00011\u0001v\u0003e!\u0018.\\3J]\u0012,\u0007PR5mK:+w\u000f\\=De\u0016\fG/\u001a3\t\u0011\u0005]\u0001\u00011A\u0005\n\u0011\u000bqa\u0019:fCR,G\rC\u0005\u0002\u001c\u0001\u0001\r\u0011\"\u0003\u0002\u001e\u0005Y1M]3bi\u0016$w\fJ3r)\u0011\t\t!a\b\t\u0013\u0005\u0005\u0012\u0011DA\u0001\u0002\u0004)\u0015a\u0001=%c!9\u0011Q\u0005\u0001!B\u0013)\u0015\u0001C2sK\u0006$X\r\u001a\u0011\t\u0011\u0005%\u0002\u00011A\u0005\n1\u000b\u0001DY=uKN\u001c\u0016N\\2f\u0019\u0006\u001cH/\u00138eKb,e\u000e\u001e:z\u0011%\ti\u0003\u0001a\u0001\n\u0013\ty#\u0001\u000fcsR,7oU5oG\u0016d\u0015m\u001d;J]\u0012,\u00070\u00128uef|F%Z9\u0015\t\u0005\u0005\u0011\u0011\u0007\u0005\n\u0003C\tY#!AA\u00025Cq!!\u000e\u0001A\u0003&Q*A\rcsR,7oU5oG\u0016d\u0015m\u001d;J]\u0012,\u00070\u00128uef\u0004\u0003\"CA\u001d\u0001\u0001\u0007I\u0011BA\u001e\u0003U\u0011x\u000e\u001c7j]\u001e\u0014\u0015m]3e)&lWm\u001d;b[B,\"!!\u0010\u0011\t%\ty$R\u0005\u0004\u0003\u0003R!AB(qi&|g\u000eC\u0005\u0002F\u0001\u0001\r\u0011\"\u0003\u0002H\u0005I\"o\u001c7mS:<')Y:fIRKW.Z:uC6\u0004x\fJ3r)\u0011\t\t!!\u0013\t\u0015\u0005\u0005\u00121IA\u0001\u0002\u0004\ti\u0004\u0003\u0005\u0002N\u0001\u0001\u000b\u0015BA\u001f\u0003Y\u0011x\u000e\u001c7j]\u001e\u0014\u0015m]3e)&lWm\u001d;b[B\u0004\u0003\u0006BA&\u0003#\u00022!CA*\u0013\r\t)F\u0003\u0002\tm>d\u0017\r^5mK\"I\u0011\u0011\f\u0001A\u0002\u0013%\u00111H\u0001\u0013?6\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'\u000fC\u0005\u0002^\u0001\u0001\r\u0011\"\u0003\u0002`\u00051r,\\1y)&lWm\u001d;b[B\u001cvNR1s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005\u0005\u0004BCA\u0011\u00037\n\t\u00111\u0001\u0002>!A\u0011Q\r\u0001!B\u0013\ti$A\n`[\u0006DH+[7fgR\fW\u000e]*p\r\u0006\u0014\b\u0005\u000b\u0003\u0002d\u0005E\u0003bBA6\u0001\u0011\u0005\u0011QN\u0001\u0016[\u0006DH+[7fgR\fW\u000e]*p\r\u0006\u0014x\fJ3r)\u0011\t\t!a\u001c\t\u000f\u0005E\u0014\u0011\u000ea\u0001\u000b\u0006IA/[7fgR\fW\u000e\u001d\u0005\u0007\u0003k\u0002A\u0011\u0001#\u0002#5\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'\u000fC\u0005\u0002z\u0001\u0001\r\u0011\"\u0003\u0002<\u0005Qrl\u001c4gg\u0016$xJZ'bqRKW.Z:uC6\u00048k\u001c$be\"I\u0011Q\u0010\u0001A\u0002\u0013%\u0011qP\u0001\u001f?>4gm]3u\u001f\u001al\u0015\r\u001f+j[\u0016\u001cH/Y7q'>4\u0015M]0%KF$B!!\u0001\u0002\u0002\"Q\u0011\u0011EA>\u0003\u0003\u0005\r!!\u0010\t\u0011\u0005\u0015\u0005\u0001)Q\u0005\u0003{\t1dX8gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007oU8GCJ\u0004\u0003\u0006BAB\u0003#Bq!a#\u0001\t\u0003\ti)A\u000fpM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e]*p\r\u0006\u0014x\fJ3r)\u0011\t\t!a$\t\u000f\u0005E\u0015\u0011\u0012a\u0001\u000b\u00061qN\u001a4tKRDa!!&\u0001\t\u0003!\u0015!G8gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007oU8GCJDa!!\u0003\u0001\t\u0003a\u0005bBAN\u0001\u0011\u0005\u0011QT\u0001\u001bG\u0006t7i\u001c8wKJ$Hk\u001c*fY\u0006$\u0018N^3PM\u001a\u001cX\r\u001e\u000b\u0004k\u0006}\u0005bBAI\u00033\u0003\r!\u0012\u0005\b\u0003G\u0003A\u0011AAS\u0003\u0019\t\u0007\u000f]3oIRQ\u0011\u0011AAT\u0003W\u000by+a-\t\u000f\u0005%\u0016\u0011\u0015a\u0001\u000b\u0006iA.\u0019:hKN$xJ\u001a4tKRDq!!,\u0002\"\u0002\u0007Q)\u0001\tmCJ<Wm\u001d;US6,7\u000f^1na\"9\u0011\u0011WAQ\u0001\u0004)\u0015aG:iC2dwn^(gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0005\u00026\u0006\u0005\u0006\u0019AA\\\u0003\u001d\u0011XmY8sIN\u00042aFA]\u0013\r\tY\f\u0007\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:)\t\u0005\u0005\u0016q\u0018\t\u0004\u001f\u0005\u0005\u0017bAAb!\tian\u001c8uQJ,\u0017\rZ:bM\u0016Dq!a2\u0001\t\u0013\tI-A\nf]N,(/Z(gMN,G/\u00138SC:<W\r\u0006\u0003\u0002\u0002\u0005-\u0007bBAI\u0003\u000b\u0004\r!\u0012\u0005\b\u0003\u001f\u0004A\u0011BAi\u0003M\t\u0007\u000f]3oI\u000eCWO\\6Ge>lg)\u001b7f)\u001di\u00151[Ak\u00033Dq!!.\u0002N\u0002\u0007a\u0003C\u0004\u0002X\u00065\u0007\u0019A'\u0002\u0011A|7/\u001b;j_:D\u0001\"a7\u0002N\u0002\u0007\u0011Q\\\u0001\u000fEV4g-\u001a:TkB\u0004H.[3s!\r9\u0012q\\\u0005\u0004\u0003CD\"A\u0004\"vM\u001a,'oU;qa2LWM\u001d\u0005\b\u0003K\u0004A\u0011AAt\u00039\t\u0007\u000f]3oI\u001a\u0013x.\u001c$jY\u0016$R!TAu\u0003WDq!!.\u0002d\u0002\u0007a\u0003C\u0004\u0002n\u0006\r\b\u0019A'\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005E\b\u0001\"\u0001\u0002t\u0006qQ\u000f\u001d3bi\u0016$\u0006P\\%oI\u0016DHCBA\u0001\u0003k\fy\u0010\u0003\u0005\u0002x\u0006=\b\u0019AA}\u00031\u0019w.\u001c9mKR,G\r\u0016=o!\rI\u00131`\u0005\u0004\u0003{\u0014!\u0001D\"p[BdW\r^3e)bt\u0007b\u0002B\u0001\u0003_\u0004\r!R\u0001\u0011Y\u0006\u001cHo\u0015;bE2,wJ\u001a4tKRDC!a<\u0002@\"9!q\u0001\u0001\u0005\n\t%\u0011aE;qI\u0006$X\r\u0015:pIV\u001cWM]*uCR,GCBA\u0001\u0005\u0017\u0011)\u0002\u0003\u0005\u0003\u000e\t\u0015\u0001\u0019\u0001B\b\u0003Q\u0001(o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4feB\u0019\u0011F!\u0005\n\u0007\tM!A\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d\u0005\t\u0005/\u0011)\u00011\u0001\u0003\u001a\u0005)!-\u0019;dQB\u0019qCa\u0007\n\u0007\tu\u0001DA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0007\u0002\u0003B\u0011\u0001\u0011\u0005!Aa\t\u0002\u001fQ\u0014\u0018M\\:mCR,wJ\u001a4tKR$bA!\n\u0003N\t=\u0003\u0003\u0002B\u0014\u0005\u000frAA!\u000b\u0003D9!!1\u0006B!\u001d\u0011\u0011iCa\u0010\u000f\t\t=\"Q\b\b\u0005\u0005c\u0011YD\u0004\u0003\u00034\teRB\u0001B\u001b\u0015\r\u00119DB\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001J!AH\u0010\n\u0005\u0015i\u0012BA\u000e\u001d\u0013\tI\"$C\u0002\u0003Fa\t1BR5mKJ+7m\u001c:eg&!!\u0011\nB&\u0005EaunZ(gMN,G\u000fU8tSRLwN\u001c\u0006\u0004\u0005\u000bB\u0002bBAI\u0005?\u0001\r!\u0012\u0005\n\u0005#\u0012y\u0002%AA\u00025\u000bAc\u001d;beRLgn\u001a$jY\u0016\u0004vn]5uS>t\u0007\u0006\u0002B\u0010\u0005+\u00022a\u0004B,\u0013\r\u0011I\u0006\u0005\u0002\u000bi\"\u0014X-\u00193tC\u001a,\u0007b\u0002B/\u0001\u0011\u0005!qL\u0001\u0005e\u0016\fG\r\u0006\u0006\u0003b\t5$\u0011\u000fB;\u0005s\u0002BAa\u0019\u0003j5\u0011!Q\r\u0006\u0004\u0005O\"\u0011AB:feZ,'/\u0003\u0003\u0003l\t\u0015$!\u0004$fi\u000eDG)\u0019;b\u0013:4w\u000eC\u0004\u0003p\tm\u0003\u0019A#\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0005g\u0012Y\u00061\u0001N\u0003\u001di\u0017\r_*ju\u0016D\u0011Ba\u001e\u0003\\A\u0005\t\u0019A#\u0002\u00175\f\u0007\u0010U8tSRLwN\u001c\u0005\n\u0005w\u0012Y\u0006%AA\u0002U\fQ\"\\5o\u001f:,W*Z:tC\u001e,\u0007\u0006\u0002B.\u0005+BqA!!\u0001\t\u0003\u0011\u0019)A\u000bgKR\u001c\u0007.\u00169qKJ\u0014u.\u001e8e\u001f\u001a47/\u001a;\u0015\r\u0005u\"Q\u0011BH\u0011!\u00119Ia A\u0002\t%\u0015aE:uCJ$xJ\u001a4tKR\u0004vn]5uS>t\u0007cA\u0015\u0003\f&\u0019!Q\u0012\u0002\u0003\u001d=3gm]3u!>\u001c\u0018\u000e^5p]\"9!\u0011\u0013B@\u0001\u0004i\u0015!\u00034fi\u000eD7+\u001b>f\u0011\u001d\u0011)\n\u0001C\u0001\u0005/\u000bqA]3d_Z,'\u000fF\u0003N\u00053\u0013Y\n\u0003\u0005\u0003\u000e\tM\u0005\u0019\u0001B\b\u0011)\u0011iJa%\u0011\u0002\u0003\u0007!qT\u0001\u0011Y\u0016\fG-\u001a:Fa>\u001c\u0007nQ1dQ\u0016\u0004R!CA \u0005C\u0003BAa)\u0003*6\u0011!Q\u0015\u0006\u0005\u0005O\u0013)'A\u0003fa>\u001c\u0007.\u0003\u0003\u0003,\n\u0015&\u0001\u0006'fC\u0012,'/\u00129pG\"4\u0015\u000e\\3DC\u000eDW\r\u000b\u0003\u0003\u0014\u0006}\u0006b\u0002BY\u0001\u0011%!1W\u0001\u0015Y>\fG\rT1sO\u0016\u001cH\u000fV5nKN$\u0018-\u001c9\u0015\u0005\u0005\u0005\u0001b\u0002B\\\u0001\u0011\u0005!\u0011X\u0001\fQ\u0006\u001cxJ^3sM2|w/F\u0001v\u0011\u001d\u0011i\f\u0001C\u0001\u0005\u007f\u000b!cY8mY\u0016\u001cG/\u00112peR,G\r\u0016=ogR1!\u0011\u0019Bd\u0005\u0017\u00042!\u000bBb\u0013\r\u0011)M\u0001\u0002\u0015)bt\u0017J\u001c3fqN+\u0017M]2i%\u0016\u001cX\u000f\u001c;\t\u000f\t%'1\u0018a\u0001\u000b\u0006Ya-\u001a;dQ>3gm]3u\u0011\u001d\u0011iMa/A\u0002\u0015\u000b\u0001#\u001e9qKJ\u0014u.\u001e8e\u001f\u001a47/\u001a;\t\u000f\tE\u0007\u0001\"\u0011\u0003T\u0006AAo\\*ue&tw\r\u0006\u0002\u0003VB!!q\u001bBo\u001d\rI!\u0011\\\u0005\u0004\u00057T\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0003`\n\u0005(AB*ue&twMC\u0002\u0003\\*AqA!:\u0001\t\u0003\u00119/\u0001\u0006ueVt7-\u0019;f)>$2!\u0014Bu\u0011\u001d\t\tJa9A\u0002\u0015CCAa9\u0002@\"1!q\u001e\u0001\u0005\u0002\u0011\u000baB]3bI:+\u0007\u0010^(gMN,G\u000f\u000b\u0003\u0003n\nU\u0003b\u0002B{\u0001\u0011\u0005!1W\u0001\u0006M2,8\u000f\u001b\u0015\u0005\u0005g\u0014)\u0006C\u0004\u0003|\u0002!\tA!@\u0002\u0013U\u0004H-\u0019;f\t&\u0014H\u0003BA\u0001\u0005\u007fD\u0001b!\u0001\u0003z\u0002\u000711A\u0001\u0004I&\u0014\b\u0003BB\u0003\u0007\u001fi!aa\u0002\u000b\t\r%11B\u0001\u0003S>T!a!\u0004\u0002\t)\fg/Y\u0005\u0005\u0007#\u00199A\u0001\u0003GS2,\u0007bBB\u000b\u0001\u0011\u00051qC\u0001\u0013G\"\fgnZ3GS2,7+\u001e4gSb,7\u000f\u0006\u0004\u0002\u0002\re1Q\u0004\u0005\t\u00077\u0019\u0019\u00021\u0001\u0003V\u0006Iq\u000e\u001c3Tk\u001a4\u0017\u000e\u001f\u0005\t\u0007?\u0019\u0019\u00021\u0001\u0003V\u0006Ia.Z<Tk\u001a4\u0017\u000e\u001f\u0005\b\u0007G\u0001A\u0011\u0001BZ\u0003]ygNQ3d_6,\u0017J\\1di&4XmU3h[\u0016tG\u000fC\u0004\u0004(\u0001!IAa-\u0002/1|\u0017\r\u001a$jeN$()\u0019;dQRKW.Z:uC6\u0004\bbBB\u0016\u0001\u0011\u00051QF\u0001\u0012i&lWmV1ji\u0016$gi\u001c:S_2dG#B#\u00040\rM\u0002bBB\u0019\u0007S\u0001\r!R\u0001\u0004]><\bbBB\u001b\u0007S\u0001\r!R\u0001\u0011[\u0016\u001c8/Y4f)&lWm\u001d;b[BDqa!\u000f\u0001\t\u0003\u0019Y$\u0001\fhKR4\u0015N]:u\u0005\u0006$8\r\u001b+j[\u0016\u001cH/Y7q)\u0005)\u0005bBB \u0001\u0011\u00051\u0011I\u0001\u0016M&tGm\u00144gg\u0016$()\u001f+j[\u0016\u001cH/Y7q)\u0019\u0019\u0019ea\u0013\u0004NA)\u0011\"a\u0010\u0004FA!!qEB$\u0013\u0011\u0019IEa\u0013\u0003%QKW.Z:uC6\u0004\u0018I\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0003c\u001ai\u00041\u0001F\u0011%\u0019ye!\u0010\u0011\u0002\u0003\u0007Q)\u0001\bti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;\t\u000f\rM\u0003\u0001\"\u0001\u00034\u0006)1\r\\8tK\"91q\u000b\u0001\u0005\u0002\tM\u0016!D2m_N,\u0007*\u00198eY\u0016\u00148\u000fC\u0004\u0004\\\u0001!\tAa-\u0002\u001d\u0011,G.\u001a;f\u0013\u001a,\u00050[:ug\"11q\f\u0001\u0005\u0002\u0011\u000bA\u0002\\1ti6{G-\u001b4jK\u0012Da!!,\u0001\t\u0003!\u0005bBB3\u0001\u0011\u00051qM\u0001\u0011Y\u0006\u001cH/T8eS\u001aLW\rZ0%KF$Ba!\u001b\u0004zA!11NB;\u001b\t\u0019iG\u0003\u0003\u0004p\rE\u0014\u0001\u00024jY\u0016TAaa\u001d\u0004\f\u0005\u0019a.[8\n\t\r]4Q\u000e\u0002\u0005!\u0006$\b\u000eC\u0004\u0004|\r\r\u0004\u0019A#\u0002\u00055\u001c\b\"CB@\u0001E\u0005I\u0011ABA\u0003E\u0011XmY8wKJ$C-\u001a4bk2$HEM\u000b\u0003\u0007\u0007SCAa(\u0004\u0006.\u00121q\u0011\t\u0005\u0007\u0013\u001b\u0019*\u0004\u0002\u0004\f*!1QRBH\u0003%)hn\u00195fG.,GMC\u0002\u0004\u0012*\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0019)ja#\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0004\u001a\u0002\t\n\u0011\"\u0001\u0004\u001c\u0006IBO]1og2\fG/Z(gMN,G\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019iJK\u0002N\u0007\u000bC\u0011b!)\u0001#\u0003%\taa)\u0002\u001dI,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u00111Q\u0015\u0016\u0004\u000b\u000e\u0015\u0005\"CBU\u0001E\u0005I\u0011ABV\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uIQ*\"a!,+\u0007U\u001c)\tC\u0005\u00042\u0002\t\n\u0011\"\u0001\u0004$\u0006yb-\u001b8e\u001f\u001a47/\u001a;CsRKW.Z:uC6\u0004H\u0005Z3gCVdG\u000f\n\u001a)\u0007\u0001\tylB\u0004\u00048\nA\ta!/\u0002\u00151{wmU3h[\u0016tG\u000fE\u0002*\u0007w3a!\u0001\u0002\t\u0002\ru6cAB^\u0011!9\u0011ma/\u0005\u0002\r\u0005GCAB]\u0011!\u0019)ma/\u0005\u0002\r\u001d\u0017\u0001B8qK:$\u0012cYBe\u0007\u0017\u001cima6\u0004Z\u000eu7\u0011]Bs\u0011!\u0019\taa1A\u0002\r\r\u0001BB\"\u0004D\u0002\u0007Q\t\u0003\u0005\u0004P\u000e\r\u0007\u0019ABi\u0003\u0019\u0019wN\u001c4jOB\u0019\u0011fa5\n\u0007\rU'AA\u0005M_\u001e\u001cuN\u001c4jO\"1qka1A\u0002eC\u0011ba7\u0004DB\u0005\t\u0019A;\u0002#\u0019LG.Z!me\u0016\fG-_#ySN$8\u000fC\u0005\u0004`\u000e\r\u0007\u0013!a\u0001\u001b\u0006a\u0011N\\5u\r&dWmU5{K\"I11]Bb!\u0003\u0005\r!^\u0001\faJ,\u0017\r\u001c7pG\u0006$X\r\u0003\u0006\u0004h\u000e\r\u0007\u0013!a\u0001\u0005+\f!BZ5mKN+hMZ5y\u0011!\u0019Yfa/\u0005\u0002\r-H\u0003CA\u0001\u0007[\u001cyo!=\t\u0011\r\u00051\u0011\u001ea\u0001\u0007\u0007AaaQBu\u0001\u0004)\u0005BCBt\u0007S\u0004\n\u00111\u0001\u0003V\"Q1Q_B^#\u0003%\taa+\u0002\u001d=\u0004XM\u001c\u0013eK\u001a\fW\u000f\u001c;%k!Q1\u0011`B^#\u0003%\taa'\u0002\u001d=\u0004XM\u001c\u0013eK\u001a\fW\u000f\u001c;%m!Q1Q`B^#\u0003%\taa+\u0002\u001d=\u0004XM\u001c\u0013eK\u001a\fW\u000f\u001c;%o!QA\u0011AB^#\u0003%\t\u0001b\u0001\u0002\u001d=\u0004XM\u001c\u0013eK\u001a\fW\u000f\u001c;%qU\u0011AQ\u0001\u0016\u0005\u0005+\u001c)\t\u0003\u0006\u0005\n\rm\u0016\u0013!C\u0001\t\u0007\t\u0001\u0004Z3mKR,\u0017JZ#ySN$8\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final LazyIndex<OffsetIndex> lazyOffsetIndex;
    private final LazyIndex<TimeIndex> lazyTimeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private volatile Option<Object> rollingBasedTimestamp;
    private volatile Option<Object> _maxTimestampSoFar;
    private volatile Option<Object> _offsetOfMaxTimestampSoFar;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return LogSegment$.MODULE$.deleteIfExists$default$3();
    }

    public static String open$default$8() {
        return LogSegment$.MODULE$.open$default$8();
    }

    public static boolean open$default$7() {
        return LogSegment$.MODULE$.open$default$7();
    }

    public static int open$default$6() {
        return LogSegment$.MODULE$.open$default$6();
    }

    public static boolean open$default$5() {
        return LogSegment$.MODULE$.open$default$5();
    }

    public static LogSegment open(File file, long l, LogConfig logConfig, Time time, boolean bl, int n, boolean bl2, String string) {
        return LogSegment$.MODULE$.open(file, l, logConfig, time, bl, n, bl2, string);
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public FileRecords log() {
        return this.log;
    }

    public LazyIndex<OffsetIndex> lazyOffsetIndex() {
        return this.lazyOffsetIndex;
    }

    public LazyIndex<TimeIndex> lazyTimeIndex() {
        return this.lazyTimeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public OffsetIndex offsetIndex() {
        return this.lazyOffsetIndex().get();
    }

    public TimeIndex timeIndex() {
        return this.lazyTimeIndex().get();
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs = this.timeWaitedForRoll(rollParams.now(), rollParams.maxTimestampInMessages()) > rollParams.maxSegmentMs() - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes() - rollParams.messagesSize() || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages());
    }

    public void resizeIndexes(int size2) {
        this.offsetIndex().resize(size2);
        this.timeIndex().resize(size2);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        if (this.lazyOffsetIndex().file().exists()) {
            Object object = timeIndexFileNewlyCreated ? BoxesRunTime.boxToBoolean((boolean)this.timeIndex().resize(0)) : BoxedUnit.UNIT;
            this.txnIndex().sanityCheck();
            return;
        }
        throw new NoSuchFileException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset index file ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.lazyOffsetIndex().file().getAbsolutePath()})));
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private Option<Object> _maxTimestampSoFar() {
        return this._maxTimestampSoFar;
    }

    private void _maxTimestampSoFar_$eq(Option<Object> x$1) {
        this._maxTimestampSoFar = x$1;
    }

    public void maxTimestampSoFar_$eq(long timestamp) {
        this._maxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)));
    }

    public long maxTimestampSoFar() {
        if (this._maxTimestampSoFar().isEmpty()) {
            this._maxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.timeIndex().lastEntry().timestamp())));
        }
        return BoxesRunTime.unboxToLong((Object)this._maxTimestampSoFar().get());
    }

    private Option<Object> _offsetOfMaxTimestampSoFar() {
        return this._offsetOfMaxTimestampSoFar;
    }

    private void _offsetOfMaxTimestampSoFar_$eq(Option<Object> x$1) {
        this._offsetOfMaxTimestampSoFar = x$1;
    }

    public void offsetOfMaxTimestampSoFar_$eq(long offset2) {
        this._offsetOfMaxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)offset2)));
    }

    public long offsetOfMaxTimestampSoFar() {
        if (this._offsetOfMaxTimestampSoFar().isEmpty()) {
            this._offsetOfMaxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.timeIndex().lastEntry().offset())));
        }
        return BoxesRunTime.unboxToLong((Object)this._offsetOfMaxTimestampSoFar().get());
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset2) {
        return this.offsetIndex().canAppendOffset(offset2);
    }

    public void append(long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        if (records.sizeInBytes() > 0) {
            this.trace((Function0<String>)new Serializable(this, largestOffset, largestTimestamp, shallowOffsetOfMaxTimestamp, records){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final long largestOffset$1;
                private final long largestTimestamp$1;
                private final long shallowOffsetOfMaxTimestamp$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inserting ", " bytes at end offset ", " at position ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.largestOffset$1), BoxesRunTime.boxToInteger((int)this.$outer.log().sizeInBytes())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with largest timestamp ", " at shallow offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.largestTimestamp$1), BoxesRunTime.boxToLong((long)this.shallowOffsetOfMaxTimestamp$1)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.largestOffset$1 = largestOffset$1;
                    this.largestTimestamp$1 = largestTimestamp$1;
                    this.shallowOffsetOfMaxTimestamp$1 = shallowOffsetOfMaxTimestamp$1;
                    this.records$1 = records$1;
                }
            });
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            this.kafka$log$LogSegment$$ensureOffsetInRange(largestOffset);
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String>)new Serializable(this, largestOffset, appendedBytes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final long largestOffset$1;
                private final int appendedBytes$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Appended ", " to ", " at end offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.appendedBytes$1), this.$outer.log().file(), BoxesRunTime.boxToLong((long)this.largestOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.largestOffset$1 = largestOffset$1;
                    this.appendedBytes$1 = appendedBytes$1;
                }
            });
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampSoFar_$eq(largestTimestamp);
                this.offsetOfMaxTimestampSoFar_$eq(shallowOffsetOfMaxTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.offsetIndex().append(largestOffset, physicalPosition);
                TimeIndex qual$1 = this.timeIndex();
                long x$4 = this.maxTimestampSoFar();
                long x$5 = this.offsetOfMaxTimestampSoFar();
                boolean x$6 = qual$1.maybeAppend$default$3();
                qual$1.maybeAppend(x$4, x$5, x$6);
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    public void kafka$log$LogSegment$$ensureOffsetInRange(long offset2) {
        if (this.canConvertToRelativeOffset(offset2)) {
            return;
        }
        throw new LogSegmentOffsetOverflowException(this, offset2);
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        IntRef bytesToAppend = IntRef.create((int)0);
        LongRef maxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef maxOffset = LongRef.create((long)Long.MIN_VALUE);
        ObjectRef readBuffer = ObjectRef.create((Object)bufferSupplier.get(0x100000));
        Iterator nextBatches = ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batchesFrom(position)).asScala()).iterator();
        nextBatches.takeWhile((Function1)new Serializable(this, bytesToAppend, readBuffer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;
            private final IntRef bytesToAppend$1;
            private final ObjectRef readBuffer$1;

            public final boolean apply(RecordBatch batch) {
                return this.$outer.kafka$log$LogSegment$$canAppend$1(batch, this.bytesToAppend$1, this.readBuffer$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytesToAppend$1 = bytesToAppend$1;
                this.readBuffer$1 = readBuffer$1;
            }
        }).foreach((Function1)new Serializable(this, bytesToAppend, maxTimestamp, offsetOfMaxTimestamp, maxOffset){
            public static final long serialVersionUID = 0L;
            private final IntRef bytesToAppend$1;
            private final LongRef maxTimestamp$1;
            private final LongRef offsetOfMaxTimestamp$1;
            private final LongRef maxOffset$1;

            public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                if (batch.maxTimestamp() > this.maxTimestamp$1.elem) {
                    this.maxTimestamp$1.elem = batch.maxTimestamp();
                    this.offsetOfMaxTimestamp$1.elem = batch.lastOffset();
                }
                this.maxOffset$1.elem = batch.lastOffset();
                this.bytesToAppend$1.elem += batch.sizeInBytes();
            }
            {
                this.bytesToAppend$1 = bytesToAppend$1;
                this.maxTimestamp$1 = maxTimestamp$1;
                this.offsetOfMaxTimestamp$1 = offsetOfMaxTimestamp$1;
                this.maxOffset$1 = maxOffset$1;
            }
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, MemoryRecords.readableRecords((ByteBuffer)((ByteBuffer)readBuffer.elem)));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start2) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start2; position < start2 + records.sizeInBytes(); position += bytesAppended) {
            bytesAppended = this.appendChunkFromFile(records, position, (BufferSupplier)bufferSupplier);
            if (bytesAppended != 0) continue;
            return position - start2;
        }
        return position - start2;
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset2) {
        if (completedTxn.isAborted()) {
            this.trace((Function0<String>)new Serializable(this, completedTxn, lastStableOffset2){
                public static final long serialVersionUID = 0L;
                private final CompletedTxn completedTxn$1;
                private final long lastStableOffset$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing aborted transaction ", " to transaction index, last stable offset is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.completedTxn$1, BoxesRunTime.boxToLong((long)this.lastStableOffset$1)}));
                }
                {
                    this.completedTxn$1 = completedTxn$1;
                    this.lastStableOffset$1 = lastStableOffset$1;
                }
            });
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset2));
        }
    }

    public void kafka$log$LogSegment$$updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, false);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch, (Option<LogOffsetMetadata>)None$.MODULE$);
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.foreach((Function1)new Serializable(this, producerStateManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final ProducerStateManager producerStateManager$2;

                public final void apply(CompletedTxn completedTxn) {
                    long lastStableOffset2 = this.producerStateManager$2.lastStableOffset(completedTxn);
                    this.$outer.updateTxnIndex(completedTxn, lastStableOffset2);
                    this.producerStateManager$2.completeTxn(completedTxn);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producerStateManager$2 = producerStateManager$2;
                }
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset2, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset2);
        return this.log().searchForOffsetWithSize(offset2, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int adjustedMaxSize;
        if (maxSize < 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid max size ", " for log read from segment ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSize), this.log()})));
        }
        FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
        if (startOffsetAndSize == null) {
            return null;
        }
        int startPosition = startOffsetAndSize.position;
        LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
        int n = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
        if (adjustedMaxSize == 0) {
            return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
        }
        int fetchSize = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
        return new FetchDataInfo(offsetMetadata, (Records)this.log().slice(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, FetchDataInfo$.MODULE$.apply$default$4());
    }

    public long read$default$3() {
        return this.size();
    }

    public boolean read$default$4() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetPosition x$1) {
                return x$1.offset();
            }
        });
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        Throwable throwable2;
        block3: {
            this.offsetIndex().reset();
            this.timeIndex().reset();
            this.txnIndex().reset();
            IntRef validBytes = IntRef.create((int)0);
            IntRef lastIndexEntry = IntRef.create((int)0);
            this.maxTimestampSoFar_$eq(-1L);
            try {
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.log().batches()).asScala()).foreach((Function1)new Serializable(this, producerStateManager, leaderEpochCache, validBytes, lastIndexEntry){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LogSegment $outer;
                    private final ProducerStateManager producerStateManager$1;
                    private final Option leaderEpochCache$1;
                    private final IntRef validBytes$1;
                    private final IntRef lastIndexEntry$1;

                    public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        batch.ensureValid();
                        this.$outer.kafka$log$LogSegment$$ensureOffsetInRange(batch.lastOffset());
                        if (batch.maxTimestamp() > this.$outer.maxTimestampSoFar()) {
                            this.$outer.maxTimestampSoFar_$eq(batch.maxTimestamp());
                            this.$outer.offsetOfMaxTimestampSoFar_$eq(batch.lastOffset());
                        }
                        if (this.validBytes$1.elem - this.lastIndexEntry$1.elem > this.$outer.indexIntervalBytes()) {
                            this.$outer.offsetIndex().append(batch.lastOffset(), this.validBytes$1.elem);
                            TimeIndex qual$2 = this.$outer.timeIndex();
                            long x$7 = this.$outer.maxTimestampSoFar();
                            long x$8 = this.$outer.offsetOfMaxTimestampSoFar();
                            boolean x$9 = qual$2.maybeAppend$default$3();
                            qual$2.maybeAppend(x$7, x$8, x$9);
                            this.lastIndexEntry$1.elem = this.validBytes$1.elem;
                        }
                        this.validBytes$1.elem += batch.sizeInBytes();
                        if (batch.magic() >= 2) {
                            this.leaderEpochCache$1.foreach((Function1)new Serializable(this, batch){
                                public static final long serialVersionUID = 0L;
                                public final FileLogInputStream.FileChannelRecordBatch batch$1;

                                public final void apply(LeaderEpochFileCache cache) {
                                    if (this.batch$1.partitionLeaderEpoch() > 0 && cache.latestEpoch().forall((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$recover$1$$anonfun$apply$2 $outer;

                                        public final boolean apply(int x$2) {
                                            return this.apply$mcZI$sp(x$2);
                                        }

                                        public boolean apply$mcZI$sp(int x$2) {
                                            return this.$outer.batch$1.partitionLeaderEpoch() > x$2;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    })) {
                                        cache.assign(this.batch$1.partitionLeaderEpoch(), this.batch$1.baseOffset());
                                    }
                                }
                                {
                                    this.batch$1 = batch$1;
                                }
                            });
                            this.$outer.kafka$log$LogSegment$$updateProducerState(this.producerStateManager$1, (RecordBatch)batch);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producerStateManager$1 = producerStateManager$1;
                        this.leaderEpochCache$1 = leaderEpochCache$1;
                        this.validBytes$1 = validBytes$1;
                        this.lastIndexEntry$1 = lastIndexEntry$1;
                    }
                });
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                boolean bl = throwable3 instanceof CorruptRecordException ? true : throwable3 instanceof InvalidRecordException;
                if (!bl) break block3;
                this.warn((Function0<String>)new Serializable(this, validBytes, throwable3){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LogSegment $outer;
                    private final IntRef validBytes$1;
                    private final Throwable x5$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s. %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.validBytes$1.elem), this.x5$1.getMessage(), this.x5$1.getCause()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.validBytes$1 = validBytes$1;
                        this.x5$1 = x5$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            int truncated = this.log().sizeInBytes() - validBytes.elem;
            if (truncated > 0) {
                this.debug((Function0<String>)new Serializable(this, truncated){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LogSegment $outer;
                    private final int truncated$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Truncated ", " invalid bytes at the end of segment ", " during recovery"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.truncated$1), this.$outer.log().file().getAbsoluteFile()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.truncated$1 = truncated$1;
                    }
                });
            }
            this.log().truncateTo(validBytes.elem);
            this.offsetIndex().trimToValidSize();
            this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
            this.timeIndex().trimToValidSize();
            return truncated;
        }
        throw throwable2;
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
        this.offsetOfMaxTimestampSoFar_$eq(lastTimeIndexEntry.offset());
        OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
        FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
        if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp()) {
            this.maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp);
            this.offsetOfMaxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.offset);
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(baseOffset=").append((Object)BoxesRunTime.boxToLong((long)this.baseOffset())).append((Object)", size=").append((Object)BoxesRunTime.boxToInteger((int)this.size())).append((Object)", lastModifiedTime=").append((Object)BoxesRunTime.boxToLong((long)this.lastModified())).append((Object)", largestTime=").append((Object)BoxesRunTime.boxToLong((long)this.largestTimestamp())).append((Object)")").toString();
    }

    public int truncateTo(long offset2) {
        int bytesTruncated;
        FileRecords.LogOffsetPosition mapping = this.translateOffset(offset2, this.translateOffset$default$2());
        this.offsetIndex().truncateTo(offset2);
        this.timeIndex().truncateTo(offset2);
        this.txnIndex().truncateTo(offset2);
        this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time().milliseconds());
            this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        if (this.maxTimestampSoFar() >= 0L) {
            this.loadLargestTimestamp();
        }
        return bytesTruncated;
    }

    public long readNextOffset() {
        FetchDataInfo fetchData = this.read(this.offsetIndex().lastOffset(), this.log().sizeInBytes(), this.read$default$3(), this.read$default$4());
        return fetchData == null ? this.baseOffset() : BoxesRunTime.unboxToLong((Object)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).lastOption().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(RecordBatch x$3) {
                return x$3.nextOffset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.baseOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().flush();
                this.$outer.offsetIndex().flush();
                this.$outer.timeIndex().flush();
                this.$outer.txnIndex().flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void updateDir(File dir) {
        this.log().setFile(new File(dir, this.log().file().getName()));
        this.lazyOffsetIndex().file_$eq(new File(dir, this.lazyOffsetIndex().file().getName()));
        this.lazyTimeIndex().file_$eq(new File(dir, this.lazyTimeIndex().file().getName()));
        this.txnIndex().file_$eq(new File(dir, this.txnIndex().file().getName()));
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        this.offsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyOffsetIndex().file().getPath(), oldSuffix, newSuffix)));
        this.timeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyTimeIndex().file().getPath(), oldSuffix, newSuffix)));
        this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    private void loadFirstBatchTimestamp() {
        java.util.Iterator iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp())));
        }
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        Some some;
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)(some = (Some)option).x())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public long getFirstBatchTimestamp() {
        Some some;
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)(some = (Some)option).x())) >= 0L ? t : Long.MAX_VALUE;
        return l;
    }

    public Option<FileRecords.TimestampAndOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup(package$.MODULE$.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset));
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().maybeAppend(this.$outer.maxTimestampSoFar(), this.$outer.offsetOfMaxTimestampSoFar(), true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.offsetIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.txnIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.offsetIndex().closeHandler();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().closeHandler();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().closeHandlers();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.txnIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogSegment$$delete$1((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deleteIfExists$1 $outer;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.$outer.kafka$log$LogSegment$$anonfun$$$outer().log().deleteIfExists();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, "log", this.$outer.log().file(), true);
            }

            public /* synthetic */ LogSegment kafka$log$LogSegment$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OffsetIndex offsetIndex = this.$outer.offsetIndex();
                this.$outer.kafka$log$LogSegment$$delete$1((Function0)new Serializable(this, offsetIndex){
                    public static final long serialVersionUID = 0L;
                    private final OffsetIndex eta$0$1$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.eta$0$1$1.deleteIfExists();
                    }
                    {
                        this.eta$0$1$1 = eta$0$1$1;
                    }
                }, "offset index", this.$outer.lazyOffsetIndex().file(), true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TimeIndex timeIndex = this.$outer.timeIndex();
                this.$outer.kafka$log$LogSegment$$delete$1((Function0)new Serializable(this, timeIndex){
                    public static final long serialVersionUID = 0L;
                    private final TimeIndex eta$0$2$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.eta$0$2$1.deleteIfExists();
                    }
                    {
                        this.eta$0$2$1 = eta$0$2$1;
                    }
                }, "time index", this.$outer.lazyTimeIndex().file(), true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogSegment$$delete$1((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deleteIfExists$4 $outer;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.$outer.kafka$log$LogSegment$$anonfun$$$outer().txnIndex().deleteIfExists();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, "transaction index", this.$outer.txnIndex().file(), false);
            }

            public /* synthetic */ LogSegment kafka$log$LogSegment$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }}))));
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public long largestTimestamp() {
        return this.maxTimestampSoFar() >= 0L ? this.maxTimestampSoFar() : this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.lazyOffsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.lazyTimeIndex().file().toPath(), fileTime);
    }

    public final boolean kafka$log$LogSegment$$canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public final void kafka$log$LogSegment$$delete$1(Function0 delete2, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete2.apply$mcZ$sp()) {
                this.info((Function0<String>)new Serializable(this, fileType, file){
                    public static final long serialVersionUID = 0L;
                    private final String fileType$1;
                    private final File file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted ", " ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fileType$1, this.file$1.getAbsolutePath()}));
                    }
                    {
                        this.fileType$1 = fileType$1;
                        this.file$1 = file$1;
                    }
                });
            } else if (logIfMissing) {
                this.info((Function0<String>)new Serializable(this, fileType, file){
                    public static final long serialVersionUID = 0L;
                    private final String fileType$1;
                    private final File file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete ", " ", " because it does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fileType$1, this.file$1.getAbsolutePath()}));
                    }
                    {
                        this.fileType$1 = fileType$1;
                        this.file$1 = file$1;
                    }
                });
            }
            return;
        }
        catch (IOException iOException) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delete of ", " ", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileType, file.getAbsolutePath()})), iOException);
        }
    }

    public LogSegment(FileRecords log, LazyIndex<OffsetIndex> lazyOffsetIndex, LazyIndex<TimeIndex> lazyTimeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.lazyOffsetIndex = lazyOffsetIndex;
        this.lazyTimeIndex = lazyTimeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging$class.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this._maxTimestampSoFar = None$.MODULE$;
        this._offsetOfMaxTimestampSoFar = None$.MODULE$;
    }
}

