/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\rt!B\u0001\u0003\u0011\u00039\u0011\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'O\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!AB\u0003\u000b\u0005!\u00051B\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM]\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\tq\u0003\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0003a\u0001\"!D\r\n\u0005iq!!B*i_J$\bB\u0002\u000f\nA\u0003%\u0001$\u0001\rQe>$WoY3s':\f\u0007o\u001d5piZ+'o]5p]\u0002BqAH\u0005C\u0002\u0013%q$\u0001\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG-F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0007BB\u0015\nA\u0003%\u0001%A\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG\r\t\u0005\bW%\u0011\r\u0011\"\u0003 \u0003!\u0019%o\u0019$jK2$\u0007BB\u0017\nA\u0003%\u0001%A\u0005De\u000e4\u0015.\u001a7eA!9q&\u0003b\u0001\n\u0013y\u0012a\u0004)s_\u0012,8-\u001a:JI\u001aKW\r\u001c3\t\rEJ\u0001\u0015!\u0003!\u0003A\u0001&o\u001c3vG\u0016\u0014\u0018\n\u001a$jK2$\u0007\u0005C\u00044\u0013\t\u0007I\u0011B\u0010\u0002#1\u000b7\u000f^*fcV,gnY3GS\u0016dG\r\u0003\u00046\u0013\u0001\u0006I\u0001I\u0001\u0013\u0019\u0006\u001cHoU3rk\u0016t7-\u001a$jK2$\u0007\u0005C\u00048\u0013\t\u0007I\u0011B\u0010\u0002%A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000e\u001a\u0005\u0007s%\u0001\u000b\u0011\u0002\u0011\u0002'A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000e\u001a\u0011\t\u000fmJ!\u0019!C\u0005?\u0005yA*Y:u\u001f\u001a47/\u001a;GS\u0016dG\r\u0003\u0004>\u0013\u0001\u0006I\u0001I\u0001\u0011\u0019\u0006\u001cHo\u00144gg\u0016$h)[3mI\u0002BqaP\u0005C\u0002\u0013%q$\u0001\tPM\u001a\u001cX\r\u001e#fYR\fg)[3mI\"1\u0011)\u0003Q\u0001\n\u0001\n\u0011c\u00144gg\u0016$H)\u001a7uC\u001aKW\r\u001c3!\u0011\u001d\u0019\u0015B1A\u0005\n}\ta\u0002V5nKN$\u0018-\u001c9GS\u0016dG\r\u0003\u0004F\u0013\u0001\u0006I\u0001I\u0001\u0010)&lWm\u001d;b[B4\u0015.\u001a7eA!9q)\u0003b\u0001\n\u0013y\u0012\u0001\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:GS\u0016dG\r\u0003\u0004J\u0013\u0001\u0006I\u0001I\u0001\u0016!J|G-^2fe\u0016sGO]5fg\u001aKW\r\u001c3!\u0011\u001dY\u0015B1A\u0005\n}\tQcQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195GS\u0016dG\r\u0003\u0004N\u0013\u0001\u0006I\u0001I\u0001\u0017\u0007>|'\u000fZ5oCR|'/\u00129pG\"4\u0015.\u001a7eA!9q*\u0003b\u0001\n\u0013y\u0012AG\"veJ,g\u000e\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r\u001e$jK2$\u0007BB)\nA\u0003%\u0001%A\u000eDkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;GS\u0016dG\r\t\u0005\b'&\u0011\r\u0011\"\u0003U\u000351VM]:j_:|eMZ:fiV\tQ\u000b\u0005\u0002\u000e-&\u0011qK\u0004\u0002\u0004\u0013:$\bBB-\nA\u0003%Q+\u0001\bWKJ\u001c\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0011\t\u000fmK!\u0019!C\u0005)\u0006I1I]2PM\u001a\u001cX\r\u001e\u0005\u0007;&\u0001\u000b\u0011B+\u0002\u0015\r\u00138m\u00144gg\u0016$\b\u0005C\u0004`\u0013\t\u0007I\u0011\u0002+\u0002+A\u0013x\u000eZ;dKJ,e\u000e\u001e:jKN|eMZ:fi\"1\u0011-\u0003Q\u0001\nU\u000ba\u0003\u0015:pIV\u001cWM]#oiJLWm](gMN,G\u000f\t\u0005\bG&\u0011\r\u0011\"\u0001e\u0003m\u0001&o\u001c3vG\u0016\u00148K\\1qg\"|G/\u00128uef\u001c6\r[3nCV\tQ\r\u0005\u0002ge6\tqM\u0003\u0002iS\u0006)A/\u001f9fg*\u0011!n[\u0001\taJ|Go\\2pY*\u0011A.\\\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015q'BA8q\u0003\u0019\t\u0007/Y2iK*\t\u0011/A\u0002pe\u001eL!a]4\u0003\rM\u001b\u0007.Z7b\u0011\u0019)\u0018\u0002)A\u0005K\u0006a\u0002K]8ek\u000e,'o\u00158baNDw\u000e^#oiJL8k\u00195f[\u0006\u0004\u0003bB<\n\u0005\u0004%\t\u0001Z\u0001\u0015!&$7K\\1qg\"|G/T1q'\u000eDW-\\1\t\reL\u0001\u0015!\u0003f\u0003U\u0001\u0016\u000eZ*oCB\u001c\bn\u001c;NCB\u001c6\r[3nC\u0002BQa_\u0005\u0005\u0002q\fAB]3bINs\u0017\r]:i_R$2!`A\r!\u0015q\u0018QBA\n\u001d\ry\u0018\u0011\u0002\b\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011bAA\u0006\u001d\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017q\u0001c\u0001\u0005\u0002\u0016%\u0019\u0011q\u0003\u0002\u0003%A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u000b:$(/\u001f\u0005\b\u00037Q\b\u0019AA\u000f\u0003\u00111\u0017\u000e\\3\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t%\u0003\tIw.\u0003\u0003\u0002(\u0005\u0005\"\u0001\u0002$jY\u0016Dq!a\u000b\n\t\u0013\ti#A\u0007xe&$Xm\u00158baNDw\u000e\u001e\u000b\u0007\u0003_\t)$a\u000e\u0011\u00075\t\t$C\u0002\u000249\u0011A!\u00168ji\"A\u00111DA\u0015\u0001\u0004\ti\u0002\u0003\u0005\u0002:\u0005%\u0002\u0019AA\u001e\u0003\u001d)g\u000e\u001e:jKN\u0004\u0002\"!\u0010\u0002H\u0005-\u00131C\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u00059Q.\u001e;bE2,'bAA#\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u0013q\b\u0002\u0004\u001b\u0006\u0004\bcA\u0007\u0002N%\u0019\u0011q\n\b\u0003\t1{gn\u001a\u0005\b\u0003'JA\u0011BA+\u00039I7o\u00158baNDw\u000e\u001e$jY\u0016$B!a\u0016\u0002^A\u0019Q\"!\u0017\n\u0007\u0005mcBA\u0004C_>dW-\u00198\t\u0011\u0005m\u0011\u0011\u000ba\u0001\u0003;A\u0001\"!\u0019\n\t\u0003\u0011\u00111M\u0001\u0012Y&\u001cHo\u00158baNDw\u000e\u001e$jY\u0016\u001cH\u0003BA3\u0003W\u0002RA`A4\u0003;IA!!\u001b\u0002\u0012\t\u00191+Z9\t\u0011\u00055\u0014q\fa\u0001\u0003;\t1\u0001Z5s\u0011!\t\t(\u0003C\u0001\u0005\u0005M\u0014!\u00063fY\u0016$Xm\u00158baNDw\u000e^:CK\u001a|'/\u001a\u000b\u0007\u0003_\t)(a\u001e\t\u0011\u00055\u0014q\u000ea\u0001\u0003;A\u0001\"!\u001f\u0002p\u0001\u0007\u00111J\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005u\u0014\u0002\"\u0003\u0002\u0000\u0005\u0019B-\u001a7fi\u0016\u001cf.\u00199tQ>$h)\u001b7fgR1\u0011qFAA\u0003\u0007C\u0001\"!\u001c\u0002|\u0001\u0007\u0011Q\u0004\u0005\u000b\u0003\u000b\u000bY\b%AA\u0002\u0005\u001d\u0015!\u00039sK\u0012L7-\u0019;f!\u001di\u0011\u0011RA&\u0003/J1!a#\u000f\u0005%1UO\\2uS>t\u0017\u0007C\u0005\u0002\u0010&\t\n\u0011\"\u0001\u0002\u0012\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a%+\u0007U\u000b)j\u000b\u0002\u0002\u0018B!\u0011\u0011TAR\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015!C;oG\",7m[3e\u0015\r\t\tKD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAS\u00037\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tI+CI\u0001\n\u0013\tY+A\u000feK2,G/Z*oCB\u001c\bn\u001c;GS2,7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tiK\u000b\u0003\u0002\b\u0006Ue!\u0002\u0006\u0003\u0001\u0005E6#BAX\u0019\u0005M\u0006\u0003BA[\u0003wk!!a.\u000b\u0007\u0005eF!A\u0003vi&d7/\u0003\u0003\u0002>\u0006]&a\u0002'pO\u001eLgn\u001a\u0005\f\u0003\u0003\fyK!b\u0001\n\u0003\t\u0019-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u0005\u0015\u0007\u0003BAd\u0003\u0013l\u0011a[\u0005\u0004\u0003\u0017\\'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\f\u0003\u001f\fyK!A!\u0002\u0013\t)-A\bu_BL7\rU1si&$\u0018n\u001c8!\u0011-\t\u0019.a,\u0003\u0002\u0004%\t!!6\u0002\r1|w\rR5s+\t\ti\u0002C\u0006\u0002Z\u0006=&\u00111A\u0005\u0002\u0005m\u0017A\u00037pO\u0012K'o\u0018\u0013fcR!\u0011qFAo\u0011)\ty.a6\u0002\u0002\u0003\u0007\u0011QD\u0001\u0004q\u0012\n\u0004bCAr\u0003_\u0013\t\u0011)Q\u0005\u0003;\tq\u0001\\8h\t&\u0014\b\u0005\u000b\u0003\u0002b\u0006\u001d\bcA\u0007\u0002j&\u0019\u00111\u001e\b\u0003\u0011Y|G.\u0019;jY\u0016D!\"a<\u00020\n\u0015\r\u0011\"\u0001U\u0003ei\u0017\r\u001f)s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|g.T:\t\u0015\u0005M\u0018q\u0016B\u0001B\u0003%Q+\u0001\u000enCb\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#ya&\u0014\u0018\r^5p]6\u001b\b\u0005C\u0004\u0014\u0003_#\t!a>\u0015\u0011\u0005e\u00181`A\u007f\u0003\u007f\u00042\u0001CAX\u0011!\t\t-!>A\u0002\u0005\u0015\u0007\u0002CAj\u0003k\u0004\r!!\b\t\u0013\u0005=\u0018Q\u001fI\u0001\u0002\u0004)\u0006B\u0003B\u0002\u0003_\u0013\r\u0011\"\u0003\u0003\u0006\u0005I\u0001O]8ek\u000e,'o]\u000b\u0003\u0003wA\u0011B!\u0003\u00020\u0002\u0006I!a\u000f\u0002\u0015A\u0014x\u000eZ;dKJ\u001c\b\u0005\u0003\u0006\u0003\u000e\u0005=\u0006\u0019!C\u0005\u0005\u001f\tQ\u0002\\1ti6\u000b\u0007o\u00144gg\u0016$XCAA&\u0011)\u0011\u0019\"a,A\u0002\u0013%!QC\u0001\u0012Y\u0006\u001cH/T1q\u001f\u001a47/\u001a;`I\u0015\fH\u0003BA\u0018\u0005/A!\"a8\u0003\u0012\u0005\u0005\t\u0019AA&\u0011%\u0011Y\"a,!B\u0013\tY%\u0001\bmCN$X*\u00199PM\u001a\u001cX\r\u001e\u0011\t\u0015\t}\u0011q\u0016a\u0001\n\u0013\u0011y!\u0001\bmCN$8K\\1q\u001f\u001a47/\u001a;\t\u0015\t\r\u0012q\u0016a\u0001\n\u0013\u0011)#\u0001\nmCN$8K\\1q\u001f\u001a47/\u001a;`I\u0015\fH\u0003BA\u0018\u0005OA!\"a8\u0003\"\u0005\u0005\t\u0019AA&\u0011%\u0011Y#a,!B\u0013\tY%A\bmCN$8K\\1q\u001f\u001a47/\u001a;!\u0011)\u0011y#a,C\u0002\u0013%!\u0011G\u0001\f_:<w.\u001b8h)bt7/\u0006\u0002\u00034AA!Q\u0007B\u001e\u0003\u0017\u0012y$\u0004\u0002\u00038)\u0019!\u0011\b\u0013\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005{\u00119DA\u0004Ue\u0016,W*\u00199\u0011\u0007!\u0011\t%C\u0002\u0003D\t\u00111\u0002\u0016=o\u001b\u0016$\u0018\rZ1uC\"I!qIAXA\u0003%!1G\u0001\r_:<w.\u001b8h)bt7\u000f\t\u0005\u000b\u0005\u0017\nyK1A\u0005\n\tE\u0012\u0001E;oe\u0016\u0004H.[2bi\u0016$G\u000b\u001f8t\u0011%\u0011y%a,!\u0002\u0013\u0011\u0019$A\tv]J,\u0007\u000f\\5dCR,G\r\u0016=og\u0002B\u0001Ba\u0015\u00020\u0012\u0005!QK\u0001\u0014M&\u00148\u000f^+ogR\f'\r\\3PM\u001a\u001cX\r^\u000b\u0003\u0005/\u0002R!\u0004B-\u0005;J1Aa\u0017\u000f\u0005\u0019y\u0005\u000f^5p]B!!q\fB3\u001b\t\u0011\tGC\u0002\u0003d\u0011\taa]3sm\u0016\u0014\u0018\u0002\u0002B4\u0005C\u0012\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011!\u0011Y'a,\u0005\u0002\t5\u0014AF8o\u0011&<\u0007nV1uKJl\u0017M]6Va\u0012\fG/\u001a3\u0015\t\u0005=\"q\u000e\u0005\t\u0005c\u0012I\u00071\u0001\u0002L\u0005i\u0001.[4i/\u0006$XM]7be.D\u0001B!\u001e\u00020\u0012\u0005!qO\u0001\u0015M&\u00148\u000f^+oI\u0016\u001c\u0017\u000eZ3e\u001f\u001a47/\u001a;\u0016\u0005\te\u0004#B\u0007\u0003Z\u0005-\u0003\u0002\u0003B?\u0003_#\tAa\u0004\u0002\u00195\f\u0007/\u00128e\u001f\u001a47/\u001a;\t\u0011\t\u0005\u0015q\u0016C\u0001\u0005\u0007\u000bq\"Y2uSZ,\u0007K]8ek\u000e,'o]\u000b\u0003\u0005\u000b\u0003\u0002Ba\"\u0003\u000e\u0006-\u00131C\u0007\u0003\u0005\u0013SAAa#\u0002D\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003\u0013\u0012I\t\u0003\u0005\u0003\u0012\u0006=F\u0011\u0001BJ\u0003\u001dI7/R7qif,\"!a\u0016\t\u0011\t]\u0015q\u0016C\u0005\u00053\u000b\u0001\u0003\\8bI\u001a\u0013x.\\*oCB\u001c\bn\u001c;\u0015\r\u0005=\"1\u0014BP\u0011!\u0011iJ!&A\u0002\u0005-\u0013A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\t\u0005C\u0013)\n1\u0001\u0002L\u0005Y1-\u001e:sK:$H+[7f\u0011%\u0011)+a,\u0005\u0002\t\u00119+A\tm_\u0006$\u0007K]8ek\u000e,'/\u00128uef$B!a\f\u0003*\"A!1\u0016BR\u0001\u0004\t\u0019\"A\u0003f]R\u0014\u0018\u0010\u0003\u0005\u00030\u0006=F\u0011\u0002BY\u0003EI7\u000f\u0015:pIV\u001cWM]#ya&\u0014X\r\u001a\u000b\u0007\u0003/\u0012\u0019La.\t\u0011\tU&Q\u0016a\u0001\u0003\u0017\nQbY;se\u0016tG\u000fV5nK6\u001b\b\u0002\u0003B]\u0005[\u0003\r!a\u0005\u0002\u001bA\u0014x\u000eZ;dKJ\u001cF/\u0019;f\u0011!\u0011i,a,\u0005\u0002\t}\u0016A\u0006:f[>4X-\u0012=qSJ,G\r\u0015:pIV\u001cWM]:\u0015\t\u0005=\"\u0011\u0019\u0005\t\u0005k\u0013Y\f1\u0001\u0002L!A!QYAX\t\u0003\u00119-A\tueVt7-\u0019;f\u0003:$'+\u001a7pC\u0012$\u0002\"a\f\u0003J\n-'q\u001a\u0005\t\u0005;\u0013\u0019\r1\u0001\u0002L!A!Q\u001aBb\u0001\u0004\tY%\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000f\u0003\u0005\u00036\n\r\u0007\u0019AA&\u0011!\u0011\u0019.a,\u0005\u0002\tU\u0017!\u00049sKB\f'/Z+qI\u0006$X\r\u0006\u0004\u0003X\nu'\u0011\u001d\t\u0004\u0011\te\u0017b\u0001Bn\u0005\t\u0011\u0002K]8ek\u000e,'/\u00119qK:$\u0017J\u001c4p\u0011!\u0011yN!5A\u0002\u0005-\u0013A\u00039s_\u0012,8-\u001a:JI\"A!1\u001dBi\u0001\u0004\t9&\u0001\u0007jg\u001a\u0013x.\\\"mS\u0016tG\u000f\u0003\u0005\u0003h\u0006=F\u0011\u0001Bu\u0003\u0019)\b\u000fZ1uKR!\u0011q\u0006Bv\u0011!\u0011iO!:A\u0002\t]\u0017AC1qa\u0016tG-\u00138g_\"A!\u0011_AX\t\u0003\u0011\u00190\u0001\nva\u0012\fG/Z'ba\u0016sGm\u00144gg\u0016$H\u0003BA\u0018\u0005kD\u0001Ba>\u0003p\u0002\u0007\u00111J\u0001\u000bY\u0006\u001cHo\u00144gg\u0016$\b\u0002\u0003B~\u0003_#\tA!@\u0002\u00131\f7\u000f^#oiJLH\u0003\u0002B\u0000\u0007\u0003\u0001R!\u0004B-\u0003'A\u0001Ba8\u0003z\u0002\u0007\u00111\n\u0005\t\u0007\u000b\ty\u000b\"\u0001\u0004\b\u0005aA/Y6f':\f\u0007o\u001d5piR\u0011\u0011q\u0006\u0005\t\u0007\u0017\ty\u000b\"\u0001\u0003x\u0005!B.\u0019;fgR\u001cf.\u00199tQ>$xJ\u001a4tKRD\u0001ba\u0004\u00020\u0012\u0005!qO\u0001\u0015_2$Wm\u001d;T]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;\t\u0011\rM\u0011q\u0016C\u0001\u0007+\tA\u0002\u001e:v]\u000e\fG/\u001a%fC\u0012$B!a\f\u0004\u0018!A!QTB\t\u0001\u0004\tY\u0005\u0003\u0005\u0004\u001c\u0005=F\u0011BB\u000f\u0003y\u0011X-\\8wKVs'/\u001a9mS\u000e\fG/\u001a3Ue\u0006t7/Y2uS>t7\u000f\u0006\u0003\u00020\r}\u0001\u0002CA=\u00073\u0001\r!a\u0013\t\u0011\r\r\u0012q\u0016C\u0001\u0007\u000f\t\u0001\u0002\u001e:v]\u000e\fG/\u001a\u0005\t\u0007O\ty\u000b\"\u0001\u0004*\u0005\u0001B.Y:u'R\f'\r\\3PM\u001a\u001cX\r\u001e\u000b\u0005\u0003\u0017\u001aY\u0003\u0003\u0005\u0004.\r\u0015\u0002\u0019AB\u0018\u00031\u0019w.\u001c9mKR,G\r\u0016=o!\rA1\u0011G\u0005\u0004\u0007g\u0011!\u0001D\"p[BdW\r^3e)bt\u0007\u0002CB\u001c\u0003_#\ta!\u000f\u0002\u0017\r|W\u000e\u001d7fi\u0016$\u0006P\u001c\u000b\u0005\u0003_\u0019Y\u0004\u0003\u0005\u0004.\rU\u0002\u0019AB\u0018\u0011!\t\t(a,\u0005\u0002\r}B\u0003BA\u0018\u0007\u0003B\u0001\"!\u001f\u0004>\u0001\u0007\u00111\n\u0015\u0005\u0007{\u0019)\u0005\u0005\u0003\u00026\u000e\u001d\u0013\u0002BB%\u0003o\u0013!\u0002\u001e5sK\u0006$7/\u00194f\u0011!\u0019i%a,\u0005\n\r=\u0013AE8mI\u0016\u001cHo\u00158baNDw\u000e\u001e$jY\u0016,\"a!\u0015\u0011\u000b5\u0011I&!\b\t\u0011\rU\u0013q\u0016C\u0005\u0007\u001f\n!\u0003\\1uKN$8K\\1qg\"|GOR5mK\"A\u0011\u0011MAX\t\u0013\u0019I&\u0006\u0002\u0002f!\"\u0011qVB/!\u0011\t)la\u0018\n\t\r\u0005\u0014q\u0017\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private volatile File logDir;
    private final int maxProducerIdExpirationMs;
    private final Map<Object, ProducerStateEntry> producers;
    private long kafka$log$ProducerStateManager$$lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> kafka$log$ProducerStateManager$$ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    private Logger logger$lzycompute() {
        ProducerStateManager producerStateManager = this;
        synchronized (producerStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    public long kafka$log$ProducerStateManager$$lastMapOffset() {
        return this.kafka$log$ProducerStateManager$$lastMapOffset;
    }

    private void kafka$log$ProducerStateManager$$lastMapOffset_$eq(long x$1) {
        this.kafka$log$ProducerStateManager$$lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    public TreeMap<Object, TxnMetadata> kafka$log$ProducerStateManager$$ongoingTxns() {
        return this.kafka$log$ProducerStateManager$$ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    public Option<LogOffsetMetadata> firstUnstableOffset() {
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LogOffsetMetadata apply(Map.Entry<Object, TxnMetadata> x$3) {
                return x$3.getValue().firstOffset();
            }
        });
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.kafka$log$ProducerStateManager$$ongoingTxns().firstEntry()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LogOffsetMetadata apply(Map.Entry<Object, TxnMetadata> x$4) {
                return x$4.getValue().firstOffset();
            }
        });
        return unreplicatedFirstOffset.isEmpty() ? undecidedFirstOffset : (undecidedFirstOffset.isEmpty() ? unreplicatedFirstOffset : (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset() ? undecidedFirstOffset : unreplicatedFirstOffset));
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.kafka$log$ProducerStateManager$$ongoingTxns().firstEntry()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Map.Entry<Object, TxnMetadata> x$5) {
                return x$5.getValue().firstOffset().messageOffset();
            }
        });
    }

    public long mapEndOffset() {
        return this.kafka$log$ProducerStateManager$$lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFromSnapshot(long logStartOffset2, long currentTime) {
        Option<File> option;
        while ((option = this.latestSnapshotFile()) instanceof Some) {
            Some some = (Some)option;
            File file = (File)some.x();
            try {
                this.info((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final File file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading producer state from snapshot file '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
                Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(file).filter((Function1)new Serializable(this, currentTime){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProducerStateManager $outer;
                    private final long currentTime$1;

                    public final boolean apply(ProducerStateEntry producerEntry) {
                        return !this.$outer.kafka$log$ProducerStateManager$$isProducerExpired(this.currentTime$1, producerEntry);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.currentTime$1 = currentTime$1;
                    }
                });
                loadedProducers.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProducerStateManager $outer;

                    public final void apply(ProducerStateEntry entry2) {
                        this.$outer.loadProducerEntry(entry2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.lastSnapOffset_$eq(Log$.MODULE$.offsetFromFile(file));
                this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(this.lastSnapOffset());
                return;
            }
            catch (CorruptSnapshotException corruptSnapshotException) {
                void var7_5;
                this.warn((Function0<String>)new Serializable(this, (File)var7_5, corruptSnapshotException){
                    public static final long serialVersionUID = 0L;
                    private final File file$1;
                    private final CorruptSnapshotException e$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load producer snapshot from '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1, this.e$1.getMessage()}));
                    }
                    {
                        this.file$1 = file$1;
                        this.e$1 = e$1;
                    }
                });
                boolean bl = Files.deleteIfExists(var7_5.toPath());
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.lastSnapOffset_$eq(logStartOffset2);
            this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(logStartOffset2);
            return;
        }
        throw new MatchError(option);
    }

    public void loadProducerEntry(ProducerStateEntry entry2) {
        long producerId = entry2.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry2);
        entry2.currentTxnFirstOffset().foreach((Function1)new Serializable(this, producerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManager $outer;
            private final long producerId$2;

            public final TxnMetadata apply(long offset2) {
                return this.$outer.kafka$log$ProducerStateManager$$ongoingTxns().put(BoxesRunTime.boxToLong((long)offset2), new TxnMetadata(this.producerId$2, offset2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerId$2 = producerId$2;
            }
        });
    }

    public boolean kafka$log$ProducerStateManager$$isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().retain((Function2)new Serializable(this, currentTimeMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManager $outer;
            private final long currentTimeMs$1;

            public final boolean apply(long x0$2, ProducerStateEntry x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$2), (Object)x1$1);
                if (tuple2 != null) {
                    ProducerStateEntry lastEntry2 = (ProducerStateEntry)tuple2._2();
                    boolean bl = !this.$outer.kafka$log$ProducerStateManager$$isProducerExpired(this.currentTimeMs$1, lastEntry2);
                    return bl;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentTimeMs$1 = currentTimeMs$1;
            }
        });
    }

    public void truncateAndReload(long logStartOffset2, long logEndOffset2, long currentTimeMs) {
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), (Function1<Object, Object>)new Serializable(this, logStartOffset2, logEndOffset2){
            public static final long serialVersionUID = 0L;
            private final long logStartOffset$1;
            private final long logEndOffset$1;

            public final boolean apply(long snapOffset) {
                return this.apply$mcZJ$sp(snapOffset);
            }

            public boolean apply$mcZJ$sp(long snapOffset) {
                return snapOffset > this.logEndOffset$1 || snapOffset <= this.logStartOffset$1;
            }
            {
                this.logStartOffset$1 = logStartOffset$1;
                this.logEndOffset$1 = logEndOffset$1;
            }
        });
        if (logEndOffset2 != this.mapEndOffset()) {
            this.producers().clear();
            this.kafka$log$ProducerStateManager$$ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset2, currentTimeMs);
        } else {
            this.truncateHead(logStartOffset2);
        }
    }

    public ProducerAppendInfo prepareUpdate(long producerId, boolean isFromClient) {
        Product product;
        if (isFromClient) {
            String string = this.topicPartition().topic();
            String string2 = "__consumer_offsets";
            product = !(string != null ? !string.equals(string2) : string2 != null) ? ValidationType$EpochOnly$.MODULE$ : ValidationType$Full$.MODULE$;
        } else {
            product = ValidationType$None$.MODULE$;
        }
        ValidationType$None$ validationToPerform = product;
        ProducerStateEntry currentEntry = (ProducerStateEntry)this.lastEntry(producerId).getOrElse((Function0)new Serializable(this, producerId){
            public static final long serialVersionUID = 0L;
            private final long producerId$1;

            public final ProducerStateEntry apply() {
                return ProducerStateEntry$.MODULE$.empty(this.producerId$1);
            }
            {
                this.producerId$1 = producerId$1;
            }
        });
        return new ProducerAppendInfo(this.topicPartition(), producerId, currentEntry, validationToPerform);
    }

    public void update(ProducerAppendInfo appendInfo) {
        Option option;
        block6: {
            block5: {
                BoxedUnit boxedUnit;
                ProducerStateEntry updatedEntry;
                block4: {
                    if (appendInfo.producerId() == -1L) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid producer id ", " passed to update "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)appendInfo.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()}))).toString());
                    }
                    this.trace((Function0<String>)new Serializable(this, appendInfo){
                        public static final long serialVersionUID = 0L;
                        private final ProducerAppendInfo appendInfo$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated producer ", " state to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.appendInfo$1.producerId()), this.appendInfo$1}));
                        }
                        {
                            this.appendInfo$1 = appendInfo$1;
                        }
                    });
                    updatedEntry = appendInfo.toEntry();
                    option = this.producers().get((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()));
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    ProducerStateEntry currentEntry = (ProducerStateEntry)some.x();
                    currentEntry.update(updatedEntry);
                    boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                boxedUnit = this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)updatedEntry);
            }
            appendInfo.startedTransactions().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerStateManager $outer;

                public final TxnMetadata apply(TxnMetadata txn) {
                    return this.$outer.kafka$log$ProducerStateManager$$ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), txn);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    public void updateMapEndOffset(long lastOffset) {
        this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        if (this.kafka$log$ProducerStateManager$$lastMapOffset() > this.lastSnapOffset()) {
            File snapshotFile = Log$.MODULE$.producerSnapshotFile(this.logDir(), this.kafka$log$ProducerStateManager$$lastMapOffset());
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerStateManager $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing producer snapshot at offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.kafka$log$ProducerStateManager$$lastMapOffset())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile, this.producers());
            this.lastSnapOffset_$eq(this.kafka$log$ProducerStateManager$$lastMapOffset());
        }
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        });
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        });
    }

    public void truncateHead(long logStartOffset2) {
        this.removeUnreplicatedTransactions(logStartOffset2);
        if (this.kafka$log$ProducerStateManager$$lastMapOffset() < logStartOffset2) {
            this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(logStartOffset2);
        }
        this.deleteSnapshotsBefore(logStartOffset2);
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)new Serializable(this, logStartOffset2){
            public static final long serialVersionUID = 0L;
            private final long logStartOffset$2;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.logStartOffset$2;
            }
            {
                this.logStartOffset$2 = logStartOffset$2;
            }
        })));
    }

    private void removeUnreplicatedTransactions(long offset2) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator2 = this.unreplicatedTxns().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator2.next();
            Option<Object> lastOffset = txnEntry.getValue().lastOffset();
            if (!lastOffset.exists((Function1)new Serializable(this, offset2){
                public static final long serialVersionUID = 0L;
                private final long offset$2;

                public final boolean apply(long x$6) {
                    return this.apply$mcZJ$sp(x$6);
                }

                public boolean apply$mcZJ$sp(long x$6) {
                    return x$6 < this.offset$2;
                }
                {
                    this.offset$2 = offset$2;
                }
            })) continue;
            iterator2.remove();
        }
    }

    public void truncate() {
        this.producers().clear();
        this.kafka$log$ProducerStateManager$$ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles$default$2());
        this.lastSnapOffset_$eq(0L);
        this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(0L);
    }

    public long lastStableOffset(CompletedTxn completedTxn) {
        Option nextIncompleteTxn = ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.kafka$log$ProducerStateManager$$ongoingTxns().values()).asScala()).find((Function1)new Serializable(this, completedTxn){
            public static final long serialVersionUID = 0L;
            private final CompletedTxn completedTxn$1;

            public final boolean apply(TxnMetadata x$7) {
                return x$7.producerId() != this.completedTxn$1.producerId();
            }
            {
                this.completedTxn$1 = completedTxn$1;
            }
        });
        return BoxesRunTime.unboxToLong((Object)nextIncompleteTxn.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(TxnMetadata x$8) {
                return x$8.firstOffset().messageOffset();
            }
        }).getOrElse((Function0)new Serializable(this, completedTxn){
            public static final long serialVersionUID = 0L;
            private final CompletedTxn completedTxn$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.completedTxn$1.lastOffset() + 1L;
            }
            {
                this.completedTxn$1 = completedTxn$1;
            }
        }));
    }

    public void completeTxn(CompletedTxn completedTxn) {
        TxnMetadata txnMetadata = this.kafka$log$ProducerStateManager$$ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to complete transaction ", " on partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{completedTxn, this.topicPartition()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which was not started"})).s((Seq)Nil$.MODULE$)).toString());
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
    }

    public void deleteSnapshotsBefore(long offset2) {
        ProducerStateManager$.MODULE$.deleteSnapshotsBefore(this.logDir(), offset2);
    }

    private Option<File> oldestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.minBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        }, (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Option<File> latestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.maxBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        }, (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Seq<File> listSnapshotFiles() {
        return ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir());
    }

    public ProducerStateManager(TopicPartition topicPartition, File logDir, int maxProducerIdExpirationMs) {
        this.topicPartition = topicPartition;
        this.logDir = logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ProducerStateManager partition=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
        this.producers = Map$.MODULE$.empty();
        this.kafka$log$ProducerStateManager$$lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.kafka$log$ProducerStateManager$$ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

