/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.QuotaTestClients$;
import kafka.server.ClientQuotaManager;
import kafka.server.DynamicConfig;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.Assert;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-r!B\u0013'\u0011\u0003Yc!B\u0017'\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004\"B\u001c\u0002\t\u0003Ad!B\u0017'\u0003\u0003I\u0005\u0002\u0003&\u0005\u0005\u0003\u0005\u000b\u0011B&\t\u0011Y#!\u0011!Q\u0001\n]C\u0001\"\u0018\u0003\u0003\u0002\u0003\u0006Ia\u0013\u0005\t=\u0012\u0011\t\u0011)A\u0005\u0017\"Aq\f\u0002BC\u0002\u0013\u0005\u0001\r\u0003\u0005o\t\t\u0005\t\u0015!\u0003b\u0011!yGA!b\u0001\n\u0003\u0001\b\u0002\u0003<\u0005\u0005\u0003\u0005\u000b\u0011B9\t\u000bU\"A\u0011A<\t\r}$a\u0011AA\u0001\u0011\u001d\t\u0019\u0002\u0002D\u0001\u0003+Aq!a\f\u0005\r\u0003\t\t\u0004C\u0004\u00024\u00111\t!!\u000e\t\u000f\u0005\u0005C\u0001\"\u0001\u0002D!9\u0011q\f\u0003\u0005\u0002\u0005\u0005\u0004\"CA<\tE\u0005I\u0011AA=\u0011\u001d\ty\t\u0002C\u0001\u0003#C\u0011\"a&\u0005#\u0003%\t!!\u001f\t\u000f\u0005eE\u0001\"\u0001\u0002\u001c\"I\u0011Q\u0015\u0003\u0012\u0002\u0013\u0005\u0011\u0011\u0010\u0005\b\u0003O#A\u0011AAU\u0011%\ty\u000bBI\u0001\n\u0003\tI\bC\u0004\u00022\u0012!\t!a-\t\u000f\u0005\rG\u0001\"\u0001\u0002F\"9\u0011\u0011\u001b\u0003\u0005\u0002\u0005M\u0007bBAp\t\u0011\u0005\u0011\u0011\u001d\u0005\b\u0003G$A\u0011AAs\u0011\u001d\tI\u000f\u0002C\u0001\u0003WD\u0011\"!?\u0005#\u0003%\t!a?\t\u000f\u0005}H\u0001\"\u0001\u0003\u0002!9!\u0011\u0004\u0003\u0005\u0002\tm\u0001\"\u0003B\u0013\tE\u0005I\u0011\u0001B\u0014\u0003A\tVo\u001c;b)\u0016\u001cHo\u00117jK:$8O\u0003\u0002(Q\u0005\u0019\u0011\r]5\u000b\u0003%\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002-\u00035\taE\u0001\tRk>$\u0018\rV3ti\u000ec\u0017.\u001a8ugN\u0011\u0011a\f\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Y\u0013aC7fiJL7MV1mk\u0016$\"!\u000f\u001f\u0011\u0005AR\u0014BA\u001e2\u0005\u0019!u.\u001e2mK\")Qh\u0001a\u0001}\u00051Q.\u001a;sS\u000e\u0004\"aP$\u000e\u0003\u0001S!!\u0011\"\u0002\r\r|W.\\8o\u0015\tI3I\u0003\u0002E\u000b\u00061\u0011\r]1dQ\u0016T\u0011AR\u0001\u0004_J<\u0017B\u0001%A\u0005\u0019iU\r\u001e:jGN\u0011AaL\u0001\u0006i>\u0004\u0018n\u0019\t\u0003\u0019Ns!!T)\u0011\u00059\u000bT\"A(\u000b\u0005AS\u0013A\u0002\u001fs_>$h(\u0003\u0002Sc\u00051\u0001K]3eK\u001aL!\u0001V+\u0003\rM#(/\u001b8h\u0015\t\u0011\u0016'\u0001\u0006mK\u0006$WM\u001d(pI\u0016\u0004\"\u0001W.\u000e\u0003eS!A\u0017\u0015\u0002\rM,'O^3s\u0013\ta\u0016LA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018\u0001\u00059s_\u0012,8-\u001a:DY&,g\u000e^%e\u0003A\u0019wN\\:v[\u0016\u00148\t\\5f]RLE-\u0001\u0005qe>$WoY3s+\u0005\t\u0007\u0003\u00022gQ\"l\u0011a\u0019\u0006\u0003?\u0012T!!\u001a\"\u0002\u000f\rd\u0017.\u001a8ug&\u0011qm\u0019\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u0007AJ7.\u0003\u0002kc\t)\u0011I\u001d:bsB\u0011\u0001\u0007\\\u0005\u0003[F\u0012AAQ=uK\u0006I\u0001O]8ek\u000e,'\u000fI\u0001\tG>t7/^7feV\t\u0011\u000f\u0005\u0003si\"DW\"A:\u000b\u0005=$\u0017BA;t\u00055Y\u0015MZ6b\u0007>t7/^7fe\u0006I1m\u001c8tk6,'\u000f\t\u000b\bqfT8\u0010`?\u007f!\taC\u0001C\u0003K\u001b\u0001\u00071\nC\u0003W\u001b\u0001\u0007q\u000bC\u0003^\u001b\u0001\u00071\nC\u0003_\u001b\u0001\u00071\nC\u0003`\u001b\u0001\u0007\u0011\rC\u0003p\u001b\u0001\u0007\u0011/A\u0007vg\u0016\u0014\bK]5oG&\u0004\u0018\r\\\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003bkRD'bAA\u0007\u0001\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002\u0012\u0005\u001d!AD&bM.\f\u0007K]5oG&\u0004\u0018\r\\\u0001\u000f_Z,'O]5eKF+x\u000e^1t)!\t9\"!\b\u0002(\u0005-\u0002c\u0001\u0019\u0002\u001a%\u0019\u00111D\u0019\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003?y\u0001\u0019AA\u0011\u00035\u0001(o\u001c3vG\u0016\u0014\u0018+^8uCB\u0019\u0001'a\t\n\u0007\u0005\u0015\u0012G\u0001\u0003M_:<\u0007bBA\u0015\u001f\u0001\u0007\u0011\u0011E\u0001\u000eG>t7/^7feF+x\u000e^1\t\r\u00055r\u00021\u0001:\u00031\u0011X-];fgR\fVo\u001c;b\u0003Q\u0011X-\\8wKF+x\u000e^1Pm\u0016\u0014(/\u001b3fgR\u0011\u0011qC\u0001\u0010cV|G/Y'fiJL7\rV1hgR!\u0011qGA\u001f!\u0015a\u0015\u0011H&L\u0013\r\tY$\u0016\u0002\u0004\u001b\u0006\u0004\bBBA #\u0001\u00071*\u0001\u0005dY&,g\u000e^%e\u0003\u0015\tXo\u001c;b)!\t)%!\u0015\u0002\\\u0005u\u0003\u0003BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-\u0003)A\u0004nKR\u0014\u0018nY:\n\t\u0005=\u0013\u0011\n\u0002\u0006#V|G/\u0019\u0005\b\u0003'\u0012\u0002\u0019AA+\u00031\tXo\u001c;b\u001b\u0006t\u0017mZ3s!\rA\u0016qK\u0005\u0004\u00033J&AE\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJDaa \nA\u0002\u0005\r\u0001BBA %\u0001\u00071*A\u000bqe>$WoY3V]RLG\u000e\u00165s_R$H.\u001a3\u0015\r\u0005\r\u0014\u0011NA7!\r\u0001\u0014QM\u0005\u0004\u0003O\n$aA%oi\"9\u00111N\nA\u0002\u0005\r\u0014AC7bqJ+7m\u001c:eg\"I\u0011qN\n\u0011\u0002\u0003\u0007\u0011\u0011O\u0001\u0019o\u0006LGOR8s%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007c\u0001\u0019\u0002t%\u0019\u0011QO\u0019\u0003\u000f\t{w\u000e\\3b]\u0006y\u0002O]8ek\u000e,WK\u001c;jYRC'o\u001c;uY\u0016$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m$\u0006BA9\u0003{Z#!a \u0011\t\u0005\u0005\u00151R\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013\u000b\u0014AC1o]>$\u0018\r^5p]&!\u0011QRAB\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016G>t7/^7f+:$\u0018\u000e\u001c+ie>$H\u000f\\3e)\u0019\t\u0019'a%\u0002\u0016\"9\u00111N\u000bA\u0002\u0005\r\u0004\"CA8+A\u0005\t\u0019AA9\u0003}\u0019wN\\:v[\u0016,f\u000e^5m)\"\u0014x\u000e\u001e;mK\u0012$C-\u001a4bk2$HEM\u0001\u0016m\u0016\u0014\u0018NZ=Qe>$WoY3UQJ|G\u000f\u001e7f)\u0019\t9\"!(\u0002\"\"9\u0011qT\fA\u0002\u0005E\u0014AD3ya\u0016\u001cG\u000f\u00165s_R$H.\u001a\u0005\n\u0003G;\u0002\u0013!a\u0001\u0003c\n!C^3sS\u001aL8\t\\5f]RlU\r\u001e:jG\u0006yb/\u001a:jMf\u0004&o\u001c3vG\u0016$\u0006N]8ui2,G\u0005Z3gCVdG\u000f\n\u001a\u0002+Y,'/\u001b4z\u0007>t7/^7f)\"\u0014x\u000e\u001e;mKR1\u0011qCAV\u0003[Cq!a(\u001a\u0001\u0004\t\t\bC\u0005\u0002$f\u0001\n\u00111\u0001\u0002r\u0005yb/\u001a:jMf\u001cuN\\:v[\u0016$\u0006N]8ui2,G\u0005Z3gCVdG\u000f\n\u001a\u00021Y,'/\u001b4z)\"\u0014x\u000e\u001e;mKRKW.Z'fiJL7\r\u0006\u0005\u0002\u0018\u0005U\u0016qXAa\u0011\u001d\t9l\u0007a\u0001\u0003s\u000b\u0011\"];pi\u0006$\u0016\u0010]3\u0011\u0007a\u000bY,C\u0002\u0002>f\u0013\u0011\"U;pi\u0006$\u0016\u0010]3\t\r\u0005}2\u00041\u0001L\u0011\u001d\tyj\u0007a\u0001\u0003c\n!\u0003\u001e5s_R$H.Z'fiJL7MT1nKR1\u0011qYAg\u0003\u001f\u00042aPAe\u0013\r\tY\r\u0011\u0002\u000b\u001b\u0016$(/[2OC6,\u0007bBA\\9\u0001\u0007\u0011\u0011\u0018\u0005\u0007\u0003\u007fa\u0002\u0019A&\u0002\u001dQD'o\u001c;uY\u0016lU\r\u001e:jGR1\u0011Q[An\u0003;\u0004B!a\u0012\u0002X&!\u0011\u0011\\A%\u0005-Y\u0015MZ6b\u001b\u0016$(/[2\t\u000f\u0005]V\u00041\u0001\u0002:\"1\u0011qH\u000fA\u0002-\u000b1#\u001a=f[B$(+Z9vKN$X*\u001a;sS\u000e,\"!!6\u0002MY,'/\u001b4z!J|G-^2fe\u000ec\u0017.\u001a8u)\"\u0014x\u000e\u001e;mKRKW.Z'fiJL7\r\u0006\u0003\u0002\u0018\u0005\u001d\bbBAP?\u0001\u0007\u0011\u0011O\u0001'm\u0016\u0014\u0018NZ=D_:\u001cX/\\3s\u00072LWM\u001c;UQJ|G\u000f\u001e7f)&lW-T3ue&\u001cGCBA\f\u0003[\fy\u000fC\u0004\u0002 \u0002\u0002\r!!\u001d\t\u0013\u0005E\b\u0005%AA\u0002\u0005M\u0018aD7bqRC'o\u001c;uY\u0016$\u0016.\\3\u0011\tA\n)0O\u0005\u0004\u0003o\f$AB(qi&|g.\u0001\u0019wKJLg-_\"p]N,X.\u001a:DY&,g\u000e\u001e+ie>$H\u000f\\3US6,W*\u001a;sS\u000e$C-\u001a4bk2$HEM\u000b\u0003\u0003{TC!a=\u0002~\u0005y\u0011/^8uCB\u0013x\u000e]3si&,7\u000f\u0006\u0005\u0003\u0004\tM!Q\u0003B\f!\u0011\u0011)Aa\u0004\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0005\u0017\tA!\u001e;jY*\u0011!QB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0012\t\u001d!A\u0003)s_B,'\u000f^5fg\"9\u0011q\u0004\u0012A\u0002\u0005\u0005\u0002bBA\u0015E\u0001\u0007\u0011\u0011\u0005\u0005\u0007\u0003[\u0011\u0003\u0019A\u001d\u0002%]\f\u0017\u000e\u001e$peF+x\u000e^1Va\u0012\fG/\u001a\u000b\u000b\u0003/\u0011iBa\b\u0003\"\t\r\u0002bBA\u0010G\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003S\u0019\u0003\u0019AA\u0011\u0011\u0019\tic\ta\u0001s!9!l\tI\u0001\u0002\u00049\u0016\u0001H<bSR4uN])v_R\fW\u000b\u001d3bi\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005SQ3aVA?\u0001")
public abstract class QuotaTestClients {
    private final String topic;
    private final KafkaServer leaderNode;
    private final String producerClientId;
    private final String consumerClientId;
    private final KafkaProducer<byte[], byte[]> producer;
    private final KafkaConsumer<byte[], byte[]> consumer;

    public static double metricValue(Metric metric) {
        return QuotaTestClients$.MODULE$.metricValue(metric);
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public abstract KafkaPrincipal userPrincipal();

    public abstract void overrideQuotas(long var1, long var3, double var5);

    public abstract void removeQuotaOverrides();

    public abstract Map<String, String> quotaMetricTags(String var1);

    public Quota quota(ClientQuotaManager quotaManager, KafkaPrincipal userPrincipal, String clientId) {
        return quotaManager.quota(userPrincipal, clientId);
    }

    /*
     * WARNING - void declaration
     */
    public int produceUntilThrottled(int maxRecords, boolean waitForRequestCompletion) {
        void var3_3;
        int numProduced = 0;
        boolean throttled = false;
        do {
            byte[] payload = ((Object)BoxesRunTime.boxToInteger((int)numProduced)).toString().getBytes();
            Future future = this.producer().send(new ProducerRecord(this.topic, null, null, (Object)payload), (Callback)new ErrorLoggingCallback(this.topic, null, null, true));
            ++numProduced;
            do {
                KafkaMetric metric;
                boolean bl = throttled = (metric = this.throttleMetric((QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId)) != null && QuotaTestClients$.MODULE$.metricValue((Metric)metric) > 0.0;
            } while (!future.isDone() && (!throttled || waitForRequestCompletion));
        } while (numProduced < maxRecords && !throttled);
        return (int)var3_3;
    }

    public boolean produceUntilThrottled$default$2() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int consumeUntilThrottled(int maxRecords, boolean waitForRequestCompletion) {
        void var3_3;
        this.consumer().subscribe(Collections.singleton(this.topic));
        int numConsumed = 0;
        boolean throttled = false;
        do {
            KafkaMetric metric;
            boolean bl = throttled = (metric = this.throttleMetric((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId)) != null && QuotaTestClients$.MODULE$.metricValue((Metric)metric) > 0.0;
        } while ((numConsumed += this.consumer().poll(Duration.ofMillis(100L)).count()) < maxRecords && !throttled);
        if (throttled && numConsumed < maxRecords && waitForRequestCompletion) {
            int minRecords = numConsumed + 1;
            while (numConsumed < minRecords) {
                numConsumed += this.consumer().poll(Duration.ofMillis(100L)).count();
            }
        }
        return (int)var3_3;
    }

    public boolean consumeUntilThrottled$default$2() {
        return true;
    }

    public void verifyProduceThrottle(boolean expectThrottle, boolean verifyClientMetric) {
        block0: {
            this.verifyThrottleTimeMetric((QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId, expectThrottle);
            if (!verifyClientMetric) break block0;
            this.verifyProducerClientThrottleTimeMetric(expectThrottle);
        }
    }

    public boolean verifyProduceThrottle$default$2() {
        return true;
    }

    public void verifyConsumeThrottle(boolean expectThrottle, boolean verifyClientMetric) {
        block0: {
            this.verifyThrottleTimeMetric((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId, expectThrottle);
            if (!verifyClientMetric) break block0;
            this.verifyConsumerClientThrottleTimeMetric(expectThrottle, this.verifyConsumerClientThrottleTimeMetric$default$2());
        }
    }

    public boolean verifyConsumeThrottle$default$2() {
        return true;
    }

    public void verifyThrottleTimeMetric(QuotaType quotaType, String clientId, boolean expectThrottle) {
        double throttleMetricValue = QuotaTestClients$.MODULE$.metricValue((Metric)this.throttleMetric(quotaType, clientId));
        if (expectThrottle) {
            Assert.assertTrue((String)new StringBuilder(42).append("Client with id=").append(clientId).append(" should have been throttled").toString(), (throttleMetricValue > 0.0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)new StringBuilder(46).append("Client with id=").append(clientId).append(" should not have been throttled").toString(), (boolean)Predef$.MODULE$.double2Double(throttleMetricValue).isNaN());
        }
    }

    public MetricName throttleMetricName(QuotaType quotaType, String clientId) {
        return this.leaderNode.metrics().metricName("throttle-time", quotaType.toString(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.quotaMetricTags(clientId)).asJava());
    }

    public KafkaMetric throttleMetric(QuotaType quotaType, String clientId) {
        return (KafkaMetric)this.leaderNode.metrics().metrics().get(this.throttleMetricName(quotaType, clientId));
    }

    public KafkaMetric exemptRequestMetric() {
        MetricName metricName = this.leaderNode.metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        return (KafkaMetric)this.leaderNode.metrics().metrics().get(metricName);
    }

    public void verifyProducerClientThrottleTimeMetric(boolean expectThrottle) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.producerClientId);
        Metric avgMetric = (Metric)this.producer().metrics().get(new MetricName("produce-throttle-time-avg", "producer-metrics", "", tags));
        Metric maxMetric = (Metric)this.producer().metrics().get(new MetricName("produce-throttle-time-max", "producer-metrics", "", tags));
        if (expectThrottle) {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> QuotaTestClients$.MODULE$.metricValue(avgMetric) > 0.0 && QuotaTestClients$.MODULE$.metricValue(maxMetric) > 0.0, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Producer throttle metric not updated: avg=").append(QuotaTestClients$.MODULE$.metricValue(avgMetric)).append(" max=").append(QuotaTestClients$.MODULE$.metricValue(maxMetric)).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        } else {
            Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)QuotaTestClients$.MODULE$.metricValue(maxMetric), (double)0.0);
        }
    }

    public void verifyConsumerClientThrottleTimeMetric(boolean expectThrottle, Option<Object> maxThrottleTime) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.consumerClientId);
        Metric avgMetric = (Metric)this.consumer().metrics().get(new MetricName("fetch-throttle-time-avg", "consumer-fetch-manager-metrics", "", tags));
        Metric maxMetric = (Metric)this.consumer().metrics().get(new MetricName("fetch-throttle-time-max", "consumer-fetch-manager-metrics", "", tags));
        if (expectThrottle) {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> QuotaTestClients$.MODULE$.metricValue(avgMetric) > 0.0 && QuotaTestClients$.MODULE$.metricValue(maxMetric) > 0.0, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Consumer throttle metric not updated: avg=").append(QuotaTestClients$.MODULE$.metricValue(avgMetric)).append(" max=").append(QuotaTestClients$.MODULE$.metricValue(maxMetric)).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            maxThrottleTime.foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)max -> Assert.assertTrue((String)new StringBuilder(36).append("Maximum consumer throttle too high: ").append(QuotaTestClients$.MODULE$.metricValue(maxMetric)).toString(), (QuotaTestClients$.MODULE$.metricValue(maxMetric) <= max ? 1 : 0) != 0));
        } else {
            Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)QuotaTestClients$.MODULE$.metricValue(maxMetric), (double)0.0);
        }
    }

    public Option<Object> verifyConsumerClientThrottleTimeMetric$default$2() {
        return None$.MODULE$;
    }

    public Properties quotaProperties(long producerQuota, long consumerQuota, double requestQuota) {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)producerQuota)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)consumerQuota)).toString());
        props.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
        return props;
    }

    public void waitForQuotaUpdate(long producerQuota, long consumerQuota, double requestQuota, KafkaServer server) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            QuotaFactory.QuotaManagers quotaManagers = server.dataPlaneRequestProcessor().quotas();
            Quota overrideProducerQuota = this.quota(quotaManagers.produce(), this.userPrincipal(), $this.producerClientId);
            Quota overrideConsumerQuota = this.quota(quotaManagers.fetch(), this.userPrincipal(), $this.consumerClientId);
            Quota overrideProducerRequestQuota = this.quota((ClientQuotaManager)quotaManagers.request(), this.userPrincipal(), $this.producerClientId);
            Quota overrideConsumerRequestQuota = this.quota((ClientQuotaManager)quotaManagers.request(), this.userPrincipal(), $this.consumerClientId);
            Assert.assertEquals((String)new StringBuilder(43).append("ClientId ").append($this.producerClientId).append(" of user ").append(this.userPrincipal()).append(" must have producer quota").toString(), (Object)Quota.upperBound((double)producerQuota), (Object)overrideProducerQuota);
            Assert.assertEquals((String)new StringBuilder(43).append("ClientId ").append($this.consumerClientId).append(" of user ").append(this.userPrincipal()).append(" must have consumer quota").toString(), (Object)Quota.upperBound((double)consumerQuota), (Object)overrideConsumerQuota);
            Assert.assertEquals((String)new StringBuilder(42).append("ClientId ").append($this.producerClientId).append(" of user ").append(this.userPrincipal()).append(" must have request quota").toString(), (Object)Quota.upperBound((double)requestQuota), (Object)overrideProducerRequestQuota);
            Assert.assertEquals((String)new StringBuilder(42).append("ClientId ").append($this.consumerClientId).append(" of user ").append(this.userPrincipal()).append(" must have request quota").toString(), (Object)Quota.upperBound((double)requestQuota), (Object)overrideConsumerRequestQuota);
        });
    }

    public KafkaServer waitForQuotaUpdate$default$4() {
        return this.leaderNode;
    }

    public QuotaTestClients(String topic, KafkaServer leaderNode, String producerClientId, String consumerClientId, KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
        this.topic = topic;
        this.leaderNode = leaderNode;
        this.producerClientId = producerClientId;
        this.consumerClientId = consumerClientId;
        this.producer = producer;
        this.consumer = consumer;
    }
}

