/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerContext;
import kafka.controller.Election$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignPartitionLeaderElectionStrategy$;
import org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3AAB\u0004\u0001\u0019!A\u0011\u0003\u0001B\u0001B\u0003%!\u0003\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0011\u0015\t\u0003\u0001\"\u0011#\u0011\u0015!\u0006\u0001\"\u0003V\u0005eiunY6QCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3\u000b\u0005!I\u0011AC2p]R\u0014x\u000e\u001c7fe*\t!\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0001C\u0001\b\u0010\u001b\u00059\u0011B\u0001\t\b\u0005U\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016\f\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u!\tq1#\u0003\u0002\u0015\u000f\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u00029Ut7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0016s\u0017M\u00197fIB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\bF\u0002\u001f?\u0001\u0002\"A\u0004\u0001\t\u000bE\u0019\u0001\u0019\u0001\n\t\u000bU\u0019\u0001\u0019\u0001\f\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\u0005G\t;E\n\u0005\u0003%W9JdBA\u0013*!\t1\u0003$D\u0001(\u0015\tA3\"\u0001\u0004=e>|GOP\u0005\u0003Ua\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\ri\u0015\r\u001d\u0006\u0003Ua\u0001\"aL\u001c\u000e\u0003AR!!\r\u001a\u0002\r\r|W.\\8o\u0015\tQ1G\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<\u0017B\u0001\u001d1\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"AO \u000f\u0005mjdB\u0001\u0014=\u0013\u0005I\u0012B\u0001 \u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Q!\u0003\u0013QC'o\\<bE2,'B\u0001 \u0019\u0011\u0015\u0019E\u00011\u0001E\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0004u\u0015s\u0013B\u0001$B\u0005\r\u0019V-\u001d\u0005\u0006\u0011\u0012\u0001\r!S\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\r\u0005\u0002\u000f\u0015&\u00111j\u0002\u0002\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0011\u0015iE\u00011\u0001O\u0003YaW-\u00193fe\u0016cWm\u0019;j_:\u001cFO]1uK\u001eL\bcA\fP#&\u0011\u0001\u000b\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00059\u0011\u0016BA*\b\u0005}\u0001\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|gn\u0015;sCR,w-_\u0001\u0012I>dU-\u00193fe\u0016cWm\u0019;j_:\u001cHcA\u0012W/\")1)\u0002a\u0001\t\")Q*\u0002a\u0001#\u0002")
public class MockPartitionStateMachine
extends PartitionStateMachine {
    private final ControllerContext controllerContext;
    private final boolean uncleanLeaderElectionEnabled;

    public Map<TopicPartition, Throwable> handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> leaderElectionStrategy) {
        Map<TopicPartition, Throwable> map;
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            this.controllerContext.putPartitionStateIfNotExists(partition, (PartitionState)NonExistentPartition$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = this.controllerContext.checkValidPartitionStateChange(partitions, targetState);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq validPartitions = (Seq)tuple2._1();
        Seq invalidPartitions = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)validPartitions, (Object)invalidPartitions);
        Tuple2 tuple23 = tuple22;
        Seq validPartitions2 = (Seq)tuple23._1();
        Seq invalidPartitions2 = (Seq)tuple23._2();
        if (invalidPartitions2.nonEmpty()) {
            Seq currentStates = (Seq)invalidPartitions2.map((Function1 & Serializable & scala.Serializable)p -> $this.controllerContext.partitionStates().get(p), Seq$.MODULE$.canBuildFrom());
            throw new IllegalStateException(new StringBuilder(44).append("Invalid state transition to ").append(targetState).append(" for partitions ").append(currentStates).toString());
        }
        PartitionState partitionState = targetState;
        OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
        if (!(partitionState != null ? !partitionState.equals(onlinePartition$) : onlinePartition$ != null)) {
            Seq uninitializedPartitions = (Seq)validPartitions2.filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)MockPartitionStateMachine.$anonfun$handleStateChanges$3(this, partition)));
            Seq partitionsToElectLeader = (Seq)partitions.filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)MockPartitionStateMachine.$anonfun$handleStateChanges$4(this, partition)));
            uninitializedPartitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                this.controllerContext.putPartitionState(partition, targetState);
                return BoxedUnit.UNIT;
            });
            Map<TopicPartition, Throwable> failedElections = this.doLeaderElections((Seq<TopicPartition>)partitionsToElectLeader, (PartitionLeaderElectionStrategy)leaderElectionStrategy.get());
            Set set = failedElections.keySet();
            Seq successfulElections = (Seq)partitionsToElectLeader.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem)));
            successfulElections.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                this.controllerContext.putPartitionState(partition, targetState);
                return BoxedUnit.UNIT;
            });
            map = failedElections;
        } else {
            validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                this.controllerContext.putPartitionState(partition, targetState);
                return BoxedUnit.UNIT;
            });
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    private Map<TopicPartition, Throwable> doLeaderElections(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy leaderElectionStrategy) {
        Seq seq;
        scala.collection.mutable.Map failedElections = Map$.MODULE$.empty();
        Seq leaderIsrAndControllerEpochPerPartition = (Seq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), $this.controllerContext.partitionLeadershipInfo().apply(partition)), Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = leaderIsrAndControllerEpochPerPartition.partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MockPartitionStateMachine.$anonfun$doLeaderElections$2(this, x0$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq invalidPartitionsForElection = (Seq)tuple2._1();
        Seq validPartitionsForElection = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)invalidPartitionsForElection, (Object)validPartitionsForElection);
        Tuple2 tuple23 = tuple22;
        Seq invalidPartitionsForElection2 = (Seq)tuple23._1();
        Seq validPartitionsForElection2 = (Seq)tuple23._2();
        invalidPartitionsForElection2.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            String failMsg = new StringBuilder(233).append("aborted leader election for partition ").append(partition).append(" since the LeaderAndIsr path was ").append("already written by another controller. This probably means that the current controller went through ").append("a soft failure and another controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(".").toString();
            Option option = failedElections.put((Object)partition, (Object)new StateChangeFailedException(failMsg));
            return option;
        });
        PartitionLeaderElectionStrategy partitionLeaderElectionStrategy = leaderElectionStrategy;
        if (OfflinePartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy)) {
            Seq partitionsWithUncleanLeaderElectionState = (Seq)validPartitionsForElection2.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition partition = (TopicPartition)tuple2._1();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                Tuple3 tuple3 = new Tuple3((Object)partition, (Object)new Some((Object)leaderIsrAndControllerEpoch), (Object)BoxesRunTime.boxToBoolean((boolean)$this.uncleanLeaderElectionEnabled));
                return tuple3;
            }, Seq$.MODULE$.canBuildFrom());
            seq = Election$.MODULE$.leaderForOffline(this.controllerContext, partitionsWithUncleanLeaderElectionState);
        } else if (ReassignPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy)) {
            seq = Election$.MODULE$.leaderForReassign(this.controllerContext, validPartitionsForElection2);
        } else if (PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy)) {
            seq = Election$.MODULE$.leaderForPreferredReplica(this.controllerContext, validPartitionsForElection2);
        } else if (ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy)) {
            seq = Election$.MODULE$.leaderForControlledShutdown(this.controllerContext, validPartitionsForElection2);
        } else {
            throw new MatchError((Object)partitionLeaderElectionStrategy);
        }
        Seq electionResults = seq;
        electionResults.foreach((Function1 & Serializable & scala.Serializable)electionResult -> {
            Option option;
            TopicPartition partition = electionResult.topicPartition();
            Option option2 = electionResult.leaderAndIsr();
            if (None$.MODULE$.equals(option2)) {
                String failMsg = new StringBuilder(53).append("Failed to elect leader for partition ").append(partition).append(" under strategy ").append(leaderElectionStrategy).toString();
                option = failedElections.put((Object)partition, (Object)new StateChangeFailedException(failMsg));
            } else if (option2 instanceof Some) {
                Some some = (Some)option2;
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)some.value();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
                option = $this.controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
            } else {
                throw new MatchError((Object)option2);
            }
            return option;
        });
        return failedElections.toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$handleStateChanges$3(MockPartitionStateMachine $this, TopicPartition partition) {
        PartitionState partitionState = $this.controllerContext.partitionState(partition);
        NewPartition$ newPartition$ = NewPartition$.MODULE$;
        return !(partitionState != null ? !partitionState.equals(newPartition$) : newPartition$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$handleStateChanges$4(MockPartitionStateMachine $this, TopicPartition partition) {
        PartitionState currentState;
        PartitionState partitionState = currentState = $this.controllerContext.partitionState(partition);
        OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
        if (partitionState == null) {
            if (offlinePartition$ == null) return true;
        } else if (partitionState.equals(offlinePartition$)) return true;
        PartitionState partitionState2 = currentState;
        OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
        if (partitionState2 != null) {
            if (!partitionState2.equals(onlinePartition$)) return false;
            return true;
        }
        if (onlinePartition$ == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$doLeaderElections$2(MockPartitionStateMachine $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
        boolean bl = leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch();
        return bl;
    }

    public MockPartitionStateMachine(ControllerContext controllerContext, boolean uncleanLeaderElectionEnabled) {
        this.controllerContext = controllerContext;
        this.uncleanLeaderElectionEnabled = uncleanLeaderElectionEnabled;
        super(controllerContext);
    }
}

