/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEd\u0001B\u001a5\u0001eBQA\u0012\u0001\u0005\u0002\u001dCqA\u0013\u0001C\u0002\u0013\u00051\n\u0003\u0004U\u0001\u0001\u0006I\u0001\u0014\u0005\b+\u0002\u0011\r\u0011\"\u0001L\u0011\u00191\u0006\u0001)A\u0005\u0019\"9q\u000b\u0001b\u0001\n\u0003A\u0006B\u00023\u0001A\u0003%\u0011\fC\u0004f\u0001\t\u0007I\u0011\u00014\t\r5\u0004\u0001\u0015!\u0003h\u0011\u001dq\u0007A1A\u0005\u0002=Daa\u001d\u0001!\u0002\u0013\u0001\bb\u0002;\u0001\u0005\u0004%\t!\u001e\u0005\u0007s\u0002\u0001\u000b\u0011\u0002<\t\u000fi\u0004!\u0019!C\u0001w\"9\u0011q\u0002\u0001!\u0002\u0013ahABA\t\u0001\u0001\t\u0019\u0002\u0003\u0007\u0002\u001cA\u0011\t\u0011)A\u0005\u0003;\t)\u0004\u0003\u0007\u00028A\u0011\t\u0011)A\u0005\u0003s\t)\u0005\u0003\u0007\u0002HA\u0011\t\u0011)A\u0005\u0003\u0013\n)\u0006\u0003\u0004G!\u0011\u0005\u0011q\u000b\u0005\b\u0003G\u0002B\u0011IA3\u0011\u001d\t)\b\u0001C\u0001\u0003oBq!!$\u0001\t\u0013\ty\tC\u0004\u0002&\u0002!\t!a\u001e\t\u000f\u0005=\u0006\u0001\"\u0001\u0002x!9\u00111\u0017\u0001\u0005\u0002\u0005]\u0004bBA\\\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003w\u0003A\u0011AA<\u0011\u001d\ty\f\u0001C\u0001\u0003oBq!a1\u0001\t\u0003\t9\bC\u0004\u0002H\u0002!\t!a\u001e\t\u000f\u0005-\u0007\u0001\"\u0001\u0002x!9\u0011q\u001a\u0001\u0005\u0002\u0005]\u0004bBAj\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003/\u0004A\u0011AA<\u0011\u001d\tY\u000e\u0001C\u0001\u0003oBq!a8\u0001\t\u0003\t9\bC\u0004\u0002d\u0002!\t!a\u001e\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002x!9\u00111\u001e\u0001\u0005\u0002\u0005]\u0004bBAx\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003g\u0004A\u0011AA<\u0011\u001d\t9\u0010\u0001C\u0005\u0003sDq!!@\u0001\t\u0013\ty\u0010C\u0004\u0003\u0006\u0001!IAa\u0002\t\u0013\te\u0001!%A\u0005\n\tm\u0001b\u0002B\u0019\u0001\u0011%!1\u0007\u0005\b\u0005\u0007\u0002A\u0011\u0002B#\u0011%\u0011y\u0005AI\u0001\n\u0013\u0011\t\u0006C\u0004\u0003V\u0001!IAa\u0016\u0003+1{wm\u00117fC:,'/T1oC\u001e,'\u000fV3ti*\u0011QGN\u0001\u0004Y><'\"A\u001c\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\u000f!\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\r\u0005s\u0017PU3g!\t\tE)D\u0001C\u0015\t\u0019e'A\u0003vi&d7/\u0003\u0002F\u0005\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001I!\tI\u0005!D\u00015\u0003\u0019!X\u000e\u001d#jeV\tA\n\u0005\u0002N%6\taJ\u0003\u0002P!\u0006\u0011\u0011n\u001c\u0006\u0002#\u0006!!.\u0019<b\u0013\t\u0019fJ\u0001\u0003GS2,\u0017a\u0002;na\u0012K'\u000fI\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tW#A-\u0011\u0005i\u0013W\"A.\u000b\u0005qk\u0016AB2p[6|gN\u0003\u00028=*\u0011q\fY\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\f1a\u001c:h\u0013\t\u00197L\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\n\u0001\u0002\\8h!J|\u0007o]\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\u0011!\u000eU\u0001\u0005kRLG.\u0003\u0002mS\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u00131|w\r\u0015:paN\u0004\u0013!\u00037pO\u000e{gNZ5h+\u0005\u0001\bCA%r\u0013\t\u0011HGA\u0005M_\u001e\u001cuN\u001c4jO\u0006QAn\\4D_:4\u0017n\u001a\u0011\u0002\tQLW.Z\u000b\u0002mB\u0011\u0011i^\u0005\u0003q\n\u0013\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0013G2,\u0017M\\3s\u0007\",7m\u001b9pS:$8/F\u0001}!\u0019i\u0018QA-\u0002\n5\taPC\u0002\u0000\u0003\u0003\tq!\\;uC\ndWMC\u0002\u0002\u0004q\n!bY8mY\u0016\u001cG/[8o\u0013\r\t9A \u0002\u0004\u001b\u0006\u0004\bcA\u001e\u0002\f%\u0019\u0011Q\u0002\u001f\u0003\t1{gnZ\u0001\u0014G2,\u0017M\\3s\u0007\",7m\u001b9pS:$8\u000f\t\u0002\u0016\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014Xj\\2l'\r\u0001\u0012Q\u0003\t\u0004\u0013\u0006]\u0011bAA\ri\t\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0002\u000f1|w\rR5sgB)\u0011qDA\u0018\u0019:!\u0011\u0011EA\u0016\u001d\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014q\u00051AH]8pizJ\u0011!P\u0005\u0004\u0003[a\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003c\t\u0019DA\u0002TKFT1!!\f=\u0013\u0011\tY\"a\u0006\u0002\t1|wm\u001d\t\u0007\u0003\u0006m\u0012,a\u0010\n\u0007\u0005u\"I\u0001\u0003Q_>d\u0007cA%\u0002B%\u0019\u00111\t\u001b\u0003\u00071{w-\u0003\u0003\u00028\u0005]\u0011\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000e\u0005\u0003\u0002L\u0005ESBAA'\u0015\r\tyEN\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005M\u0013Q\n\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\n\t\u0005\u001d\u0013q\u0003\u000b\t\u00033\ni&a\u0018\u0002bA\u0019\u00111\f\t\u000e\u0003\u0001Aq!a\u0007\u0015\u0001\u0004\ti\u0002C\u0004\u00028Q\u0001\r!!\u000f\t\u000f\u0005\u001dC\u00031\u0001\u0002J\u0005)\u0012\r\u001c7DY\u0016\fg.\u001a:DQ\u0016\u001c7\u000e]8j]R\u001cXCAA4!\u001d\tI'!\u001dZ\u0003\u0013qA!a\u001b\u0002nA\u0019\u00111\u0005\u001f\n\u0007\u0005=D(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\t\u0019HC\u0002\u0002pq\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003s\u00022aOA>\u0013\r\ti\b\u0010\u0002\u0005+:LG\u000fK\u0002\u0017\u0003\u0003\u0003B!a!\u0002\n6\u0011\u0011Q\u0011\u0006\u0004\u0003\u000f\u0003\u0017!\u00026v]&$\u0018\u0002BAF\u0003\u000b\u0013Q!\u00114uKJ\f1d]3ukBLen\u0019:fCNLgn\u001a7z\r&dG\u000f[=M_\u001e\u001cH\u0003CA\u001d\u0003#\u000b9*!)\t\u000f\u0005Mu\u00031\u0001\u0002\u0016\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u000b\u0005}\u0011qF-\t\u000f\u0005eu\u00031\u0001\u0002\u001c\u0006y1\u000f^1si:+XNQ1uG\",7\u000fE\u0002<\u0003;K1!a(=\u0005\rIe\u000e\u001e\u0005\b\u0003G;\u0002\u0019AAN\u00039\u0011\u0017\r^2i\u0013:\u001c'/Z7f]R\f\u0001\b^3ti\u001e\u0013\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dun\u001a*fiV\u0014hn\u001d'pO^KG\u000f\u001b#jeRLWm\u001d;SCRLw\u000eK\u0002\u0019\u0003S\u0003B!a!\u0002,&!\u0011QVAC\u0005\u0011!Vm\u001d;\u0002sQ,7\u000f^$sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001eLuM\\8sKN,fn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]ND3!GAU\u0003a\"Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><\u0017j\u001a8pe\u0016\u001c\u0018J\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]ND3AGAU\u0003Q#Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><\u0017j\u001a8pe\u0016\u001c(i\u001c;i\u0013:\u0004&o\\4sKN\u001c\b+\u0019:uSRLwN\\:B]\u0012,fn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]ND3aGAU\u0003%\"Xm\u001d;ESJ$\u0018p\u00144gg\u0016$(+Z:fi&3G*\u0019:hKJ$\u0006.\u00198F]\u0012|eMZ:fi\"\u001aA$!+\u0002YQ,7\u000f\u001e#jeRLxJ\u001a4tKR\u0014Vm]3u\u0013\u001a\u001cV.\u00197mKJ$\u0006.\u00198Ti\u0006\u0014Ho\u00144gg\u0016$\bfA\u000f\u0002*\u0006!E/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012tu\u000e^\"p]NLG-\u001a:DY\u0016\fg.\u001e9Q_2L7-\u001f#fY\u0016$X\rT8hg\"\u001aa$!+\u0002\u0011R,7\u000f\u001e'pON<\u0016\u000e\u001e5TK\u001elWM\u001c;t)>$U\r\\3uKNCw.\u001e7e\u0007>t7/\u001b3fe\u000ecW-\u00198vaB{G.[2z\u0007>l\u0007/Y2u\t\u0016dW\r^3M_\u001e\u001c\bfA\u0010\u0002*\u0006\u0011E/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012\u001cuN\\:jI\u0016\u00148\t\\3b]V\u0004\bk\u001c7jGf\u001cu.\u001c9bGRdunZ:)\u0007\u0001\nI+A\u0016uKN$Hj\\4t+:$WM]\"mK\u0006tW\u000f]%oK2Lw-\u001b2mK\u001a{'oQ8na\u0006\u001cG/[8oQ\r\t\u0013\u0011V\u0001)i\u0016\u001cHoQ8oGV\u0014(/\u001a8u\u0019><7\t\\3b]V\u0004\u0018I\u001c3M_\u001e$&/\u001e8dCRLwN\u001c\u0015\u0004E\u0005%\u0016\u0001\u000b;fgR\u001cuN\\2veJ,g\u000e\u001e'pO\u000ecW-\u00198va\u0006sG\rV8qS\u000e$U\r\\3uS>t\u0007fA\u0012\u0002*\u0006\u0011E/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012tu\u000e^\"p]NLG-\u001a:V]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:)\u0007\u0011\nI+A\u000euKN$8\t\\3b]\u0006\u0014G.Z(gMN,Go\u001d$pe:{g.\u001a\u0015\u0004K\u0005%\u0016a\u0007;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OR8s)&lW\rK\u0002'\u0003S\u000b\u0001\u0005^3ti\u000ecW-\u00198bE2,wJ\u001a4tKR\u001chi\u001c:TQ>\u0014H\u000fV5nK\"\u001aq%!+\u0002UQ,7\u000f^+oI\u0016\u001c\u0017\u000eZ3e)J\fgn]1di&|g.\u00197ECR\fgj\u001c;DY\u0016\fg.\u00192mK\"\u001a\u0001&!+\u0002!Q,7\u000f\u001e#p]\u0016\u001cE.Z1oS:<\u0007fA\u0015\u0002*\u0006\u0001B/Z:u\t>tW\rR3mKRLgn\u001a\u0015\u0004U\u0005%\u0016\u0001F2sK\u0006$Xm\u00117fC:,'/T1oC\u001e,'\u000f\u0006\u0003\u0002\u0016\u0005m\bBB\u001b,\u0001\u0004\ty$\u0001\rde\u0016\fG/Z\"mK\u0006tWM]'b]\u0006<WM]'pG.$B!!\u0017\u0003\u0002!9!1\u0001\u0017A\u0002\u0005e\u0012\u0001\u00029p_2\f\u0011b\u0019:fCR,Gj\\4\u0015\u0011\u0005}\"\u0011\u0002B\u0007\u0005/AqAa\u0003.\u0001\u0004\tY*A\u0006tK\u001elWM\u001c;TSj,\u0007b\u0002B\b[\u0001\u0007!\u0011C\u0001\u000eG2,\u0017M\\;q!>d\u0017nY=\u0011\t\u0005%$1C\u0005\u0005\u0005+\t\u0019H\u0001\u0004TiJLgn\u001a\u0005\b/6\u0002\n\u00111\u0001Z\u0003M\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011iBK\u0002Z\u0005?Y#A!\t\u0011\t\t\r\"QF\u0007\u0003\u0005KQAAa\n\u0003*\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005Wa\u0014AC1o]>$\u0018\r^5p]&!!q\u0006B\u0013\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\roJLG/\u001a*fG>\u0014Hm\u001d\u000b\u000b\u0003s\u0012)Da\u000e\u0003<\t}\u0002BB\u001b0\u0001\u0004\ty\u0004C\u0004\u0003:=\u0002\r!a'\u0002\u00159,XNQ1uG\",7\u000fC\u0004\u0003>=\u0002\r!a'\u0002\u001fI,7m\u001c:egB+'OQ1uG\"DqA!\u00110\u0001\u0004\tY*A\tcCR\u001c\u0007.Z:QKJ\u001cVmZ7f]R\fq!\\1lK2{w\r\u0006\u0004\u0002@\t\u001d#1\n\u0005\t\u0005\u0013\u0002\u0004\u0013!a\u0001\u0019\u0006\u0019A-\u001b:\t\r\t5\u0003\u00071\u0001q\u0003\u0019\u0019wN\u001c4jO\u0006\tR.Y6f\u0019><G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tM#f\u0001'\u0003 \u00059!/Z2pe\u0012\u001cH\u0003\u0003B-\u0005K\u0012IG!\u001c\u0011\t\tm#\u0011M\u0007\u0003\u0005;R1Aa\u0018\\\u0003\u0019\u0011XmY8sI&!!1\rB/\u00055iU-\\8ssJ+7m\u001c:eg\"9!q\r\u001aA\u0002\u0005m\u0015aA6fs\"9!1\u000e\u001aA\u0002\u0005m\u0015!\u0002<bYV,\u0007b\u0002B8e\u0001\u0007\u0011\u0011B\u0001\ni&lWm\u001d;b[B\u0004")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir;
    private final File logDir;
    private final TopicPartition topicPartition;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManagerTest logCleanerManagerTest = this;
        synchronized (logCleanerManagerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    private Pool<TopicPartition, Log> setupIncreasinglyFilthyLogs(Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            LogCleanerManagerTest.$anonfun$setupIncreasinglyFilthyLogs$1(this, logs, numBatches, batchIncrement, tp);
            return BoxedUnit.UNIT;
        });
        return logs;
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.markPartitionUncleanable(((Log)logs.get((Object)tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(((Log)logs.get((Object)tp1)).dir().getParent(), tp1);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 20, 5);
        ((Log)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.onHighWatermarkIncremented(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog.size());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), log.config().segmentSize());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), log.config().retentionMs());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.config_$eq(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"should have 0 logs ready to be compacted", (long)0L, (long)Option$.MODULE$.option2Iterable(cleanable).size());
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable & scala.Serializable)x$1 -> (TopicPartition)x$1._1(), Iterable$.MODULE$.canBuildFrom()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"should have 1 logs ready to be compacted", (long)1L, (long)Option$.MODULE$.option2Iterable(cleanable2).size());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig config2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.config_$eq(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)deletableLog2.size());
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{((LogToClean)cleanable2.get()).topicPartition()})));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog3.size());
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{log.topicPartition()})));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$2 -> (TopicPartition)x$2._1(), Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$3 -> (TopicPartition)x$3._1(), Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the second block of log entries.", (long)activeSegAtT0.baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        this.time().sleep(compactionLag + 1);
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)(sequence + 2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.onHighWatermarkIncremented(3L);
        this.time().sleep(compactionLag + 1);
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._2$mcJ$sp());
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 15)), 0, false, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.onHighWatermarkIncremented(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)3L, (long)cleanableOffsets._2$mcJ$sp());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)4L, (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assert.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    private LogCleanerManager createCleanerManager(Log log) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)this.topicPartition(), (Object)log);
        return new LogCleanerManager((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), logs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(Pool<TopicPartition, Log> pool) {
        return new LogCleanerManagerMock((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), pool, null);
    }

    private Log createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition) {
        File partitionDir;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$1 = partitionDir = new File(this.logDir(), Log$.MODULE$.logDirName(topicPartition));
        LogConfig x$2 = config;
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private void writeRecords(Log log, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1 & Serializable & scala.Serializable)i -> LogCleanerManagerTest.$anonfun$writeRecords$1(this, recordsPerBatch, log, batchesPerSegment, BoxesRunTime.unboxToInt((Object)i)));
        log.roll(log.roll$default$1());
    }

    private Log makeLog(File dir, LogConfig config) {
        File x$1 = dir;
        LogConfig x$2 = config;
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private MemoryRecords records(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    public static final /* synthetic */ void $anonfun$setupIncreasinglyFilthyLogs$1(LogCleanerManagerTest $this, Pool logs$1, IntRef numBatches$1, int batchIncrement$1, TopicPartition tp) {
        Log log = $this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        logs$1.put((Object)tp, (Object)log);
        $this.writeRecords(log, numBatches$1.elem, 1, 5);
        numBatches$1.elem += batchIncrement$1;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$writeRecords$2(LogCleanerManagerTest $this, int endOffset$1, LongRef lastTimestamp$1, int offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1(LogCleanerManagerTest $this, int recordsPerBatch$1, Log log$2, int batchesPerSegment$1, int i) {
        int startOffset = i * recordsPerBatch$1;
        int endOffset = startOffset + recordsPerBatch$1;
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startOffset), endOffset).map((Function1 & Serializable & scala.Serializable)offset -> LogCleanerManagerTest.$anonfun$writeRecords$2($this, endOffset, lastTimestamp, BoxesRunTime.unboxToInt((Object)offset)), IndexedSeq$.MODULE$.canBuildFrom());
        log$2.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 1, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4());
        log$2.onHighWatermarkIncremented(log$2.logEndOffsetMetadata().messageOffset());
        return i % batchesPerSegment$1 == 0 ? log$2.roll(log$2.roll$default$1()) : BoxedUnit.UNIT;
    }

    public LogCleanerManagerTest() {
        Logging.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.topicPartition = new TopicPartition("log", 0);
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap(Predef$.MODULE$.$conforms());
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

