/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.common.TopicAndPartition;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00154A\u0001E\t\u0001-!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0003BB\u0016\u0001A\u0003%1\u0005C\u0005-\u0001\u0001\u0007\t\u0019!C\u0001[!I\u0011\u0007\u0001a\u0001\u0002\u0004%\tA\r\u0005\nw\u0001\u0001\r\u0011!Q!\n9BQ\u0001\u0010\u0001\u0005BuBQa\u0012\u0001\u0005BuBQ\u0001\u0014\u0001\u0005\u0002uBQ!\u0015\u0001\u0005\u0002uBQa\u0015\u0001\u0005\u0002uBQ!\u0016\u0001\u0005\u0002uBQa\u0016\u0001\u0005\u0002uBQ!\u0017\u0001\u0005\u0002uBQa\u0017\u0001\u0005\u0002u\u00121BW6Vi&d7\u000fV3ti*\u0011!cE\u0001\u0006kRLGn\u001d\u0006\u0002)\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\tQ2#\u0001\u0002{W&\u0011A$\u0007\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\t\u0012\u0001\u00029bi\",\u0012a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA\u0001\\1oO*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005\u0019\u0019FO]5oO\u0006)\u0001/\u0019;iA\u00059!p[+uS2\u001cX#\u0001\u0018\u0011\u0005\u0001z\u0013B\u0001\u0019\u0012\u0005\u001dQ6.\u0016;jYN\f1B_6Vi&d7o\u0018\u0013fcR\u00111'\u000f\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0005+:LG\u000fC\u0004;\u000b\u0005\u0005\t\u0019\u0001\u0018\u0002\u0007a$\u0013'\u0001\u0005{WV#\u0018\u000e\\:!\u0003\u0015\u0019X\r^+q)\u0005\u0019\u0004FA\u0004@!\t\u0001U)D\u0001B\u0015\t\u00115)A\u0003kk:LGOC\u0001E\u0003\ry'oZ\u0005\u0003\r\u0006\u0013aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0005!I\u0005C\u0001!K\u0013\tY\u0015IA\u0003BMR,'/A\u0012uKN$8+^2dKN\u001ch-\u001e7D_:$\u0017\u000e^5p]\u0006dG)\u001a7fi\u0016\u0004\u0016\r\u001e5)\u0005%q\u0005C\u0001!P\u0013\t\u0001\u0016I\u0001\u0003UKN$\u0018\u0001\b;fgR\u0004VM]:jgR,g\u000e^*fcV,g\u000e^5bYB\u000bG\u000f\u001b\u0015\u0003\u00159\u000b\u0001\u0005^3ti\u0006\u0013wN\u001d;fI\u000e{g\u000eZ5uS>t\u0017\r\u001c#fY\u0016$X\rU1uQ\"\u00121BT\u0001!i\u0016\u001cHo\u00117vgR,'/\u00133f]RLg-[3s\u0015N|g\u000eU1sg&tw\r\u000b\u0002\r\u001d\u0006QC/Z:u\u000f\u0016$\u0018\t\u001c7QCJ$\u0018\u000e^5p]N$v\u000e]5d/&$\bn\\;u!\u0006\u0014H/\u001b;j_:\u001c\bFA\u0007O\u0003\u0011\"Xm\u001d;HKRdU-\u00193fe&\u001b(/\u00118e\u000bB|7\r\u001b$peB\u000b'\u000f^5uS>t\u0007F\u0001\bO\u0003]!Xm\u001d;HKR\u001cV-];f]\u000e,\u0017\nZ'fi\"|G\r\u000b\u0002\u0010\u001d\"\"\u0001AX1d!\t!t,\u0003\u0002ak\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0003\t\f1\u0006R3qe\u0016\u001c\u0017\r^3eA\u001dLg/\u001a8!i\"\fG\u000f\t.l+RLGn\u001d\u0011jg\u0002\"W\r\u001d:fG\u0006$X\rZ\u0011\u0002I\u0006)!G\f\u0019/a\u0001")
public class ZkUtilsTest
extends ZooKeeperTestHarness {
    private final String path;
    private ZkUtils zkUtils;

    public String path() {
        return this.path;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> JaasUtils.isZkSecurityEnabled()))));
    }

    @Override
    @After
    public void tearDown() {
        if (this.zkUtils() != null) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkUtils().close(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        }
        super.tearDown();
    }

    @Test
    public void testSuccessfulConditionalDeletePath() {
        Option optionalData;
        Stat statAfterCreation;
        ZkUtils qual$1 = this.zkUtils();
        String x$1 = this.path();
        String x$2 = qual$1.createPersistentPath$default$2();
        java.util.List x$3 = qual$1.createPersistentPath$default$3();
        qual$1.createPersistentPath(x$1, x$2, x$3);
        Tuple2 tuple2 = this.zkUtils().readData(this.path());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Stat stat = statAfterCreation = (Stat)tuple2._2();
        Stat statAfterCreation2 = stat;
        Assert.assertTrue((String)"Deletion should be successful", (boolean)this.zkUtils().conditionalDeletePath(this.path(), statAfterCreation2.getVersion()));
        Tuple2 tuple22 = this.zkUtils().readDataMaybeNull(this.path());
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Option option = optionalData = (Option)tuple22._1();
        Option optionalData2 = option;
        Assert.assertTrue((String)"Node should be deleted", (boolean)optionalData2.isEmpty());
        Assert.assertTrue((String)"Deletion should be successful", (boolean)this.zkUtils().conditionalDeletePath(this.path(), 0));
    }

    @Test
    public void testPersistentSequentialPath() {
        ZkUtils qual$1 = this.zkUtils();
        String x$1 = this.path();
        String x$2 = qual$1.createPersistentPath$default$2();
        java.util.List x$3 = qual$1.createPersistentPath$default$3();
        qual$1.createPersistentPath(x$1, x$2, x$3);
        ZkUtils qual$2 = this.zkUtils();
        String x$4 = new StringBuilder(10).append(this.path()).append("/sequence_").toString();
        String x$5 = qual$2.createSequentialPersistentPath$default$2();
        java.util.List x$6 = qual$2.createSequentialPersistentPath$default$3();
        String result = qual$2.createSequentialPersistentPath(x$4, x$5, x$6);
        Assert.assertEquals((Object)"/path/sequence_0000000000", (Object)result);
        ZkUtils qual$3 = this.zkUtils();
        String x$7 = new StringBuilder(10).append(this.path()).append("/sequence_").toString();
        String x$8 = qual$3.createSequentialPersistentPath$default$2();
        java.util.List x$9 = qual$3.createSequentialPersistentPath$default$3();
        result = qual$3.createSequentialPersistentPath(x$7, x$8, x$9);
        Assert.assertEquals((Object)"/path/sequence_0000000001", (Object)result);
    }

    @Test
    public void testAbortedConditionalDeletePath() {
        Option optionalData;
        Stat statAfterCreation;
        ZkUtils qual$1 = this.zkUtils();
        String x$1 = this.path();
        String x$2 = qual$1.createPersistentPath$default$2();
        java.util.List x$3 = qual$1.createPersistentPath$default$3();
        qual$1.createPersistentPath(x$1, x$2, x$3);
        Tuple2 tuple2 = this.zkUtils().readData(this.path());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Stat stat = statAfterCreation = (Stat)tuple2._2();
        Stat statAfterCreation2 = stat;
        ZkUtils qual$2 = this.zkUtils();
        String x$4 = this.path();
        String x$5 = "data";
        java.util.List x$6 = qual$2.updatePersistentPath$default$3();
        qual$2.updatePersistentPath(x$4, x$5, x$6);
        Assert.assertFalse((String)"Deletion should be aborted", (boolean)this.zkUtils().conditionalDeletePath(this.path(), statAfterCreation2.getVersion()));
        Tuple2 tuple22 = this.zkUtils().readDataMaybeNull(this.path());
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Option option = optionalData = (Option)tuple22._1();
        Option optionalData2 = option;
        Assert.assertTrue((String)"Node should still be there", (boolean)optionalData2.isDefined());
    }

    @Test
    public void testClusterIdentifierJsonParsing() {
        String clusterId = "test";
        Assert.assertEquals((Object)this.zkUtils().ClusterId().fromJson(this.zkUtils().ClusterId().toJson(clusterId)), (Object)clusterId);
    }

    @Test
    public void testGetAllPartitionsTopicWithoutPartitions() {
        String topic = "testtopic";
        ZkUtils qual$1 = this.zkUtils();
        String x$1 = ZkUtils$.MODULE$.getTopicPartitionPath(topic, 0);
        String x$2 = qual$1.createPersistentPath$default$2();
        java.util.List x$3 = qual$1.createPersistentPath$default$3();
        qual$1.createPersistentPath(x$1, x$2, x$3);
        ZkUtils qual$2 = this.zkUtils();
        String x$4 = ZkUtils$.MODULE$.getTopicPath("nopartitions");
        String x$5 = qual$2.createPersistentPath$default$2();
        java.util.List x$6 = qual$2.createPersistentPath$default$3();
        qual$2.createPersistentPath(x$4, x$5, x$6);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic, 0)})), (Object)this.zkUtils().getAllPartitions());
    }

    @Test
    public void testGetLeaderIsrAndEpochForPartition() {
        String topic = "my-topic-test";
        int partition = 0;
        int leader = 1;
        int leaderEpoch = 1;
        int controllerEpoch = 1;
        List isr = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        String topicPath = new StringBuilder(34).append("/brokers/topics/").append(topic).append("/partitions/").append(partition).append("/state").toString();
        String topicData = Json$.MODULE$.legacyEncodeAsString((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)controllerEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)leader)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"versions"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isr"), (Object)isr)})));
        ZkUtils qual$1 = this.zkUtils();
        String x$1 = topicPath;
        String x$2 = topicData;
        java.util.List x$3 = qual$1.createPersistentPath$default$3();
        qual$1.createPersistentPath(x$1, x$2, x$3);
        Option leaderIsrAndControllerEpoch = this.zkUtils().getLeaderIsrAndEpochForPartition(topic, partition);
        LeaderIsrAndControllerEpoch topicDataLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, leaderEpoch, isr, 0), controllerEpoch);
        Assert.assertEquals((Object)topicDataLeaderIsrAndControllerEpoch, (Object)leaderIsrAndControllerEpoch.get());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkUtils().getLeaderIsrAndEpochForPartition(topic, partition + 1));
    }

    @Test
    public void testGetSequenceIdMethod() {
        String path = "/test/seqid";
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)seqid -> {
            ZkUtils qual$1 = this.zkUtils();
            String x$1 = path;
            java.util.List x$2 = qual$1.getSequenceId$default$2();
            Assert.assertEquals((long)seqid, (long)qual$1.getSequenceId(x$1, x$2));
        });
    }

    public ZkUtilsTest() {
        this.path = "/path";
    }
}

