/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.api.AbstractConsumerTest;
import kafka.api.FixedPortTestUtils$;
import kafka.log.Log;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t}f\u0001\u0002\u00180\u0001QBQa\u0010\u0001\u0005\u0002\u0001CqA\u0011\u0001C\u0002\u0013\u00051\t\u0003\u0004K\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019\u0019\u0006\u0001)A\u0005\u001b\"9A\u000b\u0001b\u0001\n\u0003)\u0006B\u00021\u0001A\u0003%a\u000bC\u0004b\u0001\t\u0007I\u0011\u00012\t\r=\u0004\u0001\u0015!\u0003d\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015a\b\u0001\"\u0003~\u0011%\t)\u0002AI\u0001\n\u0013\t9\u0002C\u0004\u0002.\u0001!\t%a\f\t\u000f\u0005%\u0003\u0001\"\u0001\u00020!9\u00111\f\u0001\u0005\u0002\u0005u\u0003bBA9\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003k\u0002A\u0011AA<\u0011\u001d\tY\b\u0001C\u0001\u0003_Aq!a \u0001\t\u0003\ty\u0003C\u0004\u0002\u0004\u0002!I!!\"\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\"9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005bBAS\u0001\u0011%\u0011q\u0015\u0005\b\u0003g\u0003A\u0011AA\u0018\u0011\u001d\t9\f\u0001C\u0001\u0003_Aq!a/\u0001\t\u0003\ty\u0003C\u0004\u0002@\u0002!I!!1\t\u000f\u0005u\u0007\u0001\"\u0003\u0002`\"9!1\u0002\u0001\u0005\n\t5\u0001\"\u0003B\f\u0001E\u0005I\u0011\u0002B\r\u0011\u001d\u0011i\u0002\u0001C\u0005\u0005?AqA!\u0011\u0001\t\u0013\u0011\u0019E\u0002\u0004\u0003L\u0001!!Q\n\u0005\n\u0003C\n#Q1A\u0005\u0002\rC\u0011B!\u0016\"\u0005\u0003\u0005\u000b\u0011\u0002#\t\r}\nC\u0011\u0001B,\u0011!\u0011i&\ta\u0001\n\u0003\u0019\u0005\"\u0003B0C\u0001\u0007I\u0011\u0001B1\u0011\u001d\u00119'\tQ!\n\u0011CqA!\u001b\"\t\u0003\ny\u0003C\u0004\u0003l\u0001!IA!\u001c\t\u0013\t]\u0005!%A\u0005\n\te\u0005b\u0002BO\u0001\u0011%!q\u0014\u0005\n\u0005o\u0003\u0011\u0013!C\u0005\u0003/A\u0011B!/\u0001#\u0003%IAa/\u0003%\r{gn];nKJ\u0014u.\u001e8dKR+7\u000f\u001e\u0006\u0003aE\n1!\u00199j\u0015\u0005\u0011\u0014!B6bM.\f7\u0001A\n\u0004\u0001UJ\u0004C\u0001\u001c8\u001b\u0005y\u0013B\u0001\u001d0\u0005Q\t%m\u001d;sC\u000e$8i\u001c8tk6,'\u000fV3tiB\u0011!(P\u0007\u0002w)\u0011A(M\u0001\u0006kRLGn]\u0005\u0003}m\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0003B\u0011a\u0007A\u0001\r[\u0006DxI]8vaNK'0Z\u000b\u0002\tB\u0011Q\tS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n\u0019\u0011J\u001c;\u0002\u001b5\f\u0007p\u0012:pkB\u001c\u0016N_3!\u0003M9'/Y2fMVd7\t\\8tKRKW.Z't+\u0005i\u0005cA#O!&\u0011qJ\u0012\u0002\u0005'>lW\r\u0005\u0002F#&\u0011!K\u0012\u0002\u0005\u0019>tw-\u0001\u000bhe\u0006\u001cWMZ;m\u00072|7/\u001a+j[\u0016l5\u000fI\u0001\tKb,7-\u001e;peV\ta\u000b\u0005\u0002X=6\t\u0001L\u0003\u0002Z5\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005mc\u0016\u0001B;uS2T\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`1\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0013\u0015DXmY;u_J\u0004\u0013aD2p]N,X.\u001a:Q_2dWM]:\u0016\u0003\r\u00042\u0001Z5l\u001b\u0005)'B\u00014h\u0003\u001diW\u000f^1cY\u0016T!\u0001\u001b$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002kK\n1!)\u001e4gKJ\u0004\"\u0001\\7\u000e\u0003\u0001I!A\\\u001c\u00031\r{gn];nKJ\f5o]5h]6,g\u000e\u001e)pY2,'/\u0001\td_:\u001cX/\\3s!>dG.\u001a:tA\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001s!\r\u0019HO^\u0007\u0002O&\u0011Qo\u001a\u0002\u0004'\u0016\f\bCA<{\u001b\u0005A(BA=2\u0003\u0019\u0019XM\u001d<fe&\u00111\u0010\u001f\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u000bhK:,'/\u0019;f\u0017\u000647.Y\"p]\u001aLwm\u001d\u000b\u0003ezDqAQ\u0006\u0011\u0002\u0003\u0007q\u0010\u0005\u0003\u0002\u0002\u0005=a\u0002BA\u0002\u0003\u0017\u00012!!\u0002G\u001b\t\t9AC\u0002\u0002\nM\na\u0001\u0010:p_Rt\u0014bAA\u0007\r\u00061\u0001K]3eK\u001aLA!!\u0005\u0002\u0014\t11\u000b\u001e:j]\u001eT1!!\u0004G\u0003y9WM\\3sCR,7*\u00194lC\u000e{gNZ5hg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001a)\u001aq0a\u0007,\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\nG\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\t\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003c\u00012!RA\u001a\u0013\r\t)D\u0012\u0002\u0005+:LG\u000fK\u0002\u000e\u0003s\u0001B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%A\u0003kk:LGO\u0003\u0002\u0002D\u0005\u0019qN]4\n\t\u0005\u001d\u0013Q\b\u0002\u0006\u0003\u001a$XM]\u0001\"i\u0016\u001cHoQ8ogVl\u0007\u000f^5p]^KG\u000f\u001b\"s_.,'OR1jYV\u0014Xm\u001d\u0015\u0004\u001d\u00055\u0003\u0003BA\u001e\u0003\u001fJA!!\u0015\u0002>\t1\u0011j\u001a8pe\u0016D3ADA+!\u0011\tY$a\u0016\n\t\u0005e\u0013Q\b\u0002\u0005)\u0016\u001cH/A\rd_:\u001cX/\\3XSRD'I]8lKJ4\u0015-\u001b7ve\u0016\u001cH\u0003BA\u0019\u0003?Ba!!\u0019\u0010\u0001\u0004!\u0015\u0001\u00038v[&#XM]:)\u000b=\t)'!\u001c\u0011\t\u0005\u001d\u0014\u0011N\u0007\u0003\u0003KIA!a\u001b\u0002&\t1an\\<be:\f#!a\u001c\u0002\u001f\r\fG/\u00103faJ,7-\u0019;j_:\f1\u0005^3tiN+Wm[!oI\u000e{W.\\5u/&$\bN\u0011:pW\u0016\u0014h)Y5mkJ,7\u000fK\u0002\u0011\u0003+\nqd]3fW\u0006sGmQ8n[&$x+\u001b;i\u0005J|7.\u001a:GC&dWO]3t)\u0011\t\t$!\u001f\t\r\u0005\u0005\u0014\u00031\u0001E\u0003\u0005\"Xm\u001d;Tk\n\u001c8M]5cK^CWM\u001c+pa&\u001cWK\\1wC&d\u0017M\u00197fQ\r\u0011\u0012QK\u0001\ni\u0016\u001cHo\u00117pg\u0016D3aEA+\u0003I\u0019\u0007.Z2l\u00072|7/Z$p_\u0012\u0004\u0016\r\u001e5\u0015\r\u0005E\u0012qQAF\u0011\u0019\tI\t\u0006a\u0001\t\u0006Qa.^7SK\u000e|'\u000fZ:\t\r\u00055E\u00031\u0001\u0000\u0003\u001d9'o\\;q\u0013\u0012\f\u0001e\u00195fG.\u001cEn\\:f/&$\bnQ8pe\u0012Lg.\u0019;pe\u001a\u000b\u0017\u000e\\;sKRA\u0011\u0011GAJ\u0003+\u000bI\n\u0003\u0004\u0002\nV\u0001\r\u0001\u0012\u0005\u0007\u0003/+\u0002\u0019A@\u0002\u0019\u0011Lh.Y7jG\u001e\u0013x.\u001e9\t\r\u0005mU\u00031\u0001\u0000\u0003-i\u0017M\\;bY\u001e\u0013x.\u001e9\u0002\u001f\u0019Lg\u000eZ\"p_J$\u0017N\\1u_J$2\u0001RAQ\u0011\u0019\t\u0019K\u0006a\u0001\u007f\u0006)qM]8va\u0006a2\r[3dW\u000ecwn]3XSRD7\t\\;ti\u0016\u0014h)Y5mkJ,G\u0003CA\u0019\u0003S\u000bY+a,\t\r\u0005%u\u00031\u0001E\u0011\u0019\tik\u0006a\u0001\u007f\u00061qM]8vaFBa!!-\u0018\u0001\u0004y\u0018AB4s_V\u0004('\u0001$uKN$(k\u001c7mS:<'I]8lKJ\u0014Vm\u001d;beR\u001cx+\u001b;i'6\fG\u000e\\3s\u001b\u0006DxI]8vaNK'0Z\"p]\u001aLw\rR5teV\u0004Ho\u001d\"jO\u001e\u0013x.\u001e9)\u0007a\t)&\u0001\u001duKN$8i\u001c8tk6,'OU3dK&4Xm\u001d$bi\u0006dW\t_2faRLwN\\,iK:<%o\\;q!\u0006\u001c8/Z:NCb\u001c\u0016N_3)\u0007e\t)&\u0001\ruKN$8\t\\8tK\u0012+(/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016D3AGA+\u0003e\u0019\u0007.Z2l\u00072|7/\u001a#ve&twMU3cC2\fgnY3\u0015\u0015\u0005E\u00121YAc\u0003\u0013\f\t\u000e\u0003\u0004\u0002\u000en\u0001\ra \u0005\u0007\u0003\u000f\\\u0002\u0019A@\u0002\u000bQ|\u0007/[2\t\rQ[\u0002\u0019AAf!\r9\u0016QZ\u0005\u0004\u0003\u001fD&aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u000f\u0005M7\u00041\u0001\u0002V\u0006Y\"M]8lKJ\u001c\u0018I^1jY\u0006\u0014G.\u001a#ve&twm\u00117pg\u0016\u00042!RAl\u0013\r\tIN\u0012\u0002\b\u0005>|G.Z1oQ\u0015Y\u0012QMA7\u0003a\u0019'/Z1uK\u000e{gn];nKJ\fe\u000e\u001a*fG\u0016Lg/\u001a\u000b\t\u0003C\u0014\u0019A!\u0002\u0003\nAA\u00111]Az\u0003o\f90\u0004\u0002\u0002f*!\u0011q]Au\u0003!\u0019wN\\:v[\u0016\u0014(\u0002BAv\u0003[\fqa\u00197jK:$8OC\u00023\u0003_TA!!=\u0002B\u00051\u0011\r]1dQ\u0016LA!!>\u0002f\ni1*\u00194lC\u000e{gn];nKJ\u0004R!RA}\u0003{L1!a?G\u0005\u0015\t%O]1z!\r)\u0015q`\u0005\u0004\u0005\u00031%\u0001\u0002\"zi\u0016Da!!$\u001d\u0001\u0004y\bb\u0002B\u00049\u0001\u0007\u0011Q[\u0001\r[\u0006tW/\u00197BgNLwM\u001c\u0005\u0007\u0003\u0013c\u0002\u0019\u0001#\u0002'I,7-Z5wK\u0016C\u0018m\u0019;SK\u000e|'\u000fZ:\u0015\u0011\u0005E\"q\u0002B\t\u0005'Aa!a:\u001e\u0001\u0004Y\u0007BBAE;\u0001\u0007A\t\u0003\u0005\u0003\u0016u\u0001\n\u00111\u0001Q\u0003%!\u0018.\\3pkRl5/A\u000fsK\u000e,\u0017N^3Fq\u0006\u001cGOU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011YBK\u0002Q\u00037\tac];c[&$8\t\\8tK\u0006sGMV1mS\u0012\fG/\u001a\u000b\u000b\u0005C\u0011iCa\f\u00034\tu\u0002#B,\u0003$\t\u001d\u0012b\u0001B\u00131\n1a)\u001e;ve\u0016\u00042!\u0012B\u0015\u0013\r\u0011YC\u0012\u0002\u0004\u0003:L\bbBAt?\u0001\u0007\u0011\u0011\u001d\u0005\u0007\u0005cy\u0002\u0019\u0001)\u0002\u001d\rdwn]3US6,w.\u001e;Ng\"9!QG\u0010A\u0002\t]\u0012AD7j]\u000ecwn]3US6,Wj\u001d\t\u0005\u000b\ne\u0002+C\u0002\u0003<\u0019\u0013aa\u00149uS>t\u0007b\u0002B ?\u0001\u0007!qG\u0001\u000f[\u0006D8\t\\8tKRKW.Z't\u0003A\u0019\u0007.Z2l\u00072|7/\u001a3Ti\u0006$X\r\u0006\u0004\u00022\t\u0015#q\t\u0005\u0007\u0003\u001b\u0003\u0003\u0019A@\t\r\t%\u0003\u00051\u0001E\u0003A\u0019w.\\7jiR,GMU3d_J$7OA\u000bC_Vt7-\u001a\"s_.,'oU2iK\u0012,H.\u001a:\u0014\u0007\u0005\u0012y\u0005E\u0002;\u0005#J1Aa\u0015<\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0002\u00139,X.\u0013;feN\u0004C\u0003\u0002B-\u00057\u0002\"\u0001\\\u0011\t\r\u0005\u0005D\u00051\u0001E\u0003\u0011IG/\u001a:\u0002\u0011%$XM]0%KF$B!!\r\u0003d!A!Q\r\u0014\u0002\u0002\u0003\u0007A)A\u0002yIE\nQ!\u001b;fe\u0002\na\u0001Z8X_J\\\u0017!F2sK\u0006$X\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u000b\u0005_\u0012\tIa!\u0003\b\n-\u0005CBA\u0001\u0005c\u0012)(\u0003\u0003\u0003t\u0005M!aA*fiB!!q\u000fB?\u001b\t\u0011IH\u0003\u0003\u0003|\u00055\u0018AB2p[6|g.\u0003\u0003\u0003\u0000\te$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0003\u000fL\u0003\u0019A@\t\r\t\u0015\u0015\u00061\u0001E\u00035qW/\u001c)beRLG/[8og\"1!\u0011R\u0015A\u0002\u0011\u000b\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011%\u0011i)\u000bI\u0001\u0002\u0004\u0011y)A\u0006u_BL7mQ8oM&<\u0007\u0003\u0002BI\u0005'k\u0011AW\u0005\u0004\u0005+S&A\u0003)s_B,'\u000f^5fg\u0006y2M]3bi\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tm%\u0006\u0002BH\u00037\t1b]3oIJ+7m\u001c:egRQ\u0011\u0011\u0007BQ\u0005_\u0013\tLa-\t\u000f\t\r6\u00061\u0001\u0003&\u0006A\u0001O]8ek\u000e,'\u000f\u0005\u0005\u0003(\n-\u0016q_A|\u001b\t\u0011IK\u0003\u0003\u0003$\u0006%\u0018\u0002\u0002BW\u0005S\u0013QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bBBAEW\u0001\u0007A\t\u0003\u0005\u0002H.\u0002\n\u00111\u0001\u0000\u0011%\u0011)i\u000bI\u0001\u0002\u0004\u0011)\f\u0005\u0003F\u0005s!\u0015!F:f]\u0012\u0014VmY8sIN$C-\u001a4bk2$HeM\u0001\u0016g\u0016tGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011iL\u000b\u0003\u00036\u0006m\u0001")
public class ConsumerBounceTest
extends AbstractConsumerTest {
    private final int maxGroupSize;
    private final Some<Object> gracefulCloseTimeMs = new Some((Object)BoxesRunTime.boxToLong((long)1000L));
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private final Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public int maxGroupSize() {
        return this.maxGroupSize;
    }

    public Some<Object> gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    public Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers() {
        return this.consumerPollers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return this.generateKafkaConfigs(this.generateKafkaConfigs$default$1());
    }

    private Seq<KafkaConfig> generateKafkaConfigs(String maxGroupSize) {
        Properties properties = new Properties();
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        properties.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        properties.put(KafkaConfig$.MODULE$.GroupMaxSizeProp(), maxGroupSize);
        properties.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), false, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, properties), Seq$.MODULE$.canBuildFrom());
    }

    private String generateKafkaConfigs$default$1() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.maxGroupSize())).toString();
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.consumerPollers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.shutdown();
                return BoxedUnit.UNIT;
            });
            this.executor().shutdownNow();
            Assert.assertTrue((String)"Executor did not terminate", (boolean)this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS));
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    @Ignore
    public void testConsumptionWithBrokerFailures() {
        this.consumeWithBrokerFailures(10);
    }

    public void consumeWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        LongRef consumed = LongRef.create((long)0L);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            Iterable records = (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(100L)).asScala();
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala());
            records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                ConsumerBounceTest.$anonfun$consumeWithBrokerFailures$1(consumed, record);
                return BoxedUnit.UNIT;
            });
            if (!records.nonEmpty()) continue;
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
            if (consumer.position(this.tp()) != (long)numRecords) continue;
            consumer.seekToBeginning(Collections.emptyList());
            consumed.elem = 0L;
        }
        scheduler.shutdown();
    }

    @Test
    public void testSeekAndCommitWithBrokerFailures() {
        this.seekAndCommitWithBrokerFailures(5);
    }

    /*
     * WARNING - void declaration
     */
    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$1(this, numRecords)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            int coin = TestUtils$.MODULE$.random().nextInt(3);
            if (coin == 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Seeking to end of log");
                consumer.seekToEnd(Collections.emptyList());
                Assert.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin == 1) {
                long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Seeking to ").append(pos).toString());
                consumer.seek(this.tp(), pos);
                Assert.assertEquals((long)pos, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin != 2) continue;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Committing offset.");
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        }
    }

    @Test
    public void testSubscribeWhenTopicUnavailable() {
        int numRecords = 1000;
        String newtopic = "newtopic";
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                this.$outer.createTopic(this.newtopic$1, this.$outer.brokerCount(), this.$outer.brokerCount(), this.$outer.createTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(Duration.ZERO);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        AbstractConsumerTest.ConsumerAssignmentPoller poller = new AbstractConsumerTest.ConsumerAssignmentPoller((AbstractConsumerTest)this, (Consumer<byte[], byte[]>)consumer, (List<String>)new .colon.colon((Object)newtopic, (List)Nil$.MODULE$));
        this.consumerPollers().$plus$eq((Object)poller);
        poller.start();
        this.sendRecords$1(numRecords, newtopic, producer);
        this.receiveExactRecords(poller, numRecords, 10000L);
        poller.shutdown();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Thread.sleep(500L);
        this.restartDeadBrokers();
        AbstractConsumerTest.ConsumerAssignmentPoller poller2 = new AbstractConsumerTest.ConsumerAssignmentPoller((AbstractConsumerTest)this, (Consumer<byte[], byte[]>)consumer, (List<String>)new .colon.colon((Object)newtopic, (List)Nil$.MODULE$));
        this.consumerPollers().$plus$eq((Object)poller2);
        poller2.start();
        this.sendRecords$1(numRecords, newtopic, producer);
        this.receiveExactRecords(poller, numRecords, 10000L);
    }

    @Test
    public void testClose() {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5");
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs()).get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        this.killBroker(this.findCoordinator(dynamicGroup));
        this.killBroker(this.findCoordinator(manualGroup));
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        future1.get();
        future2.get();
        this.restartDeadBrokers();
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
    }

    /*
     * WARNING - void declaration
     */
    private int findCoordinator(String group) {
        FindCoordinatorRequest request = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id()).setKey(group)).build();
        IntRef nodeId = IntRef.create((int)-1);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$findCoordinator$1(this, request, nodeId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ConsumerBounceTest.$anonfun$findCoordinator$2(group), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        return nodeId.elem;
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)requestTimeout)).toString());
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)));
        future1.get();
        future2.get();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup() {
        String group = "group-max-size-test";
        String topic = "group-max-size-test";
        int maxGroupSize = 2;
        int consumerCount = maxGroupSize + 1;
        int partitionCount = consumerCount * 2;
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicPartitions(topic, partitionCount, this.brokerCount(), this.createTopicPartitions$default$4());
        this.addConsumersToGroupAndWaitForGroupAssignment(consumerCount, (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), this.consumerPollers(), (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
        Seq<KafkaConfig> newConfigs = this.generateKafkaConfigs(((Object)BoxesRunTime.boxToInteger((int)maxGroupSize)).toString());
        Range range = this.servers().indices();
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                ConsumerBounceTest.$anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$1(this, newConfigs, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 10000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ConsumerBounceTest.$anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertEquals((long)1L, (long)this.raisedExceptions$1().size());
        Assert.assertTrue((boolean)(this.raisedExceptions$1().head() instanceof GroupMaxSizeReachedException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize() {
        void var5_5;
        String group = "fatal-exception-test";
        String topic = "fatal-exception-test";
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicPartitions(topic, this.maxGroupSize(), this.brokerCount(), this.createTopicPartitions$default$4());
        this.addConsumersToGroupAndWaitForGroupAssignment(this.maxGroupSize(), (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), this.consumerPollers(), (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.addConsumersToGroup(1, (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer rejectedConsumerPollers = (Buffer)tuple2._2();
        AbstractConsumerTest.ConsumerAssignmentPoller rejectedConsumer = (AbstractConsumerTest.ConsumerAssignmentPoller)((Object)var5_5.head());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$1(rejectedConsumer)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertTrue((boolean)(rejectedConsumer.thrownException().get() instanceof GroupMaxSizeReachedException));
        this.sendRecords(this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()), this.maxGroupSize() * 100, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitions.size())));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 10000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testCloseDuringRebalance() {
        String topic = "closetest";
        this.createTopic(topic, 10, this.brokerCount(), this.createTopic$default$4());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer1, ConsumerBounceTest.subscribeAndPoll$default$2$1(), executor, topic), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[0]));
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer2, ConsumerBounceTest.subscribeAndPoll$default$2$1(), executor, topic), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, executor, topic);
        Future<Object> closeFuture1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        ConsumerBounceTest.waitForRebalance$1(2000L, rebalanceFuture, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, executor, topic);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Future<Object> closeFuture2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        closeFuture1.get(2000L, TimeUnit.MILLISECONDS);
        closeFuture2.get(2000L, TimeUnit.MILLISECONDS);
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller = manualAssign ? this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)Nil$.MODULE$, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})))) : this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$), this.subscribeConsumerAndStartPolling$default$3());
        this.receiveExactRecords(consumerPoller, numRecords, this.receiveExactRecords$default$3());
        consumerPoller.shutdown();
        return consumer;
    }

    /*
     * WARNING - void declaration
     */
    private void receiveExactRecords(AbstractConsumerTest.ConsumerAssignmentPoller consumer, int numRecords, long timeoutMs) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$receiveExactRecords$1(consumer, numRecords)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeoutMs) {
                throw Assertions$.MODULE$.fail(ConsumerBounceTest.$anonfun$receiveExactRecords$2(numRecords, consumer), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(timeoutMs, (long)waitUntilTrue_pause));
        }
    }

    private long receiveExactRecords$default$3() {
        return 60000L;
    }

    private Future<Object> submitCloseAndValidate(KafkaConsumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(() -> {
            int closeGraceTimeMs = 2000;
            long startMs = System.currentTimeMillis();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Closing consumer with timeout ").append(closeTimeoutMs).append(" ms.").toString());
            consumer.close(Duration.ofMillis(closeTimeoutMs));
            long timeTakenMs = System.currentTimeMillis() - startMs;
            if (maxCloseTimeMs == null) {
                throw null;
            }
            if (!maxCloseTimeMs.isEmpty()) {
                long l = BoxesRunTime.unboxToLong((Object)maxCloseTimeMs.get());
                ConsumerBounceTest.$anonfun$submitCloseAndValidate$3(timeTakenMs, closeGraceTimeMs, l);
            }
            if (minCloseTimeMs == null) {
                throw null;
            }
            if (!minCloseTimeMs.isEmpty()) {
                long l = BoxesRunTime.unboxToLong((Object)minCloseTimeMs.get());
                ConsumerBounceTest.$anonfun$submitCloseAndValidate$4(timeTakenMs, l);
            }
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("consumer.close() completed in ").append(timeTakenMs).append(" ms.").toString());
        }, BoxesRunTime.boxToInteger((int)0));
    }

    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(null, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        consumer.poll(Duration.ofSeconds(3L));
        Assert.assertTrue((String)"Assignment did not complete on time", (boolean)assignSemaphore.tryAcquire(1L, TimeUnit.SECONDS));
        if (committedRecords > 0) {
            Assert.assertEquals((long)committedRecords, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        }
        consumer.close();
    }

    private scala.collection.immutable.Set<TopicPartition> createTopicPartitions(String topic, int numPartitions, int replicationFactor, Properties topicConfig) {
        this.createTopic(topic, numPartitions, replicationFactor, topicConfig);
        return ((TraversableOnce)package$.MODULE$.Range().apply(0, numPartitions).map((Function1 & Serializable & scala.Serializable)part -> ConsumerBounceTest.$anonfun$createTopicPartitions$1(topic, BoxesRunTime.unboxToInt((Object)part)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
    }

    private Properties createTopicPartitions$default$4() {
        return new Properties();
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, String topic, Option<Object> numPartitions) {
        IntRef partitionIndex = IntRef.create((int)0);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        ((IndexedSeq)RichInt$.MODULE$.until$extension0(n, numRecords).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(this.getPartition$1(numPartitions, partitionIndex)), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes())), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> (RecordMetadata)x$4.get(), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private String sendRecords$default$3() {
        return this.topic();
    }

    private Option<Object> sendRecords$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$consumeWithBrokerFailures$1(LongRef consumed$1, ConsumerRecord record) {
        Assert.assertEquals((long)consumed$1.elem, (long)record.offset());
        ++consumed$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$seekAndCommitWithBrokerFailures$2(ConsumerBounceTest $this, int numRecords$1, KafkaServer server) {
        return ((Log)server.replicaManager().localLog($this.tp()).get()).highWatermark() == (long)numRecords$1;
    }

    public static final /* synthetic */ boolean $anonfun$seekAndCommitWithBrokerFailures$1(ConsumerBounceTest $this, int numRecords$1) {
        return $this.servers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$2($this, numRecords$1, server)));
    }

    public static final /* synthetic */ String $anonfun$seekAndCommitWithBrokerFailures$3() {
        return "Failed to update high watermark for followers after timeout";
    }

    public static final /* synthetic */ void $anonfun$testSubscribeWhenTopicUnavailable$2(IntRef remainingRecords$1, Future future) {
        try {
            future.get();
            --remainingRecords$1.elem;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private final void sendRecords$1(int numRecords, String topic, KafkaProducer producer$1) {
        IntRef remainingRecords = IntRef.create((int)numRecords);
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            ((IndexedSeq)RichInt$.MODULE$.until$extension0(n, remainingRecords.elem).map((Function1 & Serializable & scala.Serializable)i -> producer$1.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(this.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes())), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)future -> {
                ConsumerBounceTest.$anonfun$testSubscribeWhenTopicUnavailable$2(remainingRecords, future);
                return BoxedUnit.UNIT;
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        Assert.assertEquals((long)0L, (long)remainingRecords.elem);
    }

    public static final /* synthetic */ boolean $anonfun$findCoordinator$1(ConsumerBounceTest $this, FindCoordinatorRequest request$1, IntRef nodeId$1) {
        FindCoordinatorResponse response = (FindCoordinatorResponse)$this.connectAndReceive((AbstractRequest)request$1, $this.connectAndReceive$default$2(), $this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FindCoordinatorResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        nodeId$1.elem = response.node().id();
        Errors errors = response.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ String $anonfun$findCoordinator$2(String group$1) {
        return new StringBuilder(37).append("Failed to find coordinator for group ").append(group$1).toString();
    }

    public static final /* synthetic */ void $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$1(ConsumerBounceTest $this, Seq newConfigs$1, int serverIdx) {
        $this.killBroker(serverIdx);
        KafkaConfig config = (KafkaConfig)newConfigs$1.apply(serverIdx);
        $this.servers().update(serverIdx, (Object)TestUtils$.MODULE$.createServer(config, $this.brokerTime(config.brokerId())));
        $this.restartDeadBrokers();
    }

    private final Seq raisedExceptions$1() {
        return (Seq)this.consumerPollers().flatten((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(x$3.thrownException()));
    }

    public static final /* synthetic */ boolean $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$3(ConsumerBounceTest $this) {
        return $this.raisedExceptions$1().nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$4() {
        return "The remaining consumers in the group could not fetch the expected records";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$1(AbstractConsumerTest.ConsumerAssignmentPoller rejectedConsumer$1) {
        return rejectedConsumer$1.thrownException().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$2() {
        return "Extra consumer did not throw an exception";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$4(AbstractConsumerTest.ConsumerAssignmentPoller p) {
        return p.receivedMessages() >= 100;
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$3(ConsumerBounceTest $this) {
        return $this.consumerPollers().forall((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$4(p)));
    }

    public static final /* synthetic */ String $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$5() {
        return "The consumers in the group could not fetch the expected records";
    }

    private static final Future subscribeAndPoll$1(KafkaConsumer consumer, Option revokeSemaphore, ExecutorService executor$1, String topic$2) {
        return executor$1.submit(() -> {
            consumer.subscribe(Collections.singletonList(topic$2));
            if (revokeSemaphore == null) {
                throw null;
            }
            if (!revokeSemaphore.isEmpty()) {
                ((Semaphore)revokeSemaphore.get()).release();
            }
            consumer.poll(0L);
        }, BoxesRunTime.boxToInteger((int)0));
    }

    private static final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private static final void waitForRebalance$1(long timeoutMs, Future future, Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1 & Serializable & scala.Serializable)consumer -> consumer.poll(Duration.ofMillis(100L)));
        }
        Assert.assertTrue((String)"Rebalance did not complete in time", (boolean)future.isDone());
    }

    private final Future createConsumerToRebalance$1(String groupId$1, ExecutorService executor$1, String topic$2) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId$1);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = ConsumerBounceTest.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), executor$1, topic$2);
        Assert.assertTrue((String)"Rebalance not triggered", (boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Rebalance completed too early", (boolean)future.isDone());
        return future;
    }

    public static final /* synthetic */ boolean $anonfun$receiveExactRecords$1(AbstractConsumerTest.ConsumerAssignmentPoller consumer$2, int numRecords$2) {
        return consumer$2.receivedMessages() == numRecords$2;
    }

    public static final /* synthetic */ String $anonfun$receiveExactRecords$2(int numRecords$2, AbstractConsumerTest.ConsumerAssignmentPoller consumer$2) {
        return new StringBuilder(48).append("Consumer did not receive expected ").append(numRecords$2).append(". It received ").append(consumer$2.receivedMessages()).toString();
    }

    public static final /* synthetic */ void $anonfun$submitCloseAndValidate$3(long timeTakenMs$1, int closeGraceTimeMs$1, long ms) {
        Assert.assertTrue((String)new StringBuilder(20).append("Close took too long ").append(timeTakenMs$1).toString(), (timeTakenMs$1 < ms + (long)closeGraceTimeMs$1 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$submitCloseAndValidate$4(long timeTakenMs$1, long ms) {
        Assert.assertTrue((String)new StringBuilder(27).append("Close finished too quickly ").append(timeTakenMs$1).toString(), (timeTakenMs$1 >= ms ? 1 : 0) != 0);
    }

    public static final /* synthetic */ TopicPartition $anonfun$createTopicPartitions$1(String topic$3, int part) {
        return new TopicPartition(topic$3, part);
    }

    private final int getPartition$1(Option numPartitions$1, IntRef partitionIndex$1) {
        int n;
        if (numPartitions$1 instanceof Some) {
            int partitions = BoxesRunTime.unboxToInt((Object)((Some)numPartitions$1).value());
            int nextPart = partitionIndex$1.elem % partitions;
            ++partitionIndex$1.elem;
            n = nextPart;
        } else if (None$.MODULE$.equals(numPartitions$1)) {
            n = this.part();
        } else {
            throw new MatchError((Object)numPartitions$1);
        }
        return n;
    }

    public ConsumerBounceTest() {
        this.maxGroupSize = 5;
        this.consumerConfig().setProperty("enable.auto.commit", "true");
    }

    public static final /* synthetic */ Object $anonfun$checkCloseDuringRebalance$2$adapted(Semaphore s) {
        s.release();
        return BoxedUnit.UNIT;
    }

    public class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        public int iter() {
            return this.iter;
        }

        public void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers();
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
                return;
            }
            Thread.sleep(500L);
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

