/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonValue;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxesRunTime;

public final class PreferredReplicaLeaderElectionCommand$
implements Logging {
    public static PreferredReplicaLeaderElectionCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new PreferredReplicaLeaderElectionCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        int timeout = 30000;
        this.run(args, timeout);
    }

    public void run(String[] args, int timeout) {
        PreferredReplicaLeaderElectionCommand.Command command;
        None$ partitionsForPreferredReplicaElection;
        Predef$.MODULE$.println((Object)"This tool is deprecated. Please use kafka-leader-election tool. Tracking issue: KAFKA-8405");
        PreferredReplicaLeaderElectionCommand.PreferredReplicaLeaderElectionCommandOptions commandOpts = new PreferredReplicaLeaderElectionCommand.PreferredReplicaLeaderElectionCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(commandOpts, "This tool helps to causes leadership for each partition to be transferred back to the 'preferred replica', it can be used to balance leadership among the servers.");
        CommandLineUtils$.MODULE$.checkRequiredArgs(commandOpts.parser(), commandOpts.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[0]));
        if (commandOpts.options().has(commandOpts.bootstrapServerOpt()) == commandOpts.options().has(commandOpts.zkConnectOpt())) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(commandOpts.parser(), new StringBuilder(40).append("Exactly one of '").append(commandOpts.bootstrapServerOpt()).append("' or '").append(commandOpts.zkConnectOpt()).append("' must be provided").toString());
        }
        Object object = partitionsForPreferredReplicaElection = commandOpts.options().has(commandOpts.jsonFileOpt()) ? new Some(this.parsePreferredReplicaElectionData(Utils.readFileAsString((String)((String)commandOpts.options().valueOf(commandOpts.jsonFileOpt()))))) : None$.MODULE$;
        if (commandOpts.options().has(commandOpts.zkConnectOpt())) {
            Predef$.MODULE$.println((Object)"Warning: --zookeeper is deprecated and will be removed in a future version of Kafka.");
            Predef$.MODULE$.println((Object)"Use --bootstrap-server instead to specify a broker to connect to.");
            command = new PreferredReplicaLeaderElectionCommand.ZkCommand((String)commandOpts.options().valueOf(commandOpts.zkConnectOpt()), JaasUtils.isZkSaslEnabled(), timeout);
        } else {
            Properties adminProps = commandOpts.options().has(commandOpts.adminClientConfigOpt()) ? Utils.loadProps((String)((String)commandOpts.options().valueOf(commandOpts.adminClientConfigOpt()))) : new Properties();
            adminProps.setProperty("bootstrap.servers", (String)commandOpts.options().valueOf(commandOpts.bootstrapServerOpt()));
            adminProps.setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)timeout)).toString());
            adminProps.setProperty("default.api.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)(timeout * 2))).toString());
            command = new PreferredReplicaLeaderElectionCommand.AdminClientCommand(adminProps);
        }
        try (PreferredReplicaLeaderElectionCommand.ZkCommand preferredReplicaElectionCommand = command;){
            preferredReplicaElectionCommand.electPreferredLeaders((Option<Set<TopicPartition>>)partitionsForPreferredReplicaElection);
        }
    }

    public int run$default$2() {
        return 30000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public scala.collection.immutable.Set<TopicPartition> parsePreferredReplicaElectionData(String jsonString) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Option<JsonValue> option2 = ((JsonValue)((Some)option).value()).asJsonObject().get("partitions");
            if (option2 instanceof Some) {
                Buffer partitions = ((JsonValue)((Some)option2).value()).asJsonArray().iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asJsonObject()).map((Function1 & Serializable & scala.Serializable)p -> {
                    String topic = p.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                    int partition = BoxesRunTime.unboxToInt((Object)p.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                    return new TopicPartition(topic, partition);
                }).toBuffer();
                Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(partitions);
                if (!duplicatePartitions.nonEmpty()) return partitions.toSet();
                String string = "Preferred replica election data contains duplicate partitions: %s";
                if (Predef$.MODULE$ != null) throw new AdminOperationException(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatePartitions.mkString(",")})));
                throw null;
            }
            if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
            throw new AdminOperationException("Preferred replica election data is empty");
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("Preferred replica election data is empty");
    }

    public void writePreferredReplicaElectionData(KafkaZkClient zkClient, Set<TopicPartition> partitionsUndergoingPreferredReplicaElection) {
        try {
            zkClient.createPreferredReplicaElection((scala.collection.immutable.Set<TopicPartition>)partitionsUndergoingPreferredReplicaElection.toSet());
            String string = "Created preferred replica election path with %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsUndergoingPreferredReplicaElection.mkString(",")})));
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            String string = "%s. Aborting operation";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new AdminOperationException(new StringBuilder(60).append("Preferred replica leader election currently in progress for ").append(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{zkClient.getPreferredReplicaElection().mkString(",")}))).toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    private PreferredReplicaLeaderElectionCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

