/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t}x!B\u0013'\u0011\u0003ic!B\u0018'\u0011\u0003\u0001\u0004\"B\u001c\u0002\t\u0003A\u0004\"B\u001d\u0002\t\u0003Q\u0004b\u0002Bz\u0003\u0011%!Q\u001f\u0005\b\u0005s\fA\u0011\u0002B~\r\u0011yc\u0005\u0001\u001f\t\u0011\r3!\u0011!Q\u0001\n\u0011C\u0001b\u0012\u0004\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u0017\u001a\u0011\t\u0011)A\u0005\u0019\"AqJ\u0002B\u0001B\u0003%\u0001\u000b\u0003\u0005T\r\t\u0005\t\u0015!\u0003U\u0011!9fA!A!\u0002\u0013A\u0006\u0002C.\u0007\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011!4!\u0011!Q\u0001\n%DQa\u000e\u0004\u0005\u00021,A!\u001e\u0004\u0001m\u0016)qP\u0002\u0001\u0002\u0002\u00151\u0011q\u0002\u0004\u0001\u0003\u0003)a!!\u0005\u0007\u0001\u0005M\u0001\"CA\"\r\t\u0007I\u0011BA#\u0011!\tyF\u0002Q\u0001\n\u0005\u001d\u0003bBA1\r\u0011\u0005\u00111\r\u0005\b\u0003+3A\u0011BAL\u0011\u001d\tYL\u0002C\u0001\u0003{Cq!!=\u0007\t\u0003\t\u0019\u0010C\u0004\u0002|\u001a!\t!!@\t\u000f\t\u0015a\u0001\"\u0003\u0003\b!9!q\u0006\u0004\u0005\u0002\tE\u0002b\u0002B!\r\u0011%!1\t\u0005\b\u000532A\u0011\u0001B.\u0011\u001d\u0011)G\u0002C\u0001\u0005OBqAa\u001b\u0007\t\u0013\u0011i\u0007\u0003\u0005\u0003\u0000\u0019!\tA\nBA\u0011\u001d\u0011II\u0002C\u0001\u0005\u0017C\u0011B!%\u0007#\u0003%\tAa%\t\u000f\t%f\u0001\"\u0001\u0003,\u00061BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'O\u0003\u0002(Q\u0005YAO]1og\u0006\u001cG/[8o\u0015\tI#&A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0016\u0002\u000b-\fgm[1\u0004\u0001A\u0011a&A\u0007\u0002M\t1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'o\u0005\u0002\u0002cA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0017\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001fm\u0012iK!0\u0003H\n%'\u0011\u001cBt\u0005c\u0004\"A\f\u0004\u0014\u0007\u0019\tT\b\u0005\u0002?\u00036\tqH\u0003\u0002AU\u0005)Q\u000f^5mg&\u0011!i\u0010\u0002\b\u0019><w-\u001b8h\u0003!\u0011'o\\6fe&#\u0007C\u0001\u001aF\u0013\t15GA\u0002J]R\f\u0011\u0002\u001e=o\u0007>tg-[4\u0011\u00059J\u0015B\u0001&'\u0005E!&/\u00198tC\u000e$\u0018n\u001c8D_:4\u0017nZ\u0001\ng\u000eDW\rZ;mKJ\u0004\"AP'\n\u00059{$!C*dQ\u0016$W\u000f\\3s\u0003E\u0001(o\u001c3vG\u0016\u0014\u0018\nZ'b]\u0006<WM\u001d\t\u0003]EK!A\u0015\u0014\u0003#A\u0013x\u000eZ;dKJLE-T1oC\u001e,'/\u0001\u0006uq:l\u0015M\\1hKJ\u0004\"AL+\n\u0005Y3#a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0003]!\bP\\'be.,'o\u00115b]:,G.T1oC\u001e,'\u000f\u0005\u0002/3&\u0011!L\n\u0002 )J\fgn]1di&|g.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018\u0001\u0002;j[\u0016\u0004\"!\u00184\u000e\u0003yS!\u0001Q0\u000b\u0005\u0001\f\u0017AB2p[6|gN\u0003\u0002,E*\u00111\rZ\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\f1a\u001c:h\u0013\t9gL\u0001\u0003US6,\u0017A\u00037pO\u000e{g\u000e^3yiB\u0011QL[\u0005\u0003Wz\u0013!\u0002T8h\u0007>tG/\u001a=u)%YTN\\8qcJ\u001cH\u000fC\u0003D\u001f\u0001\u0007A\tC\u0003H\u001f\u0001\u0007\u0001\nC\u0003L\u001f\u0001\u0007A\nC\u0003P\u001f\u0001\u0007\u0001\u000bC\u0003T\u001f\u0001\u0007A\u000bC\u0003X\u001f\u0001\u0007\u0001\fC\u0003\\\u001f\u0001\u0007A\fC\u0003i\u001f\u0001\u0007\u0011N\u0001\fJ]&$\bK]8ek\u000e,'/\u00133DC2d'-Y2l!\u0011\u0011t/\u001f?\n\u0005a\u001c$!\u0003$v]\u000e$\u0018n\u001c82!\tq#0\u0003\u0002|M\t!\u0012J\\5u!J|G-^2fe&#'+Z:vYR\u0004\"AM?\n\u0005y\u001c$\u0001B+oSR\u0014Q#\u00113e!\u0006\u0014H/\u001b;j_:\u001c8)\u00197mE\u0006\u001c7\u000eE\u00033o\u0006\rA\u0010\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIaX\u0001\taJ|Go\\2pY&!\u0011QBA\u0004\u0005\u0019)%O]8sg\nqQI\u001c3Uq:\u001c\u0015\r\u001c7cC\u000e\\'!C!qSJ+7/\u001e7u+\u0011\t)\"!\r\u0011\u0011\u0005]\u0011qEA\u0002\u0003[qA!!\u0007\u0002$9!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 1\na\u0001\u0010:p_Rt\u0014\"\u0001\u001b\n\u0007\u0005\u00152'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00121\u0006\u0002\u0007\u000b&$\b.\u001a:\u000b\u0007\u0005\u00152\u0007\u0005\u0003\u00020\u0005EB\u0002\u0001\u0003\b\u0003g\u0019\"\u0019AA\u001b\u0005\u0005!\u0016\u0003BA\u001c\u0003{\u00012AMA\u001d\u0013\r\tYd\r\u0002\b\u001d>$\b.\u001b8h!\r\u0011\u0014qH\u0005\u0004\u0003\u0003\u001a$aA!os\u0006A\u0011n]!di&4X-\u0006\u0002\u0002HA!\u0011\u0011JA.\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013AB1u_6L7M\u0003\u0003\u0002R\u0005M\u0013AC2p]\u000e,(O]3oi*!\u0011QKA,\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0013\u0001\u00026bm\u0006LA!!\u0018\u0002L\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0011\"[:BGRLg/\u001a\u0011\u0002)!\fg\u000e\u001a7f\u0013:LG\u000f\u0015:pIV\u001cWM]%e)%a\u0018QMA=\u0003{\ni\tC\u0004\u0002hY\u0001\r!!\u001b\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0004B!a\u001b\u0002t9!\u0011QNA8!\r\tYbM\u0005\u0004\u0003c\u001a\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002v\u0005]$AB*ue&twMC\u0002\u0002rMBa!a\u001f\u0017\u0001\u0004!\u0015\u0001\u0006;sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5\u000fC\u0004\u0002\u0000Y\u0001\r!!!\u00025\u0015D\b/Z2uK\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\nZ!oI\u0016\u0003xn\u00195\u0011\u000bI\n\u0019)a\"\n\u0007\u0005\u00155G\u0001\u0004PaRLwN\u001c\t\u0004;\u0006%\u0015bAAF=\n\u0011\u0002K]8ek\u000e,'/\u00133B]\u0012,\u0005o\\2i\u0011\u001d\tyI\u0006a\u0001\u0003#\u000b\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\u0007\u0005M\u0005#D\u0001\u0007\u0003q\u0001(/\u001a9be\u0016Le.\u001b;Qe>$WoY3s\u0013\u0012$&/\u00198tSR$B\"!'\u0002(\u0006%\u00161VAX\u0003s\u0003R!a%\u0014\u00037\u0003bAMAO\t\u0006\u0005\u0016bAAPg\t1A+\u001e9mKJ\u00022ALAR\u0013\r\t)K\n\u0002\u0013)btGK]1og&$X*\u001a;bI\u0006$\u0018\rC\u0004\u0002h]\u0001\r!!\u001b\t\r\u0005mt\u00031\u0001E\u0011\u0019\tik\u0006a\u0001\t\u0006\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0005\b\u0003c;\u0002\u0019AAZ\u0003-!\bP\\'fi\u0006$\u0017\r^1\u0011\u00079\n),C\u0002\u00028\u001a\u00121\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006Dq!a \u0018\u0001\u0004\t\t)\u0001\u0011iC:$G.Z!eIB\u000b'\u000f^5uS>t7\u000fV8Ue\u0006t7/Y2uS>tGc\u0003?\u0002@\u0006\u0005\u00171ZAk\u0003[Dq!a\u001a\u0019\u0001\u0004\tI\u0007C\u0004\u0002Db\u0001\r!!2\u0002\u0015A\u0014x\u000eZ;dKJLE\rE\u00023\u0003\u000fL1!!34\u0005\u0011auN\\4\t\u000f\u00055\u0007\u00041\u0001\u0002P\u0006i\u0001O]8ek\u000e,'/\u00129pG\"\u00042AMAi\u0013\r\t\u0019n\r\u0002\u0006'\"|'\u000f\u001e\u0005\b\u0003/D\u0002\u0019AAm\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0007\u00037\f\t/!:\u000e\u0005\u0005u'bAApg\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0018Q\u001c\u0002\u0004'\u0016$\b\u0003BAt\u0003Sl\u0011aX\u0005\u0004\u0003W|&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003\u001fC\u0002\u0019AAx!\r\t\u0019*E\u0001\u000b_:,E.Z2uS>tG#\u0002?\u0002v\u0006e\bBBA|3\u0001\u0007A)A\nuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:LE\r\u0003\u0004\u0002.f\u0001\r\u0001R\u0001\u000e_:\u0014Vm]5h]\u0006$\u0018n\u001c8\u0015\u000bq\fyP!\u0001\t\r\u0005](\u00041\u0001E\u0011\u001d\tiK\u0007a\u0001\u0005\u0007\u0001BAMAB\t\u00069Cn\\4J]Z\fG.\u001b3Ti\u0006$X\r\u0016:b]NLG/[8o\u0003:$'+\u001a;ve:,%O]8s)!\u0011IAa\u0005\u0003\u0016\t}\u0001\u0003\u0003B\u0006\u0005\u001f\t\u0019!a\u000e\u000e\u0005\t5!bAA+g%!!\u0011\u0003B\u0007\u0005\u0011aUM\u001a;\t\u000f\u0005\u001d4\u00041\u0001\u0002j!9!qC\u000eA\u0002\te\u0011\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f!\rq#1D\u0005\u0004\u0005;1#\u0001\u0005+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u0011\u001d\u0011\tc\u0007a\u0001\u0005G\t\u0011\u0003\u001e:b]N\f7\r^5p]J+7/\u001e7u!\u0011\u0011)Ca\u000b\u000e\u0005\t\u001d\"b\u0001B\u0015?\u0006A!/Z9vKN$8/\u0003\u0003\u0003.\t\u001d\"!\u0005+sC:\u001c\u0018m\u0019;j_:\u0014Vm];mi\u0006!\u0002.\u00198eY\u0016,e\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$2\u0002 B\u001a\u0005k\u00119D!\u000f\u0003>!9\u0011q\r\u000fA\u0002\u0005%\u0004bBAb9\u0001\u0007\u0011Q\u0019\u0005\b\u0003\u001bd\u0002\u0019AAh\u0011\u001d\u0011Y\u0004\ba\u0001\u0005G\tq\u0002\u001e=o\u001b\u0006\u00148.\u001a:SKN,H\u000e\u001e\u0005\b\u0003\u001fc\u0002\u0019\u0001B !\r\t\u0019JE\u0001\u000fK:$GK]1og\u0006\u001cG/[8o)5a(Q\tB$\u0005\u0013\u0012YE!\u0014\u0003X!9\u0011qM\u000fA\u0002\u0005%\u0004bBAb;\u0001\u0007\u0011Q\u0019\u0005\b\u0003\u001bl\u0002\u0019AAh\u0011\u001d\u0011Y$\ba\u0001\u0005GAqAa\u0014\u001e\u0001\u0004\u0011\t&\u0001\u0007jg\u001a\u0013x.\\\"mS\u0016tG\u000fE\u00023\u0005'J1A!\u00164\u0005\u001d\u0011un\u001c7fC:Dq!a$\u001e\u0001\u0004\u0011y$A\fue\u0006t7/Y2uS>tGk\u001c9jG\u000e{gNZ5hgV\u0011!Q\f\t\u0005\u0005?\u0012\t'\u0004\u0002\u0002T%!!1MA*\u0005)\u0001&o\u001c9feRLWm]\u0001\ra\u0006\u0014H/\u001b;j_:4uN\u001d\u000b\u0004\t\n%\u0004bBA4?\u0001\u0007\u0011\u0011N\u0001\u0019_:,e\u000e\u001a+sC:\u001c\u0018m\u0019;j_:\u001cu.\u001c9mKR,G\u0003\u0002B8\u0005k\"2\u0001 B9\u0011\u001d\u0011\u0019\b\ta\u0001\u0003\u0007\tQ!\u001a:s_JDqAa\u001e!\u0001\u0004\u0011I(\u0001\tuq:LE-\u00118e!&$W\t]8dQB\u0019aFa\u001f\n\u0007\tudEA\u0011Ue\u0006t7/Y2uS>t\u0017\r\\%e\u0003:$\u0007K]8ek\u000e,'/\u00133Fa>\u001c\u0007.A\rbE>\u0014H\u000fV5nK\u0012|U\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\u001cHc\u0001?\u0003\u0004\"9!QQ\u0011A\u0002\t\u001d\u0015AC8o\u0007>l\u0007\u000f\\3uKB1!g\u001eB=\u0005\u007f\tqa\u001d;beR,\b\u000fF\u0002}\u0005\u001bC\u0011Ba$#!\u0003\u0005\rA!\u0015\u0002?\u0015t\u0017M\u00197f)J\fgn]1di&|g.\u00197JI\u0016C\b/\u001b:bi&|g.A\tti\u0006\u0014H/\u001e9%I\u00164\u0017-\u001e7uIE*\"A!&+\t\tE#qS\u0016\u0003\u00053\u0003BAa'\u0003&6\u0011!Q\u0014\u0006\u0005\u0005?\u0013\t+A\u0005v]\u000eDWmY6fI*\u0019!1U\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003(\nu%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006A1\u000f[;uI><h\u000eF\u0001}\u0011\u001d\u0011yk\u0001a\u0001\u0005c\u000baaY8oM&<\u0007\u0003\u0002BZ\u0005sk!A!.\u000b\u0007\t]&&\u0001\u0004tKJ4XM]\u0005\u0005\u0005w\u0013)LA\u0006LC\u001a\\\u0017mQ8oM&<\u0007b\u0002B`\u0007\u0001\u0007!\u0011Y\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\u0011\u0011\u0019La1\n\t\t\u0015'Q\u0017\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u0015Y5\u00011\u0001M\u0011\u001d\u0011Ym\u0001a\u0001\u0005\u001b\f\u0001B_6DY&,g\u000e\u001e\t\u0005\u0005\u001f\u0014).\u0004\u0002\u0003R*\u0019!1\u001b\u0016\u0002\u0005i\\\u0017\u0002\u0002Bl\u0005#\u0014QbS1gW\u0006T6n\u00117jK:$\bb\u0002Bn\u0007\u0001\u0007!Q\\\u0001\b[\u0016$(/[2t!\u0011\u0011yNa9\u000e\u0005\t\u0005(b\u0001Bn?&!!Q\u001dBq\u0005\u001diU\r\u001e:jGNDqA!;\u0004\u0001\u0004\u0011Y/A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\t\u0005\u0005g\u0013i/\u0003\u0003\u0003p\nU&!D'fi\u0006$\u0017\r^1DC\u000eDW\rC\u0003\\\u0007\u0001\u0007A,\u0001\u000bj]&$HK]1og\u0006\u001cG/[8o\u000bJ\u0014xN\u001d\u000b\u0004s\n]\bb\u0002B:\t\u0001\u0007\u00111A\u0001\u0018S:LG\u000f\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006$2!\u001fB\u007f\u0011\u001d\t\t,\u0002a\u0001\u0003C\u0003")
public class TransactionCoordinator
implements Logging {
    private final TransactionConfig txnConfig;
    private final Scheduler scheduler;
    private final ProducerIdManager producerIdManager;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig kafkaConfig, ReplicaManager replicaManager, Scheduler scheduler, KafkaZkClient kafkaZkClient, Metrics metrics, MetadataCache metadataCache, Time time) {
        return TransactionCoordinator$.MODULE$.apply(kafkaConfig, replicaManager, scheduler, kafkaZkClient, metrics, metadataCache, time);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - void declaration
     */
    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch, Function1<InitProducerIdResult, BoxedUnit> responseCallback) {
        Tuple2 tuple2;
        Either either;
        Either either2;
        if (transactionalId == null) {
            long producerId = this.producerIdManager.generateProducerId();
            responseCallback.apply((Object)new InitProducerIdResult(producerId, 0, Errors.NONE));
            return;
        }
        if (transactionalId.isEmpty()) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_REQUEST));
            return;
        }
        if (!this.txnManager.validateTransactionTimeoutMs(transactionTimeoutMs)) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_TRANSACTION_TIMEOUT));
            return;
        }
        Either either3 = this.txnManager.getTransactionState(transactionalId);
        if (either3 == null) {
            throw null;
        }
        Either flatMap_this = either3;
        if (flatMap_this instanceof Right) {
            Option option = (Option)((Right)flatMap_this).value();
            either2 = TransactionCoordinator.$anonfun$handleInitProducerId$1(this, transactionalId, transactionTimeoutMs, option);
        } else {
            either2 = flatMap_this;
        }
        if (either2 == null) {
            throw null;
        }
        if (either2 instanceof Right) {
            CoordinatorEpochAndTxnMetadata coordinatorEpochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Right)either2).value();
            either = TransactionCoordinator.$anonfun$handleInitProducerId$2(this, transactionalId, transactionTimeoutMs, expectedProducerIdAndEpoch, coordinatorEpochAndTxnMetadata);
        } else {
            either = either2;
        }
        if (either instanceof Left) {
            Errors error2 = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error2));
            return;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            TransactionState transactionState = newMetadata.txnState();
            PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
            if (!(transactionState != null ? !transactionState.equals(prepareEpochFence$) : prepareEpochFence$ != null)) {
                Tuple2 tuple22;
                Either either4;
                void endTransaction_txnMarkerResult;
                void endTransaction_producerEpoch;
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)error -> {
                    Errors errors = error;
                    Errors errors2 = Errors.NONE;
                    if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                    } else {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    }
                    return BoxedUnit.UNIT;
                };
                boolean bl = false;
                TransactionResult transactionResult = TransactionResult.ABORT;
                short s = newMetadata.producerEpoch();
                long endTransaction_producerId = newMetadata.producerId();
                BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
                if (transactionalId.isEmpty()) {
                    Errors errors;
                    Errors errors2 = errors = Errors.INVALID_REQUEST;
                    Errors errors3 = Errors.NONE;
                    if (errors2 == null ? errors3 != null : !errors2.equals(errors3)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(errors));
                        return;
                    }
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    return;
                }
                Either either5 = this.txnManager.getTransactionState(transactionalId);
                if (either5 == null) {
                    throw null;
                }
                Either endTransaction_flatMap_this = either5;
                if (endTransaction_flatMap_this instanceof Right) {
                    void endTransaction_isFromClient;
                    Option option = (Option)((Right)endTransaction_flatMap_this).value();
                    either4 = TransactionCoordinator.$anonfun$endTransaction$1(this, endTransaction_producerId, (boolean)endTransaction_isFromClient, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, endTransaction_isEpochFence, transactionalId, option);
                } else {
                    either4 = endTransaction_flatMap_this;
                }
                if (either4 instanceof Left) {
                    Errors errors;
                    Errors endTransaction_err = (Errors)((Left)either4).value();
                    this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> TransactionCoordinator.$anonfun$endTransaction$4((TransactionResult)endTransaction_txnMarkerResult, endTransaction_err, transactionalId)));
                    Errors errors4 = errors = endTransaction_err;
                    Errors errors5 = Errors.NONE;
                    if (errors4 == null ? errors5 != null : !errors4.equals(errors5)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(errors));
                        return;
                    }
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    return;
                }
                if (either4 instanceof Right && (tuple22 = (Tuple2)((Right)either4).value()) != null) {
                    void endTransaction_responseCallback;
                    int endTransaction_coordinatorEpoch = tuple22._1$mcI$sp();
                    TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple22._2();
                    this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)((Function1 & Serializable & scala.Serializable)arg_0 -> TransactionCoordinator.$anonfun$endTransaction$15$adapted(this, transactionalId, endTransaction_coordinatorEpoch, endTransaction_producerId, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, (Function1)endTransaction_responseCallback, endTransaction_newMetadata, endTransaction_isEpochFence, arg_0)), this.txnManager.appendTransactionToLog$default$5());
                    return;
                }
                throw new MatchError(either4);
            }
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata));
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                }
                return BoxedUnit.UNIT;
            }, this.txnManager.appendTransactionToLog$default$5());
            return;
        }
        throw new MatchError((Object)either);
    }

    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProducerIdTransit(String transactionalId, int transactionTimeoutMs, int coordinatorEpoch, TransactionMetadata txnMetadata, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch) {
        Left left;
        ProducerIdAndEpoch producerIdAndEpoch;
        if (txnMetadata.pendingTransitionInProgress()) {
            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        }
        if (expectedProducerIdAndEpoch == null) {
            throw null;
        }
        boolean bl = expectedProducerIdAndEpoch.isEmpty() || TransactionCoordinator.isValidProducerId$1(producerIdAndEpoch = (ProducerIdAndEpoch)expectedProducerIdAndEpoch.get(), txnMetadata);
        if (!bl) {
            return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
        }
        TransactionState transactionState = txnMetadata.state();
        boolean bl2 = PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState);
        if (bl2) {
            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        } else {
            boolean bl3 = CompleteAbort$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : Empty$.MODULE$.equals(transactionState));
            if (bl3) {
                Left left2;
                Right transitMetadataResult;
                Right right;
                ProducerIdAndEpoch producerIdAndEpoch2;
                boolean bl4;
                if (txnMetadata.isProducerEpochExhausted() && (bl4 = expectedProducerIdAndEpoch.isEmpty() || TransactionCoordinator.$anonfun$prepareInitProducerIdTransit$2(txnMetadata, producerIdAndEpoch2 = (ProducerIdAndEpoch)expectedProducerIdAndEpoch.get()))) {
                    long newProducerId = this.producerIdManager.generateProducerId();
                    right = package$.MODULE$.Right().apply((Object)txnMetadata.prepareProducerIdRotation(newProducerId, transactionTimeoutMs, this.time.milliseconds(), expectedProducerIdAndEpoch.isDefined()));
                } else {
                    Object object = expectedProducerIdAndEpoch.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToShort((short)((ProducerIdAndEpoch)expectedProducerIdAndEpoch.get()).epoch));
                    right = transitMetadataResult = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, (Option<Object>)object, this.time.milliseconds());
                }
                if (transitMetadataResult instanceof Right) {
                    TxnTransitMetadata transitMetadata = (TxnTransitMetadata)((Right)transitMetadataResult).value();
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)transitMetadata));
                } else if (transitMetadataResult instanceof Left) {
                    Errors err = (Errors)((Left)transitMetadataResult).value();
                    left2 = package$.MODULE$.Left().apply((Object)err);
                } else {
                    throw new MatchError((Object)transitMetadataResult);
                }
                left = left2;
            } else if (Ongoing$.MODULE$.equals(transactionState)) {
                left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareFenceProducerEpoch()));
            } else {
                boolean bl5 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                if (bl5) {
                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                throw new MatchError((Object)transactionState);
            }
        }
        return left;
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback) {
        Tuple2 tuple2;
        Either either;
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(Errors.INVALID_REQUEST).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either either2 = this.txnManager.getTransactionState(transactionalId);
        if (either2 == null) {
            throw null;
        }
        Either flatMap_this = either2;
        if (flatMap_this instanceof Right) {
            Option option = (Option)((Right)flatMap_this).value();
            either = TransactionCoordinator.$anonfun$handleAddPartitionsToTransaction$2(this, producerId, producerEpoch, partitions, option);
        } else {
            either = flatMap_this;
        }
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(err).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, responseCallback, this.txnManager.appendTransactionToLog$default$5());
            return;
        }
        throw new MatchError((Object)either);
    }

    public void onElection(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void onResignation(int txnTopicPartitionId, Option<Object> coordinatorEpoch) {
        if (coordinatorEpoch instanceof Some) {
            int epoch = BoxesRunTime.unboxToInt((Object)((Some)coordinatorEpoch).value());
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, epoch);
        } else if (None$.MODULE$.equals(coordinatorEpoch)) {
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId);
        } else {
            throw new MatchError(coordinatorEpoch);
        }
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("TransactionalId: ").append(transactionalId).append("'s state is ").append(transactionState).append(", but received transaction ").append("marker result to send: ").append(transactionResult).toString());
        return package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, Function1<Errors, BoxedUnit> responseCallback) {
        Tuple2 tuple2;
        Either either;
        boolean endTransaction_isFromClient = true;
        BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either either2 = this.txnManager.getTransactionState(transactionalId);
        if (either2 == null) {
            throw null;
        }
        Either endTransaction_flatMap_this = either2;
        if (endTransaction_flatMap_this instanceof Right) {
            Option option = (Option)((Right)endTransaction_flatMap_this).value();
            either = TransactionCoordinator.$anonfun$endTransaction$1(this, producerId, endTransaction_isFromClient, producerEpoch, txnMarkerResult, endTransaction_isEpochFence, transactionalId, option);
        } else {
            either = endTransaction_flatMap_this;
        }
        if (either instanceof Left) {
            Errors endTransaction_err = (Errors)((Left)either).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)endTransaction_err);
            return;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            int endTransaction_coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple2._2();
            this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Either either;
                    Either either2 = $this.txnManager.getTransactionState(transactionalId);
                    if (either2 == null) {
                        throw null;
                    }
                    Either $anonfun$endTransaction$15_sendTxnMarkersCallback$1_flatMap_this = either2;
                    if ($anonfun$endTransaction$15_sendTxnMarkersCallback$1_flatMap_this instanceof Right) {
                        Option option = (Option)((Right)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_flatMap_this).value();
                        either = TransactionCoordinator.$anonfun$endTransaction$5(this, transactionalId, endTransaction_coordinatorEpoch, producerId, producerEpoch, txnMarkerResult, option);
                    } else {
                        either = $anonfun$endTransaction$15_sendTxnMarkersCallback$1_flatMap_this;
                    }
                    if (either instanceof Left) {
                        Errors $anonfun$endTransaction$15_sendTxnMarkersCallback$1_err = (Errors)((Left)either).value();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_err);
                        return BoxedUnit.UNIT;
                    } else {
                        Tuple2 tuple2;
                        if (!(either instanceof Right) || (tuple2 = (Tuple2)((Right)either).value()) == null) throw new MatchError(either);
                        TransactionMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                        TxnTransitMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                        responseCallback.apply((Object)Errors.NONE);
                        $this.txnMarkerChannelManager.addTxnMarkersToSend(endTransaction_coordinatorEpoch, txnMarkerResult, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata);
                    }
                    return BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
                    if (isEpochFence$1.elem) {
                        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnManager.getTransactionState(transactionalId);
                        if (either == null) {
                            throw null;
                        }
                        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> $anonfun$endTransaction$15_sendTxnMarkersCallback$1_foreach_this = either;
                        if ($anonfun$endTransaction$15_sendTxnMarkersCallback$1_foreach_this instanceof Right) {
                            Option option = (Option)((Right)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_foreach_this).value();
                            TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, option);
                        }
                    }
                    responseCallback.apply(error);
                }
                return BoxedUnit.UNIT;
            }, this.txnManager.appendTransactionToLog$default$5());
            return;
        }
        throw new MatchError(either);
    }

    private void endTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, boolean isFromClient, Function1<Errors, BoxedUnit> responseCallback) {
        Tuple2 tuple2;
        Either either;
        BooleanRef isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either either2 = this.txnManager.getTransactionState(transactionalId);
        if (either2 == null) {
            throw null;
        }
        Either flatMap_this = either2;
        if (flatMap_this instanceof Right) {
            Option option = (Option)((Right)flatMap_this).value();
            either = TransactionCoordinator.$anonfun$endTransaction$1(this, producerId, isFromClient, producerEpoch, txnMarkerResult, isEpochFence, transactionalId, option);
        } else {
            either = flatMap_this;
        }
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Either either;
                    Either either2 = $this.txnManager.getTransactionState(transactionalId);
                    if (either2 == null) {
                        throw null;
                    }
                    Either $anonfun$endTransaction$15_sendTxnMarkersCallback$1_flatMap_this = either2;
                    if ($anonfun$endTransaction$15_sendTxnMarkersCallback$1_flatMap_this instanceof Right) {
                        Option option = (Option)((Right)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_flatMap_this).value();
                        either = TransactionCoordinator.$anonfun$endTransaction$5(this, transactionalId, endTransaction_coordinatorEpoch, producerId, producerEpoch, txnMarkerResult, option);
                    } else {
                        either = $anonfun$endTransaction$15_sendTxnMarkersCallback$1_flatMap_this;
                    }
                    if (either instanceof Left) {
                        Errors $anonfun$endTransaction$15_sendTxnMarkersCallback$1_err = (Errors)((Left)either).value();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_err);
                        return BoxedUnit.UNIT;
                    } else {
                        Tuple2 tuple2;
                        if (!(either instanceof Right) || (tuple2 = (Tuple2)((Right)either).value()) == null) throw new MatchError(either);
                        TransactionMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                        TxnTransitMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                        responseCallback.apply((Object)Errors.NONE);
                        $this.txnMarkerChannelManager.addTxnMarkersToSend(endTransaction_coordinatorEpoch, txnMarkerResult, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata);
                    }
                    return BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
                    if (isEpochFence$1.elem) {
                        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnManager.getTransactionState(transactionalId);
                        if (either == null) {
                            throw null;
                        }
                        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> $anonfun$endTransaction$15_sendTxnMarkersCallback$1_foreach_this = either;
                        if ($anonfun$endTransaction$15_sendTxnMarkersCallback$1_foreach_this instanceof Right) {
                            Option option = (Option)((Right)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_foreach_this).value();
                            TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, option);
                        }
                    }
                    responseCallback.apply(error);
                }
                return BoxedUnit.UNIT;
            }, this.txnManager.appendTransactionToLog$default$5());
            return;
        }
        throw new MatchError(either);
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void onEndTransactionComplete(TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch, Errors error) {
        if (Errors.NONE.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Completed rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" due to timeout").toString());
            return;
        }
        boolean bl = Errors.INVALID_PRODUCER_ID_MAPPING.equals(error) ? true : (Errors.INVALID_PRODUCER_EPOCH.equals(error) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(error));
        if (bl) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("has been cancelled due to error ").append(error).toString());
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("failed due to error ").append(error).toString());
    }

    public void abortTimedOutTransactions(Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>> onComplete) {
        this.txnManager.timedOutTransactions().foreach((Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> {
            Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId());
            if (either == null) {
                throw null;
            }
            Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> $anonfun$abortTimedOutTransactions$1_foreach_this = either;
            if ($anonfun$abortTimedOutTransactions$1_foreach_this instanceof Right) {
                Option option = (Option)((Right)$anonfun$abortTimedOutTransactions$1_foreach_this).value();
                if (None$.MODULE$.equals(option)) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch$2).toString());
                } else if (option instanceof Some) {
                    TransactionMetadata $anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata();
                    Option $anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_transitMetadataOpt = (Option)$anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        if (txnMetadata.producerId() != txnIdAndPidEpoch$2.producerId()) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch$2.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch$2.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                            return None$.MODULE$;
                        }
                        if (txnMetadata.pendingTransitionInProgress()) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch$2).append(" since there is a ").append("pending state transition").toString());
                            return None$.MODULE$;
                        }
                        return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
                    });
                    Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                        this.endTransaction($anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)));
                        return BoxedUnit.UNIT;
                    };
                    if ($anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_transitMetadataOpt == null) {
                        throw null;
                    }
                    if (!$anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_transitMetadataOpt.isEmpty()) {
                        void $anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_foreach_f;
                        $anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_foreach_f.apply($anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_transitMetadataOpt.get());
                    }
                } else {
                    throw new MatchError((Object)option);
                }
            }
            return BoxedUnit.UNIT;
        });
    }

    public void startup(boolean enableTransactionalIdExpiration) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.abortTimedOutTransactions((Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>>)(Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> (Function1 & Serializable & scala.Serializable)error -> {
            this.onEndTransactionComplete(txnIdAndPidEpoch, error);
            return BoxedUnit.UNIT;
        }), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.scheduler.schedule$default$5());
        if (enableTransactionalIdExpiration) {
            this.txnManager.enableTransactionalIdExpiration();
        }
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$1() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.producerIdManager.shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    public static final /* synthetic */ Either $anonfun$handleInitProducerId$1(TransactionCoordinator $this, String transactionalId$1, int transactionTimeoutMs$1, Option x0$1) {
        Either<Errors, CoordinatorEpochAndTxnMetadata> either;
        if (None$.MODULE$.equals(x0$1)) {
            long producerId = $this.producerIdManager.generateProducerId();
            long x$3 = -1L;
            short x$4 = -1;
            short x$5 = -1;
            Empty$ x$7 = Empty$.MODULE$;
            scala.collection.mutable.Set x$8 = Set$.MODULE$.empty();
            long x$9 = $this.time.milliseconds();
            long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
            TransactionMetadata createdMetadata = new TransactionMetadata(transactionalId$1, producerId, x$3, x$4, x$5, transactionTimeoutMs$1, x$7, (scala.collection.mutable.Set<TopicPartition>)x$8, x$10, x$9);
            either = $this.txnManager.putTransactionStateIfNotExists(createdMetadata);
        } else if (x0$1 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
            either = package$.MODULE$.Right().apply((Object)epochAndTxnMetadata);
        } else {
            throw new MatchError((Object)x0$1);
        }
        return either;
    }

    public static final /* synthetic */ Either $anonfun$handleInitProducerId$2(TransactionCoordinator $this, String transactionalId$1, int transactionTimeoutMs$1, Option expectedProducerIdAndEpoch$1, CoordinatorEpochAndTxnMetadata existingEpochAndMetadata) {
        int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
        TransactionMetadata txnMetadata = existingEpochAndMetadata.transactionMetadata();
        return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> $this.prepareInitProducerIdTransit(transactionalId$1, transactionTimeoutMs$1, coordinatorEpoch, txnMetadata, (Option<ProducerIdAndEpoch>)expectedProducerIdAndEpoch$1));
    }

    private static final void sendRetriableErrorCallback$1(Errors error, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$4(Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$7(TransactionCoordinator $this, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    private static final boolean isValidProducerId$1(ProducerIdAndEpoch producerIdAndEpoch, TransactionMetadata txnMetadata$2) {
        return txnMetadata$2.producerEpoch() == -1 || producerIdAndEpoch.producerId == txnMetadata$2.producerId() || producerIdAndEpoch.producerId == txnMetadata$2.lastProducerId() && TransactionMetadata$.MODULE$.isEpochExhausted(producerIdAndEpoch.epoch);
    }

    public static final /* synthetic */ boolean $anonfun$prepareInitProducerIdTransit$2(TransactionMetadata txnMetadata$2, ProducerIdAndEpoch x$1) {
        return x$1.epoch == txnMetadata$2.producerEpoch();
    }

    public static final /* synthetic */ Either $anonfun$handleAddPartitionsToTransaction$2(TransactionCoordinator $this, long producerId$1, short producerEpoch$1, Set partitions$1, Option x0$1) {
        Left left;
        if (None$.MODULE$.equals(x0$1)) {
            left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
        } else if (x0$1 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
            int coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
            TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
            left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                block8: {
                    block7: {
                        if (txnMetadata.producerId() != producerId$1) {
                            return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                        }
                        if (txnMetadata.producerEpoch() != producerEpoch$1) {
                            return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                        }
                        if (txnMetadata.pendingTransitionInProgress()) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                        TransactionState transactionState = txnMetadata.state();
                        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                        if (!(transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$))) break block7;
                        TransactionState transactionState2 = txnMetadata.state();
                        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                        if (transactionState2 != null ? !transactionState2.equals(prepareAbort$) : prepareAbort$ != null) break block8;
                    }
                    return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                }
                TransactionState transactionState = txnMetadata.state();
                Ongoing$ ongoing$ = Ongoing$.MODULE$;
                if (!(transactionState != null ? !transactionState.equals(ongoing$) : ongoing$ != null) && partitions$1.subsetOf(txnMetadata.topicPartitions())) {
                    return package$.MODULE$.Left().apply((Object)Errors.NONE);
                }
                return package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAddPartitions((scala.collection.immutable.Set<TopicPartition>)partitions$1.toSet(), $this.time.milliseconds())));
            });
        } else {
            throw new MatchError((Object)x0$1);
        }
        return left;
    }

    public static final /* synthetic */ Either $anonfun$endTransaction$1(TransactionCoordinator $this, long producerId$2, boolean isFromClient$1, short producerEpoch$2, TransactionResult txnMarkerResult$1, BooleanRef isEpochFence$1, String transactionalId$4, Option x0$1) {
        Left left;
        if (None$.MODULE$.equals(x0$1)) {
            left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
        } else if (x0$1 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
            TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
            int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
            left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                Right right;
                TransactionState transactionState;
                if (txnMetadata.producerId() != producerId$2) {
                    return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                }
                if (isFromClient$1 && producerEpoch$2 != txnMetadata.producerEpoch() || producerEpoch$2 < txnMetadata.producerEpoch()) {
                    return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    Object object = txnMetadata.pendingState().get();
                    PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                    if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                }
                if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                    Product nextState;
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult2 = TransactionResult.COMMIT;
                    Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                    PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                    if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                        isEpochFence$1.elem = true;
                        txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                        txnMetadata.producerEpoch_$eq(producerEpoch$2);
                        txnMetadata.lastProducerEpoch_$eq((short)-1);
                    }
                    right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult3 = TransactionResult.COMMIT;
                    right = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult4 = TransactionResult.ABORT;
                    right = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult5 = TransactionResult.COMMIT;
                    right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult6 = TransactionResult.ABORT;
                    right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else if (Empty$.MODULE$.equals(transactionState)) {
                    right = $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else {
                    boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                    if (bl) {
                        String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId$4).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                        $this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                        throw new IllegalStateException(errorMsg);
                    }
                    throw new MatchError((Object)transactionState);
                }
                return right;
            });
        } else {
            throw new MatchError((Object)x0$1);
        }
        return left;
    }

    public static final /* synthetic */ Either $anonfun$endTransaction$5(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$4, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Option x0$1) {
        Left left;
        if (None$.MODULE$.equals(x0$1)) {
            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId$4).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
            $this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        if (x0$1 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
            if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$4) {
                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    Left<Errors, Nothing$> left;
                    if (txnMetadata.producerId() != producerId$2) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (txnMetadata.producerEpoch() != producerEpoch$2) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                    TransactionState transactionState = txnMetadata.state();
                    boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                    if (bl) {
                        left = $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult$1;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult$1;
                        TransactionResult transactionResult3 = TransactionResult.ABORT;
                        left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                    } else {
                        boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                        if (bl2) {
                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId$4).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                            $this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError((Object)transactionState);
                    }
                    return left;
                });
            } else {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult$1).append(" was ").append("successfully appended to the log for ").append(transactionalId$4).append(" with old epoch ").append(coordinatorEpoch$4).toString());
                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
            }
        } else {
            throw new MatchError((Object)x0$1);
        }
        Left left2 = left;
        return left2;
    }

    public static final /* synthetic */ void $anonfun$endTransaction$12(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$4, Errors error$2, TxnTransitMetadata newMetadata$2, Option x0$2) {
        if (None$.MODULE$.equals(x0$2)) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId$4).append(", but there is ").append("no metadata in the cache; this is not expected").toString());
            return;
        }
        if (x0$2 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$2).value();
            if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$4) {
                epochAndMetadata.transactionMetadata().hasFailedEpochFence_$eq(true);
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(166).append("The coordinator failed to write an epoch fence transition for producer ").append(transactionalId$4).append(" to the transaction log ").append("with error ").append(error$2).append(". The epoch was increased to ").append(newMetadata$2.producerEpoch()).append(" but not returned to the client").toString());
                return;
            }
        } else {
            throw new MatchError((Object)x0$2);
        }
    }

    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$4, int coordinatorEpoch$4, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either either;
            Either either2 = this.txnManager.getTransactionState(transactionalId$4);
            if (either2 == null) {
                throw null;
            }
            Either flatMap_this = either2;
            if (flatMap_this instanceof Right) {
                Option option = (Option)((Right)flatMap_this).value();
                either = TransactionCoordinator.$anonfun$endTransaction$5(this, transactionalId$4, coordinatorEpoch$4, producerId$2, producerEpoch$2, txnMarkerResult$1, option);
            } else {
                either = flatMap_this;
            }
            if (either instanceof Left) {
                Errors err = (Errors)((Left)either).value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)err);
                return;
            }
            if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$4, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                return;
            }
            throw new MatchError(either);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
        if (isEpochFence$1.elem) {
            Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnManager.getTransactionState(transactionalId$4);
            if (either == null) {
                throw null;
            }
            Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> foreach_this = either;
            if (foreach_this instanceof Right) {
                Option option = (Option)((Right)foreach_this).value();
                TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId$4, coordinatorEpoch$4, error, newMetadata$2, option);
            }
        }
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$endTransaction$15(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$4, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either either;
            Either either2 = $this.txnManager.getTransactionState(transactionalId$4);
            if (either2 == null) {
                throw null;
            }
            Either sendTxnMarkersCallback$1_flatMap_this = either2;
            if (sendTxnMarkersCallback$1_flatMap_this instanceof Right) {
                Option option = (Option)((Right)sendTxnMarkersCallback$1_flatMap_this).value();
                either = TransactionCoordinator.$anonfun$endTransaction$5($this, transactionalId$4, coordinatorEpoch$4, producerId$2, producerEpoch$2, txnMarkerResult$1, option);
            } else {
                either = sendTxnMarkersCallback$1_flatMap_this;
            }
            if (either instanceof Left) {
                Errors sendTxnMarkersCallback$1_err = (Errors)((Left)either).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)sendTxnMarkersCallback$1_err);
                return;
            }
            if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                TransactionMetadata sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                $this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$4, txnMarkerResult$1, sendTxnMarkersCallback$1_txnMetadata, sendTxnMarkersCallback$1_newPreSendMetadata);
                return;
            }
            throw new MatchError(either);
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
        if (isEpochFence$1.elem) {
            Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnManager.getTransactionState(transactionalId$4);
            if (either == null) {
                throw null;
            }
            Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> sendTxnMarkersCallback$1_foreach_this = either;
            if (sendTxnMarkersCallback$1_foreach_this instanceof Right) {
                Option option = (Option)((Right)sendTxnMarkersCallback$1_foreach_this).value();
                TransactionCoordinator.$anonfun$endTransaction$12($this, transactionalId$4, coordinatorEpoch$4, error, newMetadata$2, option);
            }
        }
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$7(TransactionCoordinator $this, TransactionMetadata txnMetadata$6, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, TxnTransitMetadata txnTransitMetadata) {
        $this.endTransaction(txnMetadata$6.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete$1.apply((Object)txnIdAndPidEpoch$2)));
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$2(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, Function1 onComplete$1, Option x0$1) {
        if (None$.MODULE$.equals(x0$1)) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch$2).toString());
            return;
        }
        if (x0$1 instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
            Option transitMetadataOpt = (Option)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                if (txnMetadata.producerId() != txnIdAndPidEpoch$2.producerId()) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch$2.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch$2.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                    return None$.MODULE$;
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch$2).append(" since there is a ").append("pending state transition").toString());
                    return None$.MODULE$;
                }
                return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
            });
            if (transitMetadataOpt == null) {
                throw null;
            }
            if (!transitMetadataOpt.isEmpty()) {
                TxnTransitMetadata txnTransitMetadata = (TxnTransitMetadata)transitMetadataOpt.get();
                $this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete$1.apply((Object)txnIdAndPidEpoch$2)));
                return;
            }
        } else {
            throw new MatchError((Object)x0$1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$1(TransactionCoordinator $this, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch) {
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId());
        if (either == null) {
            throw null;
        }
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> foreach_this = either;
        if (foreach_this instanceof Right) {
            Option option = (Option)((Right)foreach_this).value();
            if (None$.MODULE$.equals(option)) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch$2).toString());
                return;
            }
            if (option instanceof Some) {
                TransactionMetadata $anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata();
                Option $anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_transitMetadataOpt = (Option)$anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadata.producerId() != txnIdAndPidEpoch$2.producerId()) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch$2.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch$2.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                        return None$.MODULE$;
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch$2).append(" since there is a ").append("pending state transition").toString());
                        return None$.MODULE$;
                    }
                    return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
                });
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                    this.endTransaction($anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)));
                    return BoxedUnit.UNIT;
                };
                if ($anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_transitMetadataOpt == null) {
                    throw null;
                }
                if (!$anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_transitMetadataOpt.isEmpty()) {
                    void $anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_foreach_f;
                    $anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_foreach_f.apply($anonfun$abortTimedOutTransactions$2$adapted_$anonfun$abortTimedOutTransactions$2_transitMetadataOpt.get());
                    return;
                }
            } else {
                throw new MatchError((Object)option);
            }
            return;
        }
    }

    public TransactionCoordinator(int brokerId, TransactionConfig txnConfig, Scheduler scheduler, ProducerIdManager producerIdManager, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time, LogContext logContext) {
        this.txnConfig = txnConfig;
        this.scheduler = scheduler;
        this.producerIdManager = producerIdManager;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(logContext.logPrefix());
        this.isActive = new AtomicBoolean(false);
    }

    public static final /* synthetic */ Object $anonfun$prepareInitProducerIdTransit$1$adapted(TransactionMetadata txnMetadata$2, ProducerIdAndEpoch producerIdAndEpoch) {
        return BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.isValidProducerId$1(producerIdAndEpoch, txnMetadata$2));
    }

    public static final /* synthetic */ Object $anonfun$prepareInitProducerIdTransit$2$adapted(TransactionMetadata txnMetadata$2, ProducerIdAndEpoch x$1) {
        return BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$prepareInitProducerIdTransit$2(txnMetadata$2, x$1));
    }

    public static final /* synthetic */ Object $anonfun$prepareInitProducerIdTransit$3$adapted(ProducerIdAndEpoch x$2) {
        return BoxesRunTime.boxToShort((short)x$2.epoch);
    }

    public static final /* synthetic */ Object $anonfun$endTransaction$12$adapted(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$4, Errors error$2, TxnTransitMetadata newMetadata$2, Option x0$2) {
        TransactionCoordinator.$anonfun$endTransaction$12($this, transactionalId$4, coordinatorEpoch$4, error$2, newMetadata$2, x0$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$abortTimedOutTransactions$2$adapted(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, Function1 onComplete$1, Option x0$1) {
        if (None$.MODULE$.equals(x0$1)) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch$2).toString());
        } else if (x0$1 instanceof Some) {
            TransactionMetadata $anonfun$abortTimedOutTransactions$2_txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
            Option $anonfun$abortTimedOutTransactions$2_transitMetadataOpt = (Option)$anonfun$abortTimedOutTransactions$2_txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                if (txnMetadata.producerId() != txnIdAndPidEpoch$2.producerId()) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch$2.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch$2.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                    return None$.MODULE$;
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch$2).append(" since there is a ").append("pending state transition").toString());
                    return None$.MODULE$;
                }
                return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
            });
            if ($anonfun$abortTimedOutTransactions$2_transitMetadataOpt == null) {
                throw null;
            }
            if (!$anonfun$abortTimedOutTransactions$2_transitMetadataOpt.isEmpty()) {
                TxnTransitMetadata txnTransitMetadata = (TxnTransitMetadata)$anonfun$abortTimedOutTransactions$2_transitMetadataOpt.get();
                $this.endTransaction($anonfun$abortTimedOutTransactions$2_txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete$1.apply((Object)txnIdAndPidEpoch$2)));
            }
        } else {
            throw new MatchError((Object)x0$1);
        }
        return BoxedUnit.UNIT;
    }
}

