/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.TxnMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArraySeq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005h\u0001\u0002\"D\u0001!CQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001A\u0002\u0013\u0005A\u000bC\u0004^\u0001\u0001\u0007I\u0011\u00010\t\r\u0011\u0004\u0001\u0015)\u0003V\u0011\u001d)\u0007\u00011A\u0005\u0002\u0019DqA\u001b\u0001A\u0002\u0013\u00051\u000e\u0003\u0004n\u0001\u0001\u0006Ka\u001a\u0005\b]\u0002\u0011\r\u0011\"\u0001p\u0011\u0019Y\b\u0001)A\u0005a\"9A\u0010\u0001b\u0001\n\u0003i\bbBA\u0002\u0001\u0001\u0006IA \u0005\n\u0003\u000b\u0001!\u0019!C\u0001\u0003\u000fA\u0001\"a\u0004\u0001A\u0003%\u0011\u0011\u0002\u0005\n\u0003#\u0001!\u0019!C\u0001\u0003'A\u0001\"!\t\u0001A\u0003%\u0011Q\u0003\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\t)\u0004\u0001C\u0001\u0003KAq!a\u0010\u0001\t\u0003\t)\u0003C\u0004\u0002J\u0001!\t!!\n\t\u000f\u00055\u0003\u0001\"\u0001\u0002&!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005\u0015\u0002bBA+\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003S\u0002A\u0011AA\u0013\u0011\u001d\ti\u0007\u0001C\u0001\u0003KAq!!\u001d\u0001\t\u0003\t)\u0003C\u0004\u0002v\u0001!\t!!\n\t\u000f\u0005e\u0004\u0001\"\u0001\u0002&!9\u0011Q\u0010\u0001\u0005\u0002\u0005\u0015\u0002bBAA\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003\u000b\u0003A\u0011AA\u0013\u0011\u001d\t\t\n\u0001C\u0001\u0003KAq!!&\u0001\t\u0003\t)\u0003C\u0004\u0002\u001a\u0002!\t!!\n\t\u000f\u0005u\u0005\u0001\"\u0001\u0002&!9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\u0015\u0002bBAS\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003S\u0003A\u0011AA\u0013\u0011\u001d\ti\u000b\u0001C\u0001\u0003KAq!!-\u0001\t\u0003\t)\u0003C\u0004\u00026\u0002!\t!!\n\t\u000f\u0005e\u0006\u0001\"\u0001\u0002&!9\u0011Q\u0018\u0001\u0005\u0002\u0005\u0015\u0002bBAa\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003\u000b\u0004A\u0011AA\u0013\u0011\u001d\tI\r\u0001C\u0001\u0003KAq!!4\u0001\t\u0003\t)\u0003C\u0004\u0002R\u0002!\t!!\n\t\u000f\u0005U\u0007\u0001\"\u0001\u0002&!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005\u0015\u0002bBAs\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003S\u0004A\u0011AA\u0013\u0011\u001d\t)\u0010\u0001C\u0001\u0003KAq!!?\u0001\t\u0003\t)\u0003C\u0004\u0002~\u0002!\t!!\n\t\u000f\t\u0005\u0001\u0001\"\u0001\u0002&!9!Q\u0001\u0001\u0005\n\t\u001d\u0001b\u0002B\u0012\u0001\u0011%!Q\u0005\u0005\n\u0005?\u0002\u0011\u0013!C\u0005\u0005CB\u0011Ba\u001e\u0001#\u0003%IA!\u001f\t\u000f\tu\u0004\u0001\"\u0003\u0003\u0000!I!1\u0015\u0001\u0012\u0002\u0013%!\u0011\u0010\u0005\n\u0005K\u0003\u0011\u0013!C\u0005\u0005OC\u0011Ba+\u0001#\u0003%IA!,\t\u000f\tu\u0004\u0001\"\u0003\u00032\"9!q\u0019\u0001\u0005\n\t%'\u0001\u0007)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'\u000fV3ti*\u0011A)R\u0001\u0004Y><'\"\u0001$\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0002\u0019\u0006)1oY1mC&\u0011aj\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\t\u0006C\u0001*\u0001\u001b\u0005\u0019\u0015A\u00027pO\u0012K'/F\u0001V!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0002j_*\t!,\u0001\u0003kCZ\f\u0017B\u0001/X\u0005\u00111\u0015\u000e\\3\u0002\u00151|w\rR5s?\u0012*\u0017\u000f\u0006\u0002`EB\u0011!\nY\u0005\u0003C.\u0013A!\u00168ji\"91mAA\u0001\u0002\u0004)\u0016a\u0001=%c\u00059An\\4ESJ\u0004\u0013\u0001D:uCR,W*\u00198bO\u0016\u0014X#A4\u0011\u0005IC\u0017BA5D\u0005Q\u0001&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\u0006\u00012\u000f^1uK6\u000bg.Y4fe~#S-\u001d\u000b\u0003?2Dqa\u0019\u0004\u0002\u0002\u0003\u0007q-A\u0007ti\u0006$X-T1oC\u001e,'\u000fI\u0001\na\u0006\u0014H/\u001b;j_:,\u0012\u0001\u001d\t\u0003cfl\u0011A\u001d\u0006\u0003gR\faaY8n[>t'B\u0001$v\u0015\t1x/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0006\u0019qN]4\n\u0005i\u0014(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u00039s_\u0012,8-\u001a:JIV\ta\u0010\u0005\u0002K\u007f&\u0019\u0011\u0011A&\u0003\t1{gnZ\u0001\faJ|G-^2fe&#\u0007%\u0001\nnCb\u0004\u0016\u000eZ#ya&\u0014\u0018\r^5p]6\u001bXCAA\u0005!\rQ\u00151B\u0005\u0004\u0003\u001bY%aA%oi\u0006\u0019R.\u0019=QS\u0012,\u0005\u0010]5sCRLwN\\'tA\u0005!A/[7f+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYB]\u0001\u0006kRLGn]\u0005\u0005\u0003?\tIB\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u0015\u0019X\r^+q)\u0005y\u0006f\u0001\t\u0002*A!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020]\fQA[;oSRLA!a\r\u0002.\t1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004#\u0005e\u0002\u0003BA\u0016\u0003wIA!!\u0010\u0002.\t)\u0011I\u001a;fe\u0006\u0011B/Z:u\u0005\u0006\u001c\u0018nY%e\u001b\u0006\u0004\b/\u001b8hQ\r\u0011\u00121\t\t\u0005\u0003W\t)%\u0003\u0003\u0002H\u00055\"\u0001\u0002+fgR\fa\u0005^3ti\u0006\u0003\b/\u001a8e)btW*\u0019:lKJ<\u0016\u000e\u001e5O_B\u0013x\u000eZ;dKJ\u001cF/\u0019;fQ\r\u0019\u00121I\u0001\u001fi\u0016\u001cH\u000f\u0015:pIV\u001cWM]*fcV,gnY3Xe\u0006\u0004\u0018I]8v]\u0012D3\u0001FA\"\u00035\"Xm\u001d;Qe>$WoY3s'\u0016\fX/\u001a8dK^KG\u000f[,sCB\f%o\\;oI\n\u000bGo\u00195SK\u000e|'\u000f\u001a\u0015\u0004+\u0005\r\u0013!\n;fgR\u0004&o\u001c3vG\u0016\u00148+Z9vK:\u001cW-\u00138wC2LGm\u0016:ba\u0006\u0013x.\u001e8eQ\u001d1\u00121IA-\u00037\n\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0003;\u0002B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003G\u0012\u0018AB3se>\u00148/\u0003\u0003\u0002h\u0005\u0005$aG(vi>3wJ\u001d3feN+\u0017/^3oG\u0016,\u0005pY3qi&|g.\u0001\u0016uKN$hj\u001c,bY&$\u0017\r^5p]>sg)\u001b:ti\u0016sGO]=XQ\u0016tGj\\1eS:<Gj\\4)\u0007]\t\u0019%A\u000euKN$8i\u001c8ue>d'+Z2pe\u0012\u0014U/\u001c9t\u000bB|7\r\u001b\u0015\u00041\u0005\r\u0013\u0001\t;fgR$\u0006P\u001c$jeN$xJ\u001a4tKRlU\r^1eCR\f7)Y2iK\u0012D3!GA\"\u0003\u0001\"Xm\u001d;MCN$8\u000b^1cY\u0016|eMZ:fi\u000e{W\u000e\u001d7fi\u0016$G\u000b\u001f8)\u0007i\t\u0019%\u0001\u0010uKN$\bK]3qCJ,W\u000b\u001d3bi\u0016$u.Z:O_RlU\u000f^1uK\"\u001a1$a\u0011\u0002=U\u0004H-\u0019;f!J|G-^2feR\u0013\u0018M\\:bGRLwN\\*uCR,\u0007f\u0001\u000f\u0002D\u0005aC/Z:u\u001fV$xJZ*fcV,gnY3BMR,'oQ8oiJ|GNU3d_J$W\t]8dQ\n+X\u000e\u001d\u0015\u0004;\u0005\r\u0013\u0001\r;fgRtuN\u001c+sC:\u001c\u0018m\u0019;j_:\fG.\u00119qK:$w+\u001b;i\u001f:<w.\u001b8h)J\fgn]1di&|g\u000eK\u0004\u001f\u0003\u0007\nI&!#$\u0005\u0005-\u0005\u0003BA0\u0003\u001bKA!a$\u0002b\tA\u0012J\u001c<bY&$G\u000b\u001f8Ti\u0006$X-\u0012=dKB$\u0018n\u001c8\u0002_Q,7\u000f\u001e+sk:\u001c\u0017\r^3B]\u0012\u0014V\r\\8bIJ+Wn\u001c<fg>+Ho\u00144SC:<Wm\u00158baNDw\u000e^:)\u0007}\t\u0019%\u0001\tuKN$H+Y6f':\f\u0007o\u001d5pi\"\u001a\u0001%a\u0011\u0002YQ,7\u000f\u001e*fG>4XM\u001d$s_6\u001cf.\u00199tQ>$XK\u001c4j]&\u001c\b.\u001a3Ue\u0006t7/Y2uS>t\u0007fA\u0011\u0002D\u0005QC/Z:u%\u0016\u001cwN^3s\rJ|Wn\u00158baNDw\u000e\u001e$j]&\u001c\b.\u001a3Ue\u0006t7/Y2uS>t\u0007f\u0001\u0012\u0002D\u00059C/Z:u%\u0016\u001cwN^3s\rJ|Wn\u00158baNDw\u000e^#naRLHK]1og\u0006\u001cG/[8oQ\r\u0019\u00131I\u0001)i\u0016\u001cH\u000f\u0015:pIV\u001cWM]*uCR,\u0017I\u001a;fe\u001a+gnY5oO\u0006\u0013wN\u001d;NCJ\\WM\u001d\u0015\u0004I\u0005\r\u0013!\b;fgR\u0014V-\\8wK\u0016C\b/\u001b:fIBKGm](o%\u0016dw.\u00193)\u0007\u0015\n\u0019%A\u0017uKN$\u0018iY2faR\f\u0005\u000f]3oI^KG\u000f[8viB\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001f:\u0014V\r\u001d7jG\u0006D3AJA\"\u0003%\"Xm\u001d;BG\u000e,\u0007\u000f^!qa\u0016tGmV5uQN+\u0017/^3oG\u0016<\u0015\r]:P]J+\u0007\u000f\\5dC\"\u001aq%a\u0011\u00023Q,7\u000f\u001e#fY\u0016$Xm\u00158baNDw\u000e^:CK\u001a|'/\u001a\u0015\u0004Q\u0005\r\u0013\u0001\u0004;fgR$&/\u001e8dCR,\u0007fA\u0015\u0002D\u00051C/Z:u\r&\u00148\u000f^+ogR\f'\r\\3PM\u001a\u001cX\r^!gi\u0016\u0014HK];oG\u0006$\u0018n\u001c8)\u0007)\n\u0019%\u0001\u0018uKN$Hj\\1e\rJ|Wn\u00158baNDw\u000e\u001e*fi\u0006Lgn\u001d(p]\u0016C\b/\u001b:fIB\u0013x\u000eZ;dKJ\u001c\bfA\u0016\u0002D\u0005\tC/Z:u'.L\u0007o\u00158baNDw\u000e^%g\u001f\u001a47/\u001a;V]\u000eD\u0017M\\4fI\"\u001aA&a\u0011\u00021Q,7\u000f\u001e)jI\u0016C\b/\u001b:bi&|g\u000eV5nK>,H\u000fK\u0002.\u0003\u0007\nq\u0003^3ti\u001aK'o\u001d;V]N$\u0018M\u00197f\u001f\u001a47/\u001a;)\u00079\n\u0019%\u0001\u0018uKN$\bK]8ek\u000e,'o],ji\"|enZ8j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8t\t>tG/\u0012=qSJ,\u0007fA\u0018\u0002D\u0005iC/Z:u'\u0016\fX/\u001a8dK:{GOV1mS\u0012\fG/\u001a3G_J<%o\\;q\u001b\u0016$\u0018\rZ1uCR{\u0007/[2)\u0007A\n\u0019%\u0001\u000fuKN$x\n\u001c3Fa>\u001c\u0007NR8s\u0007>tGO]8m%\u0016\u001cwN\u001d3)\u000fE\n\u0019%!\u0017\u0002^\u000e\u0012\u0011q\u001c\t\u0005\u0003?\n\t/\u0003\u0003\u0002d\u0006\u0005$!H%om\u0006d\u0017\u000e\u001a)s_\u0012,8-\u001a:Fa>\u001c\u0007.\u0012=dKB$\u0018n\u001c8\u0002-Q,7\u000f^\"p_J$\u0017N\\1u_J4UM\\2j]\u001eD3AMA\"\u0003\u0001\"Xm\u001d;D_>\u0014H-\u001b8bi>\u0014h)\u001a8dK\u0012\fe\r^3s%\u0016dw.\u00193)\u000fM\n\u0019%!\u0017\u0002n\u000e\u0012\u0011q\u001e\t\u0005\u0003?\n\t0\u0003\u0003\u0002t\u0006\u0005$!\n+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:GK:\u001cW\rZ#yG\u0016\u0004H/[8o\u0003u!Xm\u001d;M_\u0006$gI]8n\u000b6\u0004H/_*oCB\u001c\bn\u001c;GS2,\u0007f\u0001\u001b\u0002D\u0005\tC/Z:u\u0019>\fGM\u0012:p[R\u0013XO\\2bi\u0016$7K\\1qg\"|GOR5mK\"\u001aQ'a\u0011\u0002?Q,7\u000f\u001e'pC\u00124%o\\7D_J\u0014X\u000f\u001d;T]\u0006\u00048\u000f[8u\r&dW\rK\u00027\u0003\u0007\n1\u0004^3ti\u0006\u0003\b/\u001a8e\u000b6\u0004H/_\"p]R\u0014x\u000e\u001c\"bi\u000eD\u0007fA\u001c\u0002D\u0005YB/Z:u\u0019>\fGM\u0012:p[\u000e{'O];qiNs\u0017\r]:i_R$2a\u0018B\u0005\u0011\u001d\u0011Y\u0001\u000fa\u0001\u0005\u001b\tq\"\\1lK\u001aKG.Z\"peJ,\b\u000f\u001e\t\u0007\u0015\n=!1C0\n\u0007\tE1JA\u0005Gk:\u001cG/[8ocA!!Q\u0003B\u0010\u001b\t\u00119B\u0003\u0003\u0003\u001a\tm\u0011\u0001C2iC:tW\r\\:\u000b\u0007\tu\u0011,A\u0002oS>LAA!\t\u0003\u0018\tYa)\u001b7f\u0007\"\fgN\\3m\u0003I\t\u0007\u000f]3oI\u0016sG\r\u0016=o\u001b\u0006\u00148.\u001a:\u0015!\t\u001d\"1\u0007B\u001c\u0005s\u0011\u0019Ea\u0015\u0003X\tm\u0003C\u0002&\u0003*\t5b0C\u0002\u0003,-\u0013a\u0001V;qY\u0016\u0014\u0004c\u0001*\u00030%\u0019!\u0011G\"\u0003\u0019\r{W\u000e\u001d7fi\u0016$G\u000b\u001f8\t\r\tU\u0012\b1\u0001h\u0003\u001di\u0017\r\u001d9j]\u001eDQ\u0001`\u001dA\u0002yDqAa\u000f:\u0001\u0004\u0011i$A\u0007qe>$WoY3s\u000bB|7\r\u001b\t\u0004\u0015\n}\u0012b\u0001B!\u0017\n)1\u000b[8si\"9!QI\u001dA\u0002\t\u001d\u0013aC2p]R\u0014x\u000e\u001c+za\u0016\u0004BA!\u0013\u0003P5\u0011!1\n\u0006\u0004\u0005\u001b\u0012\u0018A\u0002:fG>\u0014H-\u0003\u0003\u0003R\t-#!E\"p]R\u0014x\u000e\u001c*fG>\u0014H\rV=qK\"1!QK\u001dA\u0002y\faa\u001c4gg\u0016$\b\"\u0003B-sA\u0005\t\u0019AA\u0005\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000e\u0003\u0005\u0003^e\u0002\n\u00111\u0001\u007f\u0003%!\u0018.\\3ti\u0006l\u0007/\u0001\u000fbaB,g\u000eZ#oIRCh.T1sW\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\t\r$\u0006BA\u0005\u0005KZ#Aa\u001a\u0011\t\t%$1O\u0007\u0003\u0005WRAA!\u001c\u0003p\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005cZ\u0015AC1o]>$\u0018\r^5p]&!!Q\u000fB6\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001dCB\u0004XM\u001c3F]\u0012$\u0006P\\'be.,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011YHK\u0002\u007f\u0005K\na!\u00199qK:$G#E0\u0003\u0002\n\r%Q\u0011BD\u0005\u0017\u0013iIa$\u0003\u001a\")Q\r\u0010a\u0001O\")A\u0010\u0010a\u0001}\"9!1\b\u001fA\u0002\tu\u0002b\u0002BEy\u0001\u0007\u0011\u0011B\u0001\u0004g\u0016\f\bB\u0002B+y\u0001\u0007a\u0010\u0003\u0005\u0003^q\u0002\n\u00111\u0001\u007f\u0011%\u0011\t\n\u0010I\u0001\u0002\u0004\u0011\u0019*A\bjgR\u0013\u0018M\\:bGRLwN\\1m!\rQ%QS\u0005\u0004\u0005/[%a\u0002\"p_2,\u0017M\u001c\u0005\n\u00057c\u0004\u0013!a\u0001\u0005;\u000baa\u001c:jO&t\u0007c\u0001*\u0003 &\u0019!\u0011U\"\u0003\u0019\u0005\u0003\b/\u001a8e\u001fJLw-\u001b8\u0002!\u0005\u0004\b/\u001a8eI\u0011,g-Y;mi\u00122\u0014\u0001E1qa\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011IK\u000b\u0003\u0003\u0014\n\u0015\u0014\u0001E1qa\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00139+\t\u0011yK\u000b\u0003\u0003\u001e\n\u0015D#D0\u00034\nU&q\u0017B]\u0005w\u0013)\rC\u0003f\u0001\u0002\u0007q\rC\u0003}\u0001\u0002\u0007a\u0010C\u0004\u0003<\u0001\u0003\rA!\u0010\t\r\tU\u0003\t1\u0001\u007f\u0011\u001d\u0011i\f\u0011a\u0001\u0005\u007f\u000bQAY1uG\"\u0004BA!\u0013\u0003B&!!1\u0019B&\u0005-\u0011VmY8sI\n\u000bGo\u00195\t\u000f\tm\u0005\t1\u0001\u0003\u001e\u000612-\u001e:sK:$8K\\1qg\"|Go\u00144gg\u0016$8/\u0006\u0002\u0003LB)!Q\u001aBn}:!!q\u001aBl!\r\u0011\tnS\u0007\u0003\u0005'T1A!6H\u0003\u0019a$o\\8u}%\u0019!\u0011\\&\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011iNa8\u0003\u0007M+GOC\u0002\u0003Z.\u0003")
public class ProducerStateManagerTest {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxPidExpirationMs;
    private final MockTime time = new MockTime();

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ProducerStateManager stateManager() {
        return this.stateManager;
    }

    public void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long producerId() {
        return this.producerId;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public MockTime time() {
        return this.time;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()));
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$), ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$), ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$), ClassTag$.MODULE$.apply(InvalidProducerEpochException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, 0, this.appendEndTxnMarker$default$7());
        Option option = this.stateManager().lastEntry(this.producerId());
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        }
        Object var4_2 = null;
        ProducerStateEntry firstEntry = (ProducerStateEntry)getOrElse_this.get();
        Assert.assertEquals((long)producerEpoch, (long)firstEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assert.assertEquals((long)-1L, (long)firstEntry.lastSeq());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$), ClassTag$.MODULE$.apply(InvalidProducerEpochException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$), ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Option option2 = this.stateManager().lastEntry(this.producerId());
        if (option2 == null) {
            throw null;
        }
        Option getOrElse_this2 = option2;
        if (getOrElse_this2.isEmpty()) {
            throw Assertions$.MODULE$.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        }
        Object var5_4 = null;
        ProducerStateEntry secondEntry = (ProducerStateEntry)getOrElse_this2.get();
        Assert.assertEquals((long)producerEpoch, (long)secondEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assert.assertEquals((long)0L, (long)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean bl = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, bl, (AppendOrigin)x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)0L, (long)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Replication$.MODULE$);
        appendInfo.appendDataBatch(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 2020L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0x7FFFFFF5L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)9L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)2000L, (long)lastEntry.firstDataOffset());
        Assert.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test(expected=OutOfOrderSequenceException.class)
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean bl = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, bl, (AppendOrigin)x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean bl = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, bl, (AppendOrigin)x$6);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)offset, (long)lastEntry.firstDataOffset());
    }

    @Test
    public void testControlRecordBumpsEpoch() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        short bumpedEpoch = (short)1;
        Tuple2<CompletedTxn, Object> tuple2 = this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        CompletedTxn completedTxn = (CompletedTxn)tuple2._1();
        long l = tuple2._2$mcJ$sp();
        Assert.assertEquals((long)1L, (long)completedTxn.firstOffset());
        Assert.assertEquals((long)1L, (long)completedTxn.lastOffset());
        Assert.assertEquals((long)2L, (long)l);
        Assert.assertTrue((boolean)completedTxn.isAborted());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)bumpedEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((long)-1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)-1L, (long)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedEpoch, 0, 2L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Option option = this.stateManager().lastEntry(this.producerId());
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((ProducerStateEntry)map_this.get()).firstSeq());
        None$ none$ = object;
        Object var7_8 = null;
        object = null;
        Assert.assertEquals((Object)new Some((Object)0), (Object)none$);
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assert.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Option option = this.stateManager().firstUnstableOffset();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((LogOffsetMetadata)map_this.get()).messageOffset());
        None$ none$ = object;
        Object var25_11 = null;
        object = null;
        Assert.assertEquals((Object)new Some((Object)startOffset2), (Object)none$);
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assert.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Option option2 = this.stateManager().firstUnstableOffset();
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        Object object2 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)((LogOffsetMetadata)map_this2.get()).messageOffset());
        None$ none$2 = object2;
        Object var27_15 = null;
        object2 = null;
        Assert.assertEquals((Object)new Some((Object)startOffset2), (Object)none$2);
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assert.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 20L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        nextAppendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 30L, false);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)16L), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        appendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)16L), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        CompletedTxn completedTxn = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assert.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assert.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assert.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)coordinatorEpoch, (long)lastEntry.coordinatorEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        AppendOrigin.Client$ client$;
        AppendOrigin.Client$ client$2;
        AppendOrigin.Client$ client$3;
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$4 = client$3 = AppendOrigin.Client$.MODULE$;
        client$3 = null;
        AppendOrigin.Client$ x$8 = client$4;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, (AppendOrigin)x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin.Client$ client$5 = client$2 = AppendOrigin.Client$.MODULE$;
        client$2 = null;
        AppendOrigin.Client$ x$16 = client$5;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, (AppendOrigin)x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            AppendOrigin.Client$ client$;
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            long x$23 = this.append$default$6();
            AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
            client$ = null;
            AppendOrigin.Client$ x$24 = client$2;
            this.append(x$17, x$18, bumpedEpoch, 2, 2L, x$23, true, (AppendOrigin)x$24);
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            AppendOrigin.Client$ client$;
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            long x$31 = this.append$default$6();
            AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
            client$ = null;
            AppendOrigin.Client$ x$32 = client$2;
            this.append(x$25, x$26, x$27, 2, 2L, x$31, true, (AppendOrigin)x$32);
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        long x$39 = this.append$default$6();
        AppendOrigin.Client$ client$6 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$40 = client$6;
        this.append(x$33, x$34, bumpedEpoch, 0, 0L, x$39, true, (AppendOrigin)x$40);
        Assert.assertEquals((long)bumpedEpoch, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test(expected=InvalidTxnStateException.class)
    public void testNonTransactionalAppendWithOngoingTransaction() {
        AppendOrigin.Client$ client$;
        AppendOrigin.Client$ client$2;
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$3 = client$2 = AppendOrigin.Client$.MODULE$;
        client$2 = null;
        AppendOrigin.Client$ x$8 = client$3;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, (AppendOrigin)x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin.Client$ client$4 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$16 = client$4;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, false, (AppendOrigin)x$16);
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)2L), (Object)this.stateManager().oldestSnapshotOffset());
        Assert.assertEquals((Object)new Some((Object)3L), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assert.assertEquals((String)"Directory doesn't contain a single file as expected", (long)1L, (long)this.logDir().list().length);
        Assert.assertTrue((String)"Snapshot file is empty", (((String)ArrayOps$.MODULE$.head$extension((Object)this.logDir().list())).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverFromSnapshotUnfinishedTransaction() {
        AppendOrigin.Client$ client$;
        AppendOrigin.Client$ client$2;
        AppendOrigin.Client$ client$3;
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$4 = client$3 = AppendOrigin.Client$.MODULE$;
        client$3 = null;
        AppendOrigin.Client$ x$8 = client$4;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, (AppendOrigin)x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin.Client$ client$5 = client$2 = AppendOrigin.Client$.MODULE$;
        client$2 = null;
        AppendOrigin.Client$ x$16 = client$5;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, (AppendOrigin)x$16);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assert.assertEquals((Object)new Some((Object)0), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
        long x$18 = this.producerId();
        long x$23 = this.append$default$6();
        AppendOrigin.Client$ client$6 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$24 = client$6;
        this.append(recoveredMapping, x$18, epoch, 2, 2L, x$23, true, (AppendOrigin)x$24);
    }

    @Test
    public void testRecoverFromSnapshotFinishedTransaction() {
        AppendOrigin.Client$ client$;
        AppendOrigin.Client$ client$2;
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$3 = client$2 = AppendOrigin.Client$.MODULE$;
        client$2 = null;
        AppendOrigin.Client$ x$8 = client$3;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, (AppendOrigin)x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin.Client$ client$4 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$16 = client$4;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, (AppendOrigin)x$16);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.ABORT, 2L, 0, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testRecoverFromSnapshotEmptyTransaction() {
        short epoch = (short)0;
        long appendTimestamp = this.time().milliseconds();
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int n = 0;
        this.appendEndTxnMarker(x$1, x$2, epoch, ControlRecordType.ABORT, 0L, n, appendTimestamp);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
        Option lastEntry = recoveredMapping.lastEntry(this.producerId());
        Assert.assertTrue((boolean)lastEntry.isDefined());
        Assert.assertEquals((long)appendTimestamp, (long)((ProducerStateEntry)lastEntry.get()).lastTimestamp());
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)lastEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testProducerStateAfterFencingAbortMarker() {
        AppendOrigin.Client$ client$;
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$8 = client$2;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, (AppendOrigin)x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)(epoch + 1), ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((long)-1L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)-1L, (long)lastEntry.firstDataOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assert.assertEquals((long)1L, (long)recoveredMapping.activeProducers().size());
        Assert.assertEquals((long)2L, (long)((ProducerStateEntry)((Tuple2)recoveredMapping.activeProducers().head())._2()).lastSeq());
        Assert.assertEquals((long)3L, (long)recoveredMapping.mapEndOffset());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assert.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)this.producerId()));
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$7 = AppendOrigin.Replication$.MODULE$;
        boolean bl = false;
        this.append(recoveredMapping, x$2, epoch, sequence, 2L, 70001L, bl, (AppendOrigin)x$7);
        Assert.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)this.producerId()));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)this.producerId())).head();
        Assert.assertEquals((long)epoch, (long)producerStateEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        int outOfOrderSequence = 3;
        try {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            AppendOrigin.Client$ x$7 = AppendOrigin.Client$.MODULE$;
            boolean bl = false;
            this.append(x$1, x$2, epoch, outOfOrderSequence, 1L, 1L, bl, (AppendOrigin)x$7);
            throw Assertions$.MODULE$.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        }
        catch (OutOfOrderSequenceException outOfOrderSequenceException) {
        }
        catch (Exception exception) {
            throw Assertions$.MODULE$.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 549));
        }
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)this.producerId())).lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        AppendOrigin.Replication$ x$15 = AppendOrigin.Replication$.MODULE$;
        boolean bl = false;
        this.append(x$9, x$10, epoch, outOfOrderSequence, 1L, 1L, bl, (AppendOrigin)x$15);
        Assert.assertEquals((long)outOfOrderSequence, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)this.producerId())).lastSeq());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteSnapshotsBefore() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems4), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems3), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (Seq)apply_elems2), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Set$ set$4 = Predef$.MODULE$.Set();
        Nil$ nil$ = Nil$.MODULE$;
        if (set$4 == null) {
            throw null;
        }
        nil$ = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$4, (Seq)apply_elems), this.currentSnapshotOffsets());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncate() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems4), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems3), this.currentSnapshotOffsets());
        this.stateManager().truncate();
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Set$ set$3 = Predef$.MODULE$.Set();
        Nil$ nil$ = Nil$.MODULE$;
        if (set$3 == null) {
            throw null;
        }
        nil$ = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (Seq)apply_elems2), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1});
        if (set$4 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$4, (Seq)apply_elems), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        AppendOrigin.Client$ client$;
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$8 = client$2;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, (AppendOrigin)x$8);
        Option option = this.stateManager().firstUnstableOffset();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((LogOffsetMetadata)map_this.get()).messageOffset());
        None$ none$ = object;
        Object var9_8 = null;
        object = null;
        Assert.assertEquals((Object)new Some((Object)99), (Object)none$);
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, 0, this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Option option2 = this.stateManager().firstUnstableOffset();
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        Object object2 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)((LogOffsetMetadata)map_this2.get()).messageOffset());
        None$ none$2 = object2;
        Object var11_10 = null;
        object2 = null;
        Assert.assertEquals((Object)None$.MODULE$, (Object)none$2);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Option option3 = this.stateManager().firstUnstableOffset();
        if (option3 == null) {
            throw null;
        }
        Option map_this3 = option3;
        Object object3 = map_this3.isEmpty() ? None$.MODULE$ : new Some((Object)((LogOffsetMetadata)map_this3.get()).messageOffset());
        None$ none$3 = object3;
        Object var13_12 = null;
        object3 = null;
        Assert.assertEquals((Object)None$.MODULE$, (Object)none$3);
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Option option4 = this.stateManager().firstUnstableOffset();
        if (option4 == null) {
            throw null;
        }
        Option map_this4 = option4;
        Object object4 = map_this4.isEmpty() ? None$.MODULE$ : new Some((Object)((LogOffsetMetadata)map_this4.get()).messageOffset());
        None$ none$4 = object4;
        Object var15_14 = null;
        object4 = null;
        Assert.assertEquals((Object)new Some((Object)99), (Object)none$4);
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        Option entry1 = this.stateManager().lastEntry(pid1);
        Assert.assertTrue((boolean)entry1.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastSeq());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Option entry2 = this.stateManager().lastEntry(pid2);
        Assert.assertTrue((boolean)entry2.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry2.get()).lastSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        void apply_elems;
        void apply_elems2;
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems2), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems), this.currentSnapshotOffsets());
    }

    @Test
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 2L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assert.assertEquals((long)1L, (long)this.stateManager().activeProducers().size());
        Assert.assertEquals((long)(sequence + 1), (long)((ProducerStateEntry)((Tuple2)this.stateManager().activeProducers().head())._2()).lastSeq());
        Assert.assertEquals((long)3L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testFirstUnstableOffset() {
        AppendOrigin.Client$ client$;
        AppendOrigin.Client$ client$2;
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$3 = client$2 = AppendOrigin.Client$.MODULE$;
        client$2 = null;
        AppendOrigin.Client$ x$8 = client$3;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, (AppendOrigin)x$8);
        Assert.assertEquals((Object)new Some((Object)99L), (Object)this.stateManager().firstUndecidedOffset());
        Option option = this.stateManager().firstUnstableOffset();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((LogOffsetMetadata)map_this.get()).messageOffset());
        None$ none$ = object;
        Object var15_8 = null;
        object = null;
        Assert.assertEquals((Object)new Some((Object)99L), (Object)none$);
        long anotherPid = 2L;
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin.Client$ client$4 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$16 = client$4;
        this.append(x$9, anotherPid, epoch, sequence, 105L, x$15, true, (AppendOrigin)x$16);
        Assert.assertEquals((Object)new Some((Object)99L), (Object)this.stateManager().firstUndecidedOffset());
        Option option2 = this.stateManager().firstUnstableOffset();
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        Object object2 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)((LogOffsetMetadata)map_this2.get()).messageOffset());
        None$ none$2 = object2;
        Object var17_15 = null;
        object2 = null;
        Assert.assertEquals((Object)new Some((Object)99L), (Object)none$2);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, 0, this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)new Some((Object)105L), (Object)this.stateManager().firstUndecidedOffset());
        Option option3 = this.stateManager().firstUnstableOffset();
        if (option3 == null) {
            throw null;
        }
        Option map_this3 = option3;
        Object object3 = map_this3.isEmpty() ? None$.MODULE$ : new Some((Object)((LogOffsetMetadata)map_this3.get()).messageOffset());
        None$ none$3 = object3;
        Object var19_17 = null;
        object3 = null;
        Assert.assertEquals((Object)new Some((Object)99L), (Object)none$3);
        this.stateManager().onHighWatermarkUpdated(100L);
        Option option4 = this.stateManager().firstUnstableOffset();
        if (option4 == null) {
            throw null;
        }
        Option map_this4 = option4;
        Object object4 = map_this4.isEmpty() ? None$.MODULE$ : new Some((Object)((LogOffsetMetadata)map_this4.get()).messageOffset());
        None$ none$4 = object4;
        Object var21_19 = null;
        object4 = null;
        Assert.assertEquals((Object)new Some((Object)99L), (Object)none$4);
        this.stateManager().onHighWatermarkUpdated(110L);
        Option option5 = this.stateManager().firstUnstableOffset();
        if (option5 == null) {
            throw null;
        }
        Option map_this5 = option5;
        Object object5 = map_this5.isEmpty() ? None$.MODULE$ : new Some((Object)((LogOffsetMetadata)map_this5.get()).messageOffset());
        None$ none$5 = object5;
        Object var23_21 = null;
        object5 = null;
        Assert.assertEquals((Object)new Some((Object)105L), (Object)none$5);
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, 0, this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Option option6 = this.stateManager().firstUnstableOffset();
        if (option6 == null) {
            throw null;
        }
        Option map_this6 = option6;
        Object object6 = map_this6.isEmpty() ? None$.MODULE$ : new Some((Object)((LogOffsetMetadata)map_this6.get()).messageOffset());
        None$ none$6 = object6;
        Object var25_23 = null;
        object6 = null;
        Assert.assertEquals((Object)new Some((Object)105L), (Object)none$6);
        this.stateManager().onHighWatermarkUpdated(113L);
        Option option7 = this.stateManager().firstUnstableOffset();
        if (option7 == null) {
            throw null;
        }
        Option map_this7 = option7;
        Object object7 = map_this7.isEmpty() ? None$.MODULE$ : new Some((Object)((LogOffsetMetadata)map_this7.get()).messageOffset());
        None$ none$7 = object7;
        Object var27_25 = null;
        object7 = null;
        Assert.assertEquals((Object)None$.MODULE$, (Object)none$7);
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        AppendOrigin.Client$ client$;
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$8 = client$2;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, (AppendOrigin)x$8);
        Assert.assertEquals((Object)new Some((Object)99L), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assert.assertEquals((Object)new Some((Object)99L), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxPidExpirationMs());
        short epoch = (short)0;
        long x$2 = this.producerId();
        AppendOrigin.Coordinator$ x$7 = AppendOrigin.Coordinator$.MODULE$;
        long x$8 = this.append$default$6();
        this.append(stateManager, x$2, epoch, -1, 99L, x$8, true, (AppendOrigin)x$7);
        long x$10 = this.producerId();
        AppendOrigin.Coordinator$ x$15 = AppendOrigin.Coordinator$.MODULE$;
        long x$16 = this.append$default$6();
        this.append(stateManager, x$10, epoch, -1, 100L, x$16, true, (AppendOrigin)x$15);
    }

    @Test(expected=InvalidProducerEpochException.class)
    public void testOldEpochForControlRecord() {
        AppendOrigin.Client$ client$;
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$8 = client$2;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, (AppendOrigin)x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testCoordinatorFencing() {
        AppendOrigin.Client$ client$;
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$8 = client$2;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, (AppendOrigin)x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        if (lastEntry == null) {
            throw null;
        }
        Object object = lastEntry.isEmpty() ? None$.MODULE$ : new Some((Object)((ProducerStateEntry)lastEntry.get()).coordinatorEpoch());
        None$ none$ = object;
        object = null;
        Assert.assertEquals((Object)new Some((Object)1), (Object)none$);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        try {
            this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7());
            throw Assertions$.MODULE$.fail("Expected coordinator to be fenced", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 776));
        }
        catch (TransactionCoordinatorFencedException transactionCoordinatorFencedException) {
            return;
        }
    }

    @Test(expected=TransactionCoordinatorFencedException.class)
    public void testCoordinatorFencedAfterReload() {
        AppendOrigin.Client$ client$;
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$8 = client$2;
        this.append(x$1, x$2, producerEpoch, 0, 99L, x$7, true, (AppendOrigin)x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()).truncateAndReload(0L, 2L, 70000L);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            testLoadFromCorruptSnapshot_channel.truncate(0L);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)testLoadFromCorruptSnapshot_producerId);
        Assert.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)testLoadFromCorruptSnapshot_producerId);
        Assert.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)testLoadFromCorruptSnapshot_producerId);
        Assert.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        short producerEpoch = (short)145;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)EasyMock.createMock(RecordBatch.class);
        EasyMock.expect((Object)batch.isControlBatch()).andReturn((Object)true).once();
        EasyMock.expect((Object)batch.iterator()).andReturn(Collections.emptyIterator()).once();
        EasyMock.replay((Object[])new Object[]{batch});
        this.append(this.stateManager(), producerId, producerEpoch, baseOffset, batch, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)2L), (Object)latestSnapshotOffset);
        File snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)producerId);
        Assert.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Tuple2<CompletedTxn, Object> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        CompletedTxn completedTxn = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        long lastStableOffset = mapping.lastStableOffset(completedTxn);
        mapping.completeTxn(completedTxn);
        mapping.updateMapEndOffset(offset + 1L);
        return new Tuple2((Object)completedTxn, (Object)lastStableOffset);
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, long offset, RecordBatch batch, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.append(batch, (Option)None$.MODULE$);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private AppendOrigin append$default$8() {
        return AppendOrigin.Client$.MODULE$;
    }

    private Set<Object> currentSnapshotOffsets() {
        Object var2_5;
        long[] lArray;
        long[] lArray2;
        File[] map$extension_$this = this.logDir().listFiles();
        int n = map$extension_$this.length;
        long[] lArray3 = lArray2 = new long[n];
        lArray2 = null;
        long[] lArray4 = lArray = lArray3;
        lArray = null;
        long[] map$extension_ys = lArray4;
        if (n > 0) {
            for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                long l;
                File file = map$extension_$this[map$extension_i];
                map$extension_ys[map$extension_i] = l = Log$.MODULE$.offsetFromFile(file);
            }
        }
        void v2 = var2_5;
        Object var1_1 = null;
        var2_5 = null;
        ArraySeq.ofLong ofLong2 = Predef$.MODULE$.wrapLongArray((long[])v2);
        if (ofLong2 == null) {
            throw null;
        }
        return IterableOnceOps.toSet$((IterableOnceOps)ofLong2);
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$2) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry$.MODULE$.empty(producerId), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.appendDataBatch(producerEpoch$2, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{37}), (ClassTag)ClassTag$.MODULE$.Byte())), file.size() / 2L);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxPidExpirationMs = 60000;
    }

    public static final /* synthetic */ Object $anonfun$testControlRecordBumpsEpoch$1$adapted(ProducerStateEntry x$2) {
        return BoxesRunTime.boxToInteger((int)x$2.firstSeq());
    }

    public static final /* synthetic */ Object $anonfun$testLastStableOffsetCompletedTxn$1$adapted(LogOffsetMetadata x$3) {
        return BoxesRunTime.boxToLong((long)x$3.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testLastStableOffsetCompletedTxn$2$adapted(LogOffsetMetadata x$4) {
        return BoxesRunTime.boxToLong((long)x$4.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffsetAfterTruncation$1$adapted(LogOffsetMetadata x$5) {
        return BoxesRunTime.boxToLong((long)x$5.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffsetAfterTruncation$2$adapted(LogOffsetMetadata x$6) {
        return BoxesRunTime.boxToLong((long)x$6.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffsetAfterTruncation$3$adapted(LogOffsetMetadata x$7) {
        return BoxesRunTime.boxToLong((long)x$7.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffsetAfterTruncation$4$adapted(LogOffsetMetadata x$8) {
        return BoxesRunTime.boxToLong((long)x$8.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffset$1$adapted(LogOffsetMetadata x$9) {
        return BoxesRunTime.boxToLong((long)x$9.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffset$2$adapted(LogOffsetMetadata x$10) {
        return BoxesRunTime.boxToLong((long)x$10.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffset$3$adapted(LogOffsetMetadata x$11) {
        return BoxesRunTime.boxToLong((long)x$11.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffset$4$adapted(LogOffsetMetadata x$12) {
        return BoxesRunTime.boxToLong((long)x$12.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffset$5$adapted(LogOffsetMetadata x$13) {
        return BoxesRunTime.boxToLong((long)x$13.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffset$6$adapted(LogOffsetMetadata x$14) {
        return BoxesRunTime.boxToLong((long)x$14.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffset$7$adapted(LogOffsetMetadata x$15) {
        return BoxesRunTime.boxToLong((long)x$15.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testCoordinatorFencing$1$adapted(ProducerStateEntry x$16) {
        return BoxesRunTime.boxToInteger((int)x$16.coordinatorEpoch());
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromEmptySnapshotFile$1$adapted(FileChannel file) {
        file.truncate(0L);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromTruncatedSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromCorruptSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$currentSnapshotOffsets$1$adapted(File file) {
        return BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file));
    }
}

