/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.server.AdminManager;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005-4A!\u0005\n\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0013\u0019\u0003B\u0002\u0016\u0001A\u0003%A\u0005C\u0004,\u0001\t\u0007I\u0011\u0002\u0017\t\re\u0002\u0001\u0015!\u0003.\u0011\u001dQ\u0004A1A\u0005\nmBaa\u0010\u0001!\u0002\u0013a\u0004b\u0002!\u0001\u0005\u0004%I!\u0011\u0005\u0007\u0015\u0002\u0001\u000b\u0011\u0002\"\t\u000f-\u0003!\u0019!C\u0005\u0019\"1\u0001\u000b\u0001Q\u0001\n5CQ!\u0015\u0001\u0005\u0002ICQ!\u0018\u0001\u0005\u0002yCQA\u0019\u0001\u0005\u0002ICQa\u001a\u0001\u0005\u0002ICQ!\u001b\u0001\u0005\u0002I\u0013\u0001#\u00113nS:l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005M!\u0012AB:feZ,'OC\u0001\u0016\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\t!#\u0001\u0005{W\u000ec\u0017.\u001a8u+\u0005!\u0003CA\u0013)\u001b\u00051#BA\u0014\u0015\u0003\tQ8.\u0003\u0002*M\ti1*\u00194lCj[7\t\\5f]R\f\u0011B_6DY&,g\u000e\u001e\u0011\u0002\u000f5,GO]5dgV\tQ\u0006\u0005\u0002/o5\tqF\u0003\u0002,a)\u0011\u0011GM\u0001\u0007G>lWn\u001c8\u000b\u0005U\u0019$B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001eL!\u0001O\u0018\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0005ce>\\WM]%e+\u0005a\u0004CA\r>\u0013\tq$DA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u000bQ|\u0007/[2\u0016\u0003\t\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\t1\fgn\u001a\u0006\u0002\u000f\u0006!!.\u0019<b\u0013\tIEI\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\u0005i\u0005CA\u0011O\u0013\ty%CA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003!!X-\u0019:E_^tG#A*\u0011\u0005e!\u0016BA+\u001b\u0005\u0011)f.\u001b;)\u000519\u0006C\u0001-\\\u001b\u0005I&B\u0001.6\u0003\u0015QWO\\5u\u0013\ta\u0016LA\u0003BMR,'/\u0001\nde\u0016\fG/Z!e[&tW*\u00198bO\u0016\u0014H#A0\u0011\u0005\u0005\u0002\u0017BA1\u0013\u00051\tE-\\5o\u001b\u0006t\u0017mZ3s\u00031\"Xm\u001d;EKN\u001c'/\u001b2f\u0007>tg-[4t/&$\bNT;mY\u000e{gNZ5hkJ\fG/[8o\u0017\u0016L8\u000f\u000b\u0002\u000fIB\u0011\u0001,Z\u0005\u0003Mf\u0013A\u0001V3ti\u0006iC/Z:u\t\u0016\u001c8M]5cK\u000e{gNZ5hg^KG\u000f[#naRL8i\u001c8gS\u001e,(/\u0019;j_:\\U-_:)\u0005=!\u0017\u0001\n;fgR$Um]2sS\n,7i\u001c8gS\u001e\u001cx+\u001b;i\t>\u001cW/\\3oi\u0006$\u0018n\u001c8)\u0005A!\u0007")
public class AdminManagerTest {
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private final String topic;
    private final MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private String topic() {
        return this.topic;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    public AdminManager createAdminManager() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        return new AdminManager(KafkaConfig$.MODULE$.fromProps(props), this.metrics(), this.metadataCache(), this.zkClient());
    }

    @Test
    public void testDescribeConfigsWithNullConfigurationKeys() {
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).andReturn((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        EasyMock.expect((Object)this.metadataCache().contains(this.topic())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.zkClient(), this.metadataCache()});
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()).setConfigurationKeys(null), (List)Nil$.MODULE$);
        List results = this.createAdminManager().describeConfigs((List)resources, true, true);
        Assert.assertEquals((long)Errors.NONE.code(), (long)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).errorCode());
        Assert.assertFalse((String)"Should return configs", (boolean)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).configs().isEmpty());
    }

    @Test
    public void testDescribeConfigsWithEmptyConfigurationKeys() {
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).andReturn((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        EasyMock.expect((Object)this.metadataCache().contains(this.topic())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.zkClient(), this.metadataCache()});
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()), (List)Nil$.MODULE$);
        List results = this.createAdminManager().describeConfigs((List)resources, true, true);
        Assert.assertEquals((long)Errors.NONE.code(), (long)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).errorCode());
        Assert.assertFalse((String)"Should return configs", (boolean)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).configs().isEmpty());
    }

    @Test
    public void testDescribeConfigsWithDocumentation() {
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).andReturn((Object)new Properties());
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Broker(), ((Object)this.brokerId()).toString())).andReturn((Object)new Properties());
        EasyMock.expect((Object)this.metadataCache().contains(this.topic())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.zkClient(), this.metadataCache()});
        AdminManager adminManager = this.createAdminManager();
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()), (List)new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(((Object)this.brokerId()).toString()).setResourceType(ConfigResource.Type.BROKER.id()), (List)Nil$.MODULE$));
        List results = adminManager.describeConfigs((List)resources, true, true);
        if (results == null) {
            throw null;
        }
        Assert.assertEquals((long)2L, (long)SeqOps.size$((SeqOps)results));
        List foreach_these = results;
        while (!foreach_these.isEmpty()) {
            AdminManagerTest.$anonfun$testDescribeConfigsWithDocumentation$1((DescribeConfigsResponseData.DescribeConfigsResult)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
    }

    public static final /* synthetic */ void $anonfun$testDescribeConfigsWithDocumentation$1(DescribeConfigsResponseData.DescribeConfigsResult r) {
        Assert.assertEquals((long)Errors.NONE.code(), (long)r.errorCode());
        Assert.assertFalse((String)"Should return configs", (boolean)r.configs().isEmpty());
        r.configs().forEach(c -> {
            Assert.assertNotNull((String)new StringBuilder(42).append("Config ").append(c.name()).append(" should have non null documentation").toString(), (Object)c.documentation());
            Assert.assertNotEquals((String)new StringBuilder(43).append("Config ").append(c.name()).append(" should have non blank documentation").toString(), (Object)"", (Object)c.documentation().trim());
        });
    }

    public AdminManagerTest() {
        this.brokerId = 1;
        this.topic = "topic-1";
    }

    public static final /* synthetic */ Object $anonfun$testDescribeConfigsWithDocumentation$1$adapted(DescribeConfigsResponseData.DescribeConfigsResult r) {
        AdminManagerTest.$anonfun$testDescribeConfigsWithDocumentation$1(r);
        return BoxedUnit.UNIT;
    }
}

