/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.AbstractPartitionTest;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.OngoingReassignmentState;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.PartitionStateStore;
import kafka.cluster.PendingShrinkIsr;
import kafka.cluster.Replica;
import kafka.cluster.SimpleAssignmentState;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.AppendOrigin;
import kafka.log.ClientRecordDeletion$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogReadInfo;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.OffsetNotAvailableException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Queue;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\tUc\u0001\u0002\u001d:\u0001yBQa\u0011\u0001\u0005\u0002\u0011CQA\u0012\u0001\u0005\u0002\u001dCQa\u0016\u0001\u0005\u0002\u001dCQ!\u0017\u0001\u0005\u0002\u001dCQa\u0017\u0001\u0005\u0002\u001dCQ!\u0018\u0001\u0005\u0002\u001dCQa\u0018\u0001\u0005\u0002\u001dCQ!\u0019\u0001\u0005\u0002\u001dCQa\u0019\u0001\u0005\u0002\u001dCQ!\u001a\u0001\u0005\u0002\u001dCQa\u001a\u0001\u0005\u0002\u001dCQ!\u001b\u0001\u0005\u0002\u001dCQa\u001b\u0001\u0005\u0002\u001dCQ!\u001c\u0001\u0005\u0002\u001dCQa\u001c\u0001\u0005\u0002\u001dCQ!\u001d\u0001\u0005\u0002\u001dCQa\u001d\u0001\u0005\u0002\u001dCQ!\u001e\u0001\u0005\nYD\u0011\"a\u0006\u0001#\u0003%I!!\u0007\t\r\u0005=\u0002\u0001\"\u0001H\u0011\u0019\t\u0019\u0004\u0001C\u0001\u000f\"1\u0011q\u0007\u0001\u0005\u0002\u001dCa!a\u000f\u0001\t\u00039\u0005BBA \u0001\u0011\u0005q\t\u0003\u0004\u0002D\u0001!\ta\u0012\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011%\t\t\nAI\u0001\n\u0003\t\u0019\nC\u0004\u0002\u0018\u0002!\t!!'\t\r\u0005}\u0005\u0001\"\u0001H\u0011\u0019\t\u0019\u000b\u0001C\u0001\u000f\"1\u0011q\u0015\u0001\u0005\u0002\u001dCa!a+\u0001\t\u00039\u0005BBAX\u0001\u0011\u0005q\t\u0003\u0004\u00024\u0002!\ta\u0012\u0005\u0007\u0003o\u0003A\u0011A$\t\r\u0005m\u0006\u0001\"\u0001H\u0011\u0019\ty\f\u0001C\u0001\u000f\"1\u00111\u0019\u0001\u0005\u0002\u001dCa!a2\u0001\t\u00039\u0005bBAf\u0001\u0011\u0005\u0011Q\u001a\u0005\u0007\u0003S\u0004A\u0011A$\t\r\u00055\b\u0001\"\u0001H\u0011\u0019\t\t\u0010\u0001C\u0001\u000f\"1\u0011Q\u001f\u0001\u0005\u0002\u001dCa!!?\u0001\t\u00039\u0005BBA\u007f\u0001\u0011\u0005q\t\u0003\u0004\u0003\u0002\u0001!\ta\u0012\u0005\u0007\u0005\u000b\u0001A\u0011A$\t\u000f\t%\u0001\u0001\"\u0003\u0003\f\u00191!Q\u0003\u0001\u0005\u0005/A!\"a\u00033\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011)\u0011IB\rB\u0001B\u0003%!1\u0004\u0005\u000b\u0005O\u0011$\u0011!Q\u0001\n\t%\u0002BB\"3\t\u0003\u0011i\u0004C\u0004\u0003JI\"\tEa\u0013\u0003\u001bA\u000b'\u000f^5uS>tG+Z:u\u0015\tQ4(A\u0004dYV\u001cH/\u001a:\u000b\u0003q\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u007fA\u0011\u0001)Q\u0007\u0002s%\u0011!)\u000f\u0002\u0016\u0003\n\u001cHO]1diB\u000b'\u000f^5uS>tG+Z:u\u0003\u0019a\u0014N\\5u}Q\tQ\t\u0005\u0002A\u0001\u0005yB/Z:u\u0019\u0006\u001cHOR3uG\",Gm\u00144gg\u0016$h+\u00197jI\u0006$\u0018n\u001c8\u0015\u0003!\u0003\"!\u0013'\u000e\u0003)S\u0011aS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b*\u0013A!\u00168ji\"\u0012!a\u0014\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000bQA[;oSRT\u0011\u0001V\u0001\u0004_J<\u0017B\u0001,R\u0005\u0011!Vm\u001d;\u0002?Q,7\u000f^'bW\u0016dU-\u00193feV\u0003H-\u0019;fg\u0016\u0003xn\u00195DC\u000eDW\r\u000b\u0002\u0004\u001f\u0006\u0011D/Z:u\u001b\u0006\\W\rT3bI\u0016\u0014Hi\\3t\u001d>$X\u000b\u001d3bi\u0016,\u0005o\\2i\u0007\u0006\u001c\u0007.\u001a$pe>cGMR8s[\u0006$8\u000f\u000b\u0002\u0005\u001f\u0006AC/Z:u\u001b\u0006L(-\u001a*fa2\f7-Z\"veJ,g\u000e^,ji\"4U\u000f^;sKJ+\u0007\u000f\\5dC\"\u0012QaT\u0001.i\u0016\u001cH/T1lK\u001a{G\u000e\\8xKJ<\u0016\u000e\u001e5XSRDgi\u001c7m_^,'/\u00119qK:$'+Z2pe\u0012\u001c\bF\u0001\u0004P\u0003q\"Xm\u001d;NCf\u0014WMU3qY\u0006\u001cWmQ;se\u0016tGoV5uQ\u001a+H/\u001e:f%\u0016\u0004H.[2b\t&4g-\u001a:f]R\u0014\u0015m]3PM\u001a\u001cX\r^:)\u0005\u001dy\u0015a\f;fgR4U\r^2i\u001f\u001a47/\u001a;T]\u0006\u00048\u000f[8u\u000bB|7\r\u001b,bY&$\u0017\r^5p]\u001a{'\u000fT3bI\u0016\u0014\bF\u0001\u0005P\u0003E\"Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$8K\\1qg\"|G/\u00129pG\"4\u0016\r\\5eCRLwN\u001c$pe\u001a{G\u000e\\8xKJD#!C(\u0002WQ,7\u000f^(gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014H*Z1eKJD#AC(\u0002[Q,7\u000f^(gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014hi\u001c7m_^,'\u000f\u000b\u0002\f\u001f\u00061C/Z:u%\u0016\fGMU3d_J$W\t]8dQZ\u000bG.\u001b3bi&|gNR8s\u0019\u0016\fG-\u001a:)\u00051y\u0015\u0001\u000b;fgR\u0014V-\u00193SK\u000e|'\u000fZ#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_J4u\u000e\u001c7po\u0016\u0014\bFA\u0007P\u0003M\"Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$hi\u001c:US6,7\u000f^1na\u0016\u0003xn\u00195WC2LG-\u0019;j_:4uN\u001d'fC\u0012,'\u000f\u000b\u0002\u000f\u001f\u0006)D/Z:u\r\u0016$8\r[(gMN,GOR8s)&lWm\u001d;b[B,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:G_2dwn^3sQ\tyq*\u0001\u0015uKN$h)\u001a;dQ2\u000bG/Z:u\u001f\u001a47/\u001a;J]\u000edW\u000fZ3t\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u000b\u0002\u0011\u001f\u0006)C/Z:u\u001b>tw\u000e^8oS\u000e|eMZ:fiN\fe\r^3s\u0019\u0016\fG-\u001a:DQ\u0006tw-\u001a\u0015\u0003#=\u000bqc]3ukB\u0004\u0016M\u001d;ji&|gnV5uQ6{7m[:\u0015\u000b]Tx0!\u0003\u0011\u0005\u0001C\u0018BA=:\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0003|%\u0001\u0007A0A\u0006mK\u0006$WM]#q_\u000eD\u0007CA%~\u0013\tq(JA\u0002J]RDq!!\u0001\u0013\u0001\u0004\t\u0019!\u0001\u0005jg2+\u0017\rZ3s!\rI\u0015QA\u0005\u0004\u0003\u000fQ%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0017\u0011\u0002\u0013!a\u0001\u0003\u001b\t1\u0001\\8h!\u0011\ty!a\u0005\u000e\u0005\u0005E!bAA\u0006w%!\u0011QCA\t\u0005\raunZ\u0001\"g\u0016$X\u000f\u001d)beRLG/[8o/&$\b.T8dWN$C-\u001a4bk2$HeM\u000b\u0003\u00037QC!!\u0004\u0002\u001e-\u0012\u0011q\u0004\t\u0005\u0003C\tY#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003%)hn\u00195fG.,GMC\u0002\u0002*)\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ti#a\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0018uKN$\u0018\t\u001d9f]\u0012\u0014VmY8sIN\f5OR8mY><XM\u001d\"fY><Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bF\u0001\u000bP\u0003u!Xm\u001d;MSN$xJ\u001a4tKRL5o\u001c7bi&|g\u000eT3wK2\u001c\bFA\u000bP\u00039!Xm\u001d;HKR\u0014V\r\u001d7jG\u0006D#AF(\u0002oQ,7\u000f^!qa\u0016tGMU3d_J$7\u000fV8G_2dwn^3s/&$\bNT8SKBd\u0017nY1UQJ|wo]#yG\u0016\u0004H/[8oQ\t9r*\u0001\u0013uKN$X*Y6f\r>dGn\\<fe^KG\u000f\u001b(p\u0019\u0016\fG-\u001a:JI\u000eC\u0017M\\4fQ\tAr*A$uKN$hi\u001c7m_^,'\u000fR8fg:{GOS8j]&\u001b&+\u00168uS2\u001c\u0015-^4iiV\u0003Hk\\(gMN,GoV5uQ&t7)\u001e:sK:$H*Z1eKJ,\u0005o\\2iQ\tIr*A\u0007de\u0016\fG/\u001a*fG>\u0014Hm\u001d\u000b\t\u0003\u0017\n\t'a!\u0002\u000eB!\u0011QJA/\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013A\u0002:fG>\u0014HM\u0003\u0003\u0002V\u0005]\u0013AB2p[6|gNC\u0002=\u00033R1!a\u0017T\u0003\u0019\t\u0007/Y2iK&!\u0011qLA(\u00055iU-\\8ssJ+7m\u001c:eg\"9\u00111\r\u000eA\u0002\u0005\u0015\u0014a\u0002:fG>\u0014Hm\u001d\t\u0007\u0003O\n9(! \u000f\t\u0005%\u00141\u000f\b\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011qN\u001f\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0015bAA;\u0015\u00069\u0001/Y2lC\u001e,\u0017\u0002BA=\u0003w\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003kR\u0005\u0003BA'\u0003\u007fJA!!!\u0002P\ta1+[7qY\u0016\u0014VmY8sI\"9\u0011Q\u0011\u000eA\u0002\u0005\u001d\u0015A\u00032bg\u0016|eMZ:fiB\u0019\u0011*!#\n\u0007\u0005-%J\u0001\u0003M_:<\u0007\u0002CAH5A\u0005\t\u0019\u0001?\u0002)A\f'\u000f^5uS>tG*Z1eKJ,\u0005o\\2i\u0003]\u0019'/Z1uKJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0016*\u001aA0!\b\u00025\r\u0014X-\u0019;f)J\fgn]1di&|g.\u00197SK\u000e|'\u000fZ:\u0015\r\u0005-\u00131TAO\u0011\u001d\t\u0019\u0007\ba\u0001\u0003KBq!!\"\u001d\u0001\u0004\t9)\u0001\u0007uKN$\u0018\t^'j]&\u001b(\u000f\u000b\u0002\u001e\u001f\u0006aB/Z:u+B$\u0017\r^3G_2dwn^3s\r\u0016$8\r[*uCR,\u0007F\u0001\u0010P\u0003A!Xm\u001d;JgJ,\u0005\u0010]1og&|g\u000e\u000b\u0002 \u001f\u0006yB/Z:u\u0013N\u0014hj\u001c;FqB\fg\u000eZ3e\u0013\u001a,\u0006\u000fZ1uK\u001a\u000b\u0017\u000e\\:)\u0005\u0001z\u0015A\u0005;fgRl\u0015-\u001f2f'\"\u0014\u0018N\\6JgJD#!I(\u0002_Q,7\u000f^*i_VdGMT8u'\"\u0014\u0018N\\6JgJLe\r\u0015:fm&|Wo\u001d$fi\u000eD\u0017j]\"bk\u001eDG/\u00169)\u0005\tz\u0015\u0001\r;fgR\u001c\u0006n\\;mI:{Go\u00155sS:\\\u0017j\u001d:JM\u001a{G\u000e\\8xKJ\u001c\u0015-^4iiV\u0003Hk\u001c'pO\u0016sG\r\u000b\u0002$\u001f\u0006iB/Z:u\u0013N\u0014hj\u001c;TQJ,hn[%g+B$\u0017\r^3GC&d7\u000f\u000b\u0002%\u001f\u0006AB/Z:u\u00032$XM]%teVs7N\\8x]R{\u0007/[2)\u0005\u0015z\u0015A\u0007;fgR\fE\u000e^3s\u0013N\u0014\u0018J\u001c<bY&$g+\u001a:tS>t\u0007F\u0001\u0014P\u0003m!Xm\u001d;BYR,'/S:s+:,\u0007\u0010]3di\u0016$WI\u001d:pe\"\u0012qeT\u0001\u0016Q\u0006tG\r\\3BYR,'/S:s\r\u0006LG.\u001e:f)\u0015A\u0015qZAp\u0011\u001d\t\t\u000e\u000ba\u0001\u0003'\fQ!\u001a:s_J\u0004B!!6\u0002\\6\u0011\u0011q\u001b\u0006\u0005\u00033\f\u0019&\u0001\u0005qe>$xnY8m\u0013\u0011\ti.a6\u0003\r\u0015\u0013(o\u001c:t\u0011\u001d\t\t\u000f\u000ba\u0001\u0003G\f\u0001bY1mY\n\f7m\u001b\t\b\u0013\u0006\u0015H\u0010`<I\u0013\r\t9O\u0013\u0002\n\rVt7\r^5p]N\n!\u0004^3tiNKgn\u001a7f\u0013:4E.[4ii\u0006cG/\u001a:JgJD#!K(\u0002UQ,7\u000f^+tK\u000eCWmY6q_&tG\u000fV8J]&$\u0018.\u00197ju\u0016D\u0015n\u001a5XCR,'/\\1sW\"\u0012!fT\u0001\u0018i\u0016\u001cH/\u00113e\u0003:$'+Z7pm\u0016lU\r\u001e:jGND#aK(\u0002[Q,7\u000f^+oI\u0016\u0014(+\u001a9mS\u000e\fG/\u001a3QCJ$\u0018\u000e^5p]N\u001cuN\u001d:fGR\u001cV-\\1oi&\u001c7\u000f\u000b\u0002-\u001f\u0006QB/Z:u+B$\u0017\r^3BgNLwM\\7f]R\fe\u000eZ%te\"\u0012QfT\u0001\u0016i\u0016\u001cH\u000fT8h\u0007>tg-[4O_R$\u0015N\u001d;zQ\tqs*\u0001\u0011uKN$Hj\\4D_:4\u0017n\u001a#jeRL\u0018i\u001d+pa&\u001cW\u000b\u001d3bi\u0016$\u0007FA\u0018P\u0003\u0005\"Xm\u001d;M_\u001e\u001cuN\u001c4jO\u0012K'\u000f^=Bg\n\u0013xn[3s+B$\u0017\r^3eQ\t\u0001t*A\u0006tK\u0016$Gj\\4ECR\fGc\u0002%\u0003\u000e\t=!1\u0003\u0005\b\u0003\u0017\t\u0004\u0019AA\u0007\u0011\u0019\u0011\t\"\ra\u0001y\u0006Qa.^7SK\u000e|'\u000fZ:\t\u000bm\f\u0004\u0019\u0001?\u0003\u000fMcwn\u001e'pON\u0019!'!\u0004\u0002\u00115|7m\u001b+j[\u0016\u0004BA!\b\u0003$5\u0011!q\u0004\u0006\u0004\u0005CY\u0014!B;uS2\u001c\u0018\u0002\u0002B\u0013\u0005?\u0011\u0001\"T8dWRKW.Z\u0001\u0010CB\u0004XM\u001c3TK6\f\u0007\u000f[8sKB!!1\u0006B\u001d\u001b\t\u0011iC\u0003\u0003\u00030\tE\u0012AC2p]\u000e,(O]3oi*!!1\u0007B\u001b\u0003\u0011)H/\u001b7\u000b\u0005\t]\u0012\u0001\u00026bm\u0006LAAa\u000f\u0003.\tI1+Z7ba\"|'/\u001a\u000b\t\u0005\u007f\u0011\u0019E!\u0012\u0003HA\u0019!\u0011\t\u001a\u000e\u0003\u0001Aq!a\u00037\u0001\u0004\ti\u0001C\u0004\u0003\u001aY\u0002\rAa\u0007\t\u000f\t\u001db\u00071\u0001\u0003*\u0005\u0001\u0012\r\u001d9f]\u0012\f5OR8mY><XM\u001d\u000b\u0005\u0005\u001b\u0012\u0019\u0006\u0005\u0003\u0002\u0010\t=\u0013\u0002\u0002B)\u0003#\u0011Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007bBA2o\u0001\u0007\u00111\n")
public class PartitionTest
extends AbstractPartitionTest {
    @Test
    public void testLastFetchedOffsetValidation() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        PartitionTest.append$1(0, 2, log);
        PartitionTest.append$1(3, 3, log);
        PartitionTest.append$1(3, 3, log);
        PartitionTest.append$1(4, 5, log);
        PartitionTest.append$1(7, 1, log);
        PartitionTest.append$1(9, 3, log);
        Assert.assertEquals((long)17L, (long)log.logEndOffset());
        int leaderEpoch = 10;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(0, 2L), PartitionTest.read$1(2, 5L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(0, 2L), PartitionTest.read$1(0, 4L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(4, 13L), PartitionTest.read$1(6, 6L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(4, 13L), PartitionTest.read$1(5, 9L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(10, 17L), PartitionTest.read$1(10, 18L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(0, 2L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(7, 14L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(9, 17L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(10, 17L, partition, leaderEpoch));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> PartitionTest.read$1(11, 5L, partition, leaderEpoch), ClassTag$.MODULE$.apply(OffsetOutOfRangeException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(5L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(2, 5L), PartitionTest.read$1(2, 8L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(0, 5L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(3, 5L, partition, leaderEpoch));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> PartitionTest.read$1(0, 0L, partition, leaderEpoch), ClassTag$.MODULE$.apply(OffsetOutOfRangeException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        log.maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> PartitionTest.read$1(5, 6L, partition, leaderEpoch), ClassTag$.MODULE$.apply(OffsetOutOfRangeException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> PartitionTest.read$1(3, 6L, partition, leaderEpoch), ClassTag$.MODULE$.apply(OffsetOutOfRangeException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMakeLeaderUpdatesEpochCache() {
        void withRecords_records;
        void withRecords_compressionType;
        void withRecords_records2;
        void withRecords_compressionType2;
        int leaderEpoch = 8;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        int n = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())};
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        compressionType = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)n, (boolean)false, (SimpleRecord[])withRecords_records2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        int n2 = 5;
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())};
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = 0L;
        compressionType2 = null;
        simpleRecordArray2 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)n2, (boolean)false, (SimpleRecord[])withRecords_records), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assert.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        Option option = partition.leaderLogIfLocal();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((Log)map_this.get()).logEndOffset());
        None$ none$ = object;
        Object var10_17 = null;
        object = null;
        Assert.assertEquals((Object)new Some((Object)4), (Object)none$);
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(leaderEpoch), leaderEpoch, true);
        Assert.assertEquals((long)4L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)leaderEpoch, (long)epochEndOffset.leaderEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMakeLeaderDoesNotUpdateEpochCacheForOldFormats() {
        void apply_elems;
        void $minus$greater$extension_y;
        int leaderEpoch = 8;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        String string = KAFKA_0_10_2_IV0$.MODULE$.shortVersion();
        String $minus$greater$extension_$this = LogConfig$.MODULE$.MessageFormatVersionProp();
        Object var11_3 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        LogConfig logConfig = new LogConfig((Map)this.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems))), LogConfig$.MODULE$.apply$default$2());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> logConfig;
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), RecordVersion.V1.value, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)Nil$.MODULE$)), RecordVersion.V1.value, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assert.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        Option option = partition.leaderLogIfLocal();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((Log)map_this.get()).logEndOffset());
        None$ none$ = object;
        Object var13_13 = null;
        object = null;
        Assert.assertEquals((Object)new Some((Object)4), (Object)none$);
        Assert.assertEquals((Object)None$.MODULE$, (Object)log.latestEpoch());
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(leaderEpoch), leaderEpoch, true);
        Assert.assertEquals((long)-1L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)-1L, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints());
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        Thread thread1 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                Partition qual$1 = this.$outer.partition();
                boolean x$1 = qual$1.removeFutureLocalReplica$default$1();
                qual$1.removeFutureLocalReplica(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        Thread thread2 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                this.$outer.partition().maybeReplaceCurrentWithFutureReplica();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.partition().futureLog());
    }

    @Test
    public void testMakeFollowerWithWithFollowerAppendRecords() {
        Semaphore appendSemaphore = new Semaphore(0);
        MockTime mockTime = new MockTime();
        this.partition_$eq(new Partition(this, mockTime, appendSemaphore){
            private final /* synthetic */ PartitionTest $outer;
            private final MockTime mockTime$1;
            private final Semaphore appendSemaphore$1;

            public Log createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints) {
                Log log = super.createLog(isNew, isFutureReplica, offsetCheckpoints);
                return new SlowLog(this.$outer, log, this.mockTime$1, this.appendSemaphore$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mockTime$1 = mockTime$1;
                this.appendSemaphore$1 = appendSemaphore$1;
                super($outer.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), $outer.brokerId(), (Time)$outer.time(), $outer.stateStore(), (IsrChangeListener)$outer.isrChangeListener(), $outer.delayedOperations(), $outer.metadataCache(), $outer.logManager(), (AlterIsrManager)$outer.alterIsrManager());
            }
        });
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints());
        Thread appendThread = new Thread(this){
            private final /* synthetic */ PartitionTest $outer;

            public void run() {
                MemoryRecords records = this.$outer.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), 0L, this.$outer.createRecords$default$3());
                this.$outer.partition().appendRecordsToFollowerOrFutureReplica(records, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        appendThread.start();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!appendSemaphore.hasQueuedThreads()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("follower log append is not called.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(2).setLeaderEpoch(1).setIsr(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)0, (List)new .colon.colon((Object)1, (List)new .colon.colon((Object)2, (List)new .colon.colon((Object)this.brokerId(), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)0, (List)new .colon.colon((Object)1, (List)new .colon.colon((Object)2, (List)new .colon.colon((Object)this.brokerId(), (List)Nil$.MODULE$))))).asJava()).setIsNew(false);
        Assert.assertTrue((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints()));
        appendSemaphore.release();
        appendThread.join();
        Assert.assertEquals((long)2L, (long)this.partition().localLogOrException().logEndOffset());
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)this.partition().leaderReplicaIdOpt().get()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeReplaceCurrentWithFutureReplicaDifferentBaseOffsets() {
        void builder_partitionLeaderEpoch;
        void builder_isTransactional;
        void builder_baseSequence;
        void builder_producerEpoch;
        void builder_logAppendTime;
        void builder_baseOffset;
        void builder_timestampType;
        void builder_compressionType;
        void withRecords_records;
        void withRecords_compressionType;
        void withRecords_records2;
        void withRecords_compressionType2;
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints());
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        Log currentLog = (Log)this.partition().log().get();
        int n = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k1".getBytes(), "v2".getBytes()), new SimpleRecord("k1".getBytes(), "v3".getBytes()), new SimpleRecord("k2".getBytes(), "v4".getBytes()), new SimpleRecord("k2".getBytes(), "v5".getBytes()), new SimpleRecord("k2".getBytes(), "v6".getBytes())};
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        compressionType = null;
        simpleRecordArray = null;
        currentLog.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)n, (boolean)false, (SimpleRecord[])withRecords_records2), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4());
        currentLog.roll(currentLog.roll$default$1());
        int n2 = 0;
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v7".getBytes()), new SimpleRecord("k4".getBytes(), "v8".getBytes())};
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = 0L;
        compressionType2 = null;
        simpleRecordArray2 = null;
        currentLog.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)n2, (boolean)false, (SimpleRecord[])withRecords_records), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4());
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        boolean bl = false;
        long l = -1L;
        long l2 = 0L;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType compressionType3 = CompressionType.NONE;
        byte builder_magic = 2;
        boolean bl2 = false;
        int n3 = -1;
        int n4 = -1;
        long builder_producerId = -1L;
        compressionType3 = null;
        timestampType = null;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)builder_magic, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)builder_baseOffset, (long)builder_logAppendTime, (long)builder_producerId, (short)builder_producerEpoch, (int)builder_baseSequence, (boolean)builder_isTransactional, (boolean)false, (int)builder_partitionLeaderEpoch);
        builder.appendWithOffset(2L, new SimpleRecord("k1".getBytes(), "v3".getBytes()));
        builder.appendWithOffset(5L, new SimpleRecord("k2".getBytes(), "v6".getBytes()));
        builder.appendWithOffset(6L, new SimpleRecord("k3".getBytes(), "v7".getBytes()));
        builder.appendWithOffset(7L, new SimpleRecord("k4".getBytes(), "v8".getBytes()));
        this.partition().futureLocalLogOrException().appendAsFollower(builder.build());
        Assert.assertTrue((boolean)this.partition().maybeReplaceCurrentWithFutureReplica());
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertSnapshotError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(leaderEpoch - 1), partition);
        PartitionTest.assertSnapshotError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(leaderEpoch + 1), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.of(leaderEpoch), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.empty(), partition);
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.of(leaderEpoch), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(leaderEpoch - 1), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(leaderEpoch + 1), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(leaderEpoch), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(leaderEpoch - 1), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(leaderEpoch + 1), true, partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.of(leaderEpoch), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(leaderEpoch - 1), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(leaderEpoch + 1), partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.of(leaderEpoch), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(leaderEpoch - 1), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(leaderEpoch + 1), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(leaderEpoch), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(leaderEpoch - 1), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(leaderEpoch + 1), true, partition);
    }

    @Test
    public void testReadRecordEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.of(leaderEpoch), partition);
        PartitionTest.assertReadRecordsError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(leaderEpoch - 1), partition);
        PartitionTest.assertReadRecordsError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(leaderEpoch + 1), partition);
    }

    @Test
    public void testReadRecordEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.of(leaderEpoch), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(leaderEpoch - 1), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(leaderEpoch + 1), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(leaderEpoch), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(leaderEpoch - 1), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(leaderEpoch + 1), true, partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.of(leaderEpoch), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(leaderEpoch - 1), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(leaderEpoch + 1), partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.of(leaderEpoch), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(leaderEpoch - 1), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(leaderEpoch + 1), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(leaderEpoch), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(leaderEpoch - 1), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(leaderEpoch + 1), true, partition);
    }

    @Test
    public void testFetchLatestOffsetIncludesLeaderEpoch() {
        int leaderEpoch = 5;
        Option timestampAndOffsetOpt = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3()).fetchOffsetForTimestamp(-1L, (Option)None$.MODULE$, Optional.empty(), true);
        Assert.assertTrue((boolean)timestampAndOffsetOpt.isDefined());
        FileRecords.TimestampAndOffset timestampAndOffset = (FileRecords.TimestampAndOffset)timestampAndOffsetOpt.get();
        Assert.assertEquals((Object)leaderEpoch, timestampAndOffset.leaderEpoch.get());
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testMonotonicOffsetsAfterLeaderChange() {
        block62: {
            block64: {
                block63: {
                    block61: {
                        block58: {
                            block60: {
                                block59: {
                                    block57: {
                                        controllerEpoch = 3;
                                        leader = this.brokerId();
                                        follower1 = this.brokerId() + 1;
                                        follower2 = this.brokerId() + 2;
                                        replicas = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader, follower1, follower2}));
                                        isr = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$))).asJava();
                                        leaderEpoch = 8;
                                        batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                        batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(20L, "k4".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(21L, "k5".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                        v0 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
                                        if (replicas == null) {
                                            throw null;
                                        }
                                        if (replicas == Nil$.MODULE$) {
                                            var72_10 = Nil$.MODULE$;
                                        } else {
                                            map_t = map_h = new .colon.colon((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                                            for (map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                                                map_nx = new .colon.colon((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                                                map_t.next_$eq((List)map_nx);
                                                map_t = map_nx;
                                            }
                                            Statics.releaseFence();
                                            var72_10 = map_h;
                                        }
                                        v1 = var72_10;
                                        var68_11 = null;
                                        var69_12 = null;
                                        var70_13 = null;
                                        var71_14 = null;
                                        var72_10 = null;
                                        leaderState = v0.setReplicas(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)v1).asJava()).setIsNew(true);
                                        Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)this.partition().makeLeader(leaderState, this.offsetCheckpoints()));
                                        Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)this.partition().getLeaderEpoch());
                                        v2 = Predef$.MODULE$.Set();
                                        var67_16 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)});
                                        if (v2 == null) {
                                            throw null;
                                        }
                                        var67_16 = null;
                                        Assert.assertEquals((String)"ISR", (Object)IterableFactory.apply$((IterableFactory)v2, (scala.collection.immutable.Seq)apply_elems), (Object)this.partition().isrState().isr());
                                        this.partition().appendRecordsToLeader(batch1, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
                                        this.partition().appendRecordsToLeader(batch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
                                        Assert.assertEquals((String)"Expected leader's HW not move", (long)this.partition().localLogOrException().logStartOffset(), (long)this.partition().localLogOrException().highWatermark());
                                        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, new LeaderAndIsr(leader, leaderEpoch, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader, follower2, follower1})), 1))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
                                        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        Assert.assertEquals((long)2L, (long)this.partition().localLogOrException().highWatermark());
                                        var11_17 = false;
                                        var12_18 = null;
                                        var13_19 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                                        if (!(var13_19 instanceof Right)) ** GOTO lbl-1000
                                        var11_17 = true;
                                        var12_18 = (Right)var13_19;
                                        var14_20 = (Option)var12_18.value();
                                        if (var14_20 instanceof Some) {
                                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var14_20).value();
                                            Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                                        } else if (var11_17 && None$.MODULE$.equals(var16_22 = (Option)var12_18.value())) {
                                            Assert.fail((String)"Should have seen some offsets");
                                        } else if (var13_19 instanceof Left) {
                                            Assert.fail((String)"Should not have seen an error");
                                        } else {
                                            throw new MatchError((Object)var13_19);
                                        }
                                        var17_23 = false;
                                        var18_24 = null;
                                        var19_25 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                        if (!(var19_25 instanceof Right)) ** GOTO lbl-1000
                                        var17_23 = true;
                                        var18_24 = (Right)var19_25;
                                        var20_26 = (Option)var18_24.value();
                                        if (var20_26 instanceof Some) {
                                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var20_26).value();
                                            Assert.assertEquals((long)2L, (long)offsetAndTimestamp.offset);
                                        } else if (var17_23 && None$.MODULE$.equals(var22_28 = (Option)var18_24.value())) {
                                            Assert.fail((String)"Should have seen some offsets");
                                        } else if (var19_25 instanceof Left) {
                                            Assert.fail((String)"Should not have seen an error");
                                        } else {
                                            throw new MatchError((Object)var19_25);
                                        }
                                        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(30L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
                                        v3 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(4);
                                        if (replicas == Nil$.MODULE$) {
                                            var77_29 = Nil$.MODULE$;
                                        } else {
                                            map_t = map_h = new .colon.colon((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                                            for (map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                                                map_nx = new .colon.colon((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                                                map_t.next_$eq((List)map_nx);
                                                map_t = map_nx;
                                            }
                                            Statics.releaseFence();
                                            var77_29 = map_h;
                                        }
                                        v4 = var77_29;
                                        var73_30 = null;
                                        var74_31 = null;
                                        var75_32 = null;
                                        var76_33 = null;
                                        var77_29 = null;
                                        followerState = v3.setReplicas(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)v4).asJava()).setIsNew(false);
                                        Assert.assertTrue((boolean)this.partition().makeFollower(followerState, this.offsetCheckpoints()));
                                        v5 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(5);
                                        if (replicas == Nil$.MODULE$) {
                                            var82_35 = Nil$.MODULE$;
                                        } else {
                                            map_t = map_h = new .colon.colon((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                                            for (map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                                                map_nx = new .colon.colon((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                                                map_t.next_$eq((List)map_nx);
                                                map_t = map_nx;
                                            }
                                            Statics.releaseFence();
                                            var82_35 = map_h;
                                        }
                                        v6 = var82_35;
                                        var78_36 = null;
                                        var79_37 = null;
                                        var80_38 = null;
                                        var81_39 = null;
                                        var82_35 = null;
                                        newLeaderState = v5.setReplicas(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)v6).asJava()).setIsNew(false);
                                        Assert.assertTrue((boolean)this.partition().makeLeader(newLeaderState, this.offsetCheckpoints()));
                                        var25_41 = false;
                                        var26_42 = null;
                                        var27_43 = false;
                                        var28_44 = null;
                                        var29_45 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                        if (!(var29_45 instanceof Right)) break block57;
                                        var25_41 = true;
                                        var26_42 = (Right)var29_45;
                                        if (!((Option)var26_42.value() instanceof Some)) break block57;
                                        Assert.fail((String)"Should have failed with OffsetNotAvailable");
                                        break block58;
                                    }
                                    if (!var25_41 || !None$.MODULE$.equals(var30_46 = (Option)var26_42.value())) break block59;
                                    Assert.fail((String)"Should have seen an error");
                                    break block58;
                                }
                                if (!(var29_45 instanceof Left)) break block60;
                                var27_43 = true;
                                var28_44 = (Left)var29_45;
                                if ((ApiException)var28_44.value() instanceof OffsetNotAvailableException) break block58;
                            }
                            if (var27_43 && (e = (ApiException)var28_44.value()) != null) {
                                Assert.fail((String)new StringBuilder(42).append("Expected OffsetNotAvailableException, got ").append(e).toString());
                            } else {
                                throw new MatchError((Object)var29_45);
                            }
                        }
                        var32_48 = false;
                        var33_49 = null;
                        var34_50 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                        if (!(var34_50 instanceof Right)) ** GOTO lbl-1000
                        var32_48 = true;
                        var33_49 = (Right)var34_50;
                        var35_51 = (Option)var33_49.value();
                        if (var35_51 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var35_51).value();
                            Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                        } else if (var32_48 && None$.MODULE$.equals(var37_53 = (Option)var33_49.value())) {
                            Assert.fail((String)"Should have seen some offsets");
                        } else if (var34_50 instanceof Left && (e = (ApiException)((Left)var34_50).value()) != null) {
                            Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var34_50);
                        }
                        var39_55 = false;
                        var40_56 = null;
                        var41_57 = this.fetchOffsetsForTimestamp$1(-2L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var41_57 instanceof Right)) ** GOTO lbl-1000
                        var39_55 = true;
                        var40_56 = (Right)var41_57;
                        var42_58 = (Option)var40_56.value();
                        if (var42_58 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var42_58).value();
                            Assert.assertEquals((long)0L, (long)offsetAndTimestamp.offset);
                        } else if (var39_55 && None$.MODULE$.equals(var44_60 = (Option)var40_56.value())) {
                            Assert.fail((String)"Should have seen some offsets");
                        } else if (var41_57 instanceof Left && (e = (ApiException)((Left)var41_57).value()) != null) {
                            Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var41_57);
                        }
                        var46_62 = false;
                        var47_63 = null;
                        var48_64 = this.fetchOffsetsForTimestamp$1(11L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var48_64 instanceof Right)) ** GOTO lbl-1000
                        var46_62 = true;
                        var47_63 = (Right)var48_64;
                        var49_65 = (Option)var47_63.value();
                        if (var49_65 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var49_65).value();
                            Assert.assertEquals((long)1L, (long)offsetAndTimestamp.offset);
                            Assert.assertEquals((long)11L, (long)offsetAndTimestamp.timestamp);
                        } else if (var46_62 && None$.MODULE$.equals(var51_67 = (Option)var47_63.value())) {
                            Assert.fail((String)"Should have seen some offsets");
                        } else if (var48_64 instanceof Left && (e = (ApiException)((Left)var48_64).value()) != null) {
                            Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var48_64);
                        }
                        var53_69 = false;
                        var54_70 = null;
                        var55_71 = false;
                        var56_72 = null;
                        var57_73 = this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var57_73 instanceof Right)) break block61;
                        var53_69 = true;
                        var54_70 = (Right)var57_73;
                        if (!((Option)var54_70.value() instanceof Some)) break block61;
                        Assert.fail((String)"Should have failed");
                        break block62;
                    }
                    if (!var53_69 || !None$.MODULE$.equals(var58_74 = (Option)var54_70.value())) break block63;
                    Assert.fail((String)"Should have failed");
                    break block62;
                }
                if (!(var57_73 instanceof Left)) break block64;
                var55_71 = true;
                var56_72 = (Left)var57_73;
                if ((ApiException)var56_72.value() instanceof OffsetNotAvailableException) break block62;
            }
            if (var55_71 && (e = (ApiException)var56_72.value()) != null) {
                Assert.fail((String)new StringBuilder(50).append("Should have seen OffsetNotAvailableException, saw ").append(e).toString());
            } else {
                throw new MatchError((Object)var57_73);
            }
        }
        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, new LeaderAndIsr(leader, leaderEpoch + 2, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader, follower2, follower1})), 5))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        var60_76 = false;
        var61_77 = null;
        var62_78 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
        if (!(var62_78 instanceof Right)) ** GOTO lbl-1000
        var60_76 = true;
        var61_77 = (Right)var62_78;
        var63_79 = (Option)var61_77.value();
        if (var63_79 instanceof Some) {
            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var63_79).value();
            Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
        } else if (var60_76 && None$.MODULE$.equals(var65_81 = (Option)var61_77.value())) {
            Assert.fail((String)"Should have seen some offsets");
        } else if (var62_78 instanceof Left && (e = (ApiException)((Left)var62_78).value()) != null) {
            Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
        } else {
            throw new MatchError((Object)var62_78);
        }
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
    }

    private Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader, Log log) {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        int controllerEpoch = 0;
        java.util.List replicas = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        if (isLeader) {
            Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()));
            Assert.assertEquals((long)leaderEpoch, (long)this.partition().getLeaderEpoch());
        } else {
            Assert.assertTrue((String)"Expected become follower transition to succeed", (boolean)this.partition().makeFollower(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId() + 1).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()));
            Assert.assertEquals((long)leaderEpoch, (long)this.partition().getLeaderEpoch());
            Assert.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }

    private Log setupPartitionWithMocks$default$3() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        return qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Log log = this.partition().localLogOrException();
        long initialLogStartOffset = 5L;
        this.partition().truncateFullyAndStartAt(initialLogStartOffset, false);
        Assert.assertEquals((String)new StringBuilder(50).append("Log end offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString(), (long)initialLogStartOffset, (long)log.logEndOffset());
        Assert.assertEquals((String)new StringBuilder(52).append("Log start offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString(), (long)initialLogStartOffset, (long)log.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 3L, this.createRecords$default$3()), false), ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
        Assert.assertEquals((String)"Log end offset should not change after failure to append", (long)initialLogStartOffset, (long)log.logEndOffset());
        long newLogStartOffset = 4L;
        MemoryRecords records = this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), newLogStartOffset, this.createRecords$default$3());
        this.partition().appendRecordsToFollowerOrFutureReplica(records, false);
        Assert.assertEquals((String)new StringBuilder(59).append("Log end offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString(), (long)7L, (long)log.logEndOffset());
        Assert.assertEquals((String)new StringBuilder(61).append("Log start offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString(), (long)newLogStartOffset, (long)log.logStartOffset());
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 7L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)"Log end offset after append of 1 record at offset 7:", (long)8L, (long)log.logEndOffset());
        Assert.assertEquals((String)"Log start offset not expected to change:", (long)newLogStartOffset, (long)log.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> {
            MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), 3L, this.createRecords$default$3());
            return this.partition().appendRecordsToFollowerOrFutureReplica(records2, false);
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803));
        Assert.assertEquals((String)"Log end offset should not change after failure to append", (long)8L, (long)log.logEndOffset());
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 8L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)"Log end offset after append of 1 record at offset 8:", (long)9L, (long)log.logEndOffset());
        Assert.assertEquals((String)"Log start offset not expected to change:", (long)newLogStartOffset, (long)log.logStartOffset());
    }

    @Test
    public void testListOffsetIsolationLevels() {
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List replicas = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()));
        Assert.assertEquals((long)leaderEpoch, (long)this.partition().getLeaderEpoch());
        MemoryRecords records = this.createTransactionalRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), 0L);
        this.partition().appendRecordsToLeader(records, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
        Assert.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$).offset);
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
        ((Log)this.partition().log().get()).updateHighWatermark(1L);
        Assert.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$).offset);
        Assert.assertEquals((long)1L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)None$.MODULE$).offset);
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
    }

    @Test
    public void testGetReplica() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.partition().log());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.partition().localLogOrException(), ClassTag$.MODULE$.apply(NotLeaderOrFollowerException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 880));
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 0L, this.createRecords$default$3()), false), ClassTag$.MODULE$.apply(NotLeaderOrFollowerException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 887));
    }

    @Test
    public void testMakeFollowerWithNoLeaderIdChange() {
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(1).setIsr(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)0, (List)new .colon.colon((Object)1, (List)new .colon.colon((Object)2, (List)new .colon.colon((Object)this.brokerId(), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)0, (List)new .colon.colon((Object)1, (List)new .colon.colon((Object)2, (List)new .colon.colon((Object)this.brokerId(), (List)Nil$.MODULE$))))).asJava()).setIsNew(false);
        this.partition().makeFollower(partitionState, this.offsetCheckpoints());
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)0, (List)new .colon.colon((Object)1, (List)new .colon.colon((Object)2, (List)new .colon.colon((Object)this.brokerId(), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)0, (List)new .colon.colon((Object)1, (List)new .colon.colon((Object)2, (List)new .colon.colon((Object)this.brokerId(), (List)Nil$.MODULE$))))).asJava()).setIsNew(false);
        Assert.assertTrue((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints()));
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)0, (List)new .colon.colon((Object)1, (List)new .colon.colon((Object)2, (List)new .colon.colon((Object)this.brokerId(), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)0, (List)new .colon.colon((Object)1, (List)new .colon.colon((Object)2, (List)new .colon.colon((Object)this.brokerId(), (List)Nil$.MODULE$))))).asJava());
        Assert.assertFalse((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFollowerDoesNotJoinISRUntilCaughtUpToOffsetWithinCurrentLeaderEpoch() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        java.util.List replicas = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)leader, (List)new .colon.colon((Object)follower1, (List)new .colon.colon((Object)follower2, (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)leader, (List)new .colon.colon((Object)follower2, (List)Nil$.MODULE$))).asJava();
        int leaderEpoch = 8;
        MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        MemoryRecords batch3 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k6".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k7".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)this.partition().makeLeader(leaderState, this.offsetCheckpoints()));
        Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)this.partition().getLeaderEpoch());
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{leader, follower2});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((String)"ISR", (Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems5), (Object)this.partition().isrState().isr());
        long lastOffsetOfFirstBatch = this.partition().appendRecordsToLeader(batch1, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0).lastOffset();
        this.partition().appendRecordsToLeader(batch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
        Assert.assertEquals((String)"Expected leader's HW not move", (long)this.partition().localLogOrException().logStartOffset(), (long)((Log)this.partition().log().get()).highWatermark());
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(0L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(lastOffsetOfFirstBatch, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Assert.assertEquals((String)"Expected leader's HW", (long)lastOffsetOfFirstBatch, (long)((Log)this.partition().log().get()).highWatermark());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState followerState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeFollower(followerState, this.offsetCheckpoints());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState newLeaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        Assert.assertTrue((String)"Expected makeLeader() to return 'leader changed' after makeFollower()", (boolean)this.partition().makeLeader(newLeaderState, this.offsetCheckpoints()));
        long currentLeaderEpochStartOffset = this.partition().localLogOrException().logEndOffset();
        this.partition().appendRecordsToLeader(batch3, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(0L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(lastOffsetOfFirstBatch, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{leader, follower2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((String)"ISR", (Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems4), (Object)this.partition().isrState().isr());
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(currentLeaderEpochStartOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{leader, follower2});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((String)"ISR", (Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems3), (Object)this.partition().isrState().isr());
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{leader, follower1, follower2});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertEquals((String)"ISR", (Object)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems2), (Object)this.partition().isrState().maximalIsr());
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader, follower1, follower2});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        Assert.assertEquals((String)"AlterIsr", (Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().dequeue()).leaderAndIsr().isr().toSet(), (Object)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems));
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords createRecords(Iterable<SimpleRecord> records, long baseOffset, int partitionLeaderEpoch) {
        MemoryRecordsBuilder memoryRecordsBuilder;
        void builder_isTransactional;
        void builder_baseSequence;
        void builder_producerEpoch;
        void builder_logAppendTime;
        void builder_timestampType;
        void builder_compressionType;
        MemoryRecordsBuilder memoryRecordsBuilder2;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, records).asJava()));
        long l = this.time().milliseconds();
        TimestampType timestampType = TimestampType.LOG_APPEND_TIME;
        CompressionType compressionType = CompressionType.NONE;
        byte builder_magic = 2;
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        long builder_producerId = -1L;
        MemoryRecordsBuilder memoryRecordsBuilder3 = memoryRecordsBuilder2 = MemoryRecords.builder((ByteBuffer)buf, (byte)builder_magic, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)baseOffset, (long)builder_logAppendTime, (long)builder_producerId, (short)builder_producerEpoch, (int)builder_baseSequence, (boolean)builder_isTransactional, (boolean)false, (int)partitionLeaderEpoch);
        memoryRecordsBuilder2 = null;
        MemoryRecordsBuilder memoryRecordsBuilder4 = memoryRecordsBuilder = memoryRecordsBuilder3;
        compressionType = null;
        timestampType = null;
        memoryRecordsBuilder = null;
        MemoryRecordsBuilder builder = memoryRecordsBuilder4;
        records.foreach((Function1 & Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords createTransactionalRecords(Iterable<SimpleRecord> records, long baseOffset) {
        MemoryRecordsBuilder memoryRecordsBuilder;
        void builder_partitionLeaderEpoch;
        void builder_logAppendTime;
        void builder_timestampType;
        MemoryRecordsBuilder memoryRecordsBuilder2;
        long producerId = 1L;
        short producerEpoch = (short)0;
        int baseSequence = 0;
        boolean isTransactional = true;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, records).asJava()));
        CompressionType builder_compressionType = CompressionType.NONE;
        int n = -1;
        long l = -1L;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        byte builder_magic = 2;
        MemoryRecordsBuilder memoryRecordsBuilder3 = memoryRecordsBuilder2 = MemoryRecords.builder((ByteBuffer)buf, (byte)builder_magic, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)baseOffset, (long)builder_logAppendTime, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional, (boolean)false, (int)builder_partitionLeaderEpoch);
        timestampType = null;
        memoryRecordsBuilder2 = null;
        MemoryRecordsBuilder memoryRecordsBuilder4 = memoryRecordsBuilder = memoryRecordsBuilder3;
        Object var11_8 = null;
        memoryRecordsBuilder = null;
        MemoryRecordsBuilder builder = memoryRecordsBuilder4;
        records.foreach((Function1 & Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    @Test
    public void testAtMinIsr() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        java.util.List replicas = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)leader, (List)new .colon.colon((Object)follower1, (List)new .colon.colon((Object)follower2, (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)leader, (List)Nil$.MODULE$)).asJava();
        int leaderEpoch = 8;
        Assert.assertFalse((boolean)this.partition().isAtMinIsr());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints());
        Assert.assertTrue((boolean)this.partition().isAtMinIsr());
    }

    @Test
    public void testUpdateFollowerFetchState() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 6, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)remoteBrokerId, (List)Nil$.MODULE$))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        long initializeTimeMs = this.time().milliseconds();
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()));
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(500L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(500L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(6L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Assert.assertEquals((long)this.time().milliseconds(), (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)6L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsrExpansion() {
        void apply_elems;
        void apply_value;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        Nil$ nil$;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)Nil$.MODULE$)).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Partition partition = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
        if (replicas == null) {
            throw null;
        }
        if (replicas == Nil$.MODULE$) {
            nil$ = Nil$.MODULE$;
        } else {
            .colon.colon map_h;
            .colon.colon map_t = map_h = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)replicas.head()), (List)Nil$.MODULE$);
            for (List map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                .colon.colon map_nx = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)map_rest.head()), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            nil$ = map_h;
        }
        Nil$ nil$2 = nil$;
        Object var19_13 = null;
        Object var20_14 = null;
        Object var21_15 = null;
        Object var22_16 = null;
        nil$ = null;
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(leaderAndIsrPartitionState.setReplicas(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)nil$2).asJava()).setIsNew(true), this.offsetCheckpoints()));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems5), (Object)this.partition().isrState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems4), (Object)this.partition().isrState().isr());
        Assert.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Queue<AlterIsrItem> queue = this.alterIsrManager().isrUpdates();
        if (queue == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$(queue), (long)1L);
        AlterIsrItem isrItem = (AlterIsrItem)this.alterIsrManager().isrUpdates().dequeue();
        Assert.assertEquals((Object)isrItem.leaderAndIsr().isr(), (Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})));
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems3), (Object)this.partition().isrState().isr());
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems2), (Object)this.partition().isrState().maximalIsr());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(this.brokerId(), leaderEpoch, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), 2);
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        leaderAndIsr = null;
        isrItem.callback().apply((Object)new Right((Object)apply_value));
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems), (Object)this.partition().isrState().isr());
        Assert.assertEquals((long)this.isrChangeListener().expands().get(), (long)1L);
        Assert.assertEquals((long)this.isrChangeListener().shrinks().get(), (long)0L);
        Assert.assertEquals((long)this.isrChangeListener().failures().get(), (long)0L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsrNotExpandedIfUpdateFails() {
        void apply_elems;
        void apply_elems2;
        void apply_value;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)remoteBrokerId, (List)Nil$.MODULE$))).asJava();
        java.util.List isr = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)Nil$.MODULE$)).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems5), (Object)this.partition().isrState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems4), (Object)this.partition().inSyncReplicaIds());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems3), (Object)this.partition().isrState().maximalIsr());
        Queue<AlterIsrItem> queue = this.alterIsrManager().isrUpdates();
        if (queue == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$(queue), (long)1L);
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        Errors errors = Errors.INVALID_UPDATE_VERSION;
        if (package$.MODULE$.Left() == null) {
            throw null;
        }
        errors = null;
        ((AlterIsrItem)this.alterIsrManager().isrUpdates().dequeue()).callback().apply((Object)new Left((Object)apply_value));
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems2), (Object)this.partition().inSyncReplicaIds());
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems), (Object)this.partition().isrState().maximalIsr());
        Queue<AlterIsrItem> queue2 = this.alterIsrManager().isrUpdates();
        if (queue2 == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$(queue2), (long)0L);
        Assert.assertEquals((long)this.isrChangeListener().expands().get(), (long)0L);
        Assert.assertEquals((long)this.isrChangeListener().shrinks().get(), (long)0L);
        Assert.assertEquals((long)this.isrChangeListener().failures().get(), (long)1L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeShrinkIsr() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        Nil$ nil$;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)remoteBrokerId, (List)Nil$.MODULE$))).asJava();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Partition partition = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
        if (replicas == null) {
            throw null;
        }
        if (replicas == Nil$.MODULE$) {
            nil$ = Nil$.MODULE$;
        } else {
            .colon.colon map_h;
            .colon.colon map_t = map_h = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)replicas.head()), (List)Nil$.MODULE$);
            for (List map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                .colon.colon map_nx = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)map_rest.head()), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            nil$ = map_h;
        }
        Nil$ nil$2 = nil$;
        Object var19_14 = null;
        Object var20_15 = null;
        Object var21_16 = null;
        Object var22_17 = null;
        nil$ = null;
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(leaderAndIsrPartitionState.setReplicas(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)nil$2).asJava()).setIsNew(true), this.offsetCheckpoints()));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems4), (Object)this.partition().isrState().isr());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr();
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems3), (Object)this.partition().isrState().isr());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Queue<AlterIsrItem> queue = this.alterIsrManager().isrUpdates();
        if (queue == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$(queue), (long)1L);
        Assert.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().dequeue()).leaderAndIsr().isr(), (Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems2), (Object)this.partition().isrState().isr());
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems), (Object)this.partition().isrState().maximalIsr());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp() {
        void apply_elems;
        void apply_elems2;
        Nil$ nil$;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)remoteBrokerId, (List)Nil$.MODULE$))).asJava();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Partition partition = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
        if (replicas == null) {
            throw null;
        }
        if (replicas == Nil$.MODULE$) {
            nil$ = Nil$.MODULE$;
        } else {
            .colon.colon map_h;
            .colon.colon map_t = map_h = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)replicas.head()), (List)Nil$.MODULE$);
            for (List map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                .colon.colon map_nx = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)map_rest.head()), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            nil$ = map_h;
        }
        Nil$ nil$2 = nil$;
        Object var19_14 = null;
        Object var20_15 = null;
        Object var21_16 = null;
        Object var22_17 = null;
        nil$ = null;
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(leaderAndIsrPartitionState.setReplicas(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)nil$2).asJava()).setIsNew(true), this.offsetCheckpoints()));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2), (Object)this.partition().isrState().isr());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(5000L);
        long firstFetchTimeMs = this.time().milliseconds();
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(5L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, firstFetchTimeMs, 10L);
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)5L, (long)this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)5L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(5001L);
        this.seedLogData(log, 5, leaderEpoch);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 15L);
        Assert.assertEquals((long)firstFetchTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr();
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems), (Object)this.partition().isrState().isr());
        Queue<AlterIsrItem> queue = this.alterIsrManager().isrUpdates();
        if (queue == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$(queue), (long)0L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd() {
        void apply_elems;
        void apply_elems2;
        Nil$ nil$;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)remoteBrokerId, (List)Nil$.MODULE$))).asJava();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Partition partition = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
        if (replicas == null) {
            throw null;
        }
        if (replicas == Nil$.MODULE$) {
            nil$ = Nil$.MODULE$;
        } else {
            .colon.colon map_h;
            .colon.colon map_t = map_h = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)replicas.head()), (List)Nil$.MODULE$);
            for (List map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                .colon.colon map_nx = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)map_rest.head()), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            nil$ = map_h;
        }
        Nil$ nil$2 = nil$;
        Object var17_14 = null;
        Object var18_15 = null;
        Object var19_16 = null;
        Object var20_17 = null;
        nil$ = null;
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(leaderAndIsrPartitionState.setReplicas(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)nil$2).asJava()).setIsNew(true), this.offsetCheckpoints()));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2), (Object)this.partition().isrState().isr());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(30001L);
        this.partition().maybeShrinkIsr();
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems), (Object)this.partition().isrState().isr());
        Queue<AlterIsrItem> queue = this.alterIsrManager().isrUpdates();
        if (queue == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$(queue), (long)0L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsrNotShrunkIfUpdateFails() {
        void apply_elems;
        void apply_value;
        void apply_elems2;
        void apply_elems3;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)remoteBrokerId, (List)Nil$.MODULE$))).asJava();
        java.util.List isr = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)remoteBrokerId, (List)Nil$.MODULE$))).asJava();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(30001L);
        this.partition().maybeShrinkIsr();
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2), (Object)this.partition().inSyncReplicaIds());
        Queue<AlterIsrItem> queue = this.alterIsrManager().isrUpdates();
        if (queue == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$(queue), (long)1L);
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Errors errors = Errors.INVALID_UPDATE_VERSION;
        if (package$.MODULE$.Left() == null) {
            throw null;
        }
        errors = null;
        ((AlterIsrItem)this.alterIsrManager().isrUpdates().dequeue()).callback().apply((Object)new Left((Object)apply_value));
        Assert.assertEquals(this.partition().isrState().getClass(), PendingShrinkIsr.class);
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems), (Object)this.partition().inSyncReplicaIds());
        Queue<AlterIsrItem> queue2 = this.alterIsrManager().isrUpdates();
        if (queue2 == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$(queue2), (long)0L);
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testAlterIsrUnknownTopic() {
        this.handleAlterIsrFailure(Errors.UNKNOWN_TOPIC_OR_PARTITION, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrUnknownTopic$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterIsrInvalidVersion() {
        this.handleAlterIsrFailure(Errors.INVALID_UPDATE_VERSION, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrInvalidVersion$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterIsrUnexpectedError() {
        this.handleAlterIsrFailure(Errors.UNKNOWN_SERVER_ERROR, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrUnexpectedError$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void handleAlterIsrFailure(Errors error, Function3<Object, Object, Partition, BoxedUnit> callback) {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)remoteBrokerId, (List)Nil$.MODULE$))).asJava();
        java.util.List isr = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)Nil$.MODULE$)).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3), (Object)this.partition().isrState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2), (Object)this.partition().inSyncReplicaIds());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems), (Object)this.partition().isrState().maximalIsr());
        Queue<AlterIsrItem> queue = this.alterIsrManager().isrUpdates();
        if (queue == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$(queue), (long)1L);
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        if (package$.MODULE$.Left() == null) {
            throw null;
        }
        ((AlterIsrItem)this.alterIsrManager().isrUpdates().dequeue()).callback().apply((Object)new Left((Object)error));
        callback.apply((Object)this.brokerId(), (Object)remoteBrokerId, (Object)this.partition());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSingleInFlightAlterIsr() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int follower3 = this.brokerId() + 3;
        java.util.List replicas = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)follower1, (List)new .colon.colon((Object)follower2, (List)new .colon.colon((Object)follower3, (List)Nil$.MODULE$))))).asJava();
        java.util.List isr = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)follower1, (List)new .colon.colon((Object)follower2, (List)Nil$.MODULE$)))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteAll();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems4), (Object)this.partition().isrState().isr());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.partition().expandIsr(follower3);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems3), (Object)this.partition().isrState().isr());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems2), (Object)this.partition().isrState().maximalIsr());
        Queue<AlterIsrItem> queue = this.alterIsrManager().isrUpdates();
        if (queue == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$(queue), (long)1L);
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{follower3});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        this.partition().shrinkIsr((Set)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems));
        Queue<AlterIsrItem> queue2 = this.alterIsrManager().isrUpdates();
        if (queue2 == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$(queue2), (long)1L);
    }

    @Test
    public void testUseCheckpointToInitializeHighWatermark() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 6, 5);
        Mockito.when((Object)this.offsetCheckpoints().fetch(this.logDir1().getAbsolutePath(), this.topicPartition())).thenReturn((Object)new Some((Object)4L));
        int controllerEpoch = 3;
        java.util.List replicas = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints());
        Assert.assertEquals((long)4L, (long)this.partition().localLogOrException().highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddAndRemoveMetrics() {
        void apply_elems;
        boolean bl;
        block3: {
            .colon.colon forall_these = new .colon.colon((Object)"UnderReplicated", (List)new .colon.colon((Object)"UnderMinIsr", (List)new .colon.colon((Object)"InSyncReplicasCount", (List)new .colon.colon((Object)"ReplicasCount", (List)new .colon.colon((Object)"LastStableOffsetLag", (List)new .colon.colon((Object)"AtMinIsr", (List)Nil$.MODULE$))))));
            while (!forall_these.isEmpty()) {
                if (!PartitionTest.$anonfun$testAddAndRemoveMetrics$3((String)forall_these.head())) {
                    bl = false;
                    break block3;
                }
                forall_these = (List)forall_these.tail();
            }
            bl = true;
        }
        Object var2_1 = null;
        Assert.assertTrue((boolean)bl);
        Partition$.MODULE$.removeMetrics(this.topicPartition());
        Set$ set$ = Predef$.MODULE$.Set();
        Nil$ nil$ = Nil$.MODULE$;
        if (set$ == null) {
            throw null;
        }
        nil$ = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems), (Object)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().keySet().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$4(x$5))));
    }

    @Test
    public void testUnderReplicatedPartitionsCorrectSemantics() {
        int controllerEpoch = 3;
        java.util.List replicas = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)(this.brokerId() + 1), (List)new .colon.colon((Object)(this.brokerId() + 2), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.brokerId(), (List)new .colon.colon((Object)(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints());
        Assert.assertTrue((boolean)this.partition().isUnderReplicated());
        leaderState = leaderState.setIsr(replicas);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints());
        Assert.assertFalse((boolean)this.partition().isUnderReplicated());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateAssignmentAndIsr() {
        void apply_elems;
        void apply_elems2;
        TopicPartition topicPartition = new TopicPartition("test", 1);
        Partition partition = new Partition(topicPartition, 1000L, ApiVersion$.MODULE$.latestVersion(), 0, (Time)new SystemTime(), (PartitionStateStore)Mockito.mock(PartitionStateStore.class), (IsrChangeListener)Mockito.mock(IsrChangeListener.class), (DelayedOperations)Mockito.mock(DelayedOperations.class), (MetadataCache)Mockito.mock(MetadataCache.class), (LogManager)Mockito.mock(LogManager.class), (AlterIsrManager)Mockito.mock(AlterIsrManager.class));
        scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set isr = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2);
        scala.collection.immutable.Seq adding = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5}));
        scala.collection.immutable.Seq removing = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        partition.updateAssignmentAndIsr((Seq)replicas, isr, (Seq)adding, (Seq)removing);
        Assert.assertTrue((String)"The assignmentState is not OngoingReassignmentState", (boolean)(partition.assignmentState() instanceof OngoingReassignmentState));
        Assert.assertEquals((Object)replicas, (Object)partition.assignmentState().replicas());
        Assert.assertEquals((Object)isr, (Object)partition.isrState().isr());
        Assert.assertEquals((Object)adding, (Object)((OngoingReassignmentState)partition.assignmentState()).addingReplicas());
        Assert.assertEquals((Object)removing, (Object)((OngoingReassignmentState)partition.assignmentState()).removingReplicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)partition.remoteReplicas().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.brokerId())));
        scala.collection.immutable.Seq replicas2 = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 4, 5}));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 4, 5});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Set isr2 = (Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems);
        partition.updateAssignmentAndIsr((Seq)replicas2, isr2, (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        Assert.assertTrue((String)"The assignmentState is not SimpleAssignmentState", (boolean)(partition.assignmentState() instanceof SimpleAssignmentState));
        Assert.assertEquals((Object)replicas2, (Object)partition.assignmentState().replicas());
        Assert.assertEquals((Object)isr2, (Object)partition.isrState().isr());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), (Object)partition.remoteReplicas().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.brokerId())));
    }

    @Test
    public void testLogConfigNotDirty() {
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any());
        ((PartitionStateStore)Mockito.verify((Object)this.stateStore())).fetchTopicConfig();
    }

    @Test
    public void testLogConfigDirtyAsTopicUpdated() {
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer(invocation -> {
            PartitionTest.$anonfun$testLogConfigDirtyAsTopicUpdated$1(this, invocation);
            return BoxedUnit.UNIT;
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any());
        ((PartitionStateStore)Mockito.verify((Object)this.stateStore(), (VerificationMode)Mockito.times((int)2))).fetchTopicConfig();
    }

    @Test
    public void testLogConfigDirtyAsBrokerUpdated() {
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer(invocation -> {
            PartitionTest.$anonfun$testLogConfigDirtyAsBrokerUpdated$1(this, invocation);
            return BoxedUnit.UNIT;
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any());
        ((PartitionStateStore)Mockito.verify((Object)this.stateStore(), (VerificationMode)Mockito.times((int)2))).fetchTopicConfig();
    }

    private void seedLogData(Log log, int numRecords, int leaderEpoch) {
        int n = 0;
        Range.Exclusive foreach_this = new Range.Exclusive(n, numRecords, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                PartitionTest.$anonfun$seedLogData$1(leaderEpoch, log, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
    }

    public static final /* synthetic */ SimpleRecord $anonfun$testLastFetchedOffsetValidation$2(int i) {
        return new SimpleRecord(String.valueOf((Object)i).getBytes());
    }

    /*
     * WARNING - void declaration
     */
    private static final void append$1(int leaderEpoch, int count, Log log$1) {
        void withRecords_records;
        void withRecords_compressionType;
        MemoryRecords memoryRecords;
        IndexedSeq indexedSeq;
        SimpleRecord simpleRecord;
        int n = 1;
        Range.Inclusive map_this = new Range.Inclusive(n, count, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            SimpleRecord simpleRecord2;
            SimpleRecord simpleRecord3 = simpleRecord2 = PartitionTest.$anonfun$testLastFetchedOffsetValidation$2(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            simpleRecord2 = null;
            simpleRecord = simpleRecord3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            simpleRecord = null;
        }
        IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var6_4 = null;
        Object var7_5 = null;
        Object var8_6 = null;
        simpleRecord = null;
        indexedSeq = null;
        IndexedSeq recordArray = indexedSeq2;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])recordArray.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)leaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        compressionType = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords2;
        log$1.appendAsLeader(records, leaderEpoch, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
    }

    private static final FetchResponseData.EpochEndOffset epochEndOffset$1(int epoch, long endOffset) {
        return new FetchResponseData.EpochEndOffset().setEpoch(epoch).setEndOffset(endOffset);
    }

    private static final LogReadInfo read$1(int lastFetchedEpoch, long fetchOffset, Partition partition$1, int leaderEpoch$1) {
        return partition$1.readRecords(Optional.of(lastFetchedEpoch), fetchOffset, Optional.of(leaderEpoch$1), Integer.MAX_VALUE, (FetchIsolation)FetchLogEnd$.MODULE$, true, true);
    }

    private static final void assertDivergence$1(FetchResponseData.EpochEndOffset divergingEpoch, LogReadInfo readInfo) {
        Assert.assertEquals((Object)new Some((Object)divergingEpoch), (Object)readInfo.divergingEpoch());
        Assert.assertEquals((long)0L, (long)readInfo.fetchedData().records().sizeInBytes());
    }

    private static final void assertNoDivergence$1(LogReadInfo readInfo) {
        Assert.assertEquals((Object)None$.MODULE$, (Object)readInfo.divergingEpoch());
    }

    public static final /* synthetic */ boolean $anonfun$testMakeFollowerWithWithFollowerAppendRecords$1(Semaphore appendSemaphore$1) {
        return appendSemaphore$1.hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testMakeFollowerWithWithFollowerAppendRecords$2() {
        return "follower log append is not called.";
    }

    private static final void assertSnapshotError$1(Errors expectedError, Optional currentLeaderEpoch, Partition partition$2) {
        try {
            partition$2.fetchOffsetSnapshot(currentLeaderEpoch, true);
            Assert.assertEquals((Object)Errors.NONE, (Object)expectedError);
            return;
        }
        catch (ApiException error) {
            Assert.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)error));
            return;
        }
    }

    private static final void assertSnapshotError$2(Errors expectedError, Optional currentLeaderEpoch, boolean fetchOnlyLeader, Partition partition$3) {
        try {
            partition$3.fetchOffsetSnapshot(currentLeaderEpoch, fetchOnlyLeader);
            Assert.assertEquals((Object)Errors.NONE, (Object)expectedError);
            return;
        }
        catch (ApiException error) {
            Assert.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)error));
            return;
        }
    }

    private static final void assertLastOffsetForLeaderError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$4) {
        EpochEndOffset endOffset = partition$4.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, true);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private static final void assertLastOffsetForLeaderError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$5) {
        EpochEndOffset endOffset = partition$5.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, fetchOnlyLeader);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private static final void assertReadRecordsError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$6) {
        try {
            partition$6.readRecords(Optional.empty(), 0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertReadRecordsError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$7) {
        try {
            partition$7.readRecords(Optional.empty(), 0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, fetchOnlyLeader, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$8) {
        try {
            partition$8.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, true);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$9) {
        try {
            partition$9.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, fetchOnlyLeader);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private final void updateFollowerFetchState$1(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset());
    }

    /*
     * WARNING - void declaration
     */
    private final Either fetchOffsetsForTimestamp$1(long timestamp, Option isolation) {
        try {
            void apply_value;
            Option option = this.partition().fetchOffsetForTimestamp(timestamp, isolation, Optional.of(this.partition().getLeaderEpoch()), true);
            if (package$.MODULE$.Right() == null) {
                throw null;
            }
            return new Right((Object)apply_value);
        }
        catch (ApiException e) {
            if (package$.MODULE$.Left() == null) {
                throw null;
            }
            return new Left((Object)e);
        }
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$3(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private final FileRecords.TimestampAndOffset fetchLatestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-1L, isolationLevel, Optional.empty(), true);
        Assert.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final FileRecords.TimestampAndOffset fetchEarliestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-2L, isolationLevel, Optional.empty(), true);
        Assert.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final void updateFollowerFetchState$2(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset());
    }

    public static final /* synthetic */ Integer $anonfun$testIsrExpansion$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testMaybeShrinkIsr$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAlterIsrUnknownTopic$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        void apply_elems;
        void apply_elems2;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)partition.isrState().isr(), (Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)partition.isrState().maximalIsr(), (Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems));
        Queue<AlterIsrItem> queue = $this.alterIsrManager().isrUpdates();
        if (queue == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$(queue), (long)0L);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAlterIsrInvalidVersion$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        void apply_elems;
        void apply_elems2;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)partition.isrState().isr(), (Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)partition.isrState().maximalIsr(), (Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems));
        Queue<AlterIsrItem> queue = $this.alterIsrManager().isrUpdates();
        if (queue == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$(queue), (long)0L);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAlterIsrUnexpectedError$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        void apply_elems;
        void apply_elems2;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)partition.isrState().isr(), (Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)partition.isrState().maximalIsr(), (Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems));
        Queue<AlterIsrItem> queue = $this.alterIsrManager().isrUpdates();
        if (queue == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$(queue), (long)1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$1(String metric$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metricName = (MetricName)x0$1._1();
        String string = metricName.getName();
        if (string == null) {
            if (metric$1 != null) {
                return false;
            }
        } else if (!string.equals(metric$1)) return false;
        String string2 = metricName.getType();
        String string3 = "Partition";
        if (string2 == null) return false;
        if (!string2.equals(string3)) return false;
        return true;
    }

    public static final /* synthetic */ Metric $anonfun$testAddAndRemoveMetrics$2(Tuple2 x$3) {
        return (Metric)x$3._2();
    }

    private static final Option getMetric$1(String metric) {
        Option option = ((IterableOps)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$1(metric, x0$1)))).headOption();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((Metric)((Tuple2)map_this.get())._2()));
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$3(String x$4) {
        return PartitionTest.getMetric$1(x$4).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$4(MetricName x$5) {
        String string = x$5.getType();
        String string2 = "Partition";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testLogConfigDirtyAsTopicUpdated$1(PartitionTest $this, InvocationOnMock invocation) {
        $this.logManager().initializingLog($this.topicPartition());
        $this.logManager().topicConfigUpdated($this.topicPartition().topic());
    }

    public static final /* synthetic */ void $anonfun$testLogConfigDirtyAsBrokerUpdated$1(PartitionTest $this, InvocationOnMock invocation) {
        $this.logManager().initializingLog($this.topicPartition());
        $this.logManager().brokerConfigUpdated();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ LogAppendInfo $anonfun$seedLogData$1(int leaderEpoch$2, Log log$2, int i) {
        void withRecords_records;
        void withRecords_compressionType;
        MemoryRecords memoryRecords;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(new StringBuilder(1).append("k").append(i).toString().getBytes(), new StringBuilder(1).append("v").append(i).toString().getBytes())};
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)leaderEpoch$2, (boolean)false, (SimpleRecord[])withRecords_records);
        compressionType = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords2;
        return log$2.appendAsLeader(records, leaderEpoch$2, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4());
    }

    public static final /* synthetic */ Object $anonfun$testMakeLeaderUpdatesEpochCache$2$adapted(Log x$1) {
        return BoxesRunTime.boxToLong((long)x$1.logEndOffset());
    }

    public static final /* synthetic */ Object $anonfun$testMakeLeaderDoesNotUpdateEpochCacheForOldFormats$2$adapted(Log x$2) {
        return BoxesRunTime.boxToLong((long)x$2.logEndOffset());
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$1(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$2$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$2(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$3$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$3(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testIsrExpansion$2$adapted(Object x) {
        return PartitionTest.$anonfun$testIsrExpansion$2(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMaybeShrinkIsr$2$adapted(Object x) {
        return PartitionTest.$anonfun$testMaybeShrinkIsr$2(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$2$adapted(Object x) {
        return PartitionTest.$anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$2(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$2$adapted(Object x) {
        return PartitionTest.$anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$2(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Object $anonfun$testAddAndRemoveMetrics$3$adapted(String x$4) {
        return BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$3(x$4));
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$seedLogData$1$adapted(int leaderEpoch$2, Log log$2, Object i) {
        return PartitionTest.$anonfun$seedLogData$1(leaderEpoch$2, log$2, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ SimpleRecord $anonfun$testLastFetchedOffsetValidation$2$adapted(Object i) {
        return PartitionTest.$anonfun$testLastFetchedOffsetValidation$2(BoxesRunTime.unboxToInt((Object)i));
    }

    public class SlowLog
    extends Log {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionTest $outer;

        public LogAppendInfo appendAsFollower(MemoryRecords records) {
            this.appendSemaphore.acquire();
            return super.appendAsFollower(records);
        }

        public /* synthetic */ PartitionTest kafka$cluster$PartitionTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionTest $outer, Log log, MockTime mockTime, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(log.dir(), log.config(), log.logStartOffset(), log.recoveryPoint(), (Scheduler)mockTime.scheduler(), new BrokerTopicStats(), log.time(), log.maxProducerIdExpirationMs(), log.producerIdExpirationCheckIntervalMs(), log.topicPartition(), log.producerStateManager(), new LogDirFailureChannel(1));
        }
    }
}

