/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kafka.raft.KafkaNetworkChannel;
import kafka.raft.KafkaNetworkChannel$;
import kafka.raft.KafkaNetworkChannelTest$;
import org.apache.kafka.clients.ApiVersion;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.RaftMessage;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.RaftResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013%!\b\u0003\u0004D\u0001\u0001\u0006Ia\u000f\u0005\b\t\u0002\u0011\r\u0011\"\u0003;\u0011\u0019)\u0005\u0001)A\u0005w!9a\t\u0001b\u0001\n\u00139\u0005BB&\u0001A\u0003%\u0001\nC\u0004M\u0001\t\u0007I\u0011B$\t\r5\u0003\u0001\u0015!\u0003I\u0011\u001dq\u0005A1A\u0005\n=Ca!\u0018\u0001!\u0002\u0013\u0001\u0006b\u00020\u0001\u0005\u0004%Ia\u0018\u0005\u0007M\u0002\u0001\u000b\u0011\u00021\t\u000f\u001d\u0004!\u0019!C\u0005Q\"1Q\u000e\u0001Q\u0001\n%DqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004t\u0001\u0001\u0006I\u0001\u001d\u0005\u0006i\u0002!\t!\u001e\u0005\u0007\u0003\u0003\u0001A\u0011A;\t\r\u0005-\u0001\u0001\"\u0001v\u0011\u0019\ty\u0001\u0001C\u0001k\"1\u00111\u0003\u0001\u0005\u0002UDq!a\u0006\u0001\t\u0013\tI\u0002\u0003\u0004\u0002 \u0001!\t!\u001e\u0005\u0007\u0003G\u0001A\u0011A;\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u0011q\t\u0001\u0005\n\u0005%\u0003bBA+\u0001\u0011%\u0011q\u000b\u0005\b\u0003;\u0002A\u0011BA0\u000f\u001d\t)'\u000bE\u0001\u0003O2a\u0001K\u0015\t\u0002\u0005%\u0004BB\u001b \t\u0003\tY\u0007C\u0005\u0002n}\u0011\r\u0011\"\u0001\u0002p!A\u0011\u0011Q\u0010!\u0002\u0013\t\tH\u0002\u0004\u0002\u0004~!\u0011Q\u0011\u0005\u0007k\r\"\t!!-\t\u000f\u0005]6\u0005\"\u0011\u0002:\"9\u0011QZ\u0012\u0005B\u0005=\u0007bBAlG\u0011\u0005\u0013\u0011\u001c\u0002\u0018\u0017\u000647.\u0019(fi^|'o[\"iC:tW\r\u001c+fgRT!AK\u0016\u0002\tI\fg\r\u001e\u0006\u0002Y\u0005)1.\u00194lC\u000e\u00011C\u0001\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u000e\t\u0003q\u0001i\u0011!K\u0001\nG2,8\u000f^3s\u0013\u0012,\u0012a\u000f\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nA\u0001\\1oO*\t\u0001)\u0001\u0003kCZ\f\u0017B\u0001\">\u0005\u0019\u0019FO]5oO\u0006Q1\r\\;ti\u0016\u0014\u0018\n\u001a\u0011\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\f\u0011b\u00197jK:$\u0018\n\u001a\u0011\u0002\u001dI,GO]=CC\u000e\\wN\u001a4NgV\t\u0001\n\u0005\u00021\u0013&\u0011!*\r\u0002\u0004\u0013:$\u0018a\u0004:fiJL()Y2l_\u001a4Wj\u001d\u0011\u0002!I,\u0017/^3tiRKW.Z8vi6\u001b\u0018!\u0005:fcV,7\u000f\u001e+j[\u0016|W\u000f^'tA\u0005!A/[7f+\u0005\u0001\u0006CA)\\\u001b\u0005\u0011&BA*U\u0003\u0015)H/\u001b7t\u0015\t)f+\u0001\u0004d_6lwN\u001c\u0006\u0003Y]S!\u0001W-\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0016aA8sO&\u0011AL\u0015\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u000511\r\\5f]R,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003GZ\u000bqa\u00197jK:$8/\u0003\u0002fE\nQQj\\2l\u00072LWM\u001c;\u0002\u000f\rd\u0017.\u001a8uA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tW#A5\u0011\u0005)\\W\"\u0001+\n\u00051$&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u000591\r[1o]\u0016dW#\u00019\u0011\u0005a\n\u0018B\u0001:*\u0005MY\u0015MZ6b\u001d\u0016$xo\u001c:l\u0007\"\fgN\\3m\u0003!\u0019\u0007.\u00198oK2\u0004\u0013AE:fiV\u00048+\u001e9q_J$X\rZ!qSN$\u0012A\u001e\t\u0003a]L!\u0001_\u0019\u0003\tUs\u0017\u000e\u001e\u0015\u0003%i\u0004\"a\u001f@\u000e\u0003qT!!`-\u0002\u000b),h.\u001b;\n\u0005}d(A\u0002\"fM>\u0014X-\u0001\u000fuKN$8+\u001a8e)>,fn\u001b8po:$Um\u001d;j]\u0006$\u0018n\u001c8)\u0007M\t)\u0001E\u0002|\u0003\u000fI1!!\u0003}\u0005\u0011!Vm\u001d;\u0002?Q,7\u000f^*f]\u0012$vN\u00117bG.,GmT;u\t\u0016\u001cH/\u001b8bi&|g\u000eK\u0002\u0015\u0003\u000b\tQ\u0003^3tiN+g\u000eZ!oI\u0012K7oY8o]\u0016\u001cG\u000fK\u0002\u0016\u0003\u000b\tQ\u0004^3tiN+g\u000eZ!oI\u001a\u000b\u0017\u000e\\!vi\",g\u000e^5dCRLwN\u001c\u0015\u0004-\u0005\u0015\u0011\u0001G1tg\u0016\u0014HO\u0011:pW\u0016\u0014hj\u001c;Bm\u0006LG.\u00192mKR\u0019a/a\u0007\t\r\u0005uq\u00031\u0001I\u00035!Wm\u001d;j]\u0006$\u0018n\u001c8JI\u0006\tC/Z:u'\u0016tG-\u00118e%\u0016\u001cW-\u001b<f\u001fV$(m\\;oIJ+\u0017/^3ti\"\u001a\u0001$!\u0002\u0002AQ,7\u000f\u001e*fG\u0016Lg/Z!oIN+g\u000eZ%oE>,h\u000e\u001a*fcV,7\u000f\u001e\u0015\u00043\u0005\u0015\u0011AG:f]\u0012\fe\u000eZ!tg\u0016\u0014H/\u0012:s_J\u0014Vm\u001d9p]N,Gc\u0002<\u0002,\u0005m\u0012Q\b\u0005\b\u0003[Q\u0002\u0019AA\u0018\u0003\u0019\t\u0007/[&fsB!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026Q\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003s\t\u0019DA\u0004Ba&\\U-_:\t\r\u0005u!\u00041\u0001I\u0011\u001d\tyD\u0007a\u0001\u0003\u0003\nQ!\u001a:s_J\u0004B!!\r\u0002D%!\u0011QIA\u001a\u0005\u0019)%O]8sg\u0006\u0001\"-^5mIR+7\u000f\u001e*fcV,7\u000f\u001e\u000b\u0005\u0003\u0017\n\t\u0006\u0005\u0003\u00022\u00055\u0013\u0002BA(\u0003g\u0011!\"\u00119j\u001b\u0016\u001c8/Y4f\u0011\u001d\t\u0019f\u0007a\u0001\u0003_\t1a[3z\u0003Y\u0011W/\u001b7e)\u0016\u001cH/\u0012:s_J\u0014Vm\u001d9p]N,GCBA&\u00033\nY\u0006C\u0004\u0002Tq\u0001\r!a\f\t\u000f\u0005}B\u00041\u0001\u0002B\u0005aQ\r\u001f;sC\u000e$XI\u001d:peR!\u0011\u0011IA1\u0011\u001d\t\u0019'\ba\u0001\u0003\u0017\n\u0001B]3ta>t7/Z\u0001\u0018\u0017\u000647.\u0019(fi^|'o[\"iC:tW\r\u001c+fgR\u0004\"\u0001O\u0010\u0014\u0005}yCCAA4\u0003!\u0011\u0016M\u001a;Ba&\u001cXCAA9!\u0019\t\u0019(! \u000205\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(A\u0005j[6,H/\u00192mK*\u0019\u00111P\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0000\u0005U$aA*fc\u0006I!+\u00194u\u0003BL7\u000f\t\u0002\u0014'R,(-T3uC\u0012\fG/Y+qI\u0006$XM]\n\u0006G\u0005\u001d\u0015Q\u0012\t\u0004y\u0005%\u0015bAAF{\t1qJ\u00196fGR\u0004B!a$\u0002,:!\u0011\u0011SAT\u001d\u0011\t\u0019*!*\u000f\t\u0005U\u00151\u0015\b\u0005\u0003/\u000b\tK\u0004\u0003\u0002\u001a\u0006}UBAAN\u0015\r\ti*L\u0001\u0007yI|w\u000e\u001e \n\u0003iK!\u0001W-\n\u00051:\u0016BA2W\u0013\r\tIKY\u0001\u000b\u001b>\u001c7n\u00117jK:$\u0018\u0002BAW\u0003_\u00131#T8dW6+G/\u00193bi\u0006,\u0006\u000fZ1uKJT1!!+c)\t\t\u0019\fE\u0002\u00026\u000ej\u0011aH\u0001\u000bM\u0016$8\r\u001b(pI\u0016\u001cHCAA^!\u0019\ti,a1\u0002H6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003|\u0014\u0001B;uS2LA!!2\u0002@\n!A*[:u!\rQ\u0017\u0011Z\u0005\u0004\u0003\u0017$&\u0001\u0002(pI\u0016\fa\"[:Va\u0012\fG/\u001a(fK\u0012,G\r\u0006\u0002\u0002RB\u0019\u0001'a5\n\u0007\u0005U\u0017GA\u0004C_>dW-\u00198\u0002\rU\u0004H-\u0019;f)\u00151\u00181\\Ar\u0011\u0019qu\u00051\u0001\u0002^B\u0019\u0011+a8\n\u0007\u0005\u0005(K\u0001\u0003US6,\u0007bBAlO\u0001\u0007\u0011Q\u001d\t\u0005\u0003O\fIOD\u0002b\u0003OKA!a;\u00020\nqQ*\u001a;bI\u0006$\u0018-\u00169eCR,\u0007")
public class KafkaNetworkChannelTest {
    private final String clusterId;
    private final String clientId;
    private final int retryBackoffMs;
    private final int requestTimeoutMs;
    private final MockTime time = new MockTime();
    private final MockClient client = new MockClient((Time)this.time(), (MockClient.MockMetadataUpdater)new StubMetadataUpdater());
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final KafkaNetworkChannel channel = new KafkaNetworkChannel((Time)this.time(), (KafkaClient)this.client(), this.clientId(), this.retryBackoffMs(), this.requestTimeoutMs());

    public static scala.collection.immutable.Seq<ApiKeys> RaftApis() {
        return KafkaNetworkChannelTest$.MODULE$.RaftApis();
    }

    private String clusterId() {
        return this.clusterId;
    }

    private String clientId() {
        return this.clientId;
    }

    private int retryBackoffMs() {
        return this.retryBackoffMs;
    }

    private int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    private MockTime time() {
        return this.time;
    }

    private MockClient client() {
        return this.client;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private KafkaNetworkChannel channel() {
        return this.channel;
    }

    @Before
    public void setupSupportedApis() {
        scala.collection.immutable.Seq supportedApis = (scala.collection.immutable.Seq)KafkaNetworkChannelTest$.MODULE$.RaftApis().map((Function1 & Serializable)api -> new ApiVersion(api));
        this.client().setNodeApiVersions(NodeApiVersions.create((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)supportedApis).asJava()));
    }

    @Test
    public void testSendToUnknownDestination() {
        int destinationId = 2;
        this.assertBrokerNotAvailable(destinationId);
    }

    @Test
    public void testSendToBlackedOutDestination() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.channel().updateEndpoint(destinationId, new InetSocketAddress(destinationNode.host(), destinationNode.port()));
        this.client().backoff(destinationNode, 500L);
        this.assertBrokerNotAvailable(destinationId);
    }

    @Test
    public void testSendAndDisconnect() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.channel().updateEndpoint(destinationId, new InetSocketAddress(destinationNode.host(), destinationNode.port()));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testSendAndDisconnect$1(this, destinationNode, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testSendAndFailAuthentication() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.channel().updateEndpoint(destinationId, new InetSocketAddress(destinationNode.host(), destinationNode.port()));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testSendAndFailAuthentication$1(this, destinationNode, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    private void assertBrokerNotAvailable(int destinationId) {
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable)apiKey -> {
            this.sendAndAssertErrorResponse(apiKey, destinationId, Errors.BROKER_NOT_AVAILABLE);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testSendAndReceiveOutboundRequest() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.channel().updateEndpoint(destinationId, new InetSocketAddress(destinationNode.host(), destinationNode.port()));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testSendAndReceiveOutboundRequest$1(this, destinationNode, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testReceiveAndSendInboundRequest() {
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testReceiveAndSendInboundRequest$1(this, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    private void sendAndAssertErrorResponse(ApiKeys apiKey, int destinationId, Errors error) {
        int correlationId = this.channel().newCorrelationId();
        long createdTimeMs = this.time().milliseconds();
        ApiMessage apiRequest = this.buildTestRequest(apiKey);
        RaftRequest.Outbound request = new RaftRequest.Outbound(correlationId, apiRequest, destinationId, createdTimeMs);
        this.channel().send((RaftMessage)request);
        Buffer responses = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)this.channel().receive(1000L)).asScala();
        if (responses == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)responses.length());
        RaftResponse.Inbound response = (RaftResponse.Inbound)responses.head();
        Assert.assertEquals((long)destinationId, (long)response.sourceId());
        Assert.assertEquals((long)correlationId, (long)response.correlationId());
        Assert.assertEquals((Object)apiKey, (Object)ApiKeys.forId((int)response.data().apiKey()));
        Assert.assertEquals((Object)error, (Object)this.extractError(response.data()));
    }

    private ApiMessage buildTestRequest(ApiKeys key) {
        BeginQuorumEpochRequestData beginQuorumEpochRequestData;
        int leaderEpoch = 5;
        int leaderId = 1;
        if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(key)) {
            beginQuorumEpochRequestData = BeginQuorumEpochRequest.singletonRequest((TopicPartition)this.topicPartition(), (String)this.clusterId(), (int)leaderEpoch, (int)leaderId);
        } else if (ApiKeys.END_QUORUM_EPOCH.equals(key)) {
            int replicaId = 1;
            beginQuorumEpochRequestData = EndQuorumEpochRequest.singletonRequest((TopicPartition)this.topicPartition(), (String)this.clusterId(), (int)replicaId, (int)leaderId, (int)leaderEpoch, Collections.singletonList(2));
        } else if (ApiKeys.VOTE.equals(key)) {
            int lastEpoch = 4;
            beginQuorumEpochRequestData = VoteRequest.singletonRequest((TopicPartition)this.topicPartition(), (String)this.clusterId(), (int)leaderEpoch, (int)leaderId, (int)lastEpoch, (long)329L);
        } else if (ApiKeys.FETCH.equals(key)) {
            TopicPartition singletonFetchRequest_topicPartition = this.topicPartition();
            FetchRequestData.FetchPartition singletonFetchRequest_fetchPartition = new FetchRequestData.FetchPartition().setPartition(singletonFetchRequest_topicPartition.partition());
            KafkaNetworkChannelTest.$anonfun$buildTestRequest$1(singletonFetchRequest_fetchPartition);
            FetchRequestData.FetchTopic singletonFetchRequest_fetchTopic = new FetchRequestData.FetchTopic().setTopic(singletonFetchRequest_topicPartition.topic()).setPartitions(Collections.singletonList(singletonFetchRequest_fetchPartition));
            Object var7_7 = null;
            Object var8_8 = null;
            Object var9_9 = null;
            beginQuorumEpochRequestData = new FetchRequestData().setTopics(Collections.singletonList(singletonFetchRequest_fetchTopic)).setReplicaId(1);
        } else {
            throw new AssertionError((Object)new StringBuilder(15).append("Unexpected api ").append(key).toString());
        }
        return beginQuorumEpochRequestData;
    }

    private ApiMessage buildTestErrorResponse(ApiKeys key, Errors error) {
        BeginQuorumEpochResponseData beginQuorumEpochResponseData;
        if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(key)) {
            beginQuorumEpochResponseData = new BeginQuorumEpochResponseData().setErrorCode(error.code());
        } else if (ApiKeys.END_QUORUM_EPOCH.equals(key)) {
            beginQuorumEpochResponseData = new EndQuorumEpochResponseData().setErrorCode(error.code());
        } else if (ApiKeys.VOTE.equals(key)) {
            beginQuorumEpochResponseData = VoteResponse.singletonResponse((Errors)error, (TopicPartition)this.topicPartition(), (Errors)Errors.NONE, (int)1, (int)5, (boolean)false);
        } else if (ApiKeys.FETCH.equals(key)) {
            beginQuorumEpochResponseData = new FetchResponseData().setErrorCode(error.code());
        } else {
            throw new AssertionError((Object)new StringBuilder(15).append("Unexpected api ").append(key).toString());
        }
        return beginQuorumEpochResponseData;
    }

    private Errors extractError(ApiMessage response) {
        short s;
        if (response instanceof BeginQuorumEpochResponseData) {
            s = ((BeginQuorumEpochResponseData)response).errorCode();
        } else if (response instanceof EndQuorumEpochResponseData) {
            s = ((EndQuorumEpochResponseData)response).errorCode();
        } else if (response instanceof FetchResponseData) {
            s = ((FetchResponseData)response).errorCode();
        } else if (response instanceof VoteResponseData) {
            s = ((VoteResponseData)response).errorCode();
        } else {
            throw new MatchError((Object)response);
        }
        return Errors.forCode((short)s);
    }

    public static final /* synthetic */ void $anonfun$testSendAndDisconnect$1(KafkaNetworkChannelTest $this, Node destinationNode$1, int destinationId$1, ApiKeys apiKey) {
        AbstractResponse response = KafkaNetworkChannel$.MODULE$.buildResponse($this.buildTestErrorResponse(apiKey, Errors.INVALID_REQUEST));
        $this.client().prepareResponseFrom(response, destinationNode$1, true);
        $this.sendAndAssertErrorResponse(apiKey, destinationId$1, Errors.BROKER_NOT_AVAILABLE);
    }

    public static final /* synthetic */ void $anonfun$testSendAndFailAuthentication$1(KafkaNetworkChannelTest $this, Node destinationNode$2, int destinationId$2, ApiKeys apiKey) {
        $this.client().createPendingAuthenticationError(destinationNode$2, 100L);
        $this.sendAndAssertErrorResponse(apiKey, destinationId$2, Errors.CLUSTER_AUTHORIZATION_FAILED);
        $this.client().reset();
    }

    public static final /* synthetic */ void $anonfun$testSendAndReceiveOutboundRequest$1(KafkaNetworkChannelTest $this, Node destinationNode$3, int destinationId$4, ApiKeys apiKey) {
        Errors expectedError = Errors.INVALID_REQUEST;
        AbstractResponse response = KafkaNetworkChannel$.MODULE$.buildResponse($this.buildTestErrorResponse(apiKey, expectedError));
        $this.client().prepareResponseFrom(response, destinationNode$3);
        $this.sendAndAssertErrorResponse(apiKey, destinationId$4, expectedError);
    }

    public static final /* synthetic */ void $anonfun$testReceiveAndSendInboundRequest$1(KafkaNetworkChannelTest $this, ApiKeys apiKey) {
        AbstractRequest request = KafkaNetworkChannel$.MODULE$.buildRequest($this.buildTestRequest(apiKey)).build();
        AtomicReference responseRef = new AtomicReference();
        int correlationId = 15;
        RequestHeader header = new RequestHeader(apiKey, request.version(), "clientId", correlationId);
        $this.channel().postInboundRequest(header, request, (Function1 & Serializable)x$1 -> {
            responseRef.set(x$1);
            return BoxedUnit.UNIT;
        });
        Buffer inbound = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)$this.channel().receive(1000L)).asScala();
        if (inbound == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)inbound.length());
        RaftRequest.Inbound inboundRequest = (RaftRequest.Inbound)inbound.head();
        Assert.assertEquals((long)correlationId, (long)inboundRequest.correlationId());
        ApiMessage errorResponse = $this.buildTestErrorResponse(apiKey, Errors.INVALID_REQUEST);
        RaftResponse.Outbound outboundResponse = new RaftResponse.Outbound(correlationId, errorResponse);
        $this.channel().send((RaftMessage)outboundResponse);
        $this.channel().receive(1000L);
        Assert.assertNotNull(responseRef.get());
        Assert.assertEquals((Object)Errors.INVALID_REQUEST, (Object)$this.extractError(KafkaNetworkChannel$.MODULE$.responseData((AbstractResponse)responseRef.get())));
    }

    public static final /* synthetic */ void $anonfun$buildTestRequest$1(FetchRequestData.FetchPartition fetchPartition) {
        fetchPartition.setCurrentLeaderEpoch(5).setFetchOffset(333L).setLastFetchedEpoch(5);
    }

    public KafkaNetworkChannelTest() {
        this.clusterId = "clusterId";
        this.clientId = "clientId";
        this.retryBackoffMs = 100;
        this.requestTimeoutMs = 30000;
    }

    public static class StubMetadataUpdater
    implements MockClient.MockMetadataUpdater {
        public void updateWithCurrentMetadata(Time x$1) {
            super.updateWithCurrentMetadata(x$1);
        }

        public void close() {
            super.close();
        }

        public List<Node> fetchNodes() {
            return Collections.emptyList();
        }

        public boolean isUpdateNeeded() {
            return false;
        }

        public void update(Time time, MockClient.MetadataUpdate update) {
        }
    }
}

