/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\u0002-Bq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004B\u0001\u0001\u0006Ia\u000f\u0005\b\u0005\u0002\u0001\r\u0011\"\u0001D\u0011\u001d\u0019\u0006\u00011A\u0005\u0002QCaA\u0017\u0001!B\u0013!\u0005bB.\u0001\u0005\u0004%\t\u0001\u0018\u0005\u0007K\u0002\u0001\u000b\u0011B/\t\u000f\u0019\u0004\u0001\u0019!C\u0001O\"9A\u000f\u0001a\u0001\n\u0003)\bBB<\u0001A\u0003&\u0001\u000eC\u0003y\u0001\u0011\u0005\u0013\u0010\u0003\u0004\u0002\f\u0001!\t!\u001f\u0005\u0007\u0003+\u0001A\u0011A=\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002BBA\u001e\u0001\u0011\u0005\u0011\u0010C\u0004\u0002@\u0001!\t!!\u0011\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N!9\u00111\f\u0001\u0005\n\u0005u\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003[\u0002A\u0011BA8\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u000b\u0013QCU3qY&\u001c\u0017\r^5p]F+x\u000e^1t)\u0016\u001cHO\u0003\u0002\u001c9\u000511/\u001a:wKJT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"I5\t!E\u0003\u0002$9\u0005\u0011!p[\u0005\u0003K\t\u0012ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u001b\u00031\u0001XM]2f]R,%O]8s)\ra#g\u000e\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0005\u0019>tw\rC\u00034\u0005\u0001\u0007A'A\u0004qKJ\u001cWM\u001c;\u0011\u00055*\u0014B\u0001\u001c/\u0005\rIe\u000e\u001e\u0005\u0006q\t\u0001\r\u0001L\u0001\u0006m\u0006dW/Z\u0001\t[N<\u0017\u0007\r\u0019L\u0005V\t1\bE\u0002.yyJ!!\u0010\u0018\u0003\u000b\u0005\u0013(/Y=\u0011\u00055z\u0014B\u0001!/\u0005\u0011\u0011\u0015\u0010^3\u0002\u00135\u001cx-\r\u00191\u0017\n\u0003\u0013a\u00022s_.,'o]\u000b\u0002\tB\u0019Q)\u0014)\u000f\u0005\u0019[eBA$K\u001b\u0005A%BA%\u001f\u0003\u0019a$o\\8u}%\tq&\u0003\u0002M]\u00059\u0001/Y2lC\u001e,\u0017B\u0001(P\u0005\r\u0019V-\u001d\u0006\u0003\u0019:\u0002\"!K)\n\u0005IS\"aC&bM.\f7+\u001a:wKJ\f1B\u0019:pW\u0016\u00148o\u0018\u0013fcR\u0011Q\u000b\u0017\t\u0003[YK!a\u0016\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b3\u001a\t\t\u00111\u0001E\u0003\rAH%M\u0001\tEJ|7.\u001a:tA\u0005)Ao\u001c9jGV\tQ\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006!A.\u00198h\u0015\u0005\u0011\u0017\u0001\u00026bm\u0006L!\u0001Z0\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005A\u0001O]8ek\u000e,'/F\u0001i!\u0011I'oO\u001e\u000e\u0003)T!AZ6\u000b\u00051l\u0017aB2mS\u0016tGo\u001d\u0006\u0003;9T!a\u001c9\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0018aA8sO&\u00111O\u001b\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0005U3\bbB-\f\u0003\u0003\u0005\r\u0001[\u0001\naJ|G-^2fe\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002+\"\u0012Qb\u001f\t\u0004y\u0006\u001dQ\"A?\u000b\u0005y|\u0018aA1qS*!\u0011\u0011AA\u0002\u0003\u001dQW\u000f]5uKJT1!!\u0002q\u0003\u0015QWO\\5u\u0013\r\tI! \u0002\n\u0003\u001a$XM]#bG\"\f1f\u001d5pk2$'i\\8ugR\u0014\u0018\r\u001d+x_\n\u0013xn[3sg^KG\u000f\u001b'fC\u0012,'\u000f\u00165s_R$H.\u001a\u0015\u0004\u001d\u0005=\u0001c\u0001?\u0002\u0012%\u0019\u00111C?\u0003\tQ+7\u000f^\u0001.g\"|W\u000f\u001c3C_>$8\u000f\u001e:baR;xN\u0011:pW\u0016\u00148oV5uQ\u001a{G\u000e\\8xKJ$\u0006N]8ui2,\u0007fA\b\u0002\u0010\u000514\u000f[8vY\u0012l\u0015\r^2i#V|G/\u0019*fa2L7-\u0019;j]\u001e$\u0006N]8vO\"\fe.Q:z[6,GO]5d)>\u0004x\u000e\\8hsR\u0019Q+!\b\t\u000f\u0005}\u0001\u00031\u0001\u0002\"\u0005qA.Z1eKJ$\u0006N]8ui2,\u0007cA\u0017\u0002$%\u0019\u0011Q\u0005\u0018\u0003\u000f\t{w\u000e\\3b]\u0006\u0011A\u000f\u001d\u000b\u0005\u0003W\t9\u0004\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t$\\\u0001\u0007G>lWn\u001c8\n\t\u0005U\u0012q\u0006\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\tI$\u0005a\u0001i\u0005I\u0001/\u0019:uSRLwN\\\u0001\u001ag\"|W\u000f\u001c3UQJ|G\u000f\u001e7f\u001f2$7+Z4nK:$8\u000fK\u0002\u0013\u0003\u001f\tq!\u00193e\t\u0006$\u0018\rF\u0003V\u0003\u0007\n9\u0005\u0003\u0004\u0002FM\u0001\r\u0001N\u0001\t[N<7i\\;oi\"1\u0011\u0011J\nA\u0002m\n1!\\:h\u0003U9\u0018-\u001b;G_J|eMZ:fiN$v.T1uG\"$r!VA(\u0003'\n9\u0006\u0003\u0004\u0002RQ\u0001\r\u0001N\u0001\u0007_\u001a47/\u001a;\t\r\u0005UC\u00031\u00015\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\r\u0005eC\u00031\u00015\u0003!\u0011'o\\6fe&#\u0017!\u00032s_.,'OR8s)\r\u0001\u0016q\f\u0005\u0007\u0003C*\u0002\u0019\u0001\u001b\u0002\u0005%$\u0017!D2sK\u0006$XM\u0011:pW\u0016\u00148\u000fF\u0002V\u0003OBq!!\u001b\u0017\u0001\u0004\tY'A\u0005ce>\\WM]%egB\u0019Q)\u0014\u001b\u0002\r\u00054(+\u0019;f)\u0019\t\t(a\u001e\u0002\u0002B\u0019Q&a\u001d\n\u0007\u0005UdF\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003s:\u0002\u0019AA>\u0003=\u0011X\r\u001d7jG\u0006$\u0018n\u001c8UsB,\u0007cA\u0015\u0002~%\u0019\u0011q\u0010\u000e\u0003\u0013E+x\u000e^1UsB,\u0007B\u0002\"\u0018\u0001\u0004\tY'\u0001\u0007nK\u0006\u001cXO]3e%\u0006$X\r\u0006\u0004\u0002r\u0005\u001d\u00151\u0012\u0005\u0007\u0003\u0013C\u0002\u0019\u0001)\u0002\r\t\u0014xn[3s\u0011\u001d\ti\t\u0007a\u0001\u0003w\nqA]3q)f\u0004X\r")
public class ReplicationQuotasTest
extends ZooKeeperTestHarness {
    private final byte[] msg100KB = new byte[100000];
    private scala.collection.immutable.Seq<KafkaServer> brokers = null;
    private final String topic;
    private KafkaProducer<byte[], byte[]> producer = null;

    public long percentError(int percent, long value) {
        return Math.round((double)(value * (long)percent) / 100.0);
    }

    public byte[] msg100KB() {
        return this.msg100KB;
    }

    public scala.collection.immutable.Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(scala.collection.immutable.Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.brokers());
        super.tearDown();
    }

    @Test
    public void shouldBootstrapTwoBrokersWithLeaderThrottle() {
        this.shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(true);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithFollowerThrottle() {
        this.shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(false);
    }

    public void shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(boolean leaderThrottle) {
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 105).map((Function1 & Serializable)id -> ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$1(this, BoxesRunTime.unboxToInt((Object)id))));
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{101, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{102, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{103, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{104, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{105, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{101, 107})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)assignment, (Seq<KafkaServer>)this.brokers());
        byte[] msg = this.msg100KB();
        int msgCount = 100;
        int expectedDuration = 10;
        LongRef throttle = LongRef.create((long)(msgCount * msg.length / expectedDuration));
        if (!leaderThrottle) {
            throttle.elem *= 3L;
        }
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> this.adminZkClient().changeBrokerConfig((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})), CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)Long.toString(throttle$1.elem)), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(throttle$1.elem))}))));
        if (leaderThrottle) {
            this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:100,1:101,2:102,3:103,4:104,5:105"));
        } else {
            this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "0:106,1:106,2:106,3:107,4:107,5:107"));
        }
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.brokers(), SecurityProtocol.PLAINTEXT), 1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), msgCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable)partition -> ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$4(this, msg, BoxesRunTime.unboxToInt((Object)partition))));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 100 + id));
        this.waitForOffsetsToMatch(msgCount, 6, 100);
        this.waitForOffsetsToMatch(msgCount, 7, 101);
        long start = System.currentTimeMillis();
        this.createBrokers((scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertEquals((long)throttle$1.elem, (long)this.brokerFor(brokerId).quotaManagers().follower().upperBound()));
        if (!leaderThrottle) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> Assertions.assertTrue((boolean)this.brokerFor(106).quotaManagers().follower().isThrottled(this.tp(partition))));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> Assertions.assertTrue((boolean)this.brokerFor(107).quotaManagers().follower().isThrottled(this.tp(partition))));
        }
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(6), 7).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 100 + id));
        long unthrottledTook = System.currentTimeMillis() - start;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 106));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 107));
        long throttledTook = System.currentTimeMillis() - start;
        double throttledLowerBound = (double)(expectedDuration * 1000) * 0.9;
        int throttledUpperBound = expectedDuration * 1000 * 3;
        Assertions.assertTrue(((double)unthrottledTook < throttledLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(unthrottledTook).append(" < ").append(throttledLowerBound).toString());
        Assertions.assertTrue(((double)throttledTook > throttledLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(throttledTook).append(" > ").append(throttledLowerBound).toString());
        Assertions.assertTrue((throttledTook < (long)throttledUpperBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(throttledTook).append(" < ").append(throttledUpperBound).toString());
        double rateUpperBound = (double)throttle.elem * 1.1;
        double rateLowerBound = (double)throttle.elem * 0.5;
        double rate = leaderThrottle ? this.avRate((QuotaType)QuotaType.LeaderReplication$.MODULE$, (scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 105)) : this.avRate((QuotaType)QuotaType.FollowerReplication$.MODULE$, (scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107));
        Assertions.assertTrue((rate < rateUpperBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(rate).append(" < ").append(rateUpperBound).toString());
        Assertions.assertTrue((rate > rateLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(rate).append(" > ").append(rateLowerBound).toString());
    }

    public TopicPartition tp(int partition) {
        return new TopicPartition(this.topic(), partition);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldThrottleOldSegments() {
        void createServer_time;
        void createServer_config;
        Time time;
        void createServer_time2;
        void createServer_config2;
        Time time2;
        Properties config = TestUtils$.MODULE$.createBrokerConfig(100, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        config.put("log.segment.bytes", Integer.toString(0x100000));
        Object[] objectArray = new KafkaServer[1];
        Time time3 = time2 = Time.SYSTEM;
        time2 = null;
        Time time4 = time3;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(config);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var14_6 = null;
        Object var11_5 = null;
        kafkaConfig = null;
        time4 = null;
        objectArray[0] = createServer_this.createServer((KafkaConfig)createServer_config2, (Time)createServer_time2, (Option<String>)createServer_createServer_threadNamePrefix, false);
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), (Seq<KafkaServer>)this.brokers());
        byte[] msg = this.msg100KB();
        int msgCount = 200;
        int expectedDuration = 4;
        long throttle = msg.length * msgCount / expectedDuration;
        this.adminZkClient().changeBrokerConfig((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), Long.toString(throttle)));
        this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:100"));
        this.addData(msgCount, msg);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting new broker");
        Time time5 = time = Time.SYSTEM;
        time = null;
        Time time6 = time5;
        KafkaConfig kafkaConfig2 = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(101, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        TestUtils$ createServer_this2 = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix2 = None$.MODULE$;
        Object var18_15 = null;
        Object var15_14 = null;
        kafkaConfig2 = null;
        time6 = null;
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)this.brokers().$colon$plus((Object)createServer_this2.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix2, false))));
        long start = System.currentTimeMillis();
        this.waitForOffsetsToMatch(msgCount, 0, 101);
        long throttledTook = System.currentTimeMillis() - start;
        Assertions.assertTrue(((double)throttledTook > (double)(expectedDuration * 1000) * 0.9 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be > ").append((double)(expectedDuration * 1000) * 0.9).append("ms").toString());
        Assertions.assertTrue(((double)throttledTook < (double)(expectedDuration * 1000) * 1.5 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be < ").append(expectedDuration * 1500).append("ms").toString());
    }

    public void addData(int msgCount, byte[] msg) {
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.brokers(), SecurityProtocol.PLAINTEXT), 0, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), msgCount).map((Function1 & Serializable)x$2 -> ReplicationQuotasTest.$anonfun$addData$1(this, msg, BoxesRunTime.unboxToInt((Object)x$2))).foreach((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get());
        this.waitForOffsetsToMatch(msgCount, 0, 100);
    }

    private void waitForOffsetsToMatch(int offset, int partitionId, int brokerId) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$1(this, offset, brokerId, partitionId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$4(partitionId, brokerId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
    }

    private KafkaServer brokerFor(int id) {
        return (KafkaServer)((IterableOps)this.brokers().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicationQuotasTest.$anonfun$brokerFor$1(id, x$5)))).head();
    }

    public void createBrokers(scala.collection.immutable.Seq<Object> brokerIds) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)id -> {
            void createServer_time;
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time time3 = time2;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            Object var5_6 = null;
            Object var2_5 = null;
            Object var3_4 = null;
            time3 = null;
            this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)this.brokers().$colon$plus((Object)createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false))));
        });
    }

    private double avRate(QuotaType replicationType, scala.collection.immutable.Seq<Object> brokers) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)brokers.map((Function1 & Serializable)id -> this.brokerFor(BoxesRunTime.unboxToInt((Object)id)))).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)this.measuredRate(x$6, replicationType)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)brokers.length();
    }

    private double measuredRate(KafkaServer broker, QuotaType repType) {
        MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
        return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)CollectionConverters$.MODULE$.MapHasAsScala(broker.metrics().metrics()).asScala().apply((Object)metricName)).metricValue());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ KafkaServer $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$1(ReplicationQuotasTest $this, int id) {
        void createServer_time;
        Time time;
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(id, $this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
    }

    public static final /* synthetic */ Future $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$4(ReplicationQuotasTest $this, byte[] msg$1, int partition) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)msg$1));
    }

    public static final /* synthetic */ Future $anonfun$addData$1(ReplicationQuotasTest $this, byte[] msg$2, int x$2) {
        return $this.producer().send(new ProducerRecord($this.topic(), (Object)msg$2));
    }

    public static final /* synthetic */ boolean $anonfun$waitForOffsetsToMatch$1(ReplicationQuotasTest $this, int offset$1, int brokerId$1, int partitionId$1) {
        LogManager qual$1 = $this.brokerFor(brokerId$1).getLogManager();
        TopicPartition x$1 = new TopicPartition($this.topic(), partitionId$1);
        boolean x$2 = qual$1.getLog$default$2();
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)offset$1), (Object)qual$1.getLog(x$1, x$2).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.logEndOffset())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public static final /* synthetic */ String $anonfun$waitForOffsetsToMatch$4(int partitionId$1, int brokerId$1) {
        return new StringBuilder(47).append("Offsets did not match for partition ").append(partitionId$1).append(" on broker ").append(brokerId$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$brokerFor$1(int id$1, KafkaServer x$5) {
        return x$5.config().brokerId() == id$1;
    }

    public ReplicationQuotasTest() {
        this.topic = "topic1";
    }
}

