/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001B\u000f\u001f\u0001\rBQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004=\u0001\u0001\u0006IA\u000e\u0005\b{\u0001\u0011\r\u0011\"\u00016\u0011\u0019q\u0004\u0001)A\u0005m!9q\b\u0001b\u0001\n\u0003\u0001\u0005BB%\u0001A\u0003%\u0011\tC\u0004K\u0001\t\u0007I\u0011A&\t\rI\u0003\u0001\u0015!\u0003M\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u001d\t\u0007A1A\u0005\u0002UBaA\u0019\u0001!\u0002\u00131\u0004\"B2\u0001\t\u0003!\u0007bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0004\u0002N\u0001!\t!a\u0014\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0004bBA9\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003{\u0002A\u0011AA@\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017Cq!!&\u0001\t\u0003\t9\nC\u0004\u0002\"\u0002!\t!a)\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAd\u0001\u0011%\u0011\u0011\u001a\u0002\f\u001b\u0016$(/[2t)\u0016\u001cHO\u0003\u0002 A\u00059Q.\u001a;sS\u000e\u001c(\"A\u0011\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d\u0002\u0013aC5oi\u0016<'/\u0019;j_:L!!\u000b\u0014\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\u0004\"a\u000b\u0018\u000e\u00031R!!\f\u0011\u0002\u000bU$\u0018\u000e\\:\n\u0005=b#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0002\"a\r\u0001\u000e\u0003y\t\u0001B\\;n\u001d>$Wm]\u000b\u0002mA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t\u0019\u0011J\u001c;\u0002\u00139,XNT8eKN\u0004\u0013\u0001\u00038v[B\u000b'\u000f^:\u0002\u00139,X\u000eU1siN\u0004\u0013!\u0007:fcVL'/\u001a3LC\u001a\\\u0017mU3sm\u0016\u0014\bK]3gSb,\u0012!\u0011\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bA\u0001\\1oO*\ta)\u0001\u0003kCZ\f\u0017B\u0001%D\u0005\u0019\u0019FO]5oO\u0006Q\"/Z9vSJ,GmS1gW\u0006\u001cVM\u001d<feB\u0013XMZ5yA\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001M!\ti\u0005+D\u0001O\u0015\tyU)\u0001\u0003vi&d\u0017BA)O\u0005)\u0001&o\u001c9feRLWm]\u0001\u0011_Z,'O]5eS:<\u0007K]8qg\u0002\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002+B\u0019a+W.\u000e\u0003]S!\u0001\u0017\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002[/\n\u00191+Z9\u0011\u0005q{V\"A/\u000b\u0005y\u0003\u0013AB:feZ,'/\u0003\u0002a;\nY1*\u00194lC\u000e{gNZ5h\u0003%qW*Z:tC\u001e,7/\u0001\u0006o\u001b\u0016\u001c8/Y4fg\u0002\nQ\u0005^3ti6+GO]5dgJ+\u0007o\u001c:uKJ\fe\r^3s\t\u0016dW\r^5oOR{\u0007/[2\u0015\u0005\u0015D\u0007CA\u001cg\u0013\t9\u0007H\u0001\u0003V]&$\b\"B5\u000e\u0001\u0004Q\u0017AB9v_J,X\u000e\u0005\u0002le:\u0011A\u000e\u001d\t\u0003[bj\u0011A\u001c\u0006\u0003_\n\na\u0001\u0010:p_Rt\u0014BA99\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001j\u001d\u0006\u0003cbBc!D;\u0002\b\u0005%\u0001c\u0001<\u0002\u00045\tqO\u0003\u0002ys\u0006A\u0001O]8wS\u0012,'O\u0003\u0002{w\u00061\u0001/\u0019:b[NT!\u0001`?\u0002\u000f),\b/\u001b;fe*\u0011ap`\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003\u0003\t1a\u001c:h\u0013\r\t)a\u001e\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005-\u0011qB\u0011\u0003\u0003\u001b\t!A_6\"\u0005\u0005E\u0011!B6sC\u001a$\bfA\u0007\u0002\u0016A!\u0011qCA\r\u001b\u0005I\u0018bAA\u000es\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002iQ,7\u000f\u001e\"s_.,'\u000fV8qS\u000elU\r\u001e:jGN,fN]3hSN$XM]3e\u0003\u001a$XM\u001d#fY\u0016$\u0018N\\4U_BL7\rF\u0002f\u0003CAQ!\u001b\bA\u0002)DcAD;\u0002\b\u0005\u0015B\u0006BA\u0006\u0003\u001fA3ADA\u000b\u0003M!Xm\u001d;DYV\u001cH/\u001a:JI6+GO]5d)\r)\u0017Q\u0006\u0005\u0006S>\u0001\rA\u001b\u0015\u0007\u001fU\f9!!\r-\t\u0005-\u0011q\u0002\u0015\u0004\u001f\u0005U\u0011!\u0006;fgR\u0014%o\\6feN#\u0018\r^3NKR\u0014\u0018n\u0019\u000b\u0004K\u0006e\u0002\"B5\u0011\u0001\u0004Q\u0007F\u0002\tv\u0003\u000f\ti\u0004\f\u0003\u0002\f\u0005=\u0001f\u0001\t\u0002\u0016\u0005aB/Z:u3\u0006lW.\u001a:NKR\u0014\u0018nY:D_VtG/T3ue&\u001cGcA3\u0002F!)\u0011.\u0005a\u0001U\"2\u0011#^A\u0004\u0003\u0013bC!a\u0003\u0002\u0010!\u001a\u0011#!\u0006\u0002%Q,7\u000f\u001e'j]VD\u0018j\\'fiJL7m\u001d\u000b\u0004K\u0006E\u0003\"B5\u0013\u0001\u0004Q\u0007F\u0002\nv\u0003\u000f\t)\u0006\f\u0003\u0002\f\u0005=\u0001f\u0001\n\u0002\u0016\u0005iA/Z:u\u00156Cf)\u001b7uKJ$2!ZA/\u0011\u0015I7\u00031\u0001kQ\u0019\u0019R/a\u0002\u0002b1\"\u00111BA\bQ\r\u0019\u0012QC\u0001\u0014i\u0016\u001cH/\u00169eCR,'*\u0014-GS2$XM\u001d\u000b\u0004K\u0006%\u0004\"B5\u0015\u0001\u0004Q\u0007F\u0002\u000bv\u0003\u000f\ti\u0007\f\u0003\u0002\f\u0005=\u0001f\u0001\u000b\u0002\u0016\u0005\u0011D/Z:u\u000f\u0016tWM]1m\u0005J|7.\u001a:U_BL7-T3ue&\u001c7/\u0011:f\u000fJ,W\rZ5msJ+w-[:uKJ,G\rF\u0002f\u0003kBQ![\u000bA\u0002)Dc!F;\u0002\b\u0005eD\u0006BA\u0006\u0003\u001fA3!FA\u000b\u0003a!Xm\u001d;XS:$wn^:TifdW\rV1h\u001d\u0006lWm\u001d\u000b\u0004K\u0006\u0005\u0005\"B5\u0017\u0001\u0004Q\u0007F\u0002\fv\u0003\u000f\t)\t\f\u0003\u0002\f\u0005=\u0001f\u0001\f\u0002\u0016\u0005\u0001C/Z:u\u0005J|7.\u001a:U_BL7-T3ue&\u001c7OQ=uKNLenT;u)\r)\u0017Q\u0012\u0005\u0006S^\u0001\rA\u001b\u0015\u0007/U\f9!!%-\t\u0005-\u0011q\u0002\u0015\u0004/\u0005U\u0011a\u0006;fgRT6nQ8oiJ|G\u000e\\3s\u001b\u0016$(/[2t)\r)\u0017\u0011\u0014\u0005\u0006Sb\u0001\rA\u001b\u0015\u00071U\f9!!(-\u0005\u0005-\u0001f\u0001\r\u0002\u0016\u0005\u0001C/Z:u'\u0016\u001c8/[8o\u000bb\u0004\u0018N]3MSN$XM\\3s\u001b\u0016$(/[2t)\r)\u0017Q\u0015\u0005\u0006Sf\u0001\rA\u001b\u0015\u00073U\f9!!+-\t\u0005-\u0011q\u0002\u0015\u00043\u0005U\u0011\u0001\u0004;pa&\u001cW*\u001a;sS\u000e\u001cH\u0003BAY\u0003o\u0003BAVAZU&\u0019\u0011QW,\u0003\u0007M+G\u000fC\u0004\u0002:j\u0001\r!a/\u0002\u000bQ|\u0007/[2\u0011\t]\niL[\u0005\u0004\u0003\u007fC$AB(qi&|g.A\tu_BL7-T3ue&\u001cwI]8vaN$B!!-\u0002F\"1\u0011\u0011X\u000eA\u0002)\f\u0001DZ5mi\u0016\u0014()\u001f+pa&\u001cW*\u001a;sS\u000e\u0014VmZ3y)\u0019\t\t,a3\u0002N\"1q\u0004\ba\u0001\u0003cCq!!/\u001d\u0001\u0004\tY\fK\u0004\u0001\u0003#\fi.a8\u0011\t\u0005M\u0017\u0011\\\u0007\u0003\u0003+T1!a6|\u0003\r\t\u0007/[\u0005\u0005\u00037\f)NA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0003a\u0004")
public class MetricsTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final String requiredKafkaServerPrefix;
    private final Properties overridingProps = new Properties();
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String requiredKafkaServerPrefix() {
        return this.requiredKafkaServerPrefix;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnectOrNull(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    public int nMessages() {
        return this.nMessages;
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testMetricsReporterAfterDeletingTopic(String quorum) {
        String topic = "test-topic-metric";
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        this.deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topic, 1, this.brokers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic(String quorum) {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4(), this.createTopic$default$5());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics don't exist");
        this.brokers().foreach((Function1 & Serializable)b -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(topic, b);
            return BoxedUnit.UNIT;
        });
        this.deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topic, 1, this.brokers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterIdMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testClusterIdMetric$1(this, x$2))), (int)1);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerStateMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testBrokerStateMetric$1(this, x$3))), (int)1);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testYammerMetricsCountMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testYammerMetricsCountMetric$1(this, x$4))), (int)1);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testLinuxIoMetrics(String quorum) {
        int expectedCount = new LinuxIoMetricsCollector("/proc", Time.SYSTEM, this.logger().underlying()).usable() ? 1 : 0;
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"linux-disk-read-bytes", "linux-disk-write-bytes"}))).foreach((Function1 & Serializable)name -> {
            MetricsTest.$anonfun$testLinuxIoMetrics$1(this, metrics, expectedCount, name);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testJMXFilter(String quorum) {
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString())));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateJMXFilter(String quorum) {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testUpdateJMXFilter$1(broker);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString())));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGeneralBrokerTopicMetricsAreGreedilyRegistered(String quorum) {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4(), this.createTopic$default$5());
        Assertions.assertTrue((boolean)this.topicMetrics((Option<String>)None$.MODULE$).nonEmpty(), (String)"General topic metrics don't exist");
        Assertions.assertEquals((int)((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().metricMap().size(), (int)this.topicMetrics((Option<String>)None$.MODULE$).size());
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).isEmpty(), (String)"Topic metrics aren't lazily registered");
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics aren't registered");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testWindowsStyleTagNames(String quorum) {
        void metricName_name;
        MetricName metricName;
        String path = "C:\\windows-path\\kafka-logs";
        Map tags = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)path)}));
        String expectedMBeanName = ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        String string = "test-metric";
        KafkaMetricsGroup$ metricName_this = KafkaMetricsGroup$.MODULE$;
        MetricName metricName2 = metricName = KafkaMetricsGroup.metricName$((KafkaMetricsGroup)metricName_this, (String)metricName_name, (Map)tags);
        Object var6_6 = null;
        string = null;
        metricName = null;
        MetricName metric = metricName2;
        Predef$.MODULE$.assert(metric.getMBeanName().endsWith(expectedMBeanName));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerTopicMetricsBytesInOut(String quorum) {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
        String replicationBytesOut = BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
        String bytesIn = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topic).toString();
        String bytesOut = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesOutPerSec()).append(",topic=").append(topic).toString();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        this.createTopic(topic, 1, this.numNodes(), topicConfig, this.createTopic$default$5());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$1(topic, topicPartition, broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, this.nMessages(), "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L);
        long initialReplicationBytesIn = TestUtils$.MODULE$.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = TestUtils$.MODULE$.meterCount(replicationBytesOut);
        long initialBytesIn = TestUtils$.MODULE$.meterCount(bytesIn);
        long initialBytesOut = TestUtils$.MODULE$.meterCount(bytesOut);
        Assertions.assertEquals((long)initialBytesOut, (long)TestUtils$.MODULE$.meterCount(bytesOut));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, this.nMessages(), "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testZkControllerMetrics(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$1(x$8))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$2(x$9))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$3(x$10))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$4(x$11))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$5(x$12))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$6(x$13))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$7(x$14))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$8(x$15))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$9(x$16))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$10(x$17))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$11(x$18))), (int)1);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testSessionExpireListenerMetrics(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        int expectedNumMetrics = this.isKRaftTest() ? 0 : 1;
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$1(x$19))));
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$2(x$20))));
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$3(x$21))));
    }

    private Set<String> topicMetrics(Option<String> topic) {
        scala.collection.mutable.Set metricNames = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().map((Function1 & Serializable)x$22 -> x$22.getMBeanName());
        return this.filterByTopicMetricRegex((Set<String>)metricNames, topic);
    }

    private Set<String> topicMetricGroups(String topic) {
        scala.collection.mutable.Set metricGroups = CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return this.filterByTopicMetricRegex((Set<String>)metricGroups, (Option<String>)new Some((Object)topic));
    }

    private Set<String> filterByTopicMetricRegex(Set<String> metrics, Option<String> topic) {
        Pattern pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(22).append(".*BrokerTopicMetrics.*").append(topic.map((Function1 & Serializable)t -> new StringBuilder(3).append("(").append((String)t).append(")$").toString()).getOrElse((Function0 & Serializable)() -> "")).toString())).pattern();
        return (Set)metrics.filter((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$filterByTopicMetricRegex$3(pattern, x$23)));
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(String topic$1, KafkaBroker b) {
        Assertions.assertNotNull((Object)b.brokerTopicStats().topicStats(topic$1));
    }

    public static final /* synthetic */ boolean $anonfun$testClusterIdMetric$1(MetricsTest $this, MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = new StringBuilder(10).append($this.requiredKafkaServerPrefix()).append("=ClusterId").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerStateMetric$1(MetricsTest $this, MetricName x$3) {
        String string = x$3.getMBeanName();
        String string2 = new StringBuilder(12).append($this.requiredKafkaServerPrefix()).append("=BrokerState").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testYammerMetricsCountMetric$1(MetricsTest $this, MetricName x$4) {
        String string = x$4.getMBeanName();
        String string2 = new StringBuilder(21).append($this.requiredKafkaServerPrefix()).append("=yammer-metrics-count").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testLinuxIoMetrics$2(MetricsTest $this, String name$1, MetricName x$5) {
        String string = x$5.getMBeanName();
        String string2 = new StringBuilder(1).append($this.requiredKafkaServerPrefix()).append("=").append(name$1).toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testLinuxIoMetrics$1(MetricsTest $this, java.util.Map metrics$1, int expectedCount$1, String name) {
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics$1.keySet()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testLinuxIoMetrics$2($this, name, x$5))), (int)expectedCount$1);
    }

    public static final /* synthetic */ void $anonfun$testUpdateJMXFilter$1(KafkaBroker broker) {
        broker.kafkaYammerMetrics().reconfigure(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metrics.jmx.exclude"), (Object)"kafka.controller:type=KafkaController,name=ActiveControllerCount")}))).asJava());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsBytesInOut$1(String topic$2, TopicPartition topicPartition$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$1 = new TopicPartition(topic$2, 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        int brokerId = broker.config().brokerId();
        Option logSize = log.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.size()));
        Assertions.assertTrue((boolean)logSize.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$7 -> x$7 > 0L), (String)new StringBuilder(64).append("Expected broker ").append(brokerId).append(" to have a Log for ").append(topicPartition$1).append(" with positive size, actual: ").append(logSize).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$1(MetricName x$8) {
        String string = x$8.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveControllerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$2(MetricName x$9) {
        String string = x$9.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=OfflinePartitionsCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$3(MetricName x$10) {
        String string = x$10.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$4(MetricName x$11) {
        String string = x$11.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalTopicCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$5(MetricName x$12) {
        String string = x$12.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalPartitionCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$6(MetricName x$13) {
        String string = x$13.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$7(MetricName x$14) {
        String string = x$14.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$8(MetricName x$15) {
        String string = x$15.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$9(MetricName x$16) {
        String string = x$16.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$10(MetricName x$17) {
        String string = x$17.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveBrokerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$11(MetricName x$18) {
        String string = x$18.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=FencedBrokerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$1(MetricName x$19) {
        String string = x$19.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=SessionState";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$2(MetricName x$20) {
        String string = x$20.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperExpiresPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$3(MetricName x$21) {
        String string = x$21.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperDisconnectsPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$filterByTopicMetricRegex$3(Pattern pattern$1, String x$23) {
        return pattern$1.matcher(x$23).matches();
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.requiredKafkaServerPrefix = "kafka.server:type=KafkaServer,name";
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(this.numParts()));
        this.overridingProps().put("metrics.jmx.exclude", new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString());
        this.nMessages = 2;
    }
}

