/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Properties;
import kafka.cluster.PartitionListener;
import kafka.coordinator.group.CoordinatorPartitionWriter;
import kafka.coordinator.group.ListenerAdapter;
import kafka.coordinator.group.StringKeyValueSerializer;
import kafka.server.ActionQueue;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.runtime.PartitionWriter;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005]2A\u0001C\u0005\u0001!!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00019!)Q\u0006\u0001C\u00019!)q\u0006\u0001C\u00019!)\u0011\u0007\u0001C\u00019!)1\u0007\u0001C\u00019!)Q\u0007\u0001C\u00019\tq2i\\8sI&t\u0017\r^8s!\u0006\u0014H/\u001b;j_:<&/\u001b;feR+7\u000f\u001e\u0006\u0003\u0015-\tQa\u001a:pkBT!\u0001D\u0007\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u001d\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0012!\t\u0011R#D\u0001\u0014\u0015\u0005!\u0012!B:dC2\f\u0017B\u0001\f\u0014\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011!C\u0001\u001fi\u0016\u001cHOU3hSN$XM\u001d#fe\u0016<\u0017n\u001d;fe2K7\u000f^3oKJ$\u0012!\b\t\u0003%yI!aH\n\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u0005\u0002\"AI\u0016\u000e\u0003\rR!\u0001J\u0013\u0002\u0007\u0005\u0004\u0018N\u0003\u0002'O\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0015*\u0003\u0015QWO\\5u\u0015\u0005Q\u0013aA8sO&\u0011Af\t\u0002\u0005)\u0016\u001cH/\u0001\tuKN$xK]5uKJ+7m\u001c:eg\"\u00121!I\u0001\u001ci\u0016\u001cHo\u0016:ji\u0016\u0014VmY8sIN<\u0016\u000e\u001e5GC&dWO]3)\u0005\u0011\t\u0013a\u0006;fgR<&/\u001b;f%\u0016\u001cwN\u001d3U_>d\u0015M]4fQ\t)\u0011%\u0001\ruKN$xK]5uK\u0016k\u0007\u000f^=SK\u000e|'\u000f\u001a'jgRD#AB\u0011\u00021Q,7\u000f\u001e(p]\u0016D\u0018n\u001d;f]R\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002\bC\u0001")
public class CoordinatorPartitionWriterTest {
    @Test
    public void testRegisterDeregisterListener() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, Time.SYSTEM);
        PartitionWriter.Listener listener = new PartitionWriter.Listener(null){

            public void onHighWatermarkUpdated(TopicPartition tp, long offset) {
            }
        };
        partitionRecordWriter.registerListener(tp, listener);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).maybeAddListener(tp, (PartitionListener)new ListenerAdapter(listener));
        partitionRecordWriter.deregisterListener(tp, listener);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).removeListener(tp, (PartitionListener)new ListenerAdapter(listener));
        Assertions.assertEquals((Object)new ListenerAdapter(listener), (Object)new ListenerAdapter(listener));
        Assertions.assertEquals((int)new ListenerAdapter(listener).hashCode(), (int)new ListenerAdapter(listener).hashCode());
    }

    @Test
    public void testWriteRecords() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        MockTime time = new MockTime();
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, (Time)time);
        Mockito.when((Object)replicaManager.getLogConfig(tp)).thenReturn((Object)new Some((Object)LogConfig.fromProps(Collections.emptyMap(), (Properties)new Properties())));
        ArgumentCaptor recordsCapture = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        replicaManager.appendRecords(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((short)((short)1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)recordsCapture.capture(), (Function1)callbackCapture.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
            CoordinatorPartitionWriterTest.$anonfun$testWriteRecords$1(callbackCapture, tp, x$1);
            return BoxedUnit.UNIT;
        });
        .colon.colon records = new .colon.colon((Object)new Tuple2((Object)"k0", (Object)"v0"), (List)new .colon.colon((Object)new Tuple2((Object)"k1", (Object)"v1"), (List)new .colon.colon((Object)new Tuple2((Object)"k2", (Object)"v2"), (List)Nil$.MODULE$)));
        Assertions.assertEquals((long)11L, (long)partitionRecordWriter.append(tp, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)records).asJava()));
        MemoryRecords batch = (MemoryRecords)((MapOps)recordsCapture.getValue()).getOrElse((Object)tp, (Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(15).append("No records for ").append(tp).toString());
        });
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(batch.batches()).asScala().toList().size());
        List receivedRecords = ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(batch.records()).asScala().map((Function1 & Serializable)record -> new Tuple2((Object)Charset.defaultCharset().decode(record.key()).toString(), (Object)Charset.defaultCharset().decode(record.value()).toString()))).toList();
        Assertions.assertEquals((Object)records, (Object)receivedRecords);
    }

    @Test
    public void testWriteRecordsWithFailure() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        MockTime time = new MockTime();
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, (Time)time);
        Mockito.when((Object)replicaManager.getLogConfig(tp)).thenReturn((Object)new Some((Object)LogConfig.fromProps(Collections.emptyMap(), (Properties)new Properties())));
        ArgumentCaptor recordsCapture = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        replicaManager.appendRecords(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((short)((short)1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)recordsCapture.capture(), (Function1)callbackCapture.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            CoordinatorPartitionWriterTest.$anonfun$testWriteRecordsWithFailure$1(callbackCapture, tp, x$2);
            return BoxedUnit.UNIT;
        });
        .colon.colon records = new .colon.colon((Object)new Tuple2((Object)"k0", (Object)"v0"), (List)new .colon.colon((Object)new Tuple2((Object)"k1", (Object)"v1"), (List)new .colon.colon((Object)new Tuple2((Object)"k2", (Object)"v2"), (List)Nil$.MODULE$)));
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> CoordinatorPartitionWriterTest.$anonfun$testWriteRecordsWithFailure$2(partitionRecordWriter, tp, (List)records));
    }

    @Test
    public void testWriteRecordTooLarge() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, Time.SYSTEM);
        int maxBatchSize = 16384;
        Mockito.when((Object)replicaManager.getLogConfig(tp)).thenReturn((Object)new Some((Object)LogConfig.fromProps((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.message.bytes"), (Object)BoxesRunTime.boxToInteger((int)maxBatchSize))}))).asJava(), (Properties)new Properties())));
        byte[] randomBytes = TestUtils.randomBytes((int)(maxBatchSize + 1));
        .colon.colon records = new .colon.colon((Object)new Tuple2((Object)"k0", (Object)new String(randomBytes)), (List)new .colon.colon((Object)new Tuple2((Object)"k1", (Object)new String(randomBytes)), (List)Nil$.MODULE$));
        Assertions.assertThrows(RecordTooLargeException.class, () -> CoordinatorPartitionWriterTest.$anonfun$testWriteRecordTooLarge$1(partitionRecordWriter, tp, (List)records));
    }

    @Test
    public void testWriteEmptyRecordList() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, Time.SYSTEM);
        Mockito.when((Object)replicaManager.getLogConfig(tp)).thenReturn((Object)new Some((Object)LogConfig.fromProps(Collections.emptyMap(), (Properties)new Properties())));
        Assertions.assertThrows(IllegalStateException.class, () -> partitionRecordWriter.append(tp, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()));
    }

    @Test
    public void testNonexistentPartition() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, Time.SYSTEM);
        Mockito.when((Object)replicaManager.getLogConfig(tp)).thenReturn((Object)None$.MODULE$);
        .colon.colon records = new .colon.colon((Object)new Tuple2((Object)"k0", (Object)"v0"), (List)new .colon.colon((Object)new Tuple2((Object)"k1", (Object)"v1"), (List)new .colon.colon((Object)new Tuple2((Object)"k2", (Object)"v2"), (List)Nil$.MODULE$)));
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> CoordinatorPartitionWriterTest.$anonfun$testNonexistentPartition$1(partitionRecordWriter, tp, (List)records));
    }

    public static final /* synthetic */ void $anonfun$testWriteRecords$1(ArgumentCaptor callbackCapture$1, TopicPartition tp$1, InvocationOnMock x$1) {
        ((Function1)callbackCapture$1.getValue()).apply(Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 5L, 10L, -1L, -1L, Collections.emptyList(), ""))})));
    }

    public static final /* synthetic */ void $anonfun$testWriteRecordsWithFailure$1(ArgumentCaptor callbackCapture$2, TopicPartition tp$2, InvocationOnMock x$2) {
        ((Function1)callbackCapture$2.getValue()).apply(Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$2), (Object)new ProduceResponse.PartitionResponse(Errors.NOT_LEADER_OR_FOLLOWER))})));
    }

    public static final /* synthetic */ void $anonfun$testWriteRecordsWithFailure$2(CoordinatorPartitionWriter partitionRecordWriter$1, TopicPartition tp$2, List records$1) {
        partitionRecordWriter$1.append(tp$2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)records$1).asJava());
    }

    public static final /* synthetic */ void $anonfun$testWriteRecordTooLarge$1(CoordinatorPartitionWriter partitionRecordWriter$2, TopicPartition tp$3, List records$2) {
        partitionRecordWriter$2.append(tp$3, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)records$2).asJava());
    }

    public static final /* synthetic */ void $anonfun$testNonexistentPartition$1(CoordinatorPartitionWriter partitionRecordWriter$4, TopicPartition tp$5, List records$3) {
        partitionRecordWriter$4.append(tp$5, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)records$3).asJava());
    }
}

