/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.controller.ReplicaAssignment;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityTypeZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.AdminOperationException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001\u0002\r\u001a\u0001yAQa\f\u0001\u0005\u0002ABqA\r\u0001C\u0002\u0013%1\u0007\u0003\u0004=\u0001\u0001\u0006I\u0001\u000e\u0005\b{\u0001\u0011\r\u0011\"\u00034\u0011\u0019q\u0004\u0001)A\u0005i!9q\b\u0001a\u0001\n\u0003\u0001\u0005b\u0002'\u0001\u0001\u0004%\t!\u0014\u0005\u0007)\u0002\u0001\u000b\u0015B!\t\u000bU\u0003A\u0011\t,\t\u000b\u0011\u0004A\u0011\u0001,\t\u000b%\u0004A\u0011\u0001,\t\u000b-\u0004A\u0011\u0001,\t\u000b5\u0004A\u0011\u0001,\t\u000b=\u0004A\u0011\u0001,\t\u000bE\u0004A\u0011\u0001,\t\u000bM\u0004A\u0011\u0001,\t\u000bU\u0004A\u0011\u0001,\t\u000b]\u0004A\u0011\u0001,\t\u000be\u0004A\u0011\u0001,\t\u000bm\u0004A\u0011\u0001,\t\u000bu\u0004A\u0011\u0001,\t\u000b}\u0004A\u0011\u0001,\t\r\u0005\r\u0001\u0001\"\u0001W\u0005E\tE-\\5o5.\u001cE.[3oiR+7\u000f\u001e\u0006\u00035m\tQ!\u00193nS:T\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001q$J\u0016\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\tZ\u0012AB:feZ,'/\u0003\u0002%C\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!Z\u0012!B;uS2\u001c\u0018B\u0001\u0016(\u0005\u001daunZ4j]\u001e\u0004\"\u0001L\u0017\u000e\u0003eI!AL\r\u0003\u001bI\u000b7m[!xCJ,G+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0007\u0005\u0002-\u0001\u0005\u0001\u0002O]8ek\u000e,'OQ=uKJ\u000bG/Z\u000b\u0002iA\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0005Y\u0006twMC\u0001:\u0003\u0011Q\u0017M^1\n\u0005m2$AB*ue&tw-A\tqe>$WoY3s\u0005f$XMU1uK\u0002\n\u0001#\u001b9D_:tWm\u0019;j_:\u0014\u0016\r^3\u0002#%\u00048i\u001c8oK\u000e$\u0018n\u001c8SCR,\u0007%A\u0004tKJ4XM]:\u0016\u0003\u0005\u00032AQ$J\u001b\u0005\u0019%B\u0001#F\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001j\u0011\u0002\u0004'\u0016\f\bC\u0001\u0011K\u0013\tY\u0015EA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018aC:feZ,'o]0%KF$\"A\u0014*\u0011\u0005=\u0003V\"A#\n\u0005E+%\u0001B+oSRDqaU\u0004\u0002\u0002\u0003\u0007\u0011)A\u0002yIE\n\u0001b]3sm\u0016\u00148\u000fI\u0001\ti\u0016\f'\u000fR8x]R\ta\n\u000b\u0002\n1B\u0011\u0011LY\u0007\u00025*\u00111\fX\u0001\u0004CBL'BA/_\u0003\u001dQW\u000f]5uKJT!a\u00181\u0002\u000b),h.\u001b;\u000b\u0003\u0005\f1a\u001c:h\u0013\t\u0019'LA\u0005BMR,'/R1dQ\u0006YB/Z:u\u001b\u0006tW/\u00197SKBd\u0017nY1BgNLwM\\7f]RD#A\u00034\u0011\u0005e;\u0017B\u00015[\u0005\u0011!Vm\u001d;\u0002+Q,7\u000f\u001e+pa&\u001c7I]3bi&|g.\u00138[\u0017\"\u00121BZ\u0001\u001fi\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>tw+\u001b;i\u0007>dG.[:j_:D#\u0001\u00044\u0002?Q,7\u000f^'be.,G\rR3mKRLwN\u001c+pa&\u001c7I]3bi&|g\u000e\u000b\u0002\u000eM\u0006\tC/Z:u\u001b>\u001c7.\u001a3D_:\u001cWO\u001d:f]R$v\u000e]5d\u0007J,\u0017\r^5p]\"\u0012aBZ\u0001\u001ci\u0016\u001cHoQ8oGV\u0014(/\u001a8u)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8)\u0005=1\u0017!\u0006;fgR$v\u000e]5d\u0007>tg-[4DQ\u0006tw-\u001a\u0015\u0003!\u0019\f1e\u001d5pk2$\u0007K]8qC\u001e\fG/\u001a#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<7\u000f\u000b\u0002\u0012M\u0006YB/Z:u\u0005>|Go\u001d;sCB\u001cE.[3oi&#7i\u001c8gS\u001eD#A\u00054\u0002-Q,7\u000f^$fi\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uCND#a\u00054\u0002kQ,7\u000f^\"iC:<W-V:fe>\u0013Xk]3s\u00072LWM\u001c;JI\u000e{gNZ5h/&$\b.V:fe\u0006sGm\u00117jK:$\u0018\n\u001a\u0015\u0003)\u0019\f!\u0006^3ti\u000eC\u0017M\\4f+N,'o\u0014:Vg\u0016\u00148\t\\5f]RLEmQ8oM&<w+\u001b;i+N,'\u000f\u000b\u0002\u0016M\u0006AB/Z:u\u0007\"\fgnZ3DY&,g\u000e^%e\u0007>tg-[4)\u0005Y1\u0017A\u0005;fgR\u001c\u0005.\u00198hK&\u00038i\u001c8gS\u001eD#a\u00064")
public class AdminZkClientTest
extends QuorumTestHarness
implements RackAwareTest {
    private final String producerByteRate;
    private final String ipConnectionRate;
    private Seq<KafkaServer> servers = Nil$.MODULE$;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Collection<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    private String producerByteRate() {
        return this.producerByteRate;
    }

    private String ipConnectionRate() {
        return this.ipConnectionRate;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), true);
        super.tearDown();
    }

    @Test
    public void testManualReplicaAssignment() {
        List brokers = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Properties topicConfig = new Properties();
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$1 = this.adminZkClient();
            Map x$3 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 0})))}));
            boolean x$4 = qual$1.createTopicWithAssignment$default$4();
            boolean x$5 = qual$1.createTopicWithAssignment$default$5();
            qual$1.createTopicWithAssignment("test", topicConfig, x$3, x$4, x$5);
        });
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$2 = this.adminZkClient();
            Map x$8 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
            boolean x$9 = qual$2.createTopicWithAssignment$default$4();
            boolean x$10 = qual$2.createTopicWithAssignment$default$5();
            qual$2.createTopicWithAssignment("test", topicConfig, x$8, x$9, x$10);
        });
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$3 = this.adminZkClient();
            Map x$13 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
            boolean x$14 = qual$3.createTopicWithAssignment$default$4();
            boolean x$15 = qual$3.createTopicWithAssignment$default$5();
            qual$3.createTopicWithAssignment("test", topicConfig, x$13, x$14, x$15);
        });
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$4 = this.adminZkClient();
            Map x$18 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
            boolean x$19 = qual$4.createTopicWithAssignment$default$4();
            boolean x$20 = qual$4.createTopicWithAssignment$default$5();
            qual$4.createTopicWithAssignment("test", topicConfig, x$18, x$19, x$20);
        });
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$5 = this.adminZkClient();
            Map x$23 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
            boolean x$24 = qual$5.createTopicWithAssignment$default$4();
            boolean x$25 = qual$5.createTopicWithAssignment$default$5();
            qual$5.createTopicWithAssignment("test", topicConfig, x$23, x$24, x$25);
        });
        Map assignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        AdminZkClient qual$6 = this.adminZkClient();
        boolean x$29 = qual$6.createTopicWithAssignment$default$4();
        boolean x$30 = qual$6.createTopicWithAssignment$default$5();
        qual$6.createTopicWithAssignment("test", topicConfig, assignment, x$29, x$30);
        Map found = this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assertions.assertEquals((Object)assignment.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void apply_removingReplicas;
                int k = x0$1._1$mcI$sp();
                List v = (List)x0$1._2();
                Nil$ nil$ = Nil$.MODULE$;
                Nil$ apply_addingReplicas = Nil$.MODULE$;
                Object var3_4 = null;
                nil$ = null;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)new ReplicaAssignment((Seq)v, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas));
            }
            throw new MatchError(null);
        }), (Object)found.apply((Object)"test"));
    }

    @Test
    public void testTopicCreationInZK() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4})))}));
        scala.collection.immutable.Map leaderForPartitionMap = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)BoxesRunTime.boxToInteger((int)1))}));
        String topic = "test";
        Properties topicConfig = new Properties();
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}))));
        AdminZkClient qual$1 = this.adminZkClient();
        boolean x$4 = qual$1.createTopicWithAssignment$default$4();
        boolean x$5 = qual$1.createTopicWithAssignment$default$5();
        qual$1.createTopicWithAssignment(topic, topicConfig, expectedReplicaAssignment, x$4, x$5);
        TestUtils$.MODULE$.makeLeaderForPartition(this.zkClient(), topic, (scala.collection.immutable.Map<Object, Object>)leaderForPartitionMap, 1);
        scala.collection.immutable.Map actualReplicaMap = ((IterableOnceOps)leaderForPartitionMap.keys().map((Function1 & Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)p))), (Object)this.zkClient().getReplicasForPartition(new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)p)))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((int)expectedReplicaAssignment.size(), (int)actualReplicaMap.size());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), actualReplicaMap.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((Object)expectedReplicaAssignment.get((Object)BoxesRunTime.boxToInteger((int)i)).get(), (Object)actualReplicaMap.apply((Object)BoxesRunTime.boxToInteger((int)i))));
        Assertions.assertThrows(TopicExistsException.class, () -> {
            AdminZkClient qual$2 = this.adminZkClient();
            boolean x$9 = qual$2.createTopicWithAssignment$default$4();
            boolean x$10 = qual$2.createTopicWithAssignment$default$5();
            qual$2.createTopicWithAssignment(topic, topicConfig, expectedReplicaAssignment, x$9, x$10);
        });
    }

    @Test
    public void testTopicCreationWithCollision() {
        String topic = "test.topic";
        String collidingTopic = "test_topic";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}))));
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, 3, 1, x$4, x$5, x$6);
        Assertions.assertThrows(InvalidTopicException.class, () -> {
            AdminZkClient qual$2 = this.adminZkClient();
            Properties x$10 = qual$2.createTopic$default$4();
            RackAwareMode x$11 = qual$2.createTopic$default$5();
            boolean x$12 = qual$2.createTopic$default$6();
            qual$2.createTopic(collidingTopic, 3, 1, x$10, x$11, x$12);
        });
    }

    @Test
    public void testMarkedDeletionTopicCreation() {
        KafkaZkClient zkMock = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        String topic = new TopicPartition("test", 0).topic();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)zkMock.isTopicMarkedForDeletion(topic))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AdminZkClient adminZkClient = new AdminZkClient(zkMock, (Option)None$.MODULE$);
        Assertions.assertThrows(TopicExistsException.class, () -> adminZkClient.validateTopicCreate(topic, (Map)Map$.MODULE$.empty(), new Properties()));
    }

    @Test
    public void testMockedConcurrentTopicCreation() {
        String topic = "test.topic";
        KafkaZkClient zkMock = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)zkMock.topicExists(topic))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)zkMock.getAllTopicsInCluster(false)).thenReturn(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"some.topic", topic, "some.other.topic"})));
        AdminZkClient adminZkClient = new AdminZkClient(zkMock, (Option)None$.MODULE$);
        Assertions.assertThrows(TopicExistsException.class, () -> adminZkClient.validateTopicCreate(topic, (Map)Map$.MODULE$.empty(), new Properties()));
    }

    @Test
    public void testConcurrentTopicCreation() {
        String topic = "test-concurrent-topic-creation";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}))));
        Properties props = new Properties();
        props.setProperty("min.insync.replicas", "2");
        TestUtils$.MODULE$.assertConcurrent("Concurrent topic creation failed", (Seq<Function0<Object>>)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> this.createTopic$1(topic, props), (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> this.createTopic$1(topic, props), (List)Nil$.MODULE$)), (int)15000L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicConfigChange() {
        void createServer_time;
        void createServer_config;
        int partitions = 3;
        String topic = "my-topic";
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean createServer_createServer_createServer_startup = true;
        Object var15_6 = null;
        Object var12_5 = null;
        kafkaConfig = null;
        time = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        int maxMessageSize = 1024;
        int retentionMs = 1000000;
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$4 = AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1");
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, partitions, 1, x$4, x$5, x$6);
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        Properties newConfig = AdminZkClientTest.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*");
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*"));
        AdminZkClientTest.checkConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*", true, partitions, topic, server);
        Properties configInZk = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
        Assertions.assertEquals((Object)newConfig, (Object)configInZk);
        this.adminZkClient().changeTopicConfig(topic, new Properties());
        AdminZkClientTest.checkConfig$1(0x10000C, 604800000L, "", "", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"follower.replication.throttled.replicas", (Object)""), new Tuple2((Object)"leader.replication.throttled.replicas", (Object)"")})));
        AdminZkClientTest.checkConfig$1(0x10000C, 604800000L, "", "", false, partitions, topic, server);
    }

    @Test
    public void shouldPropagateDynamicBrokerConfigs() {
        Seq brokerIds = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        this.servers_$eq((Seq<KafkaServer>)((Seq)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props))).map((Function1 & Serializable)x$1 -> {
            Time createServer_time = Time.SYSTEM;
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            boolean createServer_createServer_createServer_startup = true;
            return createServer_this.createServer((KafkaConfig)x$1, createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
        })));
        long limit = 1000000L;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)Long.toString(limit)), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(limit))})));
        this.checkConfig$2(limit);
        long newLimit = 2L * limit;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)Long.toString(newLimit)), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(newLimit))})));
        this.checkConfig$2(newLimit);
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> {
            Properties configInZk = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(brokerId));
            Assertions.assertEquals((long)newLimit, (long)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()))));
            Assertions.assertEquals((long)newLimit, (long)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()))));
        });
        this.adminZkClient().changeBrokerConfig(brokerIds, new Properties());
        this.checkConfig$2(DynamicConfig.Broker$.MODULE$.DefaultReplicationThrottledRate());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBootstrapClientIdConfig() {
        void createServer_time;
        void createServer_config;
        String clientId = "my-client";
        Properties props = new Properties();
        props.setProperty("producer_byte_rate", "1000");
        props.setProperty("consumer_byte_rate", "2000");
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Client(), clientId, props);
        Map configInZk = this.adminZkClient().fetchAllEntityConfigs(ConfigType$.MODULE$.Client());
        Assertions.assertEquals((int)1, (int)configInZk.size(), (String)"Must have 1 overridden client config");
        Assertions.assertEquals((Object)props, (Object)configInZk.apply((Object)clientId));
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean createServer_createServer_createServer_startup = true;
        Object var8_7 = null;
        Object var5_6 = null;
        kafkaConfig = null;
        time = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)new Quota(1000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().produce().quota("ANONYMOUS", clientId));
        Assertions.assertEquals((Object)new Quota(2000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().fetch().quota("ANONYMOUS", clientId));
    }

    @Test
    public void testGetBrokerMetadatas() {
        Range.Inclusive brokerList = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5);
        Map rackInfo = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        Collection<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackInfo, (Seq<Object>)((Seq)brokerList.filterNot((Function1)rackInfo.keySet())));
        TestUtils$.MODULE$.createBrokersInZk((Seq<BrokerMetadata>)CollectionConverters$.MODULE$.CollectionHasAsScala(brokerMetadatas).asScala().toSeq(), this.zkClient());
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode.Disabled$ x$1 = RackAwareMode.Disabled$.MODULE$;
        Option x$22 = qual$1.getBrokerMetadatas$default$2();
        Seq processedMetadatas1 = qual$1.getBrokerMetadatas((RackAwareMode)x$1, x$22);
        Assertions.assertEquals((Object)brokerList, (Object)processedMetadatas1.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id)));
        Assertions.assertEquals((Object)package$.MODULE$.List().fill(brokerList.size(), (Function0 & Serializable)() -> Optional.empty()), (Object)processedMetadatas1.map((Function1 & Serializable)x$3 -> x$3.rack));
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode.Safe$ x$32 = RackAwareMode.Safe$.MODULE$;
        Option x$42 = qual$2.getBrokerMetadatas$default$2();
        Seq processedMetadatas2 = qual$2.getBrokerMetadatas((RackAwareMode)x$32, x$42);
        Assertions.assertEquals((Object)brokerList, (Object)processedMetadatas2.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id)));
        Assertions.assertEquals((Object)package$.MODULE$.List().fill(brokerList.size(), (Function0 & Serializable)() -> Optional.empty()), (Object)processedMetadatas2.map((Function1 & Serializable)x$5 -> x$5.rack));
        Assertions.assertThrows(AdminOperationException.class, () -> {
            AdminZkClient qual$3 = this.adminZkClient();
            RackAwareMode.Enforced$ x$5 = RackAwareMode.Enforced$.MODULE$;
            Option x$6 = qual$3.getBrokerMetadatas$default$2();
            qual$3.getBrokerMetadatas((RackAwareMode)x$5, x$6);
        });
        List partialList = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 5}));
        Seq processedMetadatas3 = this.adminZkClient().getBrokerMetadatas((RackAwareMode)RackAwareMode.Enforced$.MODULE$, (Option)new Some((Object)partialList));
        Assertions.assertEquals((Object)partialList, (Object)processedMetadatas3.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id)));
        Assertions.assertEquals((Object)partialList.map((Function1)rackInfo), (Object)processedMetadatas3.map((Function1 & Serializable)x$7 -> (String)x$7.rack.get()));
        int numPartitions = 3;
        AdminZkClient qual$4 = this.adminZkClient();
        RackAwareMode.Safe$ x$10 = RackAwareMode.Safe$.MODULE$;
        Properties x$11 = qual$4.createTopic$default$4();
        boolean x$12 = qual$4.createTopic$default$6();
        qual$4.createTopic("foo", numPartitions, 2, x$11, (RackAwareMode)x$10, x$12);
        Map assignment = this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((int)numPartitions, (int)assignment.size());
    }

    @Test
    public void testChangeUserOrUserClientIdConfigWithUserAndClientId() {
        Properties config = new Properties();
        config.put("producer_byte_rate", this.producerByteRate());
        this.adminZkClient().changeUserOrUserClientIdConfig("user01/clients/client01", config, true);
        Properties props = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.User(), "user01/clients/client01");
        Assertions.assertEquals((Object)this.producerByteRate(), (Object)props.getProperty("producer_byte_rate"));
        this.adminZkClient().changeUserOrUserClientIdConfig("user01/clients/client01", new Properties(), true);
        Seq users = this.zkClient().getChildren(ConfigEntityTypeZNode$.MODULE$.path(ConfigType$.MODULE$.User()));
        Predef$.MODULE$.assert(users.isEmpty());
        AdminZkClient qual$1 = this.adminZkClient();
        boolean x$3 = qual$1.changeUserOrUserClientIdConfig$default$3();
        qual$1.changeUserOrUserClientIdConfig("user01", config, x$3);
        props = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.User(), "user01");
        Assertions.assertEquals((Object)this.producerByteRate(), (Object)props.getProperty("producer_byte_rate"));
        this.adminZkClient().changeUserOrUserClientIdConfig("user01/clients/client01", config, true);
        props = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.User(), "user01/clients/client01");
        Assertions.assertEquals((Object)this.producerByteRate(), (Object)props.getProperty("producer_byte_rate"));
        this.adminZkClient().changeUserOrUserClientIdConfig("user01/clients/client01", new Properties(), true);
        Seq seq = users = this.zkClient().getChildren(ConfigEntityTypeZNode$.MODULE$.path(ConfigType$.MODULE$.User()));
        .colon.colon colon2 = new .colon.colon((Object)"user01", (List)Nil$.MODULE$);
        Predef$.MODULE$.assert(seq != null && seq.equals(colon2));
    }

    @Test
    public void testChangeUserOrUserClientIdConfigWithUser() {
        Properties config = new Properties();
        config.put("producer_byte_rate", this.producerByteRate());
        AdminZkClient qual$1 = this.adminZkClient();
        boolean x$3 = qual$1.changeUserOrUserClientIdConfig$default$3();
        qual$1.changeUserOrUserClientIdConfig("user01", config, x$3);
        Properties props = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.User(), "user01");
        Assertions.assertEquals((Object)this.producerByteRate(), (Object)props.getProperty("producer_byte_rate"));
        AdminZkClient qual$2 = this.adminZkClient();
        Properties x$5 = new Properties();
        boolean x$6 = qual$2.changeUserOrUserClientIdConfig$default$3();
        qual$2.changeUserOrUserClientIdConfig("user01", x$5, x$6);
        Seq users = this.zkClient().getChildren(ConfigEntityTypeZNode$.MODULE$.path(ConfigType$.MODULE$.User()));
        Predef$.MODULE$.assert(users.isEmpty());
    }

    @Test
    public void testChangeClientIdConfig() {
        Properties config = new Properties();
        config.put("producer_byte_rate", this.producerByteRate());
        this.adminZkClient().changeClientIdConfig("client01", config);
        Properties props = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Client(), "client01");
        Assertions.assertEquals((Object)this.producerByteRate(), (Object)props.getProperty("producer_byte_rate"));
        this.adminZkClient().changeClientIdConfig("client01", new Properties());
        Seq users = this.zkClient().getChildren(ConfigEntityTypeZNode$.MODULE$.path(ConfigType$.MODULE$.Client()));
        Predef$.MODULE$.assert(users.isEmpty());
    }

    @Test
    public void testChangeIpConfig() {
        Properties config = new Properties();
        config.put("connection_creation_rate", this.ipConnectionRate());
        this.adminZkClient().changeIpConfig("127.0.0.1", config);
        Properties props = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Ip(), "127.0.0.1");
        Assertions.assertEquals((Object)this.ipConnectionRate(), (Object)props.getProperty("connection_creation_rate"));
        this.adminZkClient().changeIpConfig("127.0.0.1", new Properties());
        Seq users = this.zkClient().getChildren(ConfigEntityTypeZNode$.MODULE$.path(ConfigType$.MODULE$.Ip()));
        Predef$.MODULE$.assert(users.isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testConcurrentTopicCreation$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            int partition = x0$1._1$mcI$sp();
            ReplicaAssignment partitionReplicaAssignment = (ReplicaAssignment)x0$1._2();
            Assertions.assertEquals((int)1, (int)partitionReplicaAssignment.replicas().size(), (String)new StringBuilder(34).append("Unexpected replication factor for ").append(partition).toString());
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void createTopic$1(String topic$4, Properties props$1) {
        void var7_7;
        try {
            AdminZkClient qual$1 = this.adminZkClient();
            RackAwareMode x$5 = qual$1.createTopic$default$5();
            boolean x$6 = qual$1.createTopic$default$6();
            qual$1.createTopic(topic$4, 3, 1, props$1, x$5, x$6);
        }
        catch (TopicExistsException topicExistsException) {}
        Tuple2 tuple2 = (Tuple2)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic$4}))).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map partitionAssignment = (Map)tuple2._2();
        Assertions.assertEquals((int)3, (int)var7_7.size());
        var7_7.foreach((Function1 & Serializable)x0$1 -> {
            AdminZkClientTest.$anonfun$testConcurrentTopicCreation$1(x0$1);
            return BoxedUnit.UNIT;
        });
        Properties savedProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), topic$4);
        Assertions.assertEquals((Object)props$1, (Object)savedProps);
    }

    private static final Properties makeConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers) {
        Properties props = new Properties();
        props.setProperty("max.message.bytes", Integer.toString(messageSize));
        props.setProperty("retention.ms", Long.toString(retentionMs));
        props.setProperty("leader.replication.throttled.replicas", throttledLeaders);
        props.setProperty("follower.replication.throttled.replicas", throttledFollowers);
        return props;
    }

    private static final void checkList$1(java.util.List actual, String expected) {
        Assertions.assertNotNull((Object)actual);
        String string = expected;
        String string2 = "";
        if (string != null && string.equals(string2)) {
            Assertions.assertTrue((boolean)actual.isEmpty());
            return;
        }
        Assertions.assertEquals((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])expected.split(","))), (Object)CollectionConverters$.MODULE$.ListHasAsScala(actual).asScala());
    }

    public static final /* synthetic */ void $anonfun$testTopicConfigChange$1(int partitions$1, String topic$5, KafkaServer server$1, long retentionMs$1, int messageSize$1, String throttledLeaders$1, String throttledFollowers$1, boolean quotaManagerIsThrottled$1) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), partitions$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)part -> {
            TopicPartition tp = new TopicPartition(topic$5, part);
            LogManager qual$1 = server$1.logManager();
            boolean x$2 = qual$1.getLog$default$2();
            Option log = qual$1.getLog(tp, x$2);
            Assertions.assertTrue((boolean)log.isDefined());
            Assertions.assertEquals((long)retentionMs$1, (long)((UnifiedLog)log.get()).config().retentionMs);
            Assertions.assertEquals((int)messageSize$1, (int)((UnifiedLog)log.get()).config().maxMessageSize());
            AdminZkClientTest.checkList$1(((UnifiedLog)log.get()).config().leaderReplicationThrottledReplicas, throttledLeaders$1);
            AdminZkClientTest.checkList$1(((UnifiedLog)log.get()).config().followerReplicationThrottledReplicas, throttledFollowers$1);
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)quotaManagerIsThrottled$1), (Object)BoxesRunTime.boxToBoolean((boolean)server$1.quotaManagers().leader().isThrottled(tp)));
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers, boolean quotaManagerIsThrottled, int partitions$1, String topic$5, KafkaServer server$1) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                AdminZkClientTest.$anonfun$testTopicConfigChange$1(partitions$1, topic$5, server$1, retentionMs, messageSize, throttledLeaders, throttledFollowers, quotaManagerIsThrottled);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var15_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$shouldPropagateDynamicBrokerConfigs$4(long limit$1, KafkaServer server) {
        Assertions.assertEquals((long)limit$1, (long)server.quotaManagers().leader().upperBound(), (String)"Leader Quota Manager was not updated");
        Assertions.assertEquals((long)limit$1, (long)server.quotaManagers().follower().upperBound(), (String)"Follower Quota Manager was not updated");
    }

    public static final /* synthetic */ void $anonfun$shouldPropagateDynamicBrokerConfigs$3(AdminZkClientTest $this, long limit$1) {
        $this.servers().foreach((Function1 & Serializable)server -> {
            AdminZkClientTest.$anonfun$shouldPropagateDynamicBrokerConfigs$4(limit$1, server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConfig$2(long limit) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                AdminZkClientTest.$anonfun$shouldPropagateDynamicBrokerConfigs$3(this, limit);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var9_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public AdminZkClientTest() {
        this.producerByteRate = "1024";
        this.ipConnectionRate = "10";
    }
}

