/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import kafka.admin.LeaderElectionCommand$;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.server.common.AdminCommandFailedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005I2Aa\u0002\u0005\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)!\u0006\u0001C\u00013!)A\u0006\u0001C\u00013!)a\u0006\u0001C\u00013!)\u0001\u0007\u0001C\u00013\tqB*Z1eKJ,E.Z2uS>t7i\\7nC:$WI\u001d:peR+7\u000f\u001e\u0006\u0003\u0013)\tQ!\u00193nS:T\u0011aC\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0001\"a\u0006\u0001\u000e\u0003!\t\u0011\u0004^3tiR{\u0007/[2XSRDw.\u001e;QCJ$\u0018\u000e^5p]R\t!\u0004\u0005\u0002\u00107%\u0011A\u0004\u0005\u0002\u0005+:LG\u000f\u000b\u0002\u0003=A\u0011q\u0004K\u0007\u0002A)\u0011\u0011EI\u0001\u0004CBL'BA\u0012%\u0003\u001dQW\u000f]5uKJT!!\n\u0014\u0002\u000b),h.\u001b;\u000b\u0003\u001d\n1a\u001c:h\u0013\tI\u0003E\u0001\u0003UKN$\u0018!\u0007;fgR\u0004\u0016M\u001d;ji&|gnV5uQ>,H\u000fV8qS\u000eD#a\u0001\u0010\u0002/Q,7\u000f^'jgNLgnZ#mK\u000e$\u0018n\u001c8UsB,\u0007F\u0001\u0003\u001f\u0003\t\"Xm\u001d;NSN\u001c\u0018N\\4U_BL7\rU1si&$\u0018n\u001c8TK2,7\r^5p]\"\u0012QAH\u0001\u0012i\u0016\u001cH/\u00138wC2LGM\u0011:pW\u0016\u0014\bF\u0001\u0004\u001f\u0001")
public class LeaderElectionCommandErrorTest {
    @Test
    public void testTopicWithoutPartition() {
        Throwable e = Assertions.assertThrows(Throwable.class, () -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", "nohost:9092", "--election-type", "unclean", "--topic", "some-topic"}));
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Missing required option(s)"));
        Assertions.assertTrue((boolean)e.getMessage().contains(" partition"));
    }

    @Test
    public void testPartitionWithoutTopic() {
        Throwable e = Assertions.assertThrows(Throwable.class, () -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", "nohost:9092", "--election-type", "unclean", "--all-topic-partitions", "--partition", "0"}));
        Assertions.assertEquals((Object)"Option partition is only allowed if topic is used", (Object)e.getMessage());
    }

    @Test
    public void testMissingElectionType() {
        Throwable e = Assertions.assertThrows(Throwable.class, () -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", "nohost:9092", "--topic", "some-topic", "--partition", "0"}));
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Missing required option(s)"));
        Assertions.assertTrue((boolean)e.getMessage().contains(" election-type"));
    }

    @Test
    public void testMissingTopicPartitionSelection() {
        Throwable e = Assertions.assertThrows(Throwable.class, () -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", "nohost:9092", "--election-type", "preferred"}));
        Assertions.assertTrue((boolean)e.getMessage().startsWith("One and only one of the following options is required: "));
        Assertions.assertTrue((boolean)e.getMessage().contains(" all-topic-partitions"));
        Assertions.assertTrue((boolean)e.getMessage().contains(" topic"));
        Assertions.assertTrue((boolean)e.getMessage().contains(" path-to-json-file"));
    }

    @Test
    public void testInvalidBroker() {
        Assertions.assertTrue((boolean)(((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> LeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", "example.com:1234", "--election-type", "unclean", "--all-topic-partitions"}, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds()))).getCause() instanceof TimeoutException));
    }
}

