/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaRequestHandler$;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0005\u00154Aa\u0002\u0005\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)!\u0006\u0001C\u00013!)A\u0006\u0001C\u00013!)a\u0006\u0001C\u0001_!)q\t\u0001C\u0001\u0011\n92*\u00194lCJ+\u0017/^3ti\"\u000bg\u000e\u001a7feR+7\u000f\u001e\u0006\u0003\u0013)\taa]3sm\u0016\u0014(\"A\u0006\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00051\u0002CA\f\u0001\u001b\u0005A\u0011A\u0005;fgR\u001c\u0015\r\u001c7cC\u000e\\G+[7j]\u001e$\u0012A\u0007\t\u0003\u001fmI!\u0001\b\t\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005y\u0001\"a\b\u0015\u000e\u0003\u0001R!!\t\u0012\u0002\u0007\u0005\u0004\u0018N\u0003\u0002$I\u00059!.\u001e9ji\u0016\u0014(BA\u0013'\u0003\u0015QWO\\5u\u0015\u00059\u0013aA8sO&\u0011\u0011\u0006\t\u0002\u0005)\u0016\u001cH/\u0001\u0010uKN$8)\u00197mE\u0006\u001c7\u000e\u0016:z\u0007>l\u0007\u000f\\3uK\u0006\u001bG/[8og\"\u00121AH\u0001 i\u0016\u001cH\u000fS1oI2LgnZ\"bY2\u0014\u0017mY6P]:+w\u000f\u00165sK\u0006$\u0007F\u0001\u0003\u001f\u00039!Xm\u001d;U_BL7m\u0015;biN$\"A\u0007\u0019\t\u000bE*\u0001\u0019\u0001\u001a\u00025ML8\u000f^3n%\u0016lw\u000e^3Ti>\u0014\u0018mZ3F]\u0006\u0014G.\u001a3\u0011\u0005=\u0019\u0014B\u0001\u001b\u0011\u0005\u001d\u0011un\u001c7fC:DC!\u0002\u001c?\u007fA\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\taJ|g/\u001b3fe*\u00111HI\u0001\u0007a\u0006\u0014\u0018-\\:\n\u0005uB$a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0003\u0001\u0006K\u0012!A\r\u0002\u0001!\u0012Qa\u0011\t\u0003\t\u0016k\u0011AO\u0005\u0003\rj\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003-i\u0017m[3SKF,Xm\u001d;\u0015\u0007%\u001b\u0006\r\u0005\u0002K!:\u00111JT\u0007\u0002\u0019*\u0011QJC\u0001\b]\u0016$xo\u001c:l\u0013\tyE*\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\u0005E\u0013&a\u0002*fcV,7\u000f\u001e\u0006\u0003\u001f2CQ\u0001\u0016\u0004A\u0002U\u000bA\u0001^5nKB\u0011aKX\u0007\u0002/*\u0011\u0001,W\u0001\u0006kRLGn\u001d\u0006\u00035n\u000baaY8n[>t'BA\u0006]\u0015\tif%\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003?^\u0013A\u0001V5nK\")\u0011M\u0002a\u0001E\u00069Q.\u001a;sS\u000e\u001c\bC\u0001&d\u0013\t!'KA\u0004NKR\u0014\u0018nY:")
public class KafkaRequestHandlerTest {
    @Test
    public void testCallbackTiming() {
        MockTime time = new MockTime();
        long startTime = time.nanoseconds();
        RequestChannel.Metrics metrics = new RequestChannel.Metrics(Option$.MODULE$.option2Iterable((Option)None$.MODULE$));
        RequestChannel requestChannel = new RequestChannel(10, "", (Time)time, metrics);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        try {
            KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time);
            RequestChannel.Request request = this.makeRequest((Time)time, metrics);
            requestChannel.sendRequest(request);
            apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
                KafkaRequestHandlerTest.$anonfun$testCallbackTiming$1(time, handler, request, x$1);
                return BoxedUnit.UNIT;
            });
            handler.run();
            Assertions.assertEquals((long)startTime, (long)request.requestDequeueTimeNanos());
            Assertions.assertEquals((long)(startTime + 2000000L), (long)request.apiLocalCompleteTimeNanos());
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)(startTime + 2000000L))), (Object)request.callbackRequestDequeueTimeNanos());
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)(startTime + 3000000L))), (Object)request.callbackRequestCompleteTimeNanos());
        }
        finally {
            metrics.close();
        }
    }

    @Test
    public void testCallbackTryCompleteActions() {
        MockTime time = new MockTime();
        RequestChannel.Metrics metrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        RequestChannel requestChannel = new RequestChannel(10, "", (Time)time, metrics);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time);
        IntRef handledCount = IntRef.create((int)0);
        IntRef tryCompleteActionCount = IntRef.create((int)0);
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            ++handledCount$1.elem;
            return CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testCallbackTryCompleteActions$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(reqLocal, ms) -> {
                handler.stop();
                return BoxedUnit.UNIT;
            }, RequestLocal$.MODULE$.NoCaching())));
        });
        apiHandler.tryCompleteActions();
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackTryCompleteActions$4(tryCompleteActionCount, x$3);
            return BoxedUnit.UNIT;
        });
        handler.run();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
        Assertions.assertEquals((int)1, (int)tryCompleteActionCount.elem);
    }

    @Test
    public void testHandlingCallbackOnNewThread() {
        MockTime time = new MockTime();
        RequestChannel.Metrics metrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        RequestChannel requestChannel = new RequestChannel(10, "", (Time)time, metrics);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time);
        RequestLocal originalRequestLocal = (RequestLocal)Mockito.mock(RequestLocal.class);
        IntRef handledCount = IntRef.create((int)0);
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testHandlingCallbackOnNewThread$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(reqLocal, ms) -> {
            KafkaRequestHandlerTest.$anonfun$testHandlingCallbackOnNewThread$2(handledCount, handler, reqLocal, BoxesRunTime.unboxToInt((Object)ms));
            return BoxedUnit.UNIT;
        }, originalRequestLocal))));
        handler.run();
        ((RequestLocal)Mockito.verify((Object)originalRequestLocal, (VerificationMode)Mockito.times((int)0))).bufferSupplier();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTopicStats(boolean systemRemoteStorageEnabled) {
        String topic = "topic";
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.setProperty("remote.log.storage.system.enable", Boolean.toString(systemRemoteStorageEnabled));
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats(Optional.of(KafkaConfig$.MODULE$.fromProps(props)));
        brokerTopicStats.topicStats(topic);
        RemoteStorageMetrics.brokerTopicStatsMetrics().forEach(metric -> {
            if (systemRemoteStorageEnabled) {
                Assertions.assertTrue((boolean)brokerTopicStats.topicStats(topic).metricMap().contains((Object)metric.getName()));
                return;
            }
            Assertions.assertFalse((boolean)brokerTopicStats.topicStats(topic).metricMap().contains((Object)metric.getName()));
        });
    }

    public RequestChannel.Request makeRequest(Time time, RequestChannel.Metrics metrics) {
        RequestHeader requestHeader = (RequestHeader)Mockito.mock(RequestHeader.class);
        Mockito.when((Object)requestHeader.apiKey()).thenReturn((Object)ApiKeys.API_VERSIONS);
        Mockito.when((Object)BoxesRunTime.boxToShort((short)requestHeader.apiVersion())).thenReturn((Object)BoxesRunTime.boxToShort((short)((short)0)));
        RequestContext context = new RequestContext(requestHeader, "0", (InetAddress)Mockito.mock(InetAddress.class), new KafkaPrincipal("", ""), new ListenerName(""), SecurityProtocol.PLAINTEXT, (ClientInformation)Mockito.mock(ClientInformation.class), false);
        return new RequestChannel.Request(0, context, time.nanoseconds(), (MemoryPool)Mockito.mock(MemoryPool.class), ByteBuffer.allocate(0), metrics, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$2(MockTime time$1, KafkaRequestHandler handler$1, RequestLocal reqLocal, int ms) {
        time$1.sleep((long)ms);
        handler$1.stop();
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$3(Function1 callback$1) {
        callback$1.apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$1(MockTime time$1, KafkaRequestHandler handler$1, RequestChannel.Request request$1, InvocationOnMock x$1) {
        time$1.sleep(2L);
        CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testCallbackTiming$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(reqLocal, ms) -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackTiming$2(time$1, handler$1, reqLocal, BoxesRunTime.unboxToInt((Object)ms));
            return BoxedUnit.UNIT;
        }, RequestLocal$.MODULE$.NoCaching())));
        request$1.apiLocalCompleteTimeNanos_$eq(time$1.nanoseconds());
    }

    public static final /* synthetic */ void $anonfun$testCallbackTryCompleteActions$3(Function1 callback$2) {
        callback$2.apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testCallbackTryCompleteActions$4(IntRef tryCompleteActionCount$1, InvocationOnMock x$3) {
        ++tryCompleteActionCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testHandlingCallbackOnNewThread$2(IntRef handledCount$2, KafkaRequestHandler handler$3, RequestLocal reqLocal, int ms) {
        reqLocal.bufferSupplier().close();
        ++handledCount$2.elem;
        handler$3.stop();
    }

    public static final /* synthetic */ void $anonfun$testHandlingCallbackOnNewThread$3(Function1 callback$3) {
        callback$3.apply$mcVI$sp(1);
    }
}

