/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Stream;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.KRaftCachedControllerId;
import kafka.server.MetadataCache;
import kafka.server.MetadataCacheTest$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.MetadataSnapshot;
import kafka.server.metadata.ZkMetadataCache;
import kafka.server.metadata.ZkMetadataCache$;
import kafka.utils.Implicits;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

/*
 * Exception performing whole class analysis ignored.
 */
@ScalaSignature(bytes="\u0006\u0005\r}t!B)S\u0011\u00039f!B-S\u0011\u0003Q\u0006\"B1\u0002\t\u0003\u0011\u0007\"B2\u0002\t\u0003!\u0007\"\u0002:\u0002\t\u0003!\u0007\"B:\u0002\t\u0003!h!B-S\u0001\u0005M\u0001BB1\u0007\t\u0003\t)\u0002C\u0005\u0002\u001a\u0019\u0011\r\u0011\"\u0001\u0002\u001c!A\u00111\u0005\u0004!\u0002\u0013\ti\u0002C\u0004\u0002&\u0019!\t!a\n\t\u000f\u0005Uc\u0001\"\u0001\u0002X!9\u0011\u0011\r\u0004\u0005\u0002\u0005\r\u0004bBA7\r\u0011\u0005\u0011q\u000e\u0005\b\u0003s2A\u0011BA>\u0011\u001d\t\u0019P\u0002C\u0001\u0003kDq!a@\u0007\t\u0003\u0011\t\u0001C\u0004\u0003\f\u0019!\tA!\u0004\t\u000f\t]a\u0001\"\u0001\u0003\u001a!9!1\u0005\u0004\u0005\u0002\t\u0015\u0002b\u0002B\u0019\r\u0011\u0005!1\u0007\u0005\b\u0005\u00072A\u0011\u0001B\u001a\u0011\u001d\u00119E\u0002C\u0001\u0005gAqAa\u0013\u0007\t\u0003\u0011\u0019\u0004C\u0004\u0003P\u0019!\tA!\u0015\t\u000f\tmc\u0001\"\u0001\u0003^!9!Q\u0014\u0004\u0005\u0002\tM\u0002\"\u0003BQ\r\t\u0007I\u0011\u0001BR\u0011!\u0011)K\u0002Q\u0001\n\u0005\r\u0005\"\u0003BT\r\t\u0007I\u0011\u0001BR\u0011!\u0011IK\u0002Q\u0001\n\u0005\r\u0005\"\u0003BV\r\t\u0007I\u0011\u0001BW\u0011!\u0011yK\u0002Q\u0001\n\tU\u0004\"\u0003BY\r\t\u0007I\u0011\u0001BZ\u0011!\u0011)L\u0002Q\u0001\n\tm\u0004\"\u0003B\\\r\t\u0007I\u0011\u0001B]\u0011!\u0011YL\u0002Q\u0001\n\tU\u0005\"\u0003B_\r\t\u0007I\u0011\u0001B]\u0011!\u0011yL\u0002Q\u0001\n\tU\u0005\"\u0003Ba\r\t\u0007I\u0011\u0001B]\u0011!\u0011\u0019M\u0002Q\u0001\n\tU\u0005\"\u0003Bc\r\t\u0007I\u0011\u0001B]\u0011!\u00119M\u0002Q\u0001\n\tU\u0005\"\u0003Be\r\t\u0007I\u0011\u0001BW\u0011!\u0011YM\u0002Q\u0001\n\tU\u0004\"\u0003Bg\r\t\u0007I\u0011\u0001BZ\u0011!\u0011yM\u0002Q\u0001\n\tm\u0004\"\u0003Bi\r\t\u0007I\u0011\u0001BZ\u0011!\u0011\u0019N\u0002Q\u0001\n\tm\u0004\"\u0003Bk\r\t\u0007I\u0011\u0001B]\u0011!\u00119N\u0002Q\u0001\n\tU\u0005\"\u0003Bm\r\t\u0007I\u0011\u0001B]\u0011!\u0011YN\u0002Q\u0001\n\tU\u0005\"\u0003Bo\r\t\u0007I\u0011\u0001B]\u0011!\u0011yN\u0002Q\u0001\n\tU\u0005\"\u0003Bq\r\t\u0007I\u0011\u0001B]\u0011!\u0011\u0019O\u0002Q\u0001\n\tU\u0005\"\u0003Bs\r\t\u0007I\u0011\u0001B]\u0011!\u00119O\u0002Q\u0001\n\tU\u0005\"\u0003Bu\r\t\u0007I\u0011\u0001B]\u0011!\u0011YO\u0002Q\u0001\n\tU\u0005\"\u0003Bw\r\t\u0007I\u0011\u0001B]\u0011!\u0011yO\u0002Q\u0001\n\tU\u0005\"\u0003By\r\t\u0007I\u0011\u0001B]\u0011!\u0011\u0019P\u0002Q\u0001\n\tU\u0005\"\u0003B{\r\t\u0007I\u0011\u0001B]\u0011!\u00119P\u0002Q\u0001\n\tU\u0005b\u0002B}\r\u0011\u0005!1\u0007\u0005\n\u0005{4!\u0019!C\u0001\u0005\u007fD\u0001b!\u0004\u0007A\u0003%1\u0011\u0001\u0005\b\u0007\u001f1A\u0011AB\t\u0011\u001d\u0019)D\u0002C\u0001\u0005gAqa!\u000f\u0007\t\u0003\u0011\u0019\u0004C\u0004\u0004>\u0019!\tAa\r\t\u0013\r\u0005cA1A\u0005\u0002\t}\b\u0002CB\"\r\u0001\u0006Ia!\u0001\t\u000f\r\u0015c\u0001\"\u0001\u00034!91\u0011\n\u0004\u0005\u0002\tM\u0002bBB'\r\u0011\u0005!1\u0007\u0005\b\u0007#2A\u0011AB*\u0011\u001d\u0019YF\u0002C\u0001\u0007;\n\u0011#T3uC\u0012\fG/Y\"bG\",G+Z:u\u0015\t\u0019F+\u0001\u0004tKJ4XM\u001d\u0006\u0002+\u0006)1.\u00194lC\u000e\u0001\u0001C\u0001-\u0002\u001b\u0005\u0011&!E'fi\u0006$\u0017\r^1DC\u000eDW\rV3tiN\u0011\u0011a\u0017\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0016a\u0004>l\u0007\u0006\u001c\u0007.\u001a)s_ZLG-\u001a:\u0015\u0003\u0015\u00042AZ7p\u001b\u00059'B\u00015j\u0003\u0019\u0019HO]3b[*\u0011!n[\u0001\u0005kRLGNC\u0001m\u0003\u0011Q\u0017M^1\n\u00059<'AB*ue\u0016\fW\u000e\u0005\u0002Ya&\u0011\u0011O\u0015\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u001b\r\f7\r[3Qe>4\u0018\u000eZ3s\u0003-)\b\u000fZ1uK\u000e\u000b7\r[3\u0015\u0007UD(\u0010\u0005\u0002]m&\u0011q/\u0018\u0002\u0005+:LG\u000fC\u0003z\u000b\u0001\u0007q.A\u0003dC\u000eDW\rC\u0003|\u000b\u0001\u0007A0A\u0004sKF,Xm\u001d;\u0011\u0007u\fy!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\te\u0016\fX/Z:ug*!\u00111AA\u0003\u0003\u0019\u0019w.\\7p]*\u0019Q+a\u0002\u000b\t\u0005%\u00111B\u0001\u0007CB\f7\r[3\u000b\u0005\u00055\u0011aA8sO&\u0019\u0011\u0011\u0003@\u0003+U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiN\u0011aa\u0017\u000b\u0003\u0003/\u0001\"\u0001\u0017\u0004\u0002\u0017\t\u0014xn[3s\u000bB|7\r[\u000b\u0003\u0003;\u00012\u0001XA\u0010\u0013\r\t\t#\u0018\u0002\u0005\u0019>tw-\u0001\u0007ce>\\WM]#q_\u000eD\u0007%A\u0011hKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC:{g.\u0012=jgRLgn\u001a+pa&\u001c7\u000fF\u0002v\u0003SAQ!\u001f\u0006A\u0002=DsACA\u0017\u0003\u000b\n9\u0005\u0005\u0003\u00020\u0005\u0005SBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0011A\u0014xN^5eKJTA!a\u000e\u0002:\u00051\u0001/\u0019:b[NTA!a\u000f\u0002>\u00059!.\u001e9ji\u0016\u0014(\u0002BA \u0003\u0017\tQA[;oSRLA!a\u0011\u00022\taQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\u0012\u0011\u0011J\u0011\u0002e\"\u001a!\"!\u0014\u0011\t\u0005=\u0013\u0011K\u0007\u0003\u0003kIA!a\u0015\u00026\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002!\u001d,G\u000fV8qS\u000elU\r^1eCR\fGcA;\u0002Z!)\u0011p\u0003a\u0001_\":1\"!\f\u0002F\u0005uCFAA%Q\rY\u0011QJ\u0001,O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014hj\u001c;Bm\u0006LG.\u00192mKR\u0019Q/!\u001a\t\u000bed\u0001\u0019A8)\u000f1\ti#!\u0012\u0002j1\u0012\u0011\u0011\n\u0015\u0004\u0019\u00055\u0013!N4fiR{\u0007/[2NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:d\u0015n\u001d;f]\u0016\u0014hj\u001c;Bm\u0006LG.\u00192mK>sG*Z1eKJ$2!^A9\u0011\u0015IX\u00021\u0001pQ\u001di\u0011QFA#\u0003kb#!!\u0013)\u00075\ti%\u0001\u001dwKJLg-\u001f+pa&\u001cW*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8MK\u0006$WM](s\u000b:$\u0007o\\5oi:{G/\u0011<bS2\f'\r\\3\u0015\u001fU\fi(a \u0002\n\u0006\u0015\u0017Q[Am\u0003SDQ!\u001f\bA\u0002=Dq!!!\u000f\u0001\u0004\t\u0019)A\u000bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\"s_.,'/\u00133\u0011\u0007q\u000b))C\u0002\u0002\bv\u00131!\u00138u\u0011\u001d\tYI\u0004a\u0001\u0003\u001b\u000bqA\u0019:pW\u0016\u00148\u000f\u0005\u0004\u0002\u0010\u0006U\u0015\u0011T\u0007\u0003\u0003#S1!a%^\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003/\u000b\tJA\u0002TKF\u0004B!a'\u0002@:!\u0011QTA]\u001d\u0011\ty*!.\u000f\t\u0005\u0005\u00161\u0017\b\u0005\u0003G\u000b\tL\u0004\u0003\u0002&\u0006=f\u0002BAT\u0003[k!!!+\u000b\u0007\u0005-f+\u0001\u0004=e>|GOP\u0005\u0003\u0003\u001bIA!!\u0003\u0002\f%\u0019Q+a\u0002\n\t\u0005\r\u0011QA\u0005\u0005\u0003o\u000b\t!A\u0004nKN\u001c\u0018mZ3\n\t\u0005m\u0016QX\u0001\u001a+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\t\u0006$\u0018M\u0003\u0003\u00028\u0006\u0005\u0011\u0002BAa\u0003\u0007\u0014A#\u00169eCR,W*\u001a;bI\u0006$\u0018M\u0011:pW\u0016\u0014(\u0002BA^\u0003{Cq!a2\u000f\u0001\u0004\tI-\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002L\u0006EWBAAg\u0015\u0011\ty-!\u0001\u0002\u000f9,Go^8sW&!\u00111[Ag\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011\u001d\t9N\u0004a\u0001\u0003\u0007\u000ba\u0001\\3bI\u0016\u0014\bbBAn\u001d\u0001\u0007\u0011Q\\\u0001\u000eKb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:\u0011\t\u0005}\u0017Q]\u0007\u0003\u0003CTA!a9\u0002\u0002\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002h\u0006\u0005(AB#se>\u00148\u000fC\u0004\u0002l:\u0001\r!!<\u00023\u0015\u0014(o\u001c:V]\u00064\u0018-\u001b7bE2,G*[:uK:,'o\u001d\t\u00049\u0006=\u0018bAAy;\n9!i\\8mK\u0006t\u0017aI4fiR{\u0007/[2NKR\fG-\u0019;b%\u0016\u0004H.[2b\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0004k\u0006]\b\"B=\u0010\u0001\u0004y\u0007fB\b\u0002.\u0005\u0015\u00131 \u0017\u0003\u0003\u0013B3aDA'\u0003}9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018-S:s\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0004k\n\r\u0001\"B=\u0011\u0001\u0004y\u0007f\u0002\t\u0002.\u0005\u0015#q\u0001\u0017\u0003\u0003\u0013B3\u0001EA'\u0003A:W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018mV5uQ:{gnU;qa>\u0014H/\u001a3TK\u000e,(/\u001b;z!J|Go\\2pYR\u0019QOa\u0004\t\u000be\f\u0002\u0019A8)\u000fE\ti#!\u0012\u0003\u00141\u0012\u0011\u0011\n\u0015\u0004#\u00055\u0013AL4fi\u0006c\u0017N^3Ce>\\WM]:TQ>,H\u000e\u001a(pi\n+W*\u001e;bi\u0016$')_+qI\u0006$XmQ1dQ\u0016$2!\u001eB\u000e\u0011\u0015I(\u00031\u0001pQ\u001d\u0011\u0012QFA#\u0005?a#!!\u0013)\u0007I\ti%A\u0015uKN$x)\u001a;DYV\u001cH/\u001a:NKR\fG-\u0019;b/&$\bn\u00144gY&tWMU3qY&\u001c\u0017m\u001d\u000b\u0004k\n\u001d\u0002\"B=\u0014\u0001\u0004y\u0007fB\n\u0002.\u0005\u0015#1\u0006\u0017\u0003\u0005[\t\u0013a\u0019\u0015\u0004'\u00055\u0013A\u0005;fgRL5O\u0011:pW\u0016\u0014h)\u001a8dK\u0012$\u0012!\u001e\u0015\u0004)\t]\u0002\u0003\u0002B\u001d\u0005\u007fi!Aa\u000f\u000b\t\tu\u0012\u0011H\u0001\u0004CBL\u0017\u0002\u0002B!\u0005w\u0011A\u0001V3ti\u0006\u0019C/Z:u\u000f\u0016$\u0018\t\\5wK\n\u0013xn[3sg^KG\u000f\u001b\"s_.,'OR3oG\u0016$\u0007fA\u000b\u00038\u0005\u0001C/Z:u\u0013N\u0014%o\\6fe&s7i\u001c8ue>dG.\u001a3TQV$Hm\\<oQ\r1\"qG\u0001\u0017i\u0016\u001cHoR3u\u0019&4XM\u0011:pW\u0016\u0014X\t]8dQ\"\u001aqCa\u000e\u0002)Q,7\u000f^$fiB\u000b'\u000f^5uS>t\u0017J\u001c4p)\r)(1\u000b\u0005\u0006sb\u0001\ra\u001c\u0015\b1\u00055\u0012Q\tB,Y\t\tI\u0005K\u0002\u0019\u0003\u001b\n1d]3ukBLe.\u001b;jC2\fe\u000e\u001a$vY2lU\r^1eCR\fGC\u0001B0!-a&\u0011\rB3\u0005\u0007\u0013)Ga'\n\u0007\t\rTL\u0001\u0004UkBdW\r\u000e\t\t\u0005O\u0012yG!\u001e\u0003|9!!\u0011\u000eB6!\r\t9+X\u0005\u0004\u0005[j\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0003r\tM$aA'ba*\u0019!QN/\u0011\t\t\u001d$qO\u0005\u0005\u0005s\u0012\u0019H\u0001\u0004TiJLgn\u001a\t\u0005\u0005{\u0012y(\u0004\u0002\u0002\u0002%!!\u0011QA\u0001\u0005\u0011)V/\u001b3\u0011\u0011\t\u0015%1\u0012B;\u0005\u001fk!Aa\"\u000b\t\t%\u0015\u0011S\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011iIa\"\u0003\u0013\u0005s\u0017PU3g\u001b\u0006\u0004\bC\u0002BC\u0005#\u0013)*\u0003\u0003\u0003\u0014\n\u001d%a\u0002'p]\u001el\u0015\r\u001d\t\u0005\u00037\u00139*\u0003\u0003\u0003\u001a\u0006\r'\u0001H+qI\u0006$X-T3uC\u0012\fG/\u0019)beRLG/[8o'R\fG/\u001a\t\u0007\u0003\u001f\u000b)J!&\u0002aQ,7\u000f\u001e%b]\u0012dWMR;mYV\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti&s'l['jOJ\fG/[8oQ\rQ\"qG\u0001\u001a_2$'+Z9vKN$8i\u001c8ue>dG.\u001a:Fa>\u001c\u0007.\u0006\u0002\u0002\u0004\u0006Qr\u000e\u001c3SKF,Xm\u001d;D_:$(o\u001c7mKJ,\u0005o\\2iA\u0005Ib.Z<SKF,Xm\u001d;D_:$(o\u001c7mKJ,\u0005o\\2i\u0003iqWm\u001e*fcV,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195!\u000311wn\u001c+pa&\u001cg*Y7f+\t\u0011)(A\u0007g_>$v\u000e]5d\u001d\u0006lW\rI\u0001\u000bM>|Gk\u001c9jG&#WC\u0001B>\u0003-1wn\u001c+pa&\u001c\u0017\n\u001a\u0011\u0002\u0017=dGMR8p!\u0006\u0014H\u000fM\u000b\u0003\u0005+\u000bAb\u001c7e\r>|\u0007+\u0019:ua\u0001\n1B\\3x\r>|\u0007+\u0019:ua\u0005aa.Z<G_>\u0004\u0016M\u001d;1A\u0005Yq\u000e\u001c3G_>\u0004\u0016M\u001d;2\u00031yG\u000e\u001a$p_B\u000b'\u000f^\u0019!\u0003-qWm\u001e$p_B\u000b'\u000f^\u0019\u0002\u00199,wOR8p!\u0006\u0014H/\r\u0011\u0002\u0019\t\f'\u000fV8qS\u000et\u0015-\\3\u0002\u001b\t\f'\u000fV8qS\u000et\u0015-\\3!\u0003)\u0011\u0017M\u001d+pa&\u001c\u0017\nZ\u0001\fE\u0006\u0014Hk\u001c9jG&#\u0007%A\nsK\u000e\u0014X-\u0019;fI\n\u000b'\u000fV8qS\u000eLE-\u0001\u000bsK\u000e\u0014X-\u0019;fI\n\u000b'\u000fV8qS\u000eLE\rI\u0001\f_2$')\u0019:QCJ$\b'\u0001\u0007pY\u0012\u0014\u0015M\u001d)beR\u0004\u0004%A\u0006oK^\u0014\u0015M\u001d)beR\u0004\u0014\u0001\u00048fo\n\u000b'\u000fU1siB\u0002\u0013a\u00043fY\u0016$X\r\u001a\"beB\u000b'\u000f\u001e\u0019\u0002!\u0011,G.\u001a;fI\n\u000b'\u000fU1siB\u0002\u0013aC8mI\n\u000b'\u000fU1siF\nAb\u001c7e\u0005\u0006\u0014\b+\u0019:uc\u0001\n1B\\3x\u0005\u0006\u0014\b+\u0019:uc\u0005aa.Z<CCJ\u0004\u0016M\u001d;2A\u0005yA-\u001a7fi\u0016$')\u0019:QCJ$\u0018'\u0001\teK2,G/\u001a3CCJ\u0004\u0016M\u001d;2A\u0005Yq\u000e\u001c3CCJ\u0004\u0016M\u001d;3\u00031yG\u000e\u001a\"beB\u000b'\u000f\u001e\u001a!\u0003-qWm\u001e\"beB\u000b'\u000f\u001e\u001a\u0002\u00199,wOQ1s!\u0006\u0014HO\r\u0011\u0002\u001f\u0011,G.\u001a;fI\n\u000b'\u000fU1siJ\n\u0001\u0003Z3mKR,GMQ1s!\u0006\u0014HO\r\u0011\u00023Q,7\u000f^\"sK\u0006$X\rR3mKRLwN\\#oiJLWm\u001d\u0015\u0004\u0007\n]\u0012\u0001\u00049sKZ\u001cf.\u00199tQ>$XCAB\u0001!\u0011\u0019\u0019a!\u0003\u000e\u0005\r\u0015!bAB\u0004%\u0006AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0004\f\r\u0015!\u0001E'fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u\u00035\u0001(/\u001a<T]\u0006\u00048\u000f[8uA\u0005YCO]1og\u001a|'/\\&SC\u001a$8i\u001c8ue>dG.\u001a:Gk2dW*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000f\u0006\u0005\u0004\u0014\r%2QFB\u0019!\u001da6QCB\r\u0007OI1aa\u0006^\u0005\u0019!V\u000f\u001d7feA111DB\u000f\u0007Ci\u0011![\u0005\u0004\u0007?I'\u0001\u0002'jgR\u0004B!a'\u0004$%!1QEAb\u0005a)\u0006\u000fZ1uK6+G/\u00193bi\u0006$v\u000e]5d'R\fG/\u001a\t\u0007\u00077\u0019iB!\u001e\t\u000f\r-b\t1\u0001\u0004\u0002\u0005y1-\u001e:sK:$X*\u001a;bI\u0006$\u0018\rC\u0004\u00040\u0019\u0003\r!a!\u0002-I,\u0017/^3ti\u000e{g\u000e\u001e:pY2,'/\u00129pG\"Dqaa\rG\u0001\u0004\u0019I\"\u0001\nsKF,Xm\u001d;U_BL7m\u0015;bi\u0016\u001c\u0018!\u0007;sC:\u001chm\u001c:n+6\u0013v+\u001b;i\u001d>\u001c\u0005.\u00198hKND3a\u0012B\u001c\u0003i!(/\u00198tM>\u0014X.V'S/&$\b.T5tg&twMQ1sQ\rA%qG\u0001\u001diJ\fgn\u001d4pe6,VJU,ji\"\u0014Vm\u0019:fCR,GMQ1sQ\rI%qG\u0001\u000eEV<w-_*oCB\u001c\bn\u001c;\u0002\u001d\t,xmZ=T]\u0006\u00048\u000f[8uA\u0005iBO]1og\u001a|'/\\+N%^KG\u000f\u001b\"vO\u001eL8K\\1qg\"|G\u000fK\u0002M\u0005o\tQ\u0005^3tiV\u0003H-\u0019;f5.lU\r^1eCR\f7)Y2iKZK\u0017\rS=ce&$W+\u0014*)\u00075\u00139$A\u0016uKN$X\u000b\u001d3bi\u0016T6.T3uC\u0012\fG/Y\"bG\",w+\u001b;i%\u0016\u001c'/Z1uK\u0012$v\u000e]5dQ\rq%qG\u0001\u000eGJ,\u0017\r^3Gk2dW+\u0014*\u0015\u0007q\u001c)\u0006C\u0004\u0004X=\u0003\ra!\u0017\u0002\u0017Q|\u0007/[2Ti\u0006$Xm\u001d\t\u0007\u0003\u001f\u000b)j!\t\u0002%\rDWmY6DC\u000eDWmQ8oi\u0016tGo\u001d\u000b\u0006k\u000e}3q\r\u0005\u0007sB\u0003\ra!\u0019\u0011\t\r\r11M\u0005\u0005\u0007K\u001a)AA\b[W6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011\u001d\u0019I\u0007\u0015a\u0001\u0007W\n\u0001\"\u001a=qK\u000e$X\r\u001a\t\t\u0005O\u0012yGa\u001f\u0004nA11qNB=\u0005+sAa!\u001d\u0004v9!\u0011qUB:\u0013\u0005q\u0016bAB<;\u00069\u0001/Y2lC\u001e,\u0017\u0002BB>\u0007{\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0007oj\u0006")
public class MetadataCacheTest {
    private final long brokerEpoch;
    private final int oldRequestControllerEpoch;
    private final int newRequestControllerEpoch;
    private final String fooTopicName;
    private final Uuid fooTopicId = Uuid.fromString((String)"HDceyWK0Ry-j3XLR8DvvGA");
    private final UpdateMetadataRequestData.UpdateMetadataPartitionState oldFooPart0 = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.fooTopicName()).setPartitionIndex(0).setControllerEpoch(this.oldRequestControllerEpoch()).setLeader(4).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setZkVersion(789).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setOfflineReplicas(Collections.emptyList());
    private final UpdateMetadataRequestData.UpdateMetadataPartitionState newFooPart0 = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.fooTopicName()).setPartitionIndex(0).setControllerEpoch(this.newRequestControllerEpoch()).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setZkVersion(789).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setOfflineReplicas(Collections.emptyList());
    private final UpdateMetadataRequestData.UpdateMetadataPartitionState oldFooPart1 = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.fooTopicName()).setPartitionIndex(1).setControllerEpoch(this.oldRequestControllerEpoch()).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setZkVersion(789).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setOfflineReplicas(Collections.emptyList());
    private final UpdateMetadataRequestData.UpdateMetadataPartitionState newFooPart1 = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.fooTopicName()).setPartitionIndex(1).setControllerEpoch(this.newRequestControllerEpoch()).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5))).setZkVersion(789).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setOfflineReplicas(Collections.emptyList());
    private final String barTopicName;
    private final Uuid barTopicId = Uuid.fromString((String)"97FBD1g4QyyNNZNY94bkRA");
    private final Uuid recreatedBarTopicId = Uuid.fromString((String)"lZokxuaPRty7c5P4dNdTYA");
    private final UpdateMetadataRequestData.UpdateMetadataPartitionState oldBarPart0 = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.barTopicName()).setPartitionIndex(0).setControllerEpoch(this.oldRequestControllerEpoch()).setLeader(7).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8))).setZkVersion(789).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9))).setOfflineReplicas(Collections.emptyList());
    private final UpdateMetadataRequestData.UpdateMetadataPartitionState newBarPart0 = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.barTopicName()).setPartitionIndex(0).setControllerEpoch(this.newRequestControllerEpoch()).setLeader(7).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8))).setZkVersion(789).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9))).setOfflineReplicas(Collections.emptyList());
    private final UpdateMetadataRequestData.UpdateMetadataPartitionState deletedBarPart0 = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.barTopicName()).setPartitionIndex(0).setControllerEpoch(this.newRequestControllerEpoch()).setLeader(-2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8))).setZkVersion(0).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9))).setOfflineReplicas(Collections.emptyList());
    private final UpdateMetadataRequestData.UpdateMetadataPartitionState oldBarPart1 = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.barTopicName()).setPartitionIndex(1).setControllerEpoch(this.oldRequestControllerEpoch()).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setZkVersion(789).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setOfflineReplicas(Collections.emptyList());
    private final UpdateMetadataRequestData.UpdateMetadataPartitionState newBarPart1 = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.barTopicName()).setPartitionIndex(1).setControllerEpoch(this.newRequestControllerEpoch()).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setZkVersion(789).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setOfflineReplicas(Collections.emptyList());
    private final UpdateMetadataRequestData.UpdateMetadataPartitionState deletedBarPart1 = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.barTopicName()).setPartitionIndex(1).setControllerEpoch(this.newRequestControllerEpoch()).setLeader(-2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setZkVersion(0).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setOfflineReplicas(Collections.emptyList());
    private final UpdateMetadataRequestData.UpdateMetadataPartitionState oldBarPart2 = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.barTopicName()).setPartitionIndex(2).setControllerEpoch(this.oldRequestControllerEpoch()).setLeader(9).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9))).setZkVersion(789).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9))).setOfflineReplicas(Collections.emptyList());
    private final UpdateMetadataRequestData.UpdateMetadataPartitionState newBarPart2 = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.barTopicName()).setPartitionIndex(2).setControllerEpoch(this.newRequestControllerEpoch()).setLeader(8).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8))).setZkVersion(789).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9))).setOfflineReplicas(Collections.emptyList());
    private final UpdateMetadataRequestData.UpdateMetadataPartitionState deletedBarPart2 = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.barTopicName()).setPartitionIndex(2).setControllerEpoch(this.newRequestControllerEpoch()).setLeader(-2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9))).setZkVersion(0).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9))).setOfflineReplicas(Collections.emptyList());
    private final MetadataSnapshot prevSnapshot;
    private final MetadataSnapshot buggySnapshot;

    public static void updateCache(MetadataCache cache, UpdateMetadataRequest request) {
        MetadataCacheTest$.MODULE$.updateCache(cache, request);
    }

    public static Stream<MetadataCache> cacheProvider() {
        return MetadataCacheTest$.MODULE$.cacheProvider();
    }

    public static Stream<MetadataCache> zkCacheProvider() {
        return MetadataCacheTest$.MODULE$.zkCacheProvider();
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataNonExistingTopics(MetadataCache cache) {
        String topic = "topic";
        Assertions.assertTrue((boolean)cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4()).isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadata(MetadataCache cache) {
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getTopicMetadata$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(1).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(1).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(4))), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic1).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(2).setLeaderEpoch(2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)Nil$.MODULE$)));
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic0, Uuid.randomUuid());
        topicIds.put(topic1, Uuid.randomUuid());
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), topicIds).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        new .colon.colon((Object)SecurityProtocol.PLAINTEXT, (List)new .colon.colon((Object)SecurityProtocol.SSL, (List)Nil$.MODULE$)).foreach(arg_0 -> MetadataCacheTest.$anonfun$getTopicMetadata$2$adapted(cache, topicIds, (Seq)partitionStates, topic0, topic1, arg_0));
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionLeaderNotAvailable(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader(MetadataCache cache) {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        .colon.colon broker0Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(sslListenerName.value()), (List)Nil$.MODULE$));
        .colon.colon broker1Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)Nil$.MODULE$);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)broker0Endpoints).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)broker1Endpoints).asJava()), (List)Nil$.MODULE$));
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(MetadataCache cache, int metadataCacheBrokerId, Seq<UpdateMetadataRequestData.UpdateMetadataBroker> brokers, ListenerName listenerName, int leader, Errors expectedError, boolean errorUnavailableListeners) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        int leaderEpoch = 1;
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0))), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava(brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        boolean x$4 = cache.getTopicMetadata$default$3();
        Seq topicMetadatas = cache.getTopicMetadata((Set)x$1, listenerName, x$4, errorUnavailableListeners);
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)expectedError.code(), (short)partitionMetadata.errorCode());
        Assertions.assertFalse((boolean)partitionMetadata.isrNodes().isEmpty());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataReplicaNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataIsrNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataWithNonSupportedSecurityProtocol(MetadataCache cache) {
        String topic = "topic";
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadata.size());
        Assertions.assertEquals((int)1, (int)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().size());
        Assertions.assertEquals((int)-1, (int)((MetadataResponseData.MetadataResponsePartition)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().get(0)).leaderId());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache(MetadataCache cache) {
        String topic = "topic";
        Range.Inclusive initialBrokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2);
        this.updateCache$1((Seq)initialBrokerIds, topic, cache);
        Iterable aliveBrokersFromCache = cache.getAliveBrokers();
        this.updateCache$1((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3), topic, cache);
        Assertions.assertEquals((Object)initialBrokerIds.toSet(), (Object)((IterableOnceOps)aliveBrokersFromCache.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id))).toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"zkCacheProvider"})
    public void testGetClusterMetadataWithOfflineReplicas(MetadataCache cache) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("r").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava()), (List)Nil$.MODULE$));
        int controllerEpoch = 1;
        int leader = 1;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> offline = Arrays.asList(Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(topicPartition.partition()).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas).setOfflineReplicas(offline), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Node expectedNode0 = new Node(0, "foo", 9092, "r");
        Node expectedNode1 = new Node(1, "", -1);
        Cluster cluster = cache.getClusterMetadata("clusterId", listenerName);
        Assertions.assertEquals((Object)expectedNode0, (Object)cluster.nodeById(0));
        Assertions.assertNull((Object)cluster.nodeById(1));
        Assertions.assertEquals((Object)expectedNode1, (Object)cluster.leaderFor(topicPartition));
        PartitionInfo partitionInfo = cluster.partition(topicPartition);
        Assertions.assertEquals((Object)expectedNode1, (Object)partitionInfo.leader());
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())));
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.inSyncReplicas())));
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.offlineReplicas())));
    }

    @Test
    public void testIsBrokerFenced() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setFenced(false));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertFalse((boolean)metadataCache.isBrokerFenced(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setFenced((byte)1));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertTrue((boolean)metadataCache.isBrokerFenced(0));
    }

    @Test
    public void testGetAliveBrokersWithBrokerFenced() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        String listenerName = "listener";
        RegisterBrokerRecord.BrokerEndpointCollection endpoints = new RegisterBrokerRecord.BrokerEndpointCollection();
        endpoints.add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setName(listenerName).setHost("foo").setPort(123).setSecurityProtocol((short)0));
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setFenced(false).setEndPoints(endpoints));
        delta.replay(new RegisterBrokerRecord().setBrokerId(1).setFenced(false).setEndPoints(endpoints));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(1).setFenced((byte)1));
        MetadataImage metadataImage = delta.apply(MetadataProvenance.EMPTY);
        metadataCache.setImage(metadataImage);
        Assertions.assertFalse((boolean)metadataCache.isBrokerFenced(0));
        Assertions.assertTrue((boolean)metadataCache.isBrokerFenced(1));
        scala.collection.immutable.Set aliveBrokers = ((IterableOnceOps)metadataCache.getAliveBrokers().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id))).toSet();
        metadataImage.cluster().brokers().forEach((brokerId, registration) -> {
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!registration.fenced() ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)aliveBrokers.contains((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId)))));
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)aliveBrokers.contains((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId)))), (Object)BoxesRunTime.boxToBoolean((boolean)metadataCache.getAliveBrokerNode(Predef$.MODULE$.Integer2int(brokerId), new ListenerName(listenerName)).isDefined()));
        });
    }

    @Test
    public void testIsBrokerInControlledShutdown() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setInControlledShutdown(false));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertFalse((boolean)metadataCache.isBrokerShuttingDown(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setInControlledShutdown((byte)1));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertTrue((boolean)metadataCache.isBrokerShuttingDown(0));
    }

    @Test
    public void testGetLiveBrokerEpoch() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(false));
        delta.replay(new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(101L).setFenced(true));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertEquals((long)100L, (long)BoxesRunTime.unboxToLong((Object)metadataCache.getAliveBrokerEpoch(0).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
        Assertions.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)metadataCache.getAliveBrokerEpoch(1).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void testGetPartitionInfo(MetadataCache cache) {
        String topic = "topic";
        int partitionIndex = 0;
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0));
        int zkVersion = 3;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(4));
        java.util.List<Integer> offlineReplicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(partitionIndex).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas).setOfflineReplicas(offlineReplicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        int controllerId = 2;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap(), false, AbstractControlRequest.Type.UNKNOWN).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)cache.getPartitionInfo(topic, partitionIndex).get();
        Assertions.assertEquals((Object)topic, (Object)partitionState.topicName());
        Assertions.assertEquals((int)partitionIndex, (int)partitionState.partitionIndex());
        if (cache instanceof ZkMetadataCache) {
            Assertions.assertEquals((int)controllerEpoch, (int)partitionState.controllerEpoch());
        } else {
            Assertions.assertEquals((int)-1, (int)partitionState.controllerEpoch());
        }
        Assertions.assertEquals((int)leader, (int)partitionState.leader());
        Assertions.assertEquals((int)leaderEpoch, (int)partitionState.leaderEpoch());
        Assertions.assertEquals(isr, (Object)partitionState.isr());
        Assertions.assertEquals((int)zkVersion, (int)partitionState.zkVersion());
        Assertions.assertEquals(replicas, (Object)partitionState.replicas());
        if (cache instanceof ZkMetadataCache) {
            Assertions.assertEquals(offlineReplicas, (Object)partitionState.offlineReplicas());
            return;
        }
    }

    public Tuple4<scala.collection.immutable.Map<String, Uuid>, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>, scala.collection.immutable.Map<String, Uuid>, Seq<UpdateMetadataRequestData.UpdateMetadataPartitionState>> setupInitialAndFullMetadata() {
        AnyRefMap initialTopicStates = AnyRefMap$.MODULE$.empty();
        MetadataCacheTest.addTopic$1("test-topic-1", 3, initialTopicStates);
        MetadataCacheTest.addTopic$1("test-topic-2", 3, initialTopicStates);
        scala.collection.immutable.Map initialTopicIds = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-1"), (Object)Uuid.fromString((String)"IQ2F1tpCRoSbjfq4zBJwpg")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-2"), (Object)Uuid.fromString((String)"4N8_J-q7SdWHPFkos275pQ"))}));
        scala.collection.immutable.Map newTopicIds = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"different-topic"), (Object)Uuid.fromString((String)"DraFMNOJQOC5maTb1vtZ8Q"))}));
        .colon.colon newPartitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("different-topic").setPartitionIndex(0).setControllerEpoch(42).setLeader(0).setLeaderEpoch(10).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))).setZkVersion(1).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (List)Nil$.MODULE$);
        return new Tuple4((Object)initialTopicIds, (Object)initialTopicStates, (Object)newTopicIds, (Object)newPartitionStates);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandleFullUpdateMetadataRequestInZkMigration() {
        void var2_2;
        void var3_3;
        void var4_4;
        void var5_5;
        Tuple4<scala.collection.immutable.Map<String, Uuid>, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>, scala.collection.immutable.Map<String, Uuid>, Seq<UpdateMetadataRequestData.UpdateMetadataPartitionState>> tuple4 = this.setupInitialAndFullMetadata();
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Map initialTopicIds = (scala.collection.immutable.Map)tuple4._1();
        AnyRefMap initialTopicStates = (AnyRefMap)tuple4._2();
        scala.collection.immutable.Map newTopicIds = (scala.collection.immutable.Map)tuple4._3();
        Seq newPartitionStates = (Seq)tuple4._4();
        UpdateMetadataRequest updateMetadataRequest = MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$1(this, (Seq)var5_5, (scala.collection.immutable.Map)var4_4);
        updateMetadataRequest.data().setIsKRaftController(true);
        updateMetadataRequest.data().setType(AbstractControlRequest.Type.FULL.toByte());
        boolean verifyMetadataCache$1_zkMigrationEnabled = false;
        MetadataVersion verifyMetadataCache$1_x$2 = MetadataVersion.latest();
        BrokerFeatures verifyMetadataCache$1_x$4 = BrokerFeatures$.MODULE$.createEmpty();
        Seq verifyMetadataCache$1_x$5 = (Seq)Seq$.MODULE$.empty();
        int verifyMetadataCache$1_zkMetadataCache_brokerId = 1;
        ZkMetadataCache verifyMetadataCache$1_cache = new ZkMetadataCache(verifyMetadataCache$1_zkMetadataCache_brokerId, verifyMetadataCache$1_x$2, verifyMetadataCache$1_x$4, verifyMetadataCache$1_x$5, verifyMetadataCache$1_zkMigrationEnabled);
        verifyMetadataCache$1_cache.updateMetadata(1, (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)var3_3.flatMap((Function1 & Serializable)x$7 -> ((MapOps)x$7._2()).values())).toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)var2_2).asJava()).build());
        verifyMetadataCache$1_cache.updateMetadata(1, updateMetadataRequest);
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$3(verifyMetadataCache$1_cache);
        Object var8_12 = null;
        Object var9_8 = null;
        Object var10_9 = null;
        Object var11_10 = null;
        updateMetadataRequest = MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$1(this, (Seq)var5_5, (scala.collection.immutable.Map)var4_4);
        boolean verifyMetadataCache$1_zkMigrationEnabled2 = true;
        MetadataVersion verifyMetadataCache$1_x$22 = MetadataVersion.latest();
        BrokerFeatures verifyMetadataCache$1_x$42 = BrokerFeatures$.MODULE$.createEmpty();
        Seq verifyMetadataCache$1_x$52 = (Seq)Seq$.MODULE$.empty();
        int verifyMetadataCache$1_zkMetadataCache_brokerId2 = 1;
        ZkMetadataCache verifyMetadataCache$1_cache2 = new ZkMetadataCache(verifyMetadataCache$1_zkMetadataCache_brokerId2, verifyMetadataCache$1_x$22, verifyMetadataCache$1_x$42, verifyMetadataCache$1_x$52, verifyMetadataCache$1_zkMigrationEnabled2);
        verifyMetadataCache$1_cache2.updateMetadata(1, (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)var3_3.flatMap((Function1 & Serializable)x$7 -> ((MapOps)x$7._2()).values())).toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)var2_2).asJava()).build());
        verifyMetadataCache$1_cache2.updateMetadata(1, updateMetadataRequest);
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$4(verifyMetadataCache$1_cache2);
        Object var14_18 = null;
        Object var15_14 = null;
        Object var16_15 = null;
        Object var17_16 = null;
        updateMetadataRequest = MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$1(this, (Seq)var5_5, (scala.collection.immutable.Map)var4_4);
        updateMetadataRequest.data().setIsKRaftController(false);
        boolean verifyMetadataCache$1_zkMigrationEnabled3 = true;
        MetadataVersion verifyMetadataCache$1_x$23 = MetadataVersion.latest();
        BrokerFeatures verifyMetadataCache$1_x$43 = BrokerFeatures$.MODULE$.createEmpty();
        Seq verifyMetadataCache$1_x$53 = (Seq)Seq$.MODULE$.empty();
        int verifyMetadataCache$1_zkMetadataCache_brokerId3 = 1;
        ZkMetadataCache verifyMetadataCache$1_cache3 = new ZkMetadataCache(verifyMetadataCache$1_zkMetadataCache_brokerId3, verifyMetadataCache$1_x$23, verifyMetadataCache$1_x$43, verifyMetadataCache$1_x$53, verifyMetadataCache$1_zkMigrationEnabled3);
        verifyMetadataCache$1_cache3.updateMetadata(1, (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)var3_3.flatMap((Function1 & Serializable)x$7 -> ((MapOps)x$7._2()).values())).toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)var2_2).asJava()).build());
        verifyMetadataCache$1_cache3.updateMetadata(1, updateMetadataRequest);
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$5(verifyMetadataCache$1_cache3);
        Object var20_24 = null;
        Object var21_20 = null;
        Object var22_21 = null;
        Object var23_22 = null;
        updateMetadataRequest = MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$1(this, (Seq)var5_5, (scala.collection.immutable.Map)var4_4);
        updateMetadataRequest.data().setType(AbstractControlRequest.Type.INCREMENTAL.toByte());
        boolean verifyMetadataCache$1_zkMigrationEnabled4 = true;
        MetadataVersion verifyMetadataCache$1_x$24 = MetadataVersion.latest();
        BrokerFeatures verifyMetadataCache$1_x$44 = BrokerFeatures$.MODULE$.createEmpty();
        Seq verifyMetadataCache$1_x$54 = (Seq)Seq$.MODULE$.empty();
        int verifyMetadataCache$1_zkMetadataCache_brokerId4 = 1;
        ZkMetadataCache verifyMetadataCache$1_cache4 = new ZkMetadataCache(verifyMetadataCache$1_zkMetadataCache_brokerId4, verifyMetadataCache$1_x$24, verifyMetadataCache$1_x$44, verifyMetadataCache$1_x$54, verifyMetadataCache$1_zkMigrationEnabled4);
        verifyMetadataCache$1_cache4.updateMetadata(1, (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)var3_3.flatMap((Function1 & Serializable)x$7 -> ((MapOps)x$7._2()).values())).toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)var2_2).asJava()).build());
        verifyMetadataCache$1_cache4.updateMetadata(1, updateMetadataRequest);
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$6(verifyMetadataCache$1_cache4);
        Object var26_30 = null;
        Object var27_26 = null;
        Object var28_27 = null;
        Object var29_28 = null;
        updateMetadataRequest = MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$1(this, (Seq)var5_5, (scala.collection.immutable.Map)var4_4);
        updateMetadataRequest.data().setType(AbstractControlRequest.Type.UNKNOWN.toByte());
        boolean verifyMetadataCache$1_zkMigrationEnabled5 = true;
        MetadataVersion verifyMetadataCache$1_x$25 = MetadataVersion.latest();
        BrokerFeatures verifyMetadataCache$1_x$45 = BrokerFeatures$.MODULE$.createEmpty();
        Seq verifyMetadataCache$1_x$55 = (Seq)Seq$.MODULE$.empty();
        int verifyMetadataCache$1_zkMetadataCache_brokerId5 = 1;
        ZkMetadataCache verifyMetadataCache$1_cache5 = new ZkMetadataCache(verifyMetadataCache$1_zkMetadataCache_brokerId5, verifyMetadataCache$1_x$25, verifyMetadataCache$1_x$45, verifyMetadataCache$1_x$55, verifyMetadataCache$1_zkMigrationEnabled5);
        verifyMetadataCache$1_cache5.updateMetadata(1, (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)var3_3.flatMap((Function1 & Serializable)x$7 -> ((MapOps)x$7._2()).values())).toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)var2_2).asJava()).build());
        verifyMetadataCache$1_cache5.updateMetadata(1, updateMetadataRequest);
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$7(verifyMetadataCache$1_cache5);
    }

    public int oldRequestControllerEpoch() {
        return this.oldRequestControllerEpoch;
    }

    public int newRequestControllerEpoch() {
        return this.newRequestControllerEpoch;
    }

    public String fooTopicName() {
        return this.fooTopicName;
    }

    public Uuid fooTopicId() {
        return this.fooTopicId;
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState oldFooPart0() {
        return this.oldFooPart0;
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState newFooPart0() {
        return this.newFooPart0;
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState oldFooPart1() {
        return this.oldFooPart1;
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState newFooPart1() {
        return this.newFooPart1;
    }

    public String barTopicName() {
        return this.barTopicName;
    }

    public Uuid barTopicId() {
        return this.barTopicId;
    }

    public Uuid recreatedBarTopicId() {
        return this.recreatedBarTopicId;
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState oldBarPart0() {
        return this.oldBarPart0;
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState newBarPart0() {
        return this.newBarPart0;
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState deletedBarPart0() {
        return this.deletedBarPart0;
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState oldBarPart1() {
        return this.oldBarPart1;
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState newBarPart1() {
        return this.newBarPart1;
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState deletedBarPart1() {
        return this.deletedBarPart1;
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState oldBarPart2() {
        return this.oldBarPart2;
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState newBarPart2() {
        return this.newBarPart2;
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState deletedBarPart2() {
        return this.deletedBarPart2;
    }

    @Test
    public void testCreateDeletionEntries() {
        Assertions.assertEquals((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.fooTopicName()).setTopicId(this.fooTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.fooTopicName()).setPartitionIndex(0).setControllerEpoch(this.newRequestControllerEpoch()).setLeader(-2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setZkVersion(0).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setOfflineReplicas(Collections.emptyList()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(this.fooTopicName()).setPartitionIndex(1).setControllerEpoch(this.newRequestControllerEpoch()).setLeader(-2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setZkVersion(0).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setOfflineReplicas(Collections.emptyList()), (List)Nil$.MODULE$))).asJava()), (Object)ZkMetadataCache$.MODULE$.createDeletionEntries(this.fooTopicName(), this.fooTopicId(), (Iterable)new .colon.colon((Object)this.oldFooPart0(), (List)new .colon.colon((Object)this.oldFooPart1(), (List)Nil$.MODULE$)), this.newRequestControllerEpoch()));
    }

    public MetadataSnapshot prevSnapshot() {
        return this.prevSnapshot;
    }

    public Tuple2<java.util.List<UpdateMetadataRequestData.UpdateMetadataTopicState>, java.util.List<String>> transformKRaftControllerFullMetadataRequest(MetadataSnapshot currentMetadata, int requestControllerEpoch, java.util.List<UpdateMetadataRequestData.UpdateMetadataTopicState> requestTopicStates) {
        java.util.List<UpdateMetadataRequestData.UpdateMetadataTopicState> list;
        ArrayList logs = new ArrayList();
        Function1 & Serializable transformKRaftControllerFullMetadataRequest_handleLogMessage = (Function1 & Serializable)log -> {
            logs.add(log);
            return BoxedUnit.UNIT;
        };
        HashMap transformKRaftControllerFullMetadataRequest_topicIdToNewState = new HashMap();
        requestTopicStates.forEach(arg_0 -> ZkMetadataCache$.$anonfun$transformKRaftControllerFullMetadataRequest$1(transformKRaftControllerFullMetadataRequest_topicIdToNewState, arg_0));
        ArrayList<UpdateMetadataRequestData.UpdateMetadataTopicState> transformKRaftControllerFullMetadataRequest_newRequestTopicStates = new ArrayList<UpdateMetadataRequestData.UpdateMetadataTopicState>();
        currentMetadata.topicNames().foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((arg_0, arg_1) -> ZkMetadataCache$.$anonfun$transformKRaftControllerFullMetadataRequest$2(transformKRaftControllerFullMetadataRequest_topicIdToNewState, (MetadataSnapshot)currentMetadata, (Function1)transformKRaftControllerFullMetadataRequest_handleLogMessage, transformKRaftControllerFullMetadataRequest_newRequestTopicStates, (int)requestControllerEpoch, arg_0, arg_1), arg_0, arg_1));
        if (transformKRaftControllerFullMetadataRequest_newRequestTopicStates.isEmpty()) {
            list = requestTopicStates;
        } else {
            transformKRaftControllerFullMetadataRequest_newRequestTopicStates.addAll(requestTopicStates);
            list = transformKRaftControllerFullMetadataRequest_newRequestTopicStates;
        }
        Object var6_5 = null;
        Object var7_6 = null;
        Object var8_7 = null;
        java.util.List<UpdateMetadataRequestData.UpdateMetadataTopicState> results = list;
        return new Tuple2(results, logs);
    }

    @Test
    public void transformUMRWithNoChanges() {
        Assertions.assertEquals((Object)new Tuple2((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.fooTopicName()).setTopicId(this.fooTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newFooPart0(), (List)new .colon.colon((Object)this.newFooPart1(), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.barTopicName()).setTopicId(this.barTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newBarPart0(), (List)new .colon.colon((Object)this.newBarPart1(), (List)new .colon.colon((Object)this.newBarPart2(), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$))).asJava(), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava()), this.transformKRaftControllerFullMetadataRequest(this.prevSnapshot(), this.newRequestControllerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.fooTopicName()).setTopicId(this.fooTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newFooPart0(), (List)new .colon.colon((Object)this.newFooPart1(), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.barTopicName()).setTopicId(this.barTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newBarPart0(), (List)new .colon.colon((Object)this.newBarPart1(), (List)new .colon.colon((Object)this.newBarPart2(), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$))).asJava()));
    }

    @Test
    public void transformUMRWithMissingBar() {
        Assertions.assertEquals((Object)new Tuple2((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.barTopicName()).setTopicId(this.barTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.deletedBarPart0(), (List)new .colon.colon((Object)this.deletedBarPart1(), (List)new .colon.colon((Object)this.deletedBarPart2(), (List)Nil$.MODULE$)))).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.fooTopicName()).setTopicId(this.fooTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newFooPart0(), (List)new .colon.colon((Object)this.newFooPart1(), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$))).asJava(), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"Removing topic bar with ID 97FBD1g4QyyNNZNY94bkRA from the metadata cache since the full UMR did not include it.", (List)Nil$.MODULE$)).asJava()), this.transformKRaftControllerFullMetadataRequest(this.prevSnapshot(), this.newRequestControllerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.fooTopicName()).setTopicId(this.fooTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newFooPart0(), (List)new .colon.colon((Object)this.newFooPart1(), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$)).asJava()));
    }

    @Test
    public void transformUMRWithRecreatedBar() {
        Assertions.assertEquals((Object)new Tuple2((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.barTopicName()).setTopicId(this.barTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.deletedBarPart0(), (List)new .colon.colon((Object)this.deletedBarPart1(), (List)new .colon.colon((Object)this.deletedBarPart2(), (List)Nil$.MODULE$)))).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.fooTopicName()).setTopicId(this.fooTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newFooPart0(), (List)new .colon.colon((Object)this.newFooPart1(), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.barTopicName()).setTopicId(this.recreatedBarTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newBarPart0(), (List)new .colon.colon((Object)this.newBarPart1(), (List)new .colon.colon((Object)this.newBarPart2(), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)))).asJava(), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"Removing topic bar with ID 97FBD1g4QyyNNZNY94bkRA from the metadata cache since the full UMR did not include it.", (List)Nil$.MODULE$)).asJava()), this.transformKRaftControllerFullMetadataRequest(this.prevSnapshot(), this.newRequestControllerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.fooTopicName()).setTopicId(this.fooTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newFooPart0(), (List)new .colon.colon((Object)this.newFooPart1(), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.barTopicName()).setTopicId(this.recreatedBarTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newBarPart0(), (List)new .colon.colon((Object)this.newBarPart1(), (List)new .colon.colon((Object)this.newBarPart2(), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$))).asJava()));
    }

    public MetadataSnapshot buggySnapshot() {
        return this.buggySnapshot;
    }

    @Test
    public void transformUMRWithBuggySnapshot() {
        Assertions.assertEquals((Object)new Tuple2((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.fooTopicName()).setTopicId(this.fooTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newFooPart0(), (List)new .colon.colon((Object)this.newFooPart1(), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.barTopicName()).setTopicId(this.barTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newBarPart0(), (List)new .colon.colon((Object)this.newBarPart1(), (List)new .colon.colon((Object)this.newBarPart2(), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$))).asJava(), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"Error: topic foo appeared in currentMetadata.topicNames, but not in currentMetadata.partitionStates.", (List)new .colon.colon((Object)"Error: topic bar appeared in currentMetadata.topicNames, but not in currentMetadata.partitionStates.", (List)Nil$.MODULE$))).asJava()), this.transformKRaftControllerFullMetadataRequest(this.buggySnapshot(), this.newRequestControllerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.fooTopicName()).setTopicId(this.fooTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newFooPart0(), (List)new .colon.colon((Object)this.newFooPart1(), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.barTopicName()).setTopicId(this.barTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newBarPart0(), (List)new .colon.colon((Object)this.newBarPart1(), (List)new .colon.colon((Object)this.newBarPart2(), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$))).asJava()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateZkMetadataCacheViaHybridUMR() {
        void zkMetadataCache_zkMigrationEnabled;
        void zkMetadataCache_kraftControllerNodes;
        void zkMetadataCache_brokerFeatures;
        boolean bl = false;
        Seq seq = (Seq)Seq$.MODULE$.empty();
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        MetadataVersion zkMetadataCache_metadataVersion = MetadataVersion.latest();
        int zkMetadataCache_brokerId = 1;
        Object var3_4 = null;
        brokerFeatures = null;
        seq = null;
        ZkMetadataCache cache = new ZkMetadataCache(zkMetadataCache_brokerId, zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures, (Seq)zkMetadataCache_kraftControllerNodes, (boolean)zkMetadataCache_zkMigrationEnabled);
        cache.updateMetadata(123, this.createFullUMR((Seq<UpdateMetadataRequestData.UpdateMetadataTopicState>)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.fooTopicName()).setTopicId(this.fooTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.oldFooPart0(), (List)new .colon.colon((Object)this.oldFooPart1(), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.barTopicName()).setTopicId(this.barTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.oldBarPart0(), (List)new .colon.colon((Object)this.oldBarPart1(), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$))));
        this.checkCacheContents(cache, (scala.collection.immutable.Map<Uuid, Iterable<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fooTopicId()), (Object)new .colon.colon((Object)this.oldFooPart0(), (List)new .colon.colon((Object)this.oldFooPart1(), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.barTopicId()), (Object)new .colon.colon((Object)this.oldBarPart0(), (List)new .colon.colon((Object)this.oldBarPart1(), (List)Nil$.MODULE$)))}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateZkMetadataCacheWithRecreatedTopic() {
        void zkMetadataCache_zkMigrationEnabled;
        void zkMetadataCache_kraftControllerNodes;
        void zkMetadataCache_brokerFeatures;
        boolean bl = false;
        Seq seq = (Seq)Seq$.MODULE$.empty();
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        MetadataVersion zkMetadataCache_metadataVersion = MetadataVersion.latest();
        int zkMetadataCache_brokerId = 1;
        Object var3_4 = null;
        brokerFeatures = null;
        seq = null;
        ZkMetadataCache cache = new ZkMetadataCache(zkMetadataCache_brokerId, zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures, (Seq)zkMetadataCache_kraftControllerNodes, (boolean)zkMetadataCache_zkMigrationEnabled);
        cache.updateMetadata(123, this.createFullUMR((Seq<UpdateMetadataRequestData.UpdateMetadataTopicState>)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.fooTopicName()).setTopicId(this.fooTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.oldFooPart0(), (List)new .colon.colon((Object)this.oldFooPart1(), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.barTopicName()).setTopicId(this.barTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.oldBarPart0(), (List)new .colon.colon((Object)this.oldBarPart1(), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$))));
        cache.updateMetadata(124, this.createFullUMR((Seq<UpdateMetadataRequestData.UpdateMetadataTopicState>)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.fooTopicName()).setTopicId(this.fooTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.newFooPart0(), (List)new .colon.colon((Object)this.newFooPart1(), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(this.barTopicName()).setTopicId(this.barTopicId()).setPartitionStates(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.oldBarPart0(), (List)new .colon.colon((Object)this.oldBarPart1(), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$))));
        this.checkCacheContents(cache, (scala.collection.immutable.Map<Uuid, Iterable<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fooTopicId()), (Object)new .colon.colon((Object)this.newFooPart0(), (List)new .colon.colon((Object)this.newFooPart1(), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.barTopicId()), (Object)new .colon.colon((Object)this.oldBarPart0(), (List)new .colon.colon((Object)this.oldBarPart1(), (List)Nil$.MODULE$)))}))));
    }

    public UpdateMetadataRequest createFullUMR(Seq<UpdateMetadataRequestData.UpdateMetadataTopicState> topicStates) {
        UpdateMetadataRequestData data = new UpdateMetadataRequestData().setControllerId(0).setIsKRaftController(true).setControllerEpoch(123).setBrokerEpoch(456L).setTopicStates(CollectionConverters$.MODULE$.SeqHasAsJava(topicStates).asJava());
        return new UpdateMetadataRequest(data, (short)8);
    }

    public void checkCacheContents(ZkMetadataCache cache, scala.collection.immutable.Map<Uuid, Iterable<UpdateMetadataRequestData.UpdateMetadataPartitionState>> expected) {
        HashMap expectedTopics = new HashMap();
        HashMap expectedIds = new HashMap();
        HashMap expectedParts = new HashMap();
        expected.foreach((Function1 & Serializable)x0$1 -> {
            MetadataCacheTest.$anonfun$checkCacheContents$1(expectedTopics, expectedIds, expectedParts, x0$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(expectedTopics, (Object)cache.topicNamesToIds());
        Assertions.assertEquals(expectedIds, (Object)cache.topicIdsToNames());
        cache.getAllTopics().foreach((Function1 & Serializable)topic -> {
            MetadataCacheTest.$anonfun$checkCacheContents$4(expectedParts, cache, topic);
            return BoxedUnit.UNIT;
        });
    }

    private static final Seq endpoints$2(int brokerId) {
        String host = new StringBuilder(4).append("foo-").append(brokerId).toString();
        return new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value()), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getTopicMetadata$1(int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava(MetadataCacheTest.endpoints$2(brokerId)).asJava()).setRack("rack1");
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$3(String topic$2, UpdateMetadataRequestData.UpdateMetadataPartitionState ps) {
        String string = ps.topicName();
        return !(string != null ? !string.equals(topic$2) : topic$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$6(int partitionId$1, UpdateMetadataRequestData.UpdateMetadataPartitionState x$3) {
        return x$3.partitionIndex() == partitionId$1;
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$5(Seq topicPartitionStates$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)x0$1._1();
            int partitionId = x0$1._2$mcI$sp();
            Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
            Assertions.assertEquals((int)partitionId, (int)partitionMetadata.partitionIndex());
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)topicPartitionStates$1.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$6(partitionId, x$3))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(45).append("Unable to find partition state for partition ").append(partitionId).toString()));
            Assertions.assertEquals((int)partitionState.leader(), (int)partitionMetadata.leaderId());
            Assertions.assertEquals((int)partitionState.leaderEpoch(), (int)partitionMetadata.leaderEpoch());
            Assertions.assertEquals((Object)partitionState.isr(), (Object)partitionMetadata.isrNodes());
            Assertions.assertEquals((Object)partitionState.replicas(), (Object)partitionMetadata.replicaNodes());
            return;
        }
        throw new MatchError(null);
    }

    private static final void checkTopicMetadata$1(String topic, MetadataCache cache$1, ListenerName listenerName$1, HashMap topicIds$1, Seq partitionStates$1) {
        Seq topicMetadatas = cache$1.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName$1, cache$1.getTopicMetadata$default$3(), cache$1.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        Assertions.assertEquals((Object)topic, (Object)topicMetadata.name());
        Assertions.assertEquals(topicIds$1.get(topic), (Object)topicMetadata.topicId());
        Seq topicPartitionStates = (Seq)partitionStates$1.filter((Function1 & Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$3(topic, ps)));
        Buffer partitionMetadatas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitions()).asScala().sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partitionIndex()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)topicPartitionStates.size(), (int)partitionMetadatas.size(), (String)new StringBuilder(37).append("Unexpected partition count for topic ").append(topic).toString());
        ((IterableOnceOps)partitionMetadatas.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            MetadataCacheTest.$anonfun$getTopicMetadata$5(topicPartitionStates, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$2(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        MetadataCacheTest.checkTopicMetadata$1(topic0$1, cache$1, listenerName, topicIds$1, partitionStates$1);
        MetadataCacheTest.checkTopicMetadata$1(topic1$1, cache$1, listenerName, topicIds$1, partitionStates$1);
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(int brokerId) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava());
    }

    private final void updateCache$1(Seq brokerIds, String topic$3, MetadataCache cache$2) {
        Seq brokers = (Seq)brokerIds.map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic$3).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava(brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache$2, updateMetadataRequest);
    }

    public static final /* synthetic */ Option $anonfun$setupInitialAndFullMetadata$1(LongMap partitionMap$1, String name$1, int i) {
        return partitionMap$1.put((long)i, (Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(name$1).setPartitionIndex(i).setControllerEpoch(2).setLeader(0).setLeaderEpoch(10).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1))).setZkVersion(10).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))));
    }

    private static final void addTopic$1(String name, int partitions, AnyRefMap topicStates) {
        LongMap partitionMap = LongMap$.MODULE$.empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), partitions).foreach((Function1 & Serializable)i -> MetadataCacheTest.$anonfun$setupInitialAndFullMetadata$1(partitionMap, name, BoxesRunTime.unboxToInt((Object)i)));
        topicStates.put((Object)name, (Object)partitionMap);
    }

    public static final /* synthetic */ UpdateMetadataRequest $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$1(MetadataCacheTest $this, Seq newPartitionStates$1, scala.collection.immutable.Map newTopicIds$1) {
        return (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, $this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava(newPartitionStates$1).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)newTopicIds$1).asJava(), true, AbstractControlRequest.Type.FULL).build();
    }

    private final void verifyMetadataCache$1(UpdateMetadataRequest updateMetadataRequest, boolean zkMigrationEnabled, Function1 verifier, AnyRefMap initialTopicStates$1, scala.collection.immutable.Map initialTopicIds$1) {
        MetadataVersion x$2 = MetadataVersion.latest();
        BrokerFeatures x$4 = BrokerFeatures$.MODULE$.createEmpty();
        Seq x$5 = (Seq)Seq$.MODULE$.empty();
        int zkMetadataCache_brokerId = 1;
        ZkMetadataCache cache = new ZkMetadataCache(zkMetadataCache_brokerId, x$2, x$4, x$5, zkMigrationEnabled);
        cache.updateMetadata(1, (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)initialTopicStates$1.flatMap((Function1 & Serializable)x$7 -> ((MapOps)x$7._2()).values())).toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)initialTopicIds$1).asJava()).build());
        cache.updateMetadata(1, updateMetadataRequest);
        verifier.apply((Object)cache);
    }

    private static final boolean verifyMetadataCache$default$2$1() {
        return true;
    }

    public static final /* synthetic */ void $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$3(ZkMetadataCache cache) {
        Assertions.assertEquals((int)3, (int)cache.getAllTopics().size());
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
    }

    public static final /* synthetic */ void $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$4(ZkMetadataCache cache) {
        Assertions.assertEquals((int)1, (int)cache.getAllTopics().size());
        Assertions.assertFalse((boolean)cache.contains("test-topic-1"));
        Assertions.assertFalse((boolean)cache.contains("test-topic-1"));
    }

    public static final /* synthetic */ void $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$5(ZkMetadataCache cache) {
        Assertions.assertEquals((int)3, (int)cache.getAllTopics().size());
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
    }

    public static final /* synthetic */ void $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$6(ZkMetadataCache cache) {
        Assertions.assertEquals((int)3, (int)cache.getAllTopics().size());
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
    }

    public static final /* synthetic */ void $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$7(ZkMetadataCache cache) {
        Assertions.assertEquals((int)3, (int)cache.getAllTopics().size());
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
    }

    public static final /* synthetic */ boolean $anonfun$checkCacheContents$2(HashMap expectedTopics$1, Uuid id$1, HashMap expectedIds$1, HashMap expectedParts$1, UpdateMetadataRequestData.UpdateMetadataPartitionState x0$2) {
        expectedTopics$1.put(x0$2.topicName(), id$1);
        expectedIds$1.put(id$1, x0$2.topicName());
        return ((java.util.Set)expectedParts$1.computeIfAbsent(x0$2.topicName(), x$8 -> new HashSet())).add(new TopicPartition(x0$2.topicName(), x0$2.partitionIndex()));
    }

    public static final /* synthetic */ void $anonfun$checkCacheContents$1(HashMap expectedTopics$1, HashMap expectedIds$1, HashMap expectedParts$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            Uuid id = (Uuid)x0$1._1();
            ((Iterable)x0$1._2()).foreach((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$checkCacheContents$2(expectedTopics$1, id, expectedIds$1, expectedParts$1, x0$2)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$checkCacheContents$4(HashMap expectedParts$1, ZkMetadataCache cache$3, String topic) {
        Assertions.assertEquals(expectedParts$1.getOrDefault(topic, Collections.emptySet()), (Object)CollectionConverters$.MODULE$.SetHasAsJava(cache$3.getTopicPartitions(topic)).asJava());
    }

    public MetadataCacheTest() {
        this.brokerEpoch = 0L;
        this.oldRequestControllerEpoch = 122;
        this.newRequestControllerEpoch = 123;
        this.fooTopicName = "foo";
        this.barTopicName = "bar";
        AnyRefMap parts = new AnyRefMap();
        LongMap fooParts = new LongMap();
        fooParts.put(0L, (Object)this.oldFooPart0());
        fooParts.put(1L, (Object)this.oldFooPart1());
        parts.put((Object)this.fooTopicName(), (Object)fooParts);
        LongMap barParts = new LongMap();
        barParts.put(0L, (Object)this.oldBarPart0());
        barParts.put(1L, (Object)this.oldBarPart1());
        barParts.put(2L, (Object)this.oldBarPart2());
        parts.put((Object)this.barTopicName(), (Object)barParts);
        this.prevSnapshot = new MetadataSnapshot(parts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fooTopicName()), (Object)this.fooTopicId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.barTopicName()), (Object)this.barTopicId())})), (Option)new Some((Object)new KRaftCachedControllerId(1)), LongMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), LongMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$));
        this.buggySnapshot = new MetadataSnapshot(new AnyRefMap(), this.prevSnapshot().topicIds(), this.prevSnapshot().controllerId(), this.prevSnapshot().aliveBrokers(), this.prevSnapshot().aliveNodes());
    }

    public static final /* synthetic */ Object $anonfun$getTopicMetadata$2$adapted(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        MetadataCacheTest.$anonfun$getTopicMetadata$2(cache$1, topicIds$1, partitionStates$1, topic0$1, topic1$1, securityProtocol);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$3$adapted(ZkMetadataCache cache) {
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$3(cache);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$4$adapted(ZkMetadataCache cache) {
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$4(cache);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$5$adapted(ZkMetadataCache cache) {
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$5(cache);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$6$adapted(ZkMetadataCache cache) {
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$6(cache);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$7$adapted(ZkMetadataCache cache) {
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$7(cache);
        return BoxedUnit.UNIT;
    }
}

