/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rEa\u0001B\u0014)\u00015BQ!\u000e\u0001\u0005\u0002YBq\u0001\u000f\u0001C\u0002\u0013\u0005\u0013\b\u0003\u0004A\u0001\u0001\u0006IA\u000f\u0005\u0006\u0003\u0002!\tF\u0011\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0011\u0019Q\u0006\u0001)A\u0005%\"91\f\u0001b\u0001\n\u0013a\u0006BB3\u0001A\u0003%Q\fC\u0004g\u0001\t\u0007I\u0011B)\t\r\u001d\u0004\u0001\u0015!\u0003S\u0011\u0015A\u0007\u0001\"\u0015j\u0011\u001d\u0011\bA1A\u0005RMDa! \u0001!\u0002\u0013!\bb\u0002@\u0001\u0005\u0004%\tf\u001d\u0005\u0007\u007f\u0002\u0001\u000b\u0011\u0002;\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\b\u0003[\u0002A\u0011BA8\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!!+\u0001\t\u0013\tY\u000bC\u0004\u0002>\u0002!I!a0\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004!9!1\u0003\u0001\u0005\n\tU\u0001b\u0002B\u000f\u0001\u0011%!q\u0004\u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0011\u001d\u0011i\u0003\u0001C\u0005\u0005_A\u0011B!\u001f\u0001#\u0003%IAa\u001f\t\u000f\tU\u0005\u0001\"\u0003\u0003\u0018\"9!\u0011\u0017\u0001\u0005\n\tM\u0006\"\u0003Bd\u0001E\u0005I\u0011\u0002B?\u0011\u001d\u0011I\r\u0001C\u0005\u0005\u0017DqAa4\u0001\t\u0013\u0011\t\u000eC\u0004\u0003l\u0002!IA!<\t\u0013\tU\b!%A\u0005\n\t]\bb\u0002B~\u0001\u0011%!Q \u0005\b\u0007\u0007\u0001A\u0011BB\u0003\u0011\u001d\u0019I\u0001\u0001C\u0005\u0007\u0017\u00111\"T3ue&\u001c7\u000fV3ti*\u0011\u0011FK\u0001\u0004CBL'\"A\u0016\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\f\u001a\u0011\u0005=\u0002T\"\u0001\u0015\n\u0005EB#AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0011\u0005=\u001a\u0014B\u0001\u001b)\u0005%\u0019\u0016m\u001d7TKR,\b/\u0001\u0004=S:LGO\u0010\u000b\u0002oA\u0011q\u0006A\u0001\fEJ|7.\u001a:D_VtG/F\u0001;!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\rIe\u000e^\u0001\rEJ|7.\u001a:D_VtG\u000fI\u0001\rY&\u001cH/\u001a8fe:\u000bW.Z\u000b\u0002\u0007B\u0011AIT\u0007\u0002\u000b*\u0011aiR\u0001\b]\u0016$xo\u001c:l\u0015\tA\u0015*\u0001\u0004d_6lwN\u001c\u0006\u0003W)S!a\u0013'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0015aA8sO&\u0011q*\u0012\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0019W\u000647.Y\"mS\u0016tGoU1tY6+7\r[1oSNlW#\u0001*\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016\u0001\u00027b]\u001eT\u0011aV\u0001\u0005U\u00064\u0018-\u0003\u0002Z)\n11\u000b\u001e:j]\u001e\f\u0011d[1gW\u0006\u001cE.[3oiN\u000b7\u000f\\'fG\"\fg.[:nA\u0005I2.\u00194lCN+'O^3s'\u0006\u001cH.T3dQ\u0006t\u0017n]7t+\u0005i\u0006c\u00010d%6\tqL\u0003\u0002aC\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003Er\n!bY8mY\u0016\u001cG/[8o\u0013\t!wL\u0001\u0003MSN$\u0018AG6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N\u0004\u0013\u0001G6bM.\f7+\u001a:wKJT\u0015-Y:F]R\u0014\u0018PT1nK\u0006I2.\u00194lCN+'O^3s\u0015\u0006\f7/\u00128ueft\u0015-\\3!\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.F\u0001k!\tY\u0007/D\u0001m\u0015\tig.\u0001\u0003bkRD'BA8H\u0003!\u0019XmY;sSRL\u0018BA9m\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0001\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm]\u000b\u0002iB\u00191(^<\n\u0005Yd$\u0001B*p[\u0016\u0004\"\u0001_>\u000e\u0003eT!A\u001f,\u0002\tU$\u0018\u000e\\\u0005\u0003yf\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003U\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0002\nAc\u00197jK:$8+Y:m!J|\u0007/\u001a:uS\u0016\u001c\u0018!F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0005\u0003\u000b\tY\u0001E\u0002<\u0003\u000fI1!!\u0003=\u0005\u0011)f.\u001b;\t\u000f\u00055\u0001\u00031\u0001\u0002\u0010\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002\u0012\u0005uQBAA\n\u0015\rI\u0013Q\u0003\u0006\u0005\u0003/\tI\"A\u0004kkBLG/\u001a:\u000b\u0007\u0005mA*A\u0003kk:LG/\u0003\u0003\u0002 \u0005M!\u0001\u0003+fgRLeNZ8)\u0007A\t\u0019\u0003\u0005\u0003\u0002\u0012\u0005\u0015\u0012\u0002BA\u0014\u0003'\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tGCAA\u0003Q\r\t\u0012q\u0006\t\u0005\u0003#\t\t$\u0003\u0003\u00024\u0005M!!C!gi\u0016\u0014X)Y2i\u0003-!Xm\u001d;NKR\u0014\u0018nY:\u0015\t\u0005\u0015\u0011\u0011\b\u0005\b\u0003w\u0011\u0002\u0019AA\u001f\u0003i\u0019\u0018p\u001d;f[J+Wn\u001c;f'R|'/Y4f\u000b:\f'\r\\3e!\rY\u0014qH\u0005\u0004\u0003\u0003b$a\u0002\"p_2,\u0017M\u001c\u0015\b%\u0005\u0015\u0013\u0011KA*!\u0011\t9%!\u0014\u000e\u0005\u0005%#\u0002BA&\u0003+\ta\u0001]1sC6\u001c\u0018\u0002BA(\u0003\u0013\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\u0005U\u0013\u0001\r;fgRlU\r\u001e:jGN\u0004s/\u001b;iAML8\u000f^3n%\u0016lw\u000e^3Ti>\u0014\u0018mZ3F]\u0006\u0014G.\u001a3;Am\u0004T\u0010K\u0004\u0013\u00033\n)'a\u001a\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;RA!a\u0018\u0002J\u0005A\u0001O]8wS\u0012,'/\u0003\u0003\u0002d\u0005u#a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0003S\nY'G\u0001\u00023\u0005\u0001\u0011aC:f]\u0012\u0014VmY8sIN$\"\"!\u0002\u0002r\u0005=\u00151SAL\u0011\u001d\t\u0019h\u0005a\u0001\u0003k\n\u0001\u0002\u001d:pIV\u001cWM\u001d\t\t\u0003o\ny(a!\u0002\u00046\u0011\u0011\u0011\u0010\u0006\u0005\u0003g\nYHC\u0002\u0002~%\u000bqa\u00197jK:$8/\u0003\u0003\u0002\u0002\u0006e$!D&bM.\f\u0007K]8ek\u000e,'\u000fE\u0003<\u0003\u000b\u000bI)C\u0002\u0002\br\u0012Q!\u0011:sCf\u00042aOAF\u0013\r\ti\t\u0010\u0002\u0005\u0005f$X\r\u0003\u0004\u0002\u0012N\u0001\rAO\u0001\u000b]Vl'+Z2pe\u0012\u001c\bBBAK'\u0001\u0007!(\u0001\u0006sK\u000e|'\u000fZ*ju\u0016Dq!!'\u0014\u0001\u0004\tY*\u0001\u0002uaB!\u0011QTAP\u001b\u00059\u0015bAAQ\u000f\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017!H4f]\u0016\u0014\u0018\r^3BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3\u0015\t\u0005\u0015\u0011q\u0015\u0005\b\u00033#\u0002\u0019AAN\u0003%2XM]5gs.\u000bgm[1SCR,W*\u001a;sS\u000e\u001c\b*\u0019<f\u0007VlW\u000f\\1uSZ,7i\\;oiR1\u0011QAAW\u0003_Cq!a\u001d\u0016\u0001\u0004\t)\bC\u0004\u00022V\u0001\r!a-\u0002\u0011\r|gn];nKJ\u0004\u0002\"!.\u0002:\u0006\r\u00151Q\u0007\u0003\u0003oSA!!-\u0002|%!\u00111XA\\\u0005!\u0019uN\\:v[\u0016\u0014\u0018A\u0007<fe&4\u0017p\u00117jK:$h+\u001a:tS>tW*\u001a;sS\u000e\u001cHCBA\u0003\u0003\u0003\fI\u000fC\u0004\u0002DZ\u0001\r!!2\u0002\u000f5,GO]5dgB\"\u0011qYAl!\u001dA\u0018\u0011ZAg\u0003'L1!a3z\u0005\ri\u0015\r\u001d\t\u0005\u0003;\u000by-C\u0002\u0002R\u001e\u0013!\"T3ue&\u001cg*Y7f!\u0011\t).a6\r\u0001\u0011a\u0011\u0011\\Aa\u0003\u0003\u0005\tQ!\u0001\u0002\\\n\u0019q\fJ\u0019\u0012\t\u0005u\u00171\u001d\t\u0004w\u0005}\u0017bAAqy\t9aj\u001c;iS:<\u0007\u0003BAO\u0003KL1!a:H\u0005\u0019iU\r\u001e:jG\"9\u00111\u001e\fA\u0002\u00055\u0018AB3oi&$\u0018\u0010\u0005\u0003\u0002p\u0006uh\u0002BAy\u0003s\u00042!a==\u001b\t\t)PC\u0002\u0002x2\na\u0001\u0010:p_Rt\u0014bAA~y\u00051\u0001K]3eK\u001aL1!WA\u0000\u0015\r\tY\u0010P\u0001\"m\u0016\u0014\u0018NZ=Ce>\\WM]!vi\",g\u000e^5dCRLwN\\'fiJL7m\u001d\u000b\u0005\u0003\u000b\u0011)\u0001C\u0004\u0003\b]\u0001\rA!\u0003\u0002\rM,'O^3s!\u0011\u0011YAa\u0004\u000e\u0005\t5!b\u0001B\u0004U%!!\u0011\u0003B\u0007\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002IY,'/\u001b4z\u0005J|7.\u001a:NKN\u001c\u0018mZ3D_:4XM]:j_:lU\r\u001e:jGN$\u0002\"!\u0002\u0003\u0018\te!1\u0004\u0005\b\u0005\u000fA\u0002\u0019\u0001B\u0005\u0011\u0019\t)\n\u0007a\u0001u!9\u0011\u0011\u0014\rA\u0002\u0005m\u0015!\u0006<fe&4\u0017P\u0011:pW\u0016\u0014(l['fiJL7m\u001d\u000b\u0007\u0003\u000b\u0011\tCa\t\t\u000f\t\u001d\u0011\u00041\u0001\u0003\n!9!QE\rA\u0002\u00055\u0018!\u0002;pa&\u001c\u0017\u0001\u0007<fe&4\u0017P\u0011:pW\u0016\u0014XI\u001d:pe6+GO]5dgR!\u0011Q\u0001B\u0016\u0011\u001d\u00119A\u0007a\u0001\u0005\u0013\t\u0011C^3sS\u001aL8*\u00194lC6+GO]5d+\u0011\u0011\tDa\u000e\u0015\u0015\tM\"q\fB1\u0005[\u0012y\u0007\u0006\u0003\u00036\t\r\u0003\u0003BAk\u0005o!qA!\u000f\u001c\u0005\u0004\u0011YDA\u0001U#\u0011\tiN!\u0010\u0011\u0007m\u0012y$C\u0002\u0003Bq\u00121!\u00118z\u0011\u001d\u0011)e\u0007a\u0001\u0005\u000f\naA^3sS\u001aL\bcB\u001e\u0003J\t5#QG\u0005\u0004\u0005\u0017b$!\u0003$v]\u000e$\u0018n\u001c82!\u0019\u0011yE!\u0017\u0002d:!!\u0011\u000bB+\u001d\u0011\t\u0019Pa\u0015\n\u0003uJ1Aa\u0016=\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0017\u0003^\tA\u0011\n^3sC\ndWMC\u0002\u0003XqBq!!\u0015\u001c\u0001\u0004\ti\u000fC\u0004\u0002Dn\u0001\rAa\u00191\t\t\u0015$\u0011\u000e\t\bq\u0006%\u0017Q\u001aB4!\u0011\t)N!\u001b\u0005\u0019\t-$\u0011MA\u0001\u0002\u0003\u0015\t!a7\u0003\u0007}##\u0007C\u0004\u0002ln\u0001\r!!<\t\u0013\tE4\u0004%AA\u0002\tM\u0014!B4s_V\u0004\b#B\u001e\u0003v\u00055\u0018b\u0001B<y\t1q\n\u001d;j_:\f1D^3sS\u001aL8*\u00194lC6+GO]5dI\u0011,g-Y;mi\u0012\"T\u0003\u0002B?\u0005'+\"Aa +\t\tM$\u0011Q\u0016\u0003\u0005\u0007\u0003BA!\"\u0003\u00106\u0011!q\u0011\u0006\u0005\u0005\u0013\u0013Y)A\u0005v]\u000eDWmY6fI*\u0019!Q\u0012\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0012\n\u001d%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00129!\u0011\b\u000fC\u0002\tm\u0012aE7bq.\u000bgm[1NKR\u0014\u0018n\u0019,bYV,GC\u0003BM\u0005?\u0013\tK!,\u00030B\u00191Ha'\n\u0007\tuEH\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003#j\u0002\u0019AAw\u0011\u001d\t\u0019-\ba\u0001\u0005G\u0003DA!*\u0003*B9\u00010!3\u0002N\n\u001d\u0006\u0003BAk\u0005S#ABa+\u0003\"\u0006\u0005\t\u0011!B\u0001\u00037\u00141a\u0018\u00134\u0011\u001d\tY/\ba\u0001\u0003[DqA!\u001d\u001e\u0001\u0004\u0011\u0019(A\rwKJLg-_&bM.\fW*\u001a;sS\u000e\u0014VmY8sI\u0016$GCCA\u0003\u0005k\u00139La1\u0003F\"9\u0011\u0011\u000b\u0010A\u0002\u00055\bbBAb=\u0001\u0007!\u0011\u0018\u0019\u0005\u0005w\u0013y\fE\u0004y\u0003\u0013\fiM!0\u0011\t\u0005U'q\u0018\u0003\r\u0005\u0003\u00149,!A\u0001\u0002\u000b\u0005\u00111\u001c\u0002\u0004?\u0012\"\u0004bBAv=\u0001\u0007\u0011Q\u001e\u0005\n\u0005cr\u0002\u0013!a\u0001\u0005g\n1E^3sS\u001aL8*\u00194lC6+GO]5d%\u0016\u001cwN\u001d3fI\u0012\"WMZ1vYR$C'A\tzC6lWM]'fiJL7MV1mk\u0016$BA!\u0010\u0003N\"9\u0011\u0011\u000b\u0011A\u0002\u00055\u0018aD=b[6,'\u000fS5ti><'/Y7\u0015\t\tM'\u0011\u001e\t\u0005\u0005+\u0014)/\u0004\u0002\u0003X*!!\u0011\u001cBn\u0003\u0011\u0019wN]3\u000b\t\u0005\r'Q\u001c\u0006\u0005\u0005?\u0014\t/\u0001\u0004zC6lWM\u001d\u0006\u0003\u0005G\f1aY8n\u0013\u0011\u00119Oa6\u0003\u0013!K7\u000f^8he\u0006l\u0007bBA)C\u0001\u0007\u0011Q^\u0001\u001bm\u0016\u0014\u0018NZ=ZC6lWM]'fiJL7MU3d_J$W\r\u001a\u000b\u0007\u00053\u0013yO!=\t\u000f\u0005E#\u00051\u0001\u0002n\"I!Q\t\u0012\u0011\u0002\u0003\u0007!1\u001f\t\bw\t%#\u0011TA\u001f\u0003\u00112XM]5gsf\u000bW.\\3s\u001b\u0016$(/[2SK\u000e|'\u000fZ3eI\u0011,g-Y;mi\u0012\u0012TC\u0001B}U\u0011\u0011\u0019P!!\u0002-Y,'/\u001b4z\u001d>\u0014V-];fgRlU\r\u001e:jGN$B!!\u0002\u0003\u0000\"91\u0011\u0001\u0013A\u0002\u00055\u0018\u0001D3se>\u0014X*Z:tC\u001e,\u0017a\b4s_6t\u0015-\\3U_\n\u0013xn[3s)>\u0004\u0018nY*uCR\u001cXJQ3b]R!\u0011Q^B\u0004\u0011\u001d\t\t&\na\u0001\u0003[\f!D^3sS\u001aL(+Z7pi\u0016\u001cFo\u001c:bO\u0016lU\r\u001e:jGN$B!!\u0002\u0004\u000e!91q\u0002\u0014A\u0002\u0005u\u0012\u0001F:i_VdGmQ8oi\u0006Lg.T3ue&\u001c7\u000f")
public class MetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasAdminLoginModule$default$2() {
        return SaslSetup.jaasAdminLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (testInfo.getDisplayName().contains("testMetrics") && testInfo.getDisplayName().endsWith("true")) {
            this.serverConfig().setProperty("remote.log.storage.system.enable", "true");
            this.serverConfig().setProperty("remote.log.storage.manager.class.name", NoOpRemoteStorageManager.class.getName());
            this.serverConfig().setProperty("remote.log.metadata.manager.class.name", NoOpRemoteLogMetadataManager.class.getName());
        }
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.kafkaServerJaasEntryName()));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @ParameterizedTest(name="testMetrics with systemRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testMetrics(boolean systemRemoteStorageEnabled) {
        String topic = "topicWithOldMessageFormat";
        Properties props = new Properties();
        props.setProperty("message.format.version", "0.9.0");
        this.createTopic(topic, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 100000;
        Properties prop = new Properties();
        prop.setProperty("enable.idempotence", "false");
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, prop);
        this.sendRecords(producer, numRecords, recordSize, tp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, 15000L);
        this.verifyKafkaRateMetricsHaveCumulativeCount(producer, consumer);
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(producer.metrics(), "Producer");
        KafkaServer server = (KafkaServer)this.servers().head();
        this.verifyBrokerMessageConversionMetrics(server, recordSize, tp);
        this.verifyBrokerErrorMetrics((KafkaServer)this.servers().head());
        this.verifyBrokerZkMetrics(server, topic);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
        this.verifyRemoteStorageMetrics(systemRemoteStorageEnabled);
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        byte[] bytes = new byte[recordSize];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)bytes)));
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        Properties saslProps = new Properties();
        saslProps.put("sasl.mechanism", this.kafkaClientSaslMechanism());
        saslProps.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty((String)this.kafkaClientSaslMechanism(), (String)"badUser", (String)"badPass"));
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        SecurityProtocol x$5 = this.securityProtocol();
        Option<File> x$6 = this.trustStoreFile();
        Some x$7 = new Some((Object)saslProps);
        long x$8 = 0x100000L;
        int x$9 = Integer.MAX_VALUE;
        int x$10 = 30000;
        int x$11 = 0;
        int x$12 = 16384;
        String x$13 = "none";
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, 0, 1000L, x$8, x$9, x$10, x$11, x$12, x$13, 1000, x$5, x$6, (Option<Properties>)x$7, x$14, x$15, x$16);){
            try {
                producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
    }

    private void verifyKafkaRateMetricsHaveCumulativeCount(KafkaProducer<byte[], byte[]> producer, Consumer<byte[], byte[]> consumer) {
        Set consumerMetricNames = CollectionConverters$.MODULE$.SetHasAsScala(consumer.metrics().keySet()).asScala().toSet();
        ((IterableOnceOps)consumerMetricNames.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(x$1)))).foreach((Function1 & Serializable)x$2 -> {
            MetricsTest.verify$1(x$2, consumerMetricNames);
            return BoxedUnit.UNIT;
        });
        Set producerMetricNames = CollectionConverters$.MODULE$.SetHasAsScala(producer.metrics().keySet()).asScala().toSet();
        Set producerExclusions = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"}));
        ((IterableOnceOps)((IterableOps)producerMetricNames.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(x$3)))).filterNot((Function1 & Serializable)metricName -> BoxesRunTime.boxToBoolean((boolean)producerExclusions.contains((Object)metricName.name())))).foreach((Function1 & Serializable)x$4 -> {
            MetricsTest.verify$1(x$4, producerMetricNames);
            return BoxedUnit.UNIT;
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        new .colon.colon((Object)"commit-id", (List)new .colon.colon((Object)"version", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)name -> {
            MetricsTest.$anonfun$verifyClientVersionMetrics$1(this, metrics, entity, name);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void verifyBrokerAuthenticationMetrics(KafkaServer server) {
        Map metrics = server.metrics().metrics();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetricsTest.$anonfun$verifyBrokerAuthenticationMetrics$1(this, metrics)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed-authentication-total not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageConversionMetrics(KafkaServer server, int recordSize, TopicPartition tp) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(new StringBuilder(34).append(requestMetricsPrefix).append(",name=RequestBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(new StringBuilder(42).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        Assertions.assertTrue((tempBytes >= (double)recordSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("Unexpected temporary memory size requestBytes ").append(requestBytes).append(" tempBytes ").append(tempBytes).toString());
        this.verifyYammerMetricRecorded("kafka.server:type=BrokerTopicMetrics,name=ProduceMessageConversionsPerSec", this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name = new StringBuilder(46).append(requestMetricsPrefix).append(",name=MessageConversionsTimeMs,request=Produce").toString();
        double verifyYammerMetricRecorded_metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$1(verifyYammerMetricRecorded_metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name).append(" value ").append(verifyYammerMetricRecorded_metricValue).toString());
        Object var9_7 = null;
        this.verifyYammerMetricRecorded(new StringBuilder(32).append(requestMetricsPrefix).append(",name=RequestBytes,request=Fetch").toString(), this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name2 = new StringBuilder(40).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Fetch").toString();
        double verifyYammerMetricRecorded_metricValue2 = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name2));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$2(verifyYammerMetricRecorded_metricValue2), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name2).append(" value ").append(verifyYammerMetricRecorded_metricValue2).toString());
        Object var12_9 = null;
        this.verifyYammerMetricRecorded(new StringBuilder(35).append(requestMetricsPrefix).append(",name=RequestBytes,request=Metadata").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerZkMetrics(KafkaServer server, String topic) {
        Histogram histogram = this.yammerHistogram("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs");
        long initialCount = histogram.count();
        ((KafkaServer)this.servers().head()).zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assertions.assertTrue((histogram.count() > initialCount ? 1 : 0) != 0, (String)"ZooKeeper latency not recorded");
        double min = histogram.min();
        Assertions.assertTrue((min >= 0.0 ? 1 : 0) != 0, (String)new StringBuilder(36).append("Min latency should not be negative: ").append(min).toString());
        Assertions.assertEquals((Object)"CONNECTED", (Object)this.yammerMetricValue("SessionState"), (String)"Unexpected ZK state");
    }

    private void verifyBrokerErrorMetrics(KafkaServer server) {
        int startErrorMetricCount = MetricsTest.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(new StringBuilder(28).append(errorMetricPrefix).append(",request=Metadata,error=NONE").toString(), this.verifyYammerMetricRecorded$default$2());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        try {
            consumer.partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(47).append(errorMetricPrefix).append(",request=Metadata,error=INVALID_TOPIC_EXCEPTION").toString(), this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = MetricsTest.errorMetricCount$1();
        Assertions.assertEquals((int)(startErrorMetricCount + 1), (int)currentErrorMetricCount);
        Assertions.assertTrue((currentErrorMetricCount < 10 ? 1 : 0) != 0, (String)new StringBuilder(23).append("Too many error metrics ").append(currentErrorMetricCount).toString());
        try {
            consumer.partitionsFor("non-existing-topic");
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(50).append(errorMetricPrefix).append(",request=Metadata,error=UNKNOWN_TOPIC_OR_PARTITION").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private <T> T verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assertions.assertTrue((boolean)matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return (T)verify.apply((Object)matchingMetrics.values());
    }

    private <T> Option<String> verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    private double maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return MetricsTest.$anonfun$maxKafkaMetricValue$1(verifyKafkaMetric_matchingMetrics.values());
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.maxKafkaMetricValue(name, metrics, entity, group);
        Assertions.assertTrue((value > 0.0 ? 1 : 0) != 0, (String)new StringBuilder(42).append(entity).append(" metric not recorded correctly for ").append(name).append(" value ").append(value).toString());
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Object yammerMetricValue(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerMetricValue$1(name, x0$1))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$7 -> x$7.getMBeanName())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_4 instanceof Meter) {
            return BoxesRunTime.boxToDouble((double)((Meter)var4_4).count());
        }
        if (var4_4 instanceof Histogram) {
            return BoxesRunTime.boxToDouble((double)((Histogram)var4_4).max());
        }
        if (var4_4 instanceof Gauge) {
            return ((Gauge)var4_4).value();
        }
        return Assertions.fail((String)new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_4.getClass()).toString());
    }

    /*
     * WARNING - void declaration
     */
    private Histogram yammerHistogram(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerHistogram$1(name, x0$1))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$8 -> x$8.getMBeanName())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_4 instanceof Histogram) {
            return (Histogram)var4_4;
        }
        throw new AssertionError((Object)new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_4.getClass()).toString());
    }

    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify) {
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(name));
        Assertions.assertTrue((boolean)verify.apply$mcZD$sp(metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(name).append(" value ").append(metricValue).toString());
        return metricValue;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return (JFunction1.mcZD.sp & Serializable)d -> d > 0.0;
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyNoRequestMetrics$1(x0$1)));
        Assertions.assertTrue((boolean)metrics.isEmpty(), (String)new StringBuilder(2).append(errorMessage).append(": ").append(metrics.keys()).toString());
    }

    private String fromNameToBrokerTopicStatsMBean(String name) {
        return new StringBuilder(42).append("kafka.server:type=BrokerTopicMetrics,name=").append(name).toString();
    }

    private void verifyRemoteStorageMetrics(boolean shouldContainMetrics) {
        List metrics = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(RemoteStorageMetrics.allMetrics()).asScala().filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$1(name)))).toList();
        Set aggregatedBrokerTopicStats = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName(), RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName(), RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName(), RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName()}));
        List aggregatedBrokerTopicMetrics = ((IterableOnceOps)aggregatedBrokerTopicStats.filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$3(this, name)))).toList();
        if (shouldContainMetrics) {
            Assertions.assertEquals((int)RemoteStorageMetrics.allMetrics().size(), (int)metrics.size(), (String)new StringBuilder(27).append("Only ").append(metrics).append(" appear in the metrics").toString());
            Assertions.assertEquals((int)aggregatedBrokerTopicStats.size(), (int)aggregatedBrokerTopicMetrics.size(), (String)new StringBuilder(27).append("Only ").append(aggregatedBrokerTopicMetrics).append(" appear in the metrics").toString());
            return;
        }
        Assertions.assertEquals((int)0, (int)metrics.size(), (String)new StringBuilder(33).append(metrics).append(" should not appear in the metrics").toString());
        Assertions.assertEquals((int)0, (int)aggregatedBrokerTopicMetrics.size(), (String)new StringBuilder(33).append(aggregatedBrokerTopicMetrics).append(" should not appear in the metrics").toString());
    }

    private static final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    private static final void verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = MetricsTest.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = MetricsTest.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assertions.assertTrue((totalExists || totalTimeExists ? 1 : 0) != 0, (String)new StringBuilder(48).append("No cumulative count/time metric for rate metric ").append(rateMetricName).toString());
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(MetricName x$1) {
        return x$1.name().endsWith("-rate");
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(MetricName x$3) {
        return x$3.name().endsWith("-rate");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$2(String entity$1, String name$1, Iterable matchingMetrics) {
        Assertions.assertEquals((int)1, (int)matchingMetrics.size());
        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
        Object value = metric.metricValue();
        Assertions.assertNotNull((Object)value, (String)new StringBuilder(21).append(entity$1).append(" metric not recorded ").append(name$1).toString());
        Assertions.assertNotNull((Object)BoxesRunTime.boxToBoolean((value instanceof String && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)value)) ? 1 : 0) != 0), (String)new StringBuilder(37).append(entity$1).append(" metric ").append(name$1).append(" should be a non-empty String").toString());
        Assertions.assertTrue((boolean)metric.metricName().tags().containsKey("client-id"), (String)"Client-id not specified");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$1(MetricsTest $this, Map metrics$1, String entity$1, String name) {
        None$ verifyKafkaMetric_group = None$.MODULE$;
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics$1).asScala().filter(arg_0 -> MetricsTest.$anonfun$verifyKafkaMetric$1$adapted(name, (Option)verifyKafkaMetric_group, arg_0));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        Iterable iterable = verifyKafkaMetric_matchingMetrics.values();
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name, iterable);
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerAuthenticationMetrics$1(MetricsTest $this, Map metrics$2) {
        return $this.maxKafkaMetricValue("failed-authentication-total", metrics$2, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$verifyBrokerAuthenticationMetrics$2() {
        return "failed-authentication-total not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$1(double value) {
        return value > 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$2(double value) {
        return value == 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerErrorMetrics$1(com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getName();
        String string2 = "ErrorsPerSec";
        return string != null && string.equals(string2);
    }

    private static final int errorMetricCount$1() {
        return CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyBrokerErrorMetrics$1(x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$2(MetricName metricName$1, String x$6) {
        String string = x$6;
        String string2 = metricName$1.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$1(String name$2, Option group$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metricName = (MetricName)x0$1._1();
            String string = metricName.name();
            return !(string != null ? !string.equals(name$2) : name$2 != null) && group$1.forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$2(metricName, x$6)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$2(double max, org.apache.kafka.common.Metric metric) {
        return Math.max(max, BoxesRunTime.unboxToDouble((Object)metric.metricValue()));
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$1(Iterable matchingMetrics) {
        return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, metric) -> BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$2(BoxesRunTime.unboxToDouble((Object)max), metric))));
    }

    public static final /* synthetic */ boolean $anonfun$yammerMetricValue$1(String name$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$yammerHistogram$1(String name$4, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$4);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyNoRequestMetrics$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith("kafka.network:type=RequestMetrics");
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$2(com.yammer.metrics.core.MetricName name$5, Tuple2 metric) {
        return ((com.yammer.metrics.core.MetricName)metric._1()).getMBeanName().equals(name$5.getMBeanName());
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$1(com.yammer.metrics.core.MetricName name) {
        return CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().find((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$2(name, metric))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$4(MetricsTest $this, String name$6, Tuple2 metric) {
        return ((com.yammer.metrics.core.MetricName)metric._1()).getMBeanName().equals($this.fromNameToBrokerTopicStatsMBean(name$6));
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$3(MetricsTest $this, String name) {
        return CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().find((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$4($this, name, metric))).isDefined();
    }

    public MetricsTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
        this.kafkaServerJaasEntryName = new StringBuilder(1).append(this.listenerName().value().toLowerCase(Locale.ROOT)).append(".").append(JaasTestUtils$.MODULE$.KafkaServerContextName()).toString();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.8");
        this.producerConfig().setProperty("linger.ms", "10");
        this.producerConfig().setProperty("compression.type", "gzip");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$maxKafkaMetricValue$1$adapted(Iterable matchingMetrics) {
        return BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$1(matchingMetrics));
    }

    public static final /* synthetic */ Object $anonfun$verifyClientVersionMetrics$2$adapted(String entity$1, String name$1, Iterable matchingMetrics) {
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name$1, matchingMetrics);
        return BoxedUnit.UNIT;
    }
}

