/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.AbstractApiVersionsRequestTest;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.ALL, brokers=1)
@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001B\u0007\u000f\u0001MA\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\u0006?\u0001!\t\u0001\t\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006{\u0001!\tA\u0010\u0005\u0006G\u0002!\tA\u0010\u0005\u0006O\u0002!\tA\u0010\u0005\u0006_\u0002!\tA\u0010\u0005\u0006i\u0002!\tA\u0010\u0005\u0006m\u0002!\tA\u0010\u0005\u0006{\u0002!\tA\u0010\u0005\u0006\u007f\u0002!\tA\u0010\u0005\u0007\u0003\u0007\u0001A\u0011\u0001 \u0003-\u0005\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+fgRT!a\u0004\t\u0002\rM,'O^3s\u0015\u0005\t\u0012!B6bM.\f7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\f\u000e\u00039I!a\u0006\b\u0003=\u0005\u00137\u000f\u001e:bGR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;UKN$\u0018aB2mkN$XM\u001d\t\u00035ui\u0011a\u0007\u0006\u00039A\tA\u0001^3ti&\u0011ad\u0007\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\u00061A(\u001b8jiz\"\"!\t\u0012\u0011\u0005U\u0001\u0001\"\u0002\r\u0003\u0001\u0004I\u0012!B:fiV\u0004HCA\u0013,!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0011)f.\u001b;\t\u000b1\u001a\u0001\u0019A\u0017\u0002\r\r|gNZ5h!\tQb&\u0003\u000207\ti1\t\\;ti\u0016\u00148i\u001c8gS\u001eD#aA\u0019\u0011\u0005IZT\"A\u001a\u000b\u0005Q*\u0014aA1qS*\u0011agN\u0001\bUV\u0004\u0018\u000e^3s\u0015\tA\u0014(A\u0003kk:LGOC\u0001;\u0003\ry'oZ\u0005\u0003yM\u0012!BQ3g_J,W)Y2i\u0003Y!Xm\u001d;Ba&4VM]:j_:\u001c(+Z9vKN$H#A\u0013)\r\u0011\u0001ei\u0012*T!\t\tE)D\u0001C\u0015\t\u00195$\u0001\u0006b]:|G/\u0019;j_:L!!\u0012\"\u0003\u0017\rcWo\u001d;feR+7\u000f^\u0001\u0010[\u0016$\u0018\rZ1uCZ+'o]5p]\u0012\n\u0001*\u0003\u0002J\u0015\u0006Y\u0011J\u0011)`g}Ct,\u0013,1\u0015\tYE*A\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0015\tie*\u0001\u0004d_6lwN\u001c\u0006\u0003\u001f=S!!\u0005)\u000b\u0005EK\u0014AB1qC\u000eDW-\u0001\ttKJ4XM\u001d)s_B,'\u000f^5fg2\u0012AKX\u0016\u0006+bK6\f\u0018\t\u0003\u0003ZK!a\u0016\"\u0003+\rcWo\u001d;fe\u000e{gNZ5h!J|\u0007/\u001a:us\u0006\u00191.Z=\"\u0003i\u000bA$\u001e8ti\u0006\u0014G.\u001a\u0018ba&tc/\u001a:tS>t7OL3oC\ndW-A\u0003wC2,X-I\u0001^\u0003\u00151\u0017\r\\:fW\u0015)\u0006lX.bC\u0005\u0001\u0017!I;ogR\f'\r\\3/[\u0016$\u0018\rZ1uC:2XM]:j_:\u001ch&\u001a8bE2,\u0017%\u00012\u0002\tQ\u0014X/Z\u0001-i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti&s7\r\\;eKN,fN]3mK\u0006\u001cX\rZ!qSNDC!\u0002!SK2\u0012aMX\u0016\u0006+bK6,Y\u00012i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiRC'o\\;hQ\u000e{g\u000e\u001e:pYBc\u0017M\\3MSN$XM\\3sQ\u00111\u0001)\u001b6\u0002\u0017\rdWo\u001d;feRK\b/\u001a\u0013\u0002W&\u0011A.\\\u0001\u00035.S!A\u001c\"\u0002\tQK\b/Z\u00010i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiRC'o\\;hQ\u000e{g\u000e\u001e:pY2,'\u000fT5ti\u0016tWM\u001d\u0015\u0005\u000f\u0001K\u0017\u000fJ\u0001s\u0013\t\u0019X.A\u0003L%\u00063E+\u0001\u0017uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u/&$\b.\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\"\u0012\u0001\u0002Q\u0001#i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiZ\u000bG.\u001b3bi&|gN\u0016\u0019)\r%\u0001e\t\u001f*|I\u0005I\u0018B\u0001>K\u0003-I%\tU04?^z\u0016J\u0016\u001b-\u0005Qc8&B+Y?nc\u0016!\u0010;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;WC2LG-\u0019;j_:4\u0006\u0007\u00165s_V<\u0007nQ8oiJ|G\u000e\u00157b]\u0016d\u0015n\u001d;f]\u0016\u0014\b\u0006\u0002\u0006AS*\f1\b^3ti\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e,bY&$\u0017\r^5p]Z\u0003D\u000b\u001b:pk\u001eD7i\u001c8ue>dG.\u001a:MSN$XM\\3sQ\u0011Y\u0001)[9\u0002EQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR4\u0016\r\\5eCRLwN\u001c,4Q\ta\u0001\t\u000b\u0004\u0001\u0003\u0013Y\u0016Q\u0003\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB\u001a\u0002\u0013\u0015DH/\u001a8tS>t\u0017\u0002BA\n\u0003\u001b\u0011!\"\u0012=uK:$w+\u001b;iY\t\t9b\t\u0002\u0002\u001aA!\u00111DA\u0010\u001b\t\tiB\u0003\u000297%!\u0011\u0011EA\u000f\u0005U\u0019E.^:uKJ$Vm\u001d;FqR,gn]5p]ND#\u0002AA\u0013S\u0006-\u0012\u0011GA\u001a!\r\t\u0015qE\u0005\u0004\u0003S\u0011%aE\"mkN$XM\u001d+fgR$UMZ1vYR\u001cHEAA\u0017\u0013\r\ty#\\\u0001\u0004\u00032c\u0015a\u00022s_.,'o]\u000f\u0002\u0003\u0001")
public class ApiVersionsRequestTest
extends AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    @BeforeEach
    public void setup(ClusterConfig config) {
        super.brokerPropertyOverrides(config.serverProperties());
    }

    @ClusterTest(metadataVersion=MetadataVersion.IBP_3_8_IV0, serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="false"), @ClusterConfigProperty(key="unstable.metadata.versions.enable", value="true")})
    public void testApiVersionsRequest() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        this.validateApiVersionsResponse(apiVersionsResponse, this.validateApiVersionsResponse$default$2(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="true"), @ClusterConfigProperty(key="unstable.metadata.versions.enable", value="true")})
    public void testApiVersionsRequestIncludesUnreleasedApis() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        ListenerName x$3 = this.validateApiVersionsResponse$default$2();
        boolean x$4 = this.validateApiVersionsResponse$default$4();
        short x$5 = this.validateApiVersionsResponse$default$5();
        this.validateApiVersionsResponse(apiVersionsResponse, x$3, true, x$4, x$5);
    }

    @ClusterTest(clusterType=Type.ZK)
    public void testApiVersionsRequestThroughControlPlaneListener() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.controlPlaneListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controlPlaneListenerName().get(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest(clusterType=Type.KRAFT)
    public void testApiVersionsRequestThroughControllerListener() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.controllerListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controllerListenerName().get(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest
    public void testApiVersionsRequestWithUnsupportedVersion() {
        ApiVersionsRequest apiVersionsRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendUnsupportedApiVersionRequest(apiVersionsRequest);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)apiVersionsResponse.data().errorCode());
        Assertions.assertFalse((boolean)apiVersionsResponse.data().apiKeys().isEmpty());
        ApiVersionsResponseData.ApiVersion apiVersion = apiVersionsResponse.data().apiKeys().find(ApiKeys.API_VERSIONS.id);
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.id, (short)apiVersion.apiKey());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.oldestVersion(), (short)apiVersion.minVersion());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.latestVersion(), (short)apiVersion.maxVersion());
    }

    @ClusterTest(metadataVersion=MetadataVersion.IBP_3_7_IV4, serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="false"), @ClusterConfigProperty(key="unstable.metadata.versions.enable", value="false")})
    public void testApiVersionsRequestValidationV0() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        ListenerName x$3 = this.validateApiVersionsResponse$default$2();
        boolean x$4 = this.validateApiVersionsResponse$default$3();
        boolean x$5 = this.validateApiVersionsResponse$default$4();
        this.validateApiVersionsResponse(apiVersionsResponse, x$3, x$4, x$5, (short)0);
    }

    @ClusterTest(clusterType=Type.ZK)
    public void testApiVersionsRequestValidationV0ThroughControlPlaneListener() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.controlPlaneListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controlPlaneListenerName().get(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest(clusterType=Type.KRAFT)
    public void testApiVersionsRequestValidationV0ThroughControllerListener() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.controllerListenerName().get());
        ListenerName x$2 = this.cluster.controllerListenerName().get();
        boolean x$4 = this.validateApiVersionsResponse$default$3();
        boolean x$5 = this.validateApiVersionsResponse$default$4();
        this.validateApiVersionsResponse(apiVersionsResponse, x$2, x$4, x$5, (short)0);
    }

    @ClusterTest
    public void testApiVersionsRequestValidationV3() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new ApiVersionsRequestData(), (short)3);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)apiVersionsResponse.data().errorCode());
    }

    public ApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
    }
}

