/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.BrokerTopicMetrics;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaRequestHandler$;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t-a\u0001\u0002\u001a4\u0001aBQa\u0010\u0001\u0005\u0002\u0001Cqa\u0011\u0001C\u0002\u0013\u0005A\t\u0003\u0004N\u0001\u0001\u0006I!\u0012\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001P\u0011\u0019\u0019\u0006\u0001)A\u0005!\"9A\u000b\u0001b\u0001\n\u0003)\u0006B\u0002/\u0001A\u0003%a\u000bC\u0004^\u0001\t\u0007I\u0011A+\t\ry\u0003\u0001\u0015!\u0003W\u0011\u001dy\u0006A1A\u0005\u0002\u0001Da\u0001\u001a\u0001!\u0002\u0013\t\u0007bB3\u0001\u0005\u0004%\t\u0001\u0019\u0005\u0007M\u0002\u0001\u000b\u0011B1\t\u000b\u001d\u0004A\u0011\u00015\t\u000be\u0004A\u0011\u00015\t\u000bm\u0004A\u0011\u00015\t\u000bu\u0004A\u0011\u00015\t\r}\u0004A\u0011AA\u0001\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!!\u001c\u0001\t\u0003\ty\u0007C\u0005\u0002t\u0001\t\n\u0011\"\u0001\u0002v!9\u00111\u0012\u0001\u0005\u0002\u00055\u0005BBAL\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0002\u001c\u0002!\t\u0001\u001b\u0005\u0007\u0003?\u0003A\u0011\u00015\t\r\u0005\r\u0006\u0001\"\u0001i\u0011\u0019\t9\u000b\u0001C\u0001Q\"1\u00111\u0016\u0001\u0005\u0002!Da!a,\u0001\t\u0003A\u0007BBAZ\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u00028\u0002!\t\u0001\u001b\u0005\u0007\u0003w\u0003A\u0011\u00015\t\r\u0005}\u0006\u0001\"\u0001i\u0011\u0019\t\u0019\r\u0001C\u0001Q\"1\u0011q\u0019\u0001\u0005\u0002!Da!a3\u0001\t\u0003A\u0007BBAh\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0002T\u0002!\t\u0001\u001b\u0005\u0007\u0003/\u0004A\u0011\u00015\t\r\u0005m\u0007\u0001\"\u0001i\u0011\u0019\ty\u000e\u0001C\u0001Q\"1\u00111\u001d\u0001\u0005\u0002!Da!a:\u0001\t\u0003A\u0007bBAv\u0001\u0011\u0005\u0011Q\u001e\u0005\u0007\u0003o\u0004A\u0011\u00015\t\r\u0005m\b\u0001\"\u0001i\u0011\u0019\ty\u0010\u0001C\u0001Q\"1!1\u0001\u0001\u0005\u0002!DaAa\u0002\u0001\t\u0003A'aF&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u0014H+Z:u\u0015\t!T'\u0001\u0004tKJ4XM\u001d\u0006\u0002m\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001:!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0011\t\u0003\u0005\u0002i\u0011aM\u0001\u0006aJ|\u0007o]\u000b\u0002\u000bB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0005kRLGNC\u0001K\u0003\u0011Q\u0017M^1\n\u00051;%A\u0003)s_B,'\u000f^5fg\u00061\u0001O]8qg\u0002\n\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0016\u0003A\u0003\"AQ)\n\u0005I\u001b$\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0003E\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000fI\u0001\u0006i>\u0004\u0018nY\u000b\u0002-B\u0011qKW\u0007\u00021*\u0011\u0011,S\u0001\u0005Y\u0006tw-\u0003\u0002\\1\n11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013A\u0002;pa&\u001c''A\u0004u_BL7M\r\u0011\u0002%\t\u0014xn[3s)>\u0004\u0018nY'fiJL7m]\u000b\u0002CB\u0011!IY\u0005\u0003GN\u0012!C\u0011:pW\u0016\u0014Hk\u001c9jG6+GO]5dg\u0006\u0019\"M]8lKJ$v\u000e]5d\u001b\u0016$(/[2tA\u0005y\u0011\r\u001c7U_BL7-T3ue&\u001c7/\u0001\tbY2$v\u000e]5d\u001b\u0016$(/[2tA\u0005\u0011B/Z:u\u0007\u0006dGNY1dWRKW.\u001b8h)\u0005I\u0007C\u0001\u001ek\u0013\tY7H\u0001\u0003V]&$\bF\u0001\bn!\tqw/D\u0001p\u0015\t\u0001\u0018/A\u0002ba&T!A]:\u0002\u000f),\b/\u001b;fe*\u0011A/^\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002m\u0006\u0019qN]4\n\u0005a|'\u0001\u0002+fgR\fa\u0004^3ti\u000e\u000bG\u000e\u001c2bG.$&/_\"p[BdW\r^3BGRLwN\\:)\u0005=i\u0017a\b;fgRD\u0015M\u001c3mS:<7)\u00197mE\u0006\u001c7n\u00148OK^$\u0006N]3bI\"\u0012\u0001#\\\u0001\u0019i\u0016\u001cHoQ1mY\n\f7m[(o'\u0006lW\r\u00165sK\u0006$\u0007FA\tn\u00039!Xm\u001d;U_BL7m\u0015;biN$2![A\u0002\u0011\u001d\t)A\u0005a\u0001\u0003\u000f\t!d]=ti\u0016l'+Z7pi\u0016\u001cFo\u001c:bO\u0016,e.\u00192mK\u0012\u00042AOA\u0005\u0013\r\tYa\u000f\u0002\b\u0005>|G.Z1oQ\r\u0011\u0012q\u0002\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011QC9\u0002\rA\f'/Y7t\u0013\u0011\tI\"a\u0005\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000fK\u0004\u0013\u0003;\tI#a\u000b\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQA!a\t\u0002\u0014\u0005A\u0001O]8wS\u0012,'/\u0003\u0003\u0002(\u0005\u0005\"a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0003[\ty#G\u0001\u00023\u0005\u0001\u0011aC7bW\u0016\u0014V-];fgR$b!!\u000e\u0002J\u0005\r\u0004\u0003BA\u001c\u0003\u0007rA!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{)\u0014a\u00028fi^|'o[\u0005\u0005\u0003\u0003\nY$\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\t\u0005\u0015\u0013q\t\u0002\b%\u0016\fX/Z:u\u0015\u0011\t\t%a\u000f\t\u000f\u0005-3\u00031\u0001\u0002N\u0005!A/[7f!\u0011\ty%a\u0018\u000e\u0005\u0005E#\u0002BA*\u0003+\nQ!\u001e;jYNTA!a\u0016\u0002Z\u000511m\\7n_:T1ANA.\u0015\r\ti&^\u0001\u0007CB\f7\r[3\n\t\u0005\u0005\u0014\u0011\u000b\u0002\u0005)&lW\rC\u0004\u0002fM\u0001\r!a\u001a\u0002\u000f5,GO]5dgB!\u0011qGA5\u0013\u0011\tY'a\u0012\u0003\u000f5+GO]5dg\u000692/\u001a;va\n\u0013xn[3s)>\u0004\u0018nY'fiJL7m\u001d\u000b\u0004C\u0006E\u0004\"CA\u0003)A\u0005\t\u0019AA\u0004\u0003\u0005\u001aX\r^;q\u0005J|7.\u001a:U_BL7-T3ue&\u001c7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t9H\u000b\u0003\u0002\b\u0005e4FAA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u00155(\u0001\u0006b]:|G/\u0019;j_:LA!!#\u0002\u0000\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002=Q,7\u000f^*j]\u001e,H.\u0019:D_BLH*Y4CsR,7/T3ue&\u001cGcA5\u0002\u0010\"9\u0011Q\u0001\fA\u0002\u0005\u001d\u0001f\u0001\f\u0002\u0010!:a#!\b\u0002*\u0005UE\u0006BA\u0017\u0003_\tq\u0004^3ti6+H\u000e^5qY\u0016\u001cu\u000e]=MC\u001e\u0014\u0015\u0010^3t\u001b\u0016$(/[2tQ\t9R.\u0001\u0017uKN$8i\u001c9z\u0019\u0006<')\u001f;fg6+GO]5d/&$\b\u000eU1si&$\u0018n\u001c8FqB\fgn]5p]\"\u0012\u0001$\\\u0001-i\u0016\u001cHoQ8qs2\u000bwMQ=uKNlU\r\u001e:jG^KG\u000f\u001b)beRLG/[8o'\"\u0014\u0018N\\6j]\u001eD#!G7\u0002oQ,7\u000f^\"pafd\u0015m\u001a\"zi\u0016\u001cX*\u001a;sS\u000e<\u0016\u000e\u001e5SK6|g/\u001b8h\u001d>tW\r_5ti\u0016tG\u000fU1si&$\u0018n\u001c8tQ\tQR.A\u000euKN$8i\u001c9z\u0019\u0006<')\u001f;fg6+GO]5d\u00072,\u0017M\u001d\u0015\u000375\f!\u0005^3ti6+H\u000e^5qY\u0016\u001cu\u000e]=MC\u001e\u001cVmZ7f]R\u001cX*\u001a;sS\u000e\u001c\bF\u0001\u000fn\u0003=\"Xm\u001d;D_BLH*Y4TK\u001elWM\u001c;t\u001b\u0016$(/[2XSRD\u0007+\u0019:uSRLwN\\#ya\u0006t7/[8oQ\tiR.A\u0018uKN$8i\u001c9z\u0019\u0006<7+Z4nK:$8/T3ue&\u001cw+\u001b;i!\u0006\u0014H/\u001b;j_:\u001c\u0006N]5oW&tw\r\u000b\u0002\u001f[\u0006QD/Z:u\u0007>\u0004\u0018\u0010T1h'\u0016<W.\u001a8ug6+GO]5d/&$\bNU3n_ZLgn\u001a(p]\u0016D\u0018n\u001d;f]R\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003?5\fa\u0004^3ti\u000e{\u0007/\u001f'bON+w-\\3oiNlU\r\u001e:jG\u000ecW-\u0019:)\u0005\u0001j\u0017!\t;fgRlU\u000f\u001c;ja2,G)\u001a7fi\u0016d\u0015m\u001a\"zi\u0016\u001cX*\u001a;sS\u000e\u001c\bFA\u0011n\u00039\"Xm\u001d;EK2,G/\u001a'bO\nKH/Z:NKR\u0014\u0018nY,ji\"\u0004\u0016M\u001d;ji&|g.\u0012=qC:\u001c\u0018n\u001c8)\u0005\tj\u0017A\f;fgR$U\r\\3uK2\u000bwMQ=uKNlU\r\u001e:jG^KG\u000f\u001b)beRLG/[8o'\"\u0014\u0018N\\6j]\u001eD#aI7\u0002sQ,7\u000f\u001e#fY\u0016$X\rT1h\u0005f$Xm]'fiJL7mV5uQJ+Wn\u001c<j]\u001etuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]ND#\u0001J7\u0002;Q,7\u000f\u001e#fY\u0016$X\rT1h\u0005f$Xm]'fiJL7m\u00117fCJD#!J7\u0002IQ,7\u000f^'vYRL\u0007\u000f\\3EK2,G/\u001a'bON+w-\\3oiNlU\r\u001e:jGND#AJ7\u0002cQ,7\u000f\u001e#fY\u0016$X\rT1h'\u0016<W.\u001a8ug6+GO]5d/&$\b\u000eU1si&$\u0018n\u001c8FqB\fgn]5p]\"\u0012q%\\\u00012i\u0016\u001cH\u000fR3mKR,G*Y4TK\u001elWM\u001c;t\u001b\u0016$(/[2XSRD\u0007+\u0019:uSRLwN\\*ie&t7.\u001b8hQ\tAS.\u0001\u001fuKN$H)\u001a7fi\u0016d\u0015mZ*fO6,g\u000e^:NKR\u0014\u0018nY,ji\"\u0014V-\\8wS:<gj\u001c8fq&\u001cH/\u001a8u!\u0006\u0014H/\u001b;j_:\u001c\bFA\u0015n\u0003\u0001\"Xm\u001d;EK2,G/\u001a'bON+w-\\3oiNlU\r\u001e:jG\u000ecW-\u0019:)\u0005)j\u0017A\u0007;fgR\u0014V-\\8uK2{w-T3uC\u0012\fG/Y\"pk:$\bFA\u0016n\u0003y!Xm\u001d;TS:<W\u000f\\1s\u0019><7+\u001b>f\u0005f$Xm]'fiJL7\rF\u0002j\u0003_Dq!!\u0002-\u0001\u0004\t9\u0001K\u0002-\u0003\u001fAs\u0001LA\u000f\u0003S\t)\u0010\f\u0003\u0002.\u0005=\u0012a\b;fgRlU\u000f\u001c;ja2,Gj\\4TSj,')\u001f;fg6+GO]5dg\"\u0012Q&\\\u0001-i\u0016\u001cH\u000fT8h'&TXMQ=uKNlU\r\u001e:jG^KG\u000f\u001b)beRLG/[8o\u000bb\u0004\u0018M\\:j_:D#AL7\u0002YQ,7\u000f\u001e'pONK'0\u001a\"zi\u0016\u001cX*\u001a;sS\u000e<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]NC'/\u001b8lS:<\u0007FA\u0018n\u0003]\"Xm\u001d;M_\u001e\u001c\u0016N_3CsR,7/T3ue&\u001cw+\u001b;i%\u0016lwN^5oO:{g.\u001a=jgR,g\u000e\u001e)beRLG/[8og\"\u0012\u0001'\\\u0001\u001ci\u0016\u001cH\u000fT8h'&TXMQ=uKNlU\r\u001e:jG\u000ecW-\u0019:)\u0005Ej\u0007")
public class KafkaRequestHandlerTest {
    private final Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
    private final BrokerTopicStats brokerTopicStats;
    private final String topic;
    private final String topic2;
    private final BrokerTopicMetrics brokerTopicMetrics;
    private final BrokerTopicMetrics allTopicMetrics;

    public Properties props() {
        return this.props;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public String topic() {
        return this.topic;
    }

    public String topic2() {
        return this.topic2;
    }

    public BrokerTopicMetrics brokerTopicMetrics() {
        return this.brokerTopicMetrics;
    }

    public BrokerTopicMetrics allTopicMetrics() {
        return this.allTopicMetrics;
    }

    @Test
    public void testCallbackTiming() {
        MockTime time = new MockTime();
        long startTime = time.nanoseconds();
        RequestChannel.Metrics metrics = new RequestChannel.Metrics(Option$.MODULE$.option2Iterable((Option)None$.MODULE$));
        RequestChannel requestChannel = new RequestChannel(10, "", (Time)time, metrics);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        try {
            KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, "broker");
            RequestChannel.Request request = this.makeRequest((Time)time, metrics);
            requestChannel.sendRequest(request);
            apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
                KafkaRequestHandlerTest.$anonfun$testCallbackTiming$1(time, handler, request, x$1);
                return BoxedUnit.UNIT;
            });
            handler.run();
            Assertions.assertEquals((long)startTime, (long)request.requestDequeueTimeNanos());
            Assertions.assertEquals((long)(startTime + 2000000L), (long)request.apiLocalCompleteTimeNanos());
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)(startTime + 2000000L))), (Object)request.callbackRequestDequeueTimeNanos());
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)(startTime + 3000000L))), (Object)request.callbackRequestCompleteTimeNanos());
        }
        finally {
            metrics.close();
        }
    }

    @Test
    public void testCallbackTryCompleteActions() {
        MockTime time = new MockTime();
        RequestChannel.Metrics metrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        RequestChannel requestChannel = new RequestChannel(10, "", (Time)time, metrics);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, "broker");
        IntRef handledCount = IntRef.create((int)0);
        IntRef tryCompleteActionCount = IntRef.create((int)0);
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            ++handledCount$1.elem;
            return CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testCallbackTryCompleteActions$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(reqLocal, ms) -> {
                handler.stop();
                return BoxedUnit.UNIT;
            }, RequestLocal$.MODULE$.NoCaching())));
        });
        apiHandler.tryCompleteActions();
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackTryCompleteActions$4(tryCompleteActionCount, x$3);
            return BoxedUnit.UNIT;
        });
        handler.run();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
        Assertions.assertEquals((int)1, (int)tryCompleteActionCount.elem);
    }

    @Test
    public void testHandlingCallbackOnNewThread() {
        MockTime time = new MockTime();
        RequestChannel.Metrics metrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        RequestChannel requestChannel = new RequestChannel(10, "", (Time)time, metrics);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, "broker");
        RequestLocal originalRequestLocal = (RequestLocal)Mockito.mock(RequestLocal.class);
        IntRef handledCount = IntRef.create((int)0);
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testHandlingCallbackOnNewThread$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(reqLocal, ms) -> {
            KafkaRequestHandlerTest.$anonfun$testHandlingCallbackOnNewThread$2(handledCount, handler, reqLocal, BoxesRunTime.unboxToInt((Object)ms));
            return BoxedUnit.UNIT;
        }, originalRequestLocal))));
        handler.run();
        ((RequestLocal)Mockito.verify((Object)originalRequestLocal, (VerificationMode)Mockito.times((int)0))).bufferSupplier();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
    }

    @Test
    public void testCallbackOnSameThread() {
        MockTime time = new MockTime();
        RequestChannel.Metrics metrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        RequestChannel requestChannel = new RequestChannel(10, "", (Time)time, metrics);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, "broker");
        RequestLocal originalRequestLocal = (RequestLocal)Mockito.mock(RequestLocal.class);
        Mockito.when((Object)originalRequestLocal.bufferSupplier()).thenReturn((Object)BufferSupplier.create());
        IntRef handledCount = IntRef.create((int)0);
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$5 -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackOnSameThread$1(handledCount, handler, originalRequestLocal, x$5);
            return BoxedUnit.UNIT;
        });
        handler.run();
        ((RequestLocal)Mockito.verify((Object)originalRequestLocal, (VerificationMode)Mockito.times((int)1))).bufferSupplier();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTopicStats(boolean systemRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.setProperty("remote.log.storage.system.enable", Boolean.toString(systemRemoteStorageEnabled));
        BrokerTopicMetrics brokerTopicMetrics = new BrokerTopicStats(Optional.of(KafkaConfig$.MODULE$.fromProps(props))).topicStats(this.topic());
        Set gaugeMetrics = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName(), RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName(), RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName(), RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName(), RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName()}));
        RemoteStorageMetrics.brokerTopicStatsMetrics().forEach(metric -> {
            if (systemRemoteStorageEnabled) {
                if (!gaugeMetrics.contains((Object)metric.getName())) {
                    Assertions.assertTrue((boolean)brokerTopicMetrics.metricMap().contains((Object)metric.getName()), (String)new StringBuilder(23).append("the metric is missing: ").append(metric.getName()).toString());
                    return;
                }
                Assertions.assertFalse((boolean)brokerTopicMetrics.metricMap().contains((Object)metric.getName()), (String)new StringBuilder(30).append("the metric should not appear: ").append(metric.getName()).toString());
                return;
            }
            Assertions.assertFalse((boolean)brokerTopicMetrics.metricMap().contains((Object)metric.getName()));
        });
        gaugeMetrics.foreach((Function1 & Serializable)metricName -> {
            KafkaRequestHandlerTest.$anonfun$testTopicStats$2(systemRemoteStorageEnabled, brokerTopicMetrics, metricName);
            return BoxedUnit.UNIT;
        });
    }

    public RequestChannel.Request makeRequest(Time time, RequestChannel.Metrics metrics) {
        RequestHeader requestHeader = (RequestHeader)Mockito.mock(RequestHeader.class);
        Mockito.when((Object)requestHeader.apiKey()).thenReturn((Object)ApiKeys.API_VERSIONS);
        Mockito.when((Object)BoxesRunTime.boxToShort((short)requestHeader.apiVersion())).thenReturn((Object)BoxesRunTime.boxToShort((short)((short)0)));
        RequestContext context = new RequestContext(requestHeader, "0", (InetAddress)Mockito.mock(InetAddress.class), new KafkaPrincipal("", ""), new ListenerName(""), SecurityProtocol.PLAINTEXT, (ClientInformation)Mockito.mock(ClientInformation.class), false);
        return new RequestChannel.Request(0, context, time.nanoseconds(), (MemoryPool)Mockito.mock(MemoryPool.class), ByteBuffer.allocate(0), metrics, (Option)None$.MODULE$);
    }

    public BrokerTopicMetrics setupBrokerTopicMetrics(boolean systemRemoteStorageEnabled) {
        String topic = "topic";
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.setProperty("remote.log.storage.system.enable", Boolean.toString(systemRemoteStorageEnabled));
        return new BrokerTopicMetrics(Option$.MODULE$.apply((Object)topic), Optional.of(KafkaConfig$.MODULE$.fromProps(props)));
    }

    public boolean setupBrokerTopicMetrics$default$1() {
        return true;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSingularCopyLagBytesMetric(boolean systemRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.setProperty("remote.log.storage.system.enable", Boolean.toString(systemRemoteStorageEnabled));
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats(Optional.of(KafkaConfig$.MODULE$.fromProps(props)));
        BrokerTopicMetrics brokerTopicMetrics = brokerTopicStats.topicStats(this.topic());
        if (systemRemoteStorageEnabled) {
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic(), 0, 100L);
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic(), 1, 150L);
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic(), 2, 250L);
            Assertions.assertEquals((long)500L, (long)brokerTopicMetrics.remoteCopyLagBytes());
            Assertions.assertEquals((long)500L, (long)brokerTopicStats.allTopicsStats().remoteCopyLagBytes());
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic2(), 0, 100L);
            Assertions.assertEquals((long)600L, (long)brokerTopicStats.allTopicsStats().remoteCopyLagBytes());
            return;
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)brokerTopicMetrics.metricGaugeMap().get((Object)RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)brokerTopicStats.allTopicsStats().metricGaugeMap().get((Object)RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName()));
    }

    @Test
    public void testMultipleCopyLagBytesMetrics() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 2, 5L);
        Assertions.assertEquals((long)20L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testCopyLagBytesMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)7L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testCopyLagBytesMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().removeRemoteCopyLagBytes(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)2L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testCopyLagBytesMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().removeRemoteCopyLagBytes(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testCopyLagBytesMetricClear() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testMultipleCopyLagSegmentsMetrics() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)16L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testCopyLagSegmentsMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testCopyLagSegmentsMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().removeRemoteCopyLagSegments(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testCopyLagSegmentsMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().removeRemoteCopyLagSegments(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testCopyLagSegmentsMetricClear() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testMultipleDeleteLagBytesMetrics() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)16L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testDeleteLagBytesMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testDeleteLagBytesMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().removeRemoteDeleteLagBytes(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testDeleteLagBytesMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().removeRemoteDeleteLagBytes(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testDeleteLagBytesMetricClear() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testMultipleDeleteLagSegmentsMetrics() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic2(), 1, 5L);
        Assertions.assertEquals((long)20L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testDeleteLagSegmentsMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testDeleteLagSegmentsMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().removeRemoteDeleteLagSegments(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testDeleteLagSegmentsMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().removeRemoteDeleteLagSegments(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testDeleteLagSegmentsMetricClear() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testRemoteLogMetadataCount() {
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteLogMetadataCount());
        this.brokerTopicStats().recordRemoteLogMetadataCount(this.topic(), 0, 1L);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteLogMetadataCount());
        this.brokerTopicStats().recordRemoteLogMetadataCount(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteLogMetadataCount(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteLogMetadataCount());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteLogMetadataCount());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSingularLogSizeBytesMetric(boolean systemRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.setProperty("remote.log.storage.system.enable", Boolean.toString(systemRemoteStorageEnabled));
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats(Optional.of(KafkaConfig$.MODULE$.fromProps(props)));
        BrokerTopicMetrics brokerTopicMetrics = brokerTopicStats.topicStats(this.topic());
        if (systemRemoteStorageEnabled) {
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic(), 0, 100L);
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic(), 1, 150L);
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic(), 2, 250L);
            Assertions.assertEquals((long)500L, (long)brokerTopicMetrics.remoteLogSizeBytes());
            Assertions.assertEquals((long)500L, (long)brokerTopicStats.allTopicsStats().remoteLogSizeBytes());
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic2(), 0, 100L);
            Assertions.assertEquals((long)600L, (long)brokerTopicStats.allTopicsStats().remoteLogSizeBytes());
            return;
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)brokerTopicMetrics.metricGaugeMap().get((Object)RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName()));
    }

    @Test
    public void testMultipleLogSizeBytesMetrics() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    public void testLogSizeBytesMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    public void testLogSizeBytesMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().removeRemoteLogSizeBytes(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    public void testLogSizeBytesMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().removeRemoteLogSizeBytes(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    public void testLogSizeBytesMetricClear() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$2(MockTime time$1, KafkaRequestHandler handler$1, RequestLocal reqLocal, int ms) {
        time$1.sleep((long)ms);
        handler$1.stop();
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$3(Function1 callback$1) {
        callback$1.apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$1(MockTime time$1, KafkaRequestHandler handler$1, RequestChannel.Request request$1, InvocationOnMock x$1) {
        time$1.sleep(2L);
        CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testCallbackTiming$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(reqLocal, ms) -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackTiming$2(time$1, handler$1, reqLocal, BoxesRunTime.unboxToInt((Object)ms));
            return BoxedUnit.UNIT;
        }, RequestLocal$.MODULE$.NoCaching())));
        request$1.apiLocalCompleteTimeNanos_$eq(time$1.nanoseconds());
    }

    public static final /* synthetic */ void $anonfun$testCallbackTryCompleteActions$3(Function1 callback$2) {
        callback$2.apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testCallbackTryCompleteActions$4(IntRef tryCompleteActionCount$1, InvocationOnMock x$3) {
        ++tryCompleteActionCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testHandlingCallbackOnNewThread$2(IntRef handledCount$2, KafkaRequestHandler handler$3, RequestLocal reqLocal, int ms) {
        reqLocal.bufferSupplier().close();
        ++handledCount$2.elem;
        handler$3.stop();
    }

    public static final /* synthetic */ void $anonfun$testHandlingCallbackOnNewThread$3(Function1 callback$3) {
        callback$3.apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testCallbackOnSameThread$2(IntRef handledCount$3, KafkaRequestHandler handler$4, RequestLocal reqLocal, int ms) {
        reqLocal.bufferSupplier().close();
        ++handledCount$3.elem;
        handler$4.stop();
    }

    public static final /* synthetic */ void $anonfun$testCallbackOnSameThread$1(IntRef handledCount$3, KafkaRequestHandler handler$4, RequestLocal originalRequestLocal$2, InvocationOnMock x$5) {
        KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(reqLocal, ms) -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackOnSameThread$2(handledCount$3, handler$4, reqLocal, BoxesRunTime.unboxToInt((Object)ms));
            return BoxedUnit.UNIT;
        }, originalRequestLocal$2).apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testTopicStats$2(boolean systemRemoteStorageEnabled$1, BrokerTopicMetrics brokerTopicMetrics$1, String metricName) {
        if (systemRemoteStorageEnabled$1) {
            Assertions.assertTrue((boolean)brokerTopicMetrics$1.metricGaugeMap().contains((Object)metricName), (String)new StringBuilder(22).append("The metric is missing:").append(metricName).toString());
            return;
        }
        Assertions.assertFalse((boolean)brokerTopicMetrics$1.metricGaugeMap().contains((Object)metricName), (String)new StringBuilder(25).append("The metric should appear:").append(metricName).toString());
    }

    public KafkaRequestHandlerTest() {
        this.props().setProperty("remote.log.storage.system.enable", Boolean.toString(true));
        this.brokerTopicStats = new BrokerTopicStats(Optional.of(KafkaConfig$.MODULE$.fromProps(this.props())));
        this.topic = "topic";
        this.topic2 = "topic2";
        this.brokerTopicMetrics = this.brokerTopicStats().topicStats(this.topic());
        this.allTopicMetrics = this.brokerTopicStats().allTopicsStats();
    }
}

