/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.PartitionTest$;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchPartitionStatus;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004G\u0001\u0001\u0006I!\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019)\u0006\u0001)A\u0005\u0013\"9a\u000b\u0001b\u0001\n\u00039\u0006BB0\u0001A\u0003%\u0001\fC\u0004a\u0001\t\u0007I\u0011A1\t\r\u001d\u0004\u0001\u0015!\u0003c\u0011\u001dA\u0007A1A\u0005\u0002%DaA\u001c\u0001!\u0002\u0013Q\u0007bB8\u0001\u0005\u0004%\t!\u001b\u0005\u0007a\u0002\u0001\u000b\u0011\u00026\t\u000fE\u0004!\u0019!C\u0001e\"1a\u000f\u0001Q\u0001\nMDqa\u001e\u0001C\u0002\u0013\u0005\u0001\u0010C\u0004\u0002\u000e\u0001\u0001\u000b\u0011B=\t\u0013\u0005=\u0001A1A\u0005\u0002\u0005E\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0005\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005E\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0005\t\u0013\u0005}\u0001A1A\u0005\u0002\u0005\u0005\u0002\u0002CA0\u0001\u0001\u0006I!a\t\t\u0017\u0005\u0005\u0004\u00011AA\u0002\u0013\u0005\u00111\r\u0005\f\u0003w\u0002\u0001\u0019!a\u0001\n\u0003\ti\bC\u0006\u0002\n\u0002\u0001\r\u0011!Q!\n\u0005\u0015\u0004bCAF\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u001bC1\"!&\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0018\"Y\u00111\u0014\u0001A\u0002\u0003\u0005\u000b\u0015BAH\u0011\u001d\ti\n\u0001C\u0001\u0003?Cq!a.\u0001\t\u0003\ty\nC\u0004\u0002<\u0002!\t!a(\t\u000f\u0005}\u0006\u0001\"\u0001\u0002 \"9\u00111\u0019\u0001\u0005\u0002\u0005}\u0005bBAd\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003\u0017\u0004A\u0011AAP\u0011\u001d\ty\r\u0001C\u0001\u0003#D\u0011\"!=\u0001#\u0003%\t!a=\t\u0013\t%\u0001!%A\u0005\u0002\t-\u0001b\u0002B\b\u0001\u0011\u0005\u0011q\u0014\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0005a\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fVo\u001c;bgR+7\u000f\u001e\u0006\u0003Y5\naa]3sm\u0016\u0014(\"\u0001\u0018\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\r\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0004C\u0001\u001e\u0001\u001b\u0005Y\u0013aB2p]\u001aLwm]\u000b\u0002{A\u0019a(Q\"\u000e\u0003}R!\u0001Q\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002C\u007f\t\u00191+Z9\u0011\u0005i\"\u0015BA#,\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0011\r|gNZ5hg\u0002\nA\u0001^5nKV\t\u0011\n\u0005\u0002K'6\t1J\u0003\u0002M\u001b\u0006!Q\u000f^5m\u0015\tacJ\u0003\u0002/\u001f*\u0011\u0001+U\u0001\u0007CB\f7\r[3\u000b\u0003I\u000b1a\u001c:h\u0013\t!6J\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001diW\r\u001e:jGN,\u0012\u0001\u0017\t\u00033vk\u0011A\u0017\u0006\u0003-nS!\u0001\u0018(\u0002\r\r|W.\\8o\u0013\tq&LA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\naA]3d_J$W#\u00012\u0011\u0005\r,W\"\u00013\u000b\u0005\u0001\\\u0016B\u00014e\u00051\u0019\u0016.\u001c9mKJ+7m\u001c:e\u0003\u001d\u0011XmY8sI\u0002\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.M\u000b\u0002UB\u00111\u000e\\\u0007\u00027&\u0011Qn\u0017\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0004%A\bu_BL7\rU1si&$\u0018n\u001c83\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0014\u0004%A\u0004u_BL7-\u00133\u0016\u0003M\u0004\"a\u001b;\n\u0005U\\&\u0001B+vS\u0012\f\u0001\u0002^8qS\u000eLE\rI\u0001\ti>\u0004\u0018nY%egV\t\u0011\u0010E\u0003{}\u0006\u00051/D\u0001|\u0015\taEPC\u0001~\u0003\u0011Q\u0017M^1\n\u0005}\\(aA'baB!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\bq\fA\u0001\\1oO&!\u00111BA\u0003\u0005\u0019\u0019FO]5oO\u0006IAo\u001c9jG&#7\u000fI\u0001\u0012i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\fTCAA\n!\rY\u0017QC\u0005\u0004\u0003/Y&\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003I!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\r\u0011\u0002#Q|\u0007/[2JIB\u000b'\u000f^5uS>t''\u0001\nu_BL7-\u00133QCJ$\u0018\u000e^5p]J\u0002\u0013!\u00034fi\u000eD\u0017J\u001c4p+\t\t\u0019\u0003\u0005\u0004\u0002&\u0005-\u0012QF\u0007\u0003\u0003OQ1!!\u000b@\u0003%IW.\\;uC\ndW-C\u0002C\u0003O\u0001rAMA\u0018\u0003'\t\u0019$C\u0002\u00022M\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BA\u001b\u00033rA!a\u000e\u0002T9!\u0011\u0011HA(\u001d\u0011\tY$!\u0014\u000f\t\u0005u\u00121\n\b\u0005\u0003\u007f\tIE\u0004\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)eL\u0001\u0007yI|w\u000e\u001e \n\u0003IK!\u0001U)\n\u00059z\u0015B\u0001/O\u0013\r\t\tfW\u0001\te\u0016\fX/Z:ug&!\u0011QKA,\u000311U\r^2i%\u0016\fX/Z:u\u0015\r\t\tfW\u0005\u0005\u00037\niFA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0005\u0003+\n9&\u0001\u0006gKR\u001c\u0007.\u00138g_\u0002\nA\"];pi\u0006l\u0015M\\1hKJ,\"!!\u001a\u0011\t\u0005\u001d\u0014Q\u000f\b\u0005\u0003S\n\tH\u0004\u0003\u0002l\u0005=d\u0002BA!\u0003[J\u0011AL\u0005\u0003Y5J1!a\u001d,\u00031\tVo\u001c;b\r\u0006\u001cGo\u001c:z\u0013\u0011\t9(!\u001f\u0003\u001bE+x\u000e^1NC:\fw-\u001a:t\u0015\r\t\u0019hK\u0001\u0011cV|G/Y'b]\u0006<WM]0%KF$B!a \u0002\u0006B\u0019!'!!\n\u0007\u0005\r5G\u0001\u0003V]&$\b\"CAD3\u0005\u0005\t\u0019AA3\u0003\rAH%M\u0001\u000ecV|G/Y'b]\u0006<WM\u001d\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011q\u0012\t\u0004u\u0005E\u0015bAAJW\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$B!a \u0002\u001a\"I\u0011q\u0011\u000f\u0002\u0002\u0003\u0007\u0011qR\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005Q3\u000f[8vY\u0012,\u0005p\u00197vI\u0016\u001cVOY:fcV,g\u000e\u001e+ie>$H\u000f\\3e!\u0006\u0014H/\u001b;j_:\u001cHCAA@Q\rq\u00121\u0015\t\u0005\u0003K\u000b\u0019,\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003\r\t\u0007/\u001b\u0006\u0005\u0003[\u000by+A\u0004kkBLG/\u001a:\u000b\u0007\u0005E\u0016+A\u0003kk:LG/\u0003\u0003\u00026\u0006\u001d&\u0001\u0002+fgR\f\u0011h\u001d5pk2$w)\u001a;O_6+7o]1hKNLe-U;pi\u0006\u001cX\t_2fK\u0012,Gm\u00148Tk\n\u001cX-];f]R\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004?\u0005\r\u0016AI:i_VdGmR3u\u0005>$\b.T3tg\u0006<Wm]%g#V|G/Y:BY2|w\u000fK\u0002!\u0003G\u000bAe\u001d5pk2$\u0017J\\2mk\u0012,\u0017J\\*z]\u000e$\u0006N]8ui2,GMU3qY&\u001c\u0017m\u001d\u0015\u0004C\u0005\r\u0016AL:i_VdG-\u00138dYV$W\r\u00165s_R$H.\u001a3SKBd\u0017nY1t\r>\u00148i\u001c8tk6,'OR3uG\"D3AIAR\u0003=\"Xm\u001d;D_6\u0004H.\u001a;f\u0013:$U\r\\1zK\u00124U\r^2i/&$\bNU3qY&\u001c\u0017\r\u00165s_R$H.\u001b8hQ\r\u0019\u00131U\u0001(i\u0016\u001cHoQ8na2,G/Z%o\t\u0016d\u0017-_3e\r\u0016$8\r[\"p]N,X.\u001a:GKR\u001c\u0007\u000eK\u0002%\u0003G\u000b!b]3u+BlunY6t)!\ty(a5\u0002f\u0006\u001d\bbBA\u0010K\u0001\u0007\u0011Q\u001b\t\u0007\u0003/\f\t/!\f\u000f\t\u0005e\u0017Q\u001c\b\u0005\u0003\u0003\nY.C\u00015\u0013\r\tynM\u0001\ba\u0006\u001c7.Y4f\u0013\r\u0011\u00151\u001d\u0006\u0004\u0003?\u001c\u0004b\u00021&!\u0003\u0005\rA\u0019\u0005\n\u0003S,\u0003\u0013!a\u0001\u0003W\f!CY8uQJ+\u0007\u000f\\5dCNLenU=oGB\u0019!'!<\n\u0007\u0005=8GA\u0004C_>dW-\u00198\u0002)M,G/\u00169N_\u000e\\7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t)PK\u0002c\u0003o\\#!!?\u0011\t\u0005m(QA\u0007\u0003\u0003{TA!a@\u0003\u0002\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0007\u0019\u0014AC1o]>$\u0018\r^5p]&!!qAA\u007f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0015g\u0016$X\u000b]'pG.\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t5!\u0006BAv\u0003o\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004Q\tM\u0001\u0003BAS\u0005+IAAa\u0006\u0002(\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\n[>\u001c7.U;pi\u0006$\"A!\b\u0011\u0007i\u0012y\"C\u0002\u0003\"-\u0012ABU3qY&\u001c\u0017-U;pi\u0006\u0004")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
        Properties fromProps_overrides = new Properties();
        return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
    });
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final SimpleRecord record = new SimpleRecord("some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final Uuid topicId = Uuid.randomUuid();
    private final java.util.Map<String, Uuid> topicIds = Collections.singletonMap("test-topic", this.topicId());
    private final TopicIdPartition topicIdPartition1 = new TopicIdPartition(this.topicId(), this.topicPartition1());
    private final TopicIdPartition topicIdPartition2 = new TopicIdPartition(this.topicId(), this.topicPartition2());
    private final scala.collection.immutable.Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition1()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, 0L, 0L, 100, Optional.empty())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition2()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, 0L, 0L, 100, Optional.empty())), (List)Nil$.MODULE$));
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SimpleRecord record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public java.util.Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public TopicIdPartition topicIdPartition1() {
        return this.topicIdPartition1;
    }

    public TopicIdPartition topicIdPartition2() {
        return this.topicIdPartition2;
    }

    public scala.collection.immutable.Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, 1L, 0L, 1, Integer.MAX_VALUE);
        Seq fetch = this.replicaManager().readFromLog(fetchParams, this.fetchInfo(), quota, false);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldExcludeSubsequentThrottledPartitions$1$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala().size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldExcludeSubsequentThrottledPartitions$2$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala().size(), (String)"But we shouldn't get the second");
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, 1L, 0L, 1, Integer.MAX_VALUE);
        Seq fetch = this.replicaManager().readFromLog(fetchParams, this.fetchInfo(), quota, false);
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala().size(), (String)"Given two partitions, with both throttled, we should get no messages");
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala().size(), (String)"Given two partitions, with both throttled, we should get no messages");
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, 1L, 0L, 1, Integer.MAX_VALUE);
        Seq fetch = this.replicaManager().readFromLog(fetchParams, this.fetchInfo(), quota, false);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldGetBothMessagesIfQuotasAllow$1$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala().size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldGetBothMessagesIfQuotasAllow$2$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala().size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        scala.collection.immutable.Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> x$1 = this.fetchInfo();
        SimpleRecord x$3 = this.setUpMocks$default$2();
        this.setUpMocks(x$1, x$3, true);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, 1L, 0L, 1, Integer.MAX_VALUE);
        Seq fetch = this.replicaManager().readFromLog(fetchParams, this.fetchInfo(), quota, false);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldIncludeInSyncThrottledReplicas$1$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala().size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldIncludeInSyncThrottledReplicas$2$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala().size(), (String)"But we should get the second too since it's throttled but in sync");
    }

    @Test
    public void shouldIncludeThrottledReplicasForConsumerFetch() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.consumerFetchParams(0L, 1, Integer.MAX_VALUE, (Option<ClientMetadata>)None$.MODULE$, FetchIsolation.HIGH_WATERMARK);
        scala.collection.immutable.Map fetch = this.replicaManager().readFromLog(fetchParams, this.fetchInfo(), quota, false).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)fetch.apply((Object)this.topicIdPartition1())).info().records.batches()).asScala().size(), (String)"Replication throttled partitions should return data for consumer fetch");
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)fetch.apply((Object)this.topicIdPartition2())).info().records.batches()).asScala().size(), (String)"Replication throttled partitions should return data for consumer fetch");
    }

    @Test
    public void testCompleteInDelayedFetchWithReplicaThrottling() {
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(true).tryComplete(), (String)"In sync replica should complete");
        Assertions.assertFalse((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(false).tryComplete(), (String)"Out of sync replica should not complete");
    }

    @Test
    public void testCompleteInDelayedFetchConsumerFetch() {
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$2(false).tryComplete(), (String)"Consumer fetch replica should complete if reading from current segment");
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$2(true).tryComplete(), (String)"Consumer fetch replica should complete if reading from older segment");
    }

    /*
     * WARNING - void declaration
     */
    public void setUpMocks(scala.collection.immutable.Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo, SimpleRecord record, boolean bothReplicasInSync) {
        void zkMetadataCache_zkMigrationEnabled;
        void zkMetadataCache_kraftControllerNodes;
        void zkMetadataCache_brokerFeatures;
        void withRecords_records;
        void withRecords_timestampType;
        KafkaScheduler scheduler = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)5L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.lastStableOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)5L));
        Mockito.when((Object)log.logEndOffsetMetadata()).thenReturn((Object)new LogOffsetMetadata(20L));
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        Mockito.when((Object)log.config()).thenReturn((Object)new LogConfig(Collections.emptyMap()));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{record};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var32_7 = null;
        simpleRecordArray = null;
        Mockito.when((Object)log.read(ArgumentMatchers.anyLong(), AdditionalMatchers.geq((int)1), (FetchIsolation)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records)));
        Mockito.when((Object)log.read(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((int)0), (FetchIsolation)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY));
        Mockito.when((Object)log.maybeIncrementHighWatermark((LogOffsetMetadata)ArgumentMatchers.any())).thenReturn((Object)None$.MODULE$);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.getLog((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        AlterPartitionManager alterIsrManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        int leaderBrokerId = ((KafkaConfig)this.configs().head()).brokerId();
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        boolean bl = false;
        Seq seq = (Seq)Seq$.MODULE$.empty();
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        MetadataVersion zkMetadataCache_metadataVersion = ((KafkaConfig)this.configs().head()).interBrokerProtocolVersion();
        Object var28_21 = null;
        brokerFeatures = null;
        seq = null;
        ZkMetadataCache x$7 = new ZkMetadataCache(leaderBrokerId, zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures, (Seq)zkMetadataCache_kraftControllerNodes, (boolean)zkMetadataCache_zkMigrationEnabled);
        LogDirFailureChannel x$8 = new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size());
        None$ x$10 = None$.MODULE$;
        BrokerTopicStats x$11 = ReplicaManager$.MODULE$.$lessinit$greater$default$11();
        AtomicBoolean x$122 = new AtomicBoolean(false);
        None$ x$13 = None$.MODULE$;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        None$ x$18 = None$.MODULE$;
        None$ x$19 = None$.MODULE$;
        Function0 x$20 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        None$ x$21 = None$.MODULE$;
        DirectoryEventHandler x$22 = DirectoryEventHandler.NOOP;
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, (Scheduler)scheduler, logManager, (Option)x$10, x$6, (MetadataCache)x$7, x$8, alterIsrManager, x$11, x$122, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17, (Option)x$18, (Option)x$19, x$20, (Option)x$21, x$22));
        fetchInfo.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$setUpMocks$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$12 -> {
            ReplicaManagerQuotasTest.$anonfun$setUpMocks$2(this, log, leaderBrokerId, bothReplicasInSync, x$12);
            return BoxedUnit.UNIT;
        });
    }

    public SimpleRecord setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable)x$13 -> {
            x$13.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable)x$14 -> {
            x$14.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    public ReplicaQuota mockQuota() {
        ReplicaQuota quota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        return quota;
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$4) {
        Object object = x$4._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$5) {
        Object object = x$5._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$6) {
        Object object = x$6._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$7) {
        Object object = x$7._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$1(ReplicaManagerQuotasTest $this, Tuple2 x$8) {
        Object object = x$8._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$2(ReplicaManagerQuotasTest $this, Tuple2 x$9) {
        Object object = x$9._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$1(ReplicaManagerQuotasTest $this, Tuple2 x$10) {
        Object object = x$10._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$2(ReplicaManagerQuotasTest $this, Tuple2 x$11) {
        Object object = x$11._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    private static final DelayedFetch setupDelayedFetch$1(boolean isReplicaInSync) {
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(100L, 0L, 500);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        Mockito.when((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.shouldLeaderThrottle((ReplicaQuota)ArgumentMatchers.any(), (Partition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((!isReplicaInSync ? 1 : 0) != 0));
        Mockito.when((Object)partition.getReplica(1)).thenReturn((Object)None$.MODULE$);
        TopicIdPartition tp = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t1", 0));
        FetchPartitionStatus fetchPartitionStatus = new FetchPartitionStatus(new LogOffsetMetadata(50L, 0L, 250), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 50L, 0L, 1, Optional.empty()));
        FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), 1, 1L, 600L, 1, 1000, FetchIsolation.LOG_END, Optional.empty());
        return new DelayedFetch(null, fetchParams, tp, fetchPartitionStatus, replicaManager){

            public boolean forceComplete() {
                return true;
            }
        };
    }

    private static final DelayedFetch setupDelayedFetch$2(boolean isFetchFromOlderSegment) {
        LogOffsetMetadata endOffsetMetadata = isFetchFromOlderSegment ? new LogOffsetMetadata(100L, 0L, 500) : new LogOffsetMetadata(150L, 50L, 500);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        Mockito.when((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        TopicIdPartition tidp = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t1", 0));
        FetchPartitionStatus fetchPartitionStatus = new FetchPartitionStatus(new LogOffsetMetadata(50L, 0L, 250), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 50L, 0L, 1, Optional.empty()));
        FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), -1, -1L, 600L, 1, 1000, FetchIsolation.HIGH_WATERMARK, Optional.empty());
        return new DelayedFetch(null, fetchParams, tidp, fetchPartitionStatus, replicaManager){

            public boolean forceComplete() {
                return true;
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$setUpMocks$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$setUpMocks$2(ReplicaManagerQuotasTest $this, UnifiedLog log$1, int leaderBrokerId$1, boolean bothReplicasInSync$1, Tuple2 x$12) {
        if (x$12 != null) {
            TopicIdPartition p = (TopicIdPartition)x$12._1();
            Partition partition = $this.replicaManager().createPartition(p.topicPartition());
            log$1.updateHighWatermark(5L);
            partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId$1)));
            partition.setLog(log$1, false);
            partition.updateAssignmentAndIsr((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})), true, bothReplicasInSync$1 ? (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})) : (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1})), (Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty(), LeaderRecoveryState.RECOVERED);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Object $anonfun$shouldExcludeSubsequentThrottledPartitions$1$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$4) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$1($this, x$4));
    }

    public static final /* synthetic */ Object $anonfun$shouldExcludeSubsequentThrottledPartitions$2$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$5) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$2($this, x$5));
    }

    public static final /* synthetic */ Object $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$6) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1($this, x$6));
    }

    public static final /* synthetic */ Object $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$7) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2($this, x$7));
    }

    public static final /* synthetic */ Object $anonfun$shouldGetBothMessagesIfQuotasAllow$1$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$8) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$1($this, x$8));
    }

    public static final /* synthetic */ Object $anonfun$shouldGetBothMessagesIfQuotasAllow$2$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$9) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$2($this, x$9));
    }

    public static final /* synthetic */ Object $anonfun$shouldIncludeInSyncThrottledReplicas$1$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$10) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$1($this, x$10));
    }

    public static final /* synthetic */ Object $anonfun$shouldIncludeInSyncThrottledReplicas$2$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$11) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$2($this, x$11));
    }
}

