/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.log.LogManager;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.server.QuotaType;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001B\r\u001b\u0001}AQ\u0001\n\u0001\u0005\u0002\u0015BQa\n\u0001\u0005\u0002!BqA\u000e\u0001C\u0002\u0013\u0005q\u0007\u0003\u0004?\u0001\u0001\u0006I\u0001\u000f\u0005\n\u007f\u0001\u0001\r\u00111A\u0005\u0002\u0001C\u0011\u0002\u0015\u0001A\u0002\u0003\u0007I\u0011A)\t\u0013]\u0003\u0001\u0019!A!B\u0013\t\u0005b\u0002-\u0001\u0005\u0004%\t!\u0017\u0005\u0007E\u0002\u0001\u000b\u0011\u0002.\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u0003!\u0007\"C9\u0001\u0001\u0004\u0005\r\u0011\"\u0001s\u0011%!\b\u00011A\u0001B\u0003&Q\rC\u0003v\u0001\u0011\u0005c\u000f\u0003\u0004\u0002\u0006\u0001!\tA\u001e\u0005\u0007\u0003\u001f\u0001A\u0011\u0001<\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002BBA\u001b\u0001\u0011\u0005a\u000fC\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H!9\u0011Q\u000b\u0001\u0005\n\u0005]\u0003bBA/\u0001\u0011\u0005\u0011q\f\u0005\b\u0003O\u0002A\u0011BA5\u0011\u001d\ti\b\u0001C\u0005\u0003\u007f\u0012QCU3qY&\u001c\u0017\r^5p]F+x\u000e^1t)\u0016\u001cHO\u0003\u0002\u001c9\u000511/\u001a:wKJT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"E5\t!$\u0003\u0002$5\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u00051\u0003CA\u0011\u0001\u00031\u0001XM]2f]R,%O]8s)\rIs\u0006\u000e\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0005\u0019>tw\rC\u00031\u0005\u0001\u0007\u0011'A\u0004qKJ\u001cWM\u001c;\u0011\u0005)\u0012\u0014BA\u001a,\u0005\rIe\u000e\u001e\u0005\u0006k\t\u0001\r!K\u0001\u0006m\u0006dW/Z\u0001\t[N<\u0017\u0007\r\u0019L\u0005V\t\u0001\bE\u0002+smJ!AO\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0005)b\u0014BA\u001f,\u0005\u0011\u0011\u0015\u0010^3\u0002\u00135\u001cx-\r\u00191\u0017\n\u0003\u0013a\u00022s_.,'o]\u000b\u0002\u0003B\u0019!IS'\u000f\u0005\rCeB\u0001#H\u001b\u0005)%B\u0001$\u001f\u0003\u0019a$o\\8u}%\tA&\u0003\u0002JW\u00059\u0001/Y2lC\u001e,\u0017BA&M\u0005\r\u0019V-\u001d\u0006\u0003\u0013.\u0002\"!\t(\n\u0005=S\"aC&bM.\f7+\u001a:wKJ\f1B\u0019:pW\u0016\u00148o\u0018\u0013fcR\u0011!+\u0016\t\u0003UMK!\u0001V\u0016\u0003\tUs\u0017\u000e\u001e\u0005\b-\u001a\t\t\u00111\u0001B\u0003\rAH%M\u0001\tEJ|7.\u001a:tA\u0005)Ao\u001c9jGV\t!\f\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006!A.\u00198h\u0015\u0005y\u0016\u0001\u00026bm\u0006L!!\u0019/\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005A\u0001O]8ek\u000e,'/F\u0001f!\u00111w\u000e\u000f\u001d\u000e\u0003\u001dT!a\u00195\u000b\u0005%T\u0017aB2mS\u0016tGo\u001d\u0006\u0003;-T!\u0001\\7\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0017aA8sO&\u0011\u0001o\u001a\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0005I\u001b\bb\u0002,\f\u0003\u0003\u0005\r!Z\u0001\naJ|G-^2fe\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002%\"\u0012Q\u0002\u001f\t\u0004s\u0006\u0005Q\"\u0001>\u000b\u0005md\u0018aA1qS*\u0011QP`\u0001\bUV\u0004\u0018\u000e^3s\u0015\tyX.A\u0003kk:LG/C\u0002\u0002\u0004i\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u0002WMDw.\u001e7e\u0005>|Go\u001d;sCB$vo\u001c\"s_.,'o],ji\"dU-\u00193feRC'o\u001c;uY\u0016D3ADA\u0005!\rI\u00181B\u0005\u0004\u0003\u001bQ(\u0001\u0002+fgR\fQf\u001d5pk2$'i\\8ugR\u0014\u0018\r\u001d+x_\n\u0013xn[3sg^KG\u000f\u001b$pY2|w/\u001a:UQJ|G\u000f\u001e7fQ\ry\u0011\u0011B\u00017g\"|W\u000f\u001c3NCR\u001c\u0007.U;pi\u0006\u0014V\r\u001d7jG\u0006$\u0018N\\4UQJ|Wo\u001a5B]\u0006\u001b\u00180\\7fiJL7\rV8q_2|w-\u001f\u000b\u0004%\u0006]\u0001bBA\r!\u0001\u0007\u00111D\u0001\u000fY\u0016\fG-\u001a:UQJ|G\u000f\u001e7f!\rQ\u0013QD\u0005\u0004\u0003?Y#a\u0002\"p_2,\u0017M\\\u0001\u0003iB$B!!\n\u00022A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,)\faaY8n[>t\u0017\u0002BA\u0018\u0003S\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u00024E\u0001\r!M\u0001\na\u0006\u0014H/\u001b;j_:\f\u0011d\u001d5pk2$G\u000b\u001b:piRdWm\u00147e'\u0016<W.\u001a8ug\"\u001a!#!\u0003\u0002\u000f\u0005$G\rR1uCR)!+!\u0010\u0002B!1\u0011qH\nA\u0002E\n\u0001\"\\:h\u0007>,h\u000e\u001e\u0005\u0007\u0003\u0007\u001a\u0002\u0019\u0001\u001d\u0002\u00075\u001cx-A\u000bxC&$hi\u001c:PM\u001a\u001cX\r^:U_6\u000bGo\u00195\u0015\u000fI\u000bI%!\u0014\u0002R!1\u00111\n\u000bA\u0002E\naa\u001c4gg\u0016$\bBBA()\u0001\u0007\u0011'A\u0006qCJ$\u0018\u000e^5p]&#\u0007BBA*)\u0001\u0007\u0011'\u0001\u0005ce>\\WM]%e\u0003%\u0011'o\\6fe\u001a{'\u000fF\u0002N\u00033Ba!a\u0017\u0016\u0001\u0004\t\u0014AA5e\u00035\u0019'/Z1uK\n\u0013xn[3sgR\u0019!+!\u0019\t\u000f\u0005\rd\u00031\u0001\u0002f\u0005I!M]8lKJLEm\u001d\t\u0004\u0005*\u000b\u0014AB1w%\u0006$X\r\u0006\u0004\u0002l\u0005E\u00141\u0010\t\u0004U\u00055\u0014bAA8W\t1Ai\\;cY\u0016Dq!a\u001d\u0018\u0001\u0004\t)(A\bsKBd\u0017nY1uS>tG+\u001f9f!\r\t\u0013qO\u0005\u0004\u0003sR\"!C)v_R\fG+\u001f9f\u0011\u0019yt\u00031\u0001\u0002f\u0005aQ.Z1tkJ,GMU1uKR1\u00111NAA\u0003\u000bCa!a!\u0019\u0001\u0004i\u0015A\u00022s_.,'\u000fC\u0004\u0002\bb\u0001\r!!\u001e\u0002\u000fI,\u0007\u000fV=qK\u0002")
public class ReplicationQuotasTest
extends QuorumTestHarness {
    private final byte[] msg100KB = new byte[100000];
    private scala.collection.immutable.Seq<KafkaServer> brokers;
    private final String topic;
    private KafkaProducer<byte[], byte[]> producer;

    public long percentError(int percent, long value) {
        return Math.round((double)(value * (long)percent) / 100.0);
    }

    public byte[] msg100KB() {
        return this.msg100KB;
    }

    public scala.collection.immutable.Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(scala.collection.immutable.Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.brokers(), true);
        super.tearDown();
    }

    @Test
    public void shouldBootstrapTwoBrokersWithLeaderThrottle() {
        this.shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(true);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithFollowerThrottle() {
        this.shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(false);
    }

    public void shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(boolean leaderThrottle) {
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 105).map((Function1 & Serializable)id -> ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$1(this, BoxesRunTime.unboxToInt((Object)id))));
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{101, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{102, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{103, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{104, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{105, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{101, 107})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)assignment, this.brokers());
        byte[] msg = this.msg100KB();
        int msgCount = 100;
        int expectedDuration = 10;
        LongRef throttle = LongRef.create((long)(msgCount * msg.length / expectedDuration));
        if (!leaderThrottle) {
            throttle.elem *= 3L;
        }
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> this.adminZkClient().changeBrokerConfig((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})), CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)Long.toString(throttle$1.elem)), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(throttle$1.elem))}))));
        if (leaderThrottle) {
            this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith("leader.replication.throttled.replicas", "0:100,1:101,2:102,3:103,4:104,5:105"));
        } else {
            this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith("follower.replication.throttled.replicas", "0:106,1:106,2:106,3:107,4:107,5:107"));
        }
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), 1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), msgCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable)partition -> ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$4(this, msg, BoxesRunTime.unboxToInt((Object)partition))));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 100 + id));
        this.waitForOffsetsToMatch(msgCount, 6, 100);
        this.waitForOffsetsToMatch(msgCount, 7, 101);
        long start = System.currentTimeMillis();
        this.createBrokers((scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertEquals((long)throttle$1.elem, (long)this.brokerFor(brokerId).quotaManagers().follower().upperBound()));
        if (!leaderThrottle) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> Assertions.assertTrue((boolean)this.brokerFor(106).quotaManagers().follower().isThrottled(this.tp(partition))));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> Assertions.assertTrue((boolean)this.brokerFor(107).quotaManagers().follower().isThrottled(this.tp(partition))));
        }
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(6), 7).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 100 + id));
        long unthrottledTook = System.currentTimeMillis() - start;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 106));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 107));
        long throttledTook = System.currentTimeMillis() - start;
        double throttledLowerBound = (double)(expectedDuration * 1000) * 0.9;
        int throttledUpperBound = expectedDuration * 1000 * 3;
        Assertions.assertTrue(((double)unthrottledTook < throttledLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(unthrottledTook).append(" < ").append(throttledLowerBound).toString());
        Assertions.assertTrue(((double)throttledTook > throttledLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(throttledTook).append(" > ").append(throttledLowerBound).toString());
        Assertions.assertTrue((throttledTook < (long)throttledUpperBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(throttledTook).append(" < ").append(throttledUpperBound).toString());
        double rateUpperBound = (double)throttle.elem * 1.1;
        double rateLowerBound = (double)throttle.elem * 0.5;
        double rate = leaderThrottle ? this.avRate((QuotaType)QuotaType.LeaderReplication$.MODULE$, (scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 105)) : this.avRate((QuotaType)QuotaType.FollowerReplication$.MODULE$, (scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107));
        Assertions.assertTrue((rate < rateUpperBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(rate).append(" < ").append(rateUpperBound).toString());
        Assertions.assertTrue((rate > rateLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(rate).append(" > ").append(rateLowerBound).toString());
    }

    public TopicPartition tp(int partition) {
        return new TopicPartition(this.topic(), partition);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldThrottleOldSegments() {
        void createServer_time;
        void createServer_config;
        void createServer_time2;
        void createServer_config2;
        Properties config = TestUtils$.MODULE$.createBrokerConfig(100, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        config.put("log.segment.bytes", Integer.toString(0x100000));
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(config);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean createServer_createServer_createServer_startup = true;
        Object var14_5 = null;
        Object var11_4 = null;
        kafkaConfig = null;
        time = null;
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)new .colon.colon((Object)createServer_this.createServer((KafkaConfig)createServer_config2, (Time)createServer_time2, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false), (List)Nil$.MODULE$));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        byte[] msg = this.msg100KB();
        int msgCount = 200;
        int expectedDuration = 4;
        long throttle = msg.length * msgCount / expectedDuration;
        this.adminZkClient().changeBrokerConfig((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), Long.toString(throttle)));
        this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith("leader.replication.throttled.replicas", "0:100"));
        this.addData(msgCount, msg);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting new broker");
        Time time2 = Time.SYSTEM;
        KafkaConfig kafkaConfig2 = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(101, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        TestUtils$ createServer_this2 = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix2 = None$.MODULE$;
        boolean createServer_createServer_createServer_startup2 = true;
        Object var19_14 = null;
        Object var16_13 = null;
        kafkaConfig2 = null;
        time2 = null;
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)this.brokers().$colon$plus((Object)createServer_this2.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix2, createServer_createServer_createServer_startup2, false))));
        long start = System.currentTimeMillis();
        this.waitForOffsetsToMatch(msgCount, 0, 101);
        long throttledTook = System.currentTimeMillis() - start;
        Assertions.assertTrue(((double)throttledTook > (double)(expectedDuration * 1000) * 0.9 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be > ").append((double)(expectedDuration * 1000) * 0.9).append("ms").toString());
        Assertions.assertTrue(((double)throttledTook < (double)(expectedDuration * 1000) * 1.5 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be < ").append(expectedDuration * 1500).append("ms").toString());
    }

    public void addData(int msgCount, byte[] msg) {
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), 0, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), msgCount).map((Function1 & Serializable)x$4 -> ReplicationQuotasTest.$anonfun$addData$1(this, msg, BoxesRunTime.unboxToInt((Object)x$4))).foreach((Function1 & Serializable)x$5 -> (RecordMetadata)x$5.get());
        this.waitForOffsetsToMatch(msgCount, 0, 100);
    }

    /*
     * WARNING - void declaration
     */
    private void waitForOffsetsToMatch(int offset, int partitionId, int brokerId) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$1(this, offset, brokerId, partitionId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$4(partitionId, brokerId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private KafkaServer brokerFor(int id) {
        return (KafkaServer)((IterableOps)this.brokers().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ReplicationQuotasTest.$anonfun$brokerFor$1(id, x$7)))).head();
    }

    public void createBrokers(scala.collection.immutable.Seq<Object> brokerIds) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)id -> {
            void createServer_time;
            Time time = Time.SYSTEM;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            boolean createServer_createServer_createServer_startup = true;
            Object var5_5 = null;
            Object var2_4 = null;
            Object var3_3 = null;
            time = null;
            this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)this.brokers().$colon$plus((Object)createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false))));
        });
    }

    private double avRate(QuotaType replicationType, scala.collection.immutable.Seq<Object> brokers) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)brokers.map((Function1 & Serializable)id -> this.brokerFor(BoxesRunTime.unboxToInt((Object)id)))).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToDouble((double)this.measuredRate(x$8, replicationType)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)brokers.length();
    }

    private double measuredRate(KafkaServer broker, QuotaType repType) {
        MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
        return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)CollectionConverters$.MODULE$.MapHasAsScala(broker.metrics().metrics()).asScala().apply((Object)metricName)).metricValue());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ KafkaServer $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$1(ReplicationQuotasTest $this, int id) {
        void createServer_time;
        Time time = Time.SYSTEM;
        KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(id, $this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean createServer_createServer_createServer_startup = true;
        return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
    }

    public static final /* synthetic */ Future $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$4(ReplicationQuotasTest $this, byte[] msg$1, int partition) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)msg$1));
    }

    public static final /* synthetic */ Future $anonfun$addData$1(ReplicationQuotasTest $this, byte[] msg$2, int x$4) {
        return $this.producer().send(new ProducerRecord($this.topic(), (Object)msg$2));
    }

    public static final /* synthetic */ boolean $anonfun$waitForOffsetsToMatch$1(ReplicationQuotasTest $this, int offset$1, int brokerId$1, int partitionId$1) {
        LogManager qual$1 = $this.brokerFor(brokerId$1).getLogManager();
        TopicPartition x$1 = new TopicPartition($this.topic(), partitionId$1);
        boolean x$2 = qual$1.getLog$default$2();
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)offset$1), (Object)qual$1.getLog(x$1, x$2).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.logEndOffset())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public static final /* synthetic */ String $anonfun$waitForOffsetsToMatch$4(int partitionId$1, int brokerId$1) {
        return new StringBuilder(47).append("Offsets did not match for partition ").append(partitionId$1).append(" on broker ").append(brokerId$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$brokerFor$1(int id$1, KafkaServer x$7) {
        return x$7.config().brokerId() == id$1;
    }

    public ReplicationQuotasTest() {
        this.topic = "topic1";
    }
}

