/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.concurrent.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005)3Aa\u0003\u0007\u0001#!)A\u0004\u0001C\u0001;!9q\u0004\u0001b\u0001\n\u0003\u0001\u0003BB\u0016\u0001A\u0003%\u0011\u0005C\u0003-\u0001\u0011\u0005Q\u0006C\u0003?\u0001\u0011\u0005Q\u0006C\u0003A\u0001\u0011\u0005Q\u0006C\u0003C\u0001\u0011\u0005Q\u0006C\u0003E\u0001\u0011\u0005Q\u0006C\u0003G\u0001\u0011\u0005Q\u0006C\u0003I\u0001\u0011\u0005QFA\u0007D_J,W\u000b^5mgR+7\u000f\u001e\u0006\u0003\u001b9\tQ!\u001e;jYNT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eQR\"\u0001\u0007\n\u0005ma!a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"!\u0007\u0001\u0002!\rdWo\u001d;fe&#\u0007+\u0019;uKJtW#A\u0011\u0011\u0005\tJS\"A\u0012\u000b\u0005\u0011*\u0013!\u0002:fO\u0016D(B\u0001\u0014(\u0003\u0011)H/\u001b7\u000b\u0003!\nAA[1wC&\u0011!f\t\u0002\b!\u0006$H/\u001a:o\u0003E\u0019G.^:uKJLE\rU1ui\u0016\u0014h\u000eI\u0001\fi\u0016\u001cHoU<bY2|w\u000fF\u0001/!\t\u0019r&\u0003\u00021)\t!QK\\5uQ\t!!\u0007\u0005\u00024y5\tAG\u0003\u00026m\u0005\u0019\u0011\r]5\u000b\u0005]B\u0014a\u00026va&$XM\u001d\u0006\u0003si\nQA[;oSRT\u0011aO\u0001\u0004_J<\u0017BA\u001f5\u0005\u0011!Vm\u001d;\u0002\u001bQ,7\u000f\u001e*fC\u0012\u0014\u0015\u0010^3tQ\t)!'A\u0004uKN$\u0018IY:)\u0005\u0019\u0011\u0014A\u0003;fgRLe\u000eT8dW\"\u0012qAM\u0001\u001ci\u0016\u001cH/\u0016:m'\u00064WMQ1tKZ\"TI\\2pI\u0016,V+\u0013#)\u0005!\u0011\u0014\u0001\u0007;fgR<UM\\3sCR,W+^5e\u0003N\u0014\u0015m]37i!\u0012\u0011BM\u0001\u0016i\u0016\u001cH/\u0011;p[&\u001cw)\u001a;PeV\u0003H-\u0019;fQ\tQ!\u0007")
public class CoreUtilsTest
implements Logging {
    private final Pattern clusterIdPattern = Pattern.compile("[a-zA-Z0-9_\\-]+");
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Pattern clusterIdPattern() {
        return this.clusterIdPattern;
    }

    @Test
    public void testSwallow() {
        ObjectRef loggedMessage = ObjectRef.create((Object)None$.MODULE$);
        Logging testLogging = new Logging(null, loggedMessage){
            private Logger logger;
            private String logIdent;
            private volatile boolean bitmap$0;
            private final ObjectRef loggedMessage$1;

            public String loggerName() {
                return Logging.loggerName$((Logging)this);
            }

            public String msgWithLogIdent(String msg) {
                return Logging.msgWithLogIdent$((Logging)this, (String)msg);
            }

            public void trace(Function0<String> msg) {
                Logging.trace$((Logging)this, msg);
            }

            public boolean isDebugEnabled() {
                return Logging.isDebugEnabled$((Logging)this);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void debug(Function0<String> msg) {
                Logging.debug$((Logging)this, msg);
            }

            public void info(Function0<String> msg) {
                Logging.info$((Logging)this, msg);
            }

            public void warn(Function0<String> msg) {
                Logging.warn$((Logging)this, msg);
            }

            public void error(Function0<String> msg) {
                Logging.error$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg) {
                Logging.fatal$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg, Function0<Throwable> e) {
                Logging.fatal$((Logging)this, msg, e);
            }

            private Logger logger$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.logger = Logging.logger$((Logging)this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                if (!this.bitmap$0) {
                    return this.logger$lzycompute();
                }
                return this.logger;
            }

            public String logIdent() {
                return this.logIdent;
            }

            public void logIdent_$eq(String x$1) {
                this.logIdent = x$1;
            }

            public void info(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)new StringBuilder(0).append((String)msg.apply()).append(Level.INFO).toString());
            }

            public void debug(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)new StringBuilder(0).append((String)msg.apply()).append(Level.DEBUG).toString());
            }

            public void warn(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)new StringBuilder(0).append((String)msg.apply()).append(Level.WARN).toString());
            }

            public void error(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)new StringBuilder(0).append((String)msg.apply()).append(Level.ERROR).toString());
            }

            public void trace(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)new StringBuilder(0).append((String)msg.apply()).append(Level.TRACE).toString());
            }
            {
                this.loggedMessage$1 = loggedMessage$1;
            }
        };
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.TRACE);
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(4).append("test").append(Level.TRACE).toString()), (Object)((Option)loggedMessage.elem));
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.DEBUG);
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(4).append("test").append(Level.DEBUG).toString()), (Object)((Option)loggedMessage.elem));
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.INFO);
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(4).append("test").append(Level.INFO).toString()), (Object)((Option)loggedMessage.elem));
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.WARN);
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(4).append("test").append(Level.WARN).toString()), (Object)((Option)loggedMessage.elem));
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.ERROR);
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(4).append("test").append(Level.ERROR).toString()), (Object)((Option)loggedMessage.elem));
    }

    @Test
    public void testReadBytes() {
        new .colon.colon((Object)"", (List)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"abcd", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)testCase -> {
            CoreUtilsTest.$anonfun$testReadBytes$1(testCase);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAbs() {
        Assertions.assertEquals((int)0, (int)Utils.abs((int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)1, (int)Utils.abs((int)-1));
        Assertions.assertEquals((int)0, (int)Utils.abs((int)0));
        Assertions.assertEquals((int)1, (int)Utils.abs((int)1));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)Utils.abs((int)Integer.MAX_VALUE));
    }

    @Test
    public void testInLock() {
        int n;
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        try {
            n = CoreUtilsTest.$anonfun$testInLock$1(lock);
        }
        finally {
            lock.unlock();
        }
        int result = n;
        Assertions.assertEquals((int)2, (int)result);
        Assertions.assertFalse((boolean)lock.isLocked(), (String)"Should be unlocked");
    }

    @Test
    public void testUrlSafeBase64EncodeUUID() {
        String clusterId1 = Base64.getUrlEncoder().withoutPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("a149b4a3-06e1-4b49-a8cb-8a9c4a59fa46")));
        Assertions.assertEquals((Object)clusterId1, (Object)"oUm0owbhS0moy4qcSln6Rg");
        Assertions.assertEquals((int)clusterId1.length(), (int)22);
        Assertions.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId1).matches());
        String clusterId2 = Base64.getUrlEncoder().withoutPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("d418ec02-277e-4853-81e6-afe30259daec")));
        Assertions.assertEquals((Object)clusterId2, (Object)"1BjsAid-SFOB5q_jAlna7A");
        Assertions.assertEquals((int)clusterId2.length(), (int)22);
        Assertions.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId2).matches());
    }

    @Test
    public void testGenerateUuidAsBase64() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        Assertions.assertEquals((int)clusterId.length(), (int)22);
        Assertions.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId).matches());
    }

    @Test
    public void testAtomicGetOrUpdate() {
        int count = 1000;
        int nThreads = 5;
        AtomicInteger createdCount = new AtomicInteger();
        Map map = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        ExecutionContextExecutorService executionContext = ExecutionContext$.MODULE$.fromExecutorService(Executors.newFixedThreadPool(nThreads));
        try {
            Await$.MODULE$.result((Awaitable)Future$.MODULE$.traverse((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count), (Function1 & Serializable)x$1 -> Future$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> {
                Object object;
                Integer atomicGetOrUpdate_key = BoxesRunTime.boxToInteger((int)0);
                Option option = map$1.get((Object)atomicGetOrUpdate_key);
                if (option instanceof Some) {
                    object = ((Some)option).value();
                } else if (None$.MODULE$.equals(option)) {
                    AtomicInteger atomicGetOrUpdate_value = CoreUtilsTest.$anonfun$testAtomicGetOrUpdate$3(createdCount$1);
                    object = map$1.putIfAbsent((Object)atomicGetOrUpdate_key, (Object)atomicGetOrUpdate_value).getOrElse(() -> CoreUtils$.$anonfun$atomicGetOrUpdate$1((Object)atomicGetOrUpdate_value));
                } else {
                    throw new MatchError((Object)option);
                }
                Object var2_2 = null;
                option = null;
                Object var4_4 = null;
                return ((AtomicInteger)object).incrementAndGet();
            }, (ExecutionContext)executionContext), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)executionContext), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.MINUTES));
            Assertions.assertEquals((int)count, (int)((AtomicInteger)map.apply((Object)BoxesRunTime.boxToInteger((int)0))).get());
            int created = createdCount.get();
            Assertions.assertTrue((created > 0 && created <= nThreads ? 1 : 0) != 0, (String)new StringBuilder(19).append("Too many creations ").append(created).toString());
        }
        finally {
            executionContext.shutdownNow();
        }
    }

    public static final /* synthetic */ void $anonfun$testReadBytes$1(String testCase) {
        byte[] bytes = testCase.getBytes();
        Assertions.assertTrue((boolean)Arrays.equals(bytes, Utils.readBytes((ByteBuffer)ByteBuffer.wrap(bytes))));
    }

    public static final /* synthetic */ int $anonfun$testInLock$1(ReentrantLock lock$1) {
        Assertions.assertTrue((boolean)lock$1.isHeldByCurrentThread(), (String)"Should be in lock");
        return 2;
    }

    public static final /* synthetic */ AtomicInteger $anonfun$testAtomicGetOrUpdate$3(AtomicInteger createdCount$1) {
        createdCount$1.incrementAndGet();
        return new AtomicInteger();
    }
}

