/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.InvalidOffsetException;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Os$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sun.nio.ch.DirectBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tEb\u0001B\u0001\u0003\u0001\u001d\u00111b\u00144gg\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\t\u0017!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t;\u0001\u0011\t\u0019!C\u0001=\u0005!a-\u001b7f+\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\r\u0003\tIw.\u0003\u0002%C\t!a)\u001b7f\u0011!1\u0003A!a\u0001\n\u00039\u0013\u0001\u00034jY\u0016|F%Z9\u0015\u0005!Z\u0003CA\f*\u0013\tQ\u0003D\u0001\u0003V]&$\bb\u0002\u0017&\u0003\u0003\u0005\raH\u0001\u0004q\u0012\n\u0004\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0015B\u0010\u0002\u000b\u0019LG.\u001a\u0011)\u00055\u0002\u0004CA\f2\u0013\t\u0011\u0004D\u0001\u0005w_2\fG/\u001b7f\u0011!!\u0004A!b\u0001\n\u0003)\u0014A\u00032bg\u0016|eMZ:fiV\ta\u0007\u0005\u0002\u0018o%\u0011\u0001\b\u0007\u0002\u0005\u0019>tw\r\u0003\u0005;\u0001\t\u0005\t\u0015!\u00037\u0003-\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0011\t\u0011q\u0002!Q1A\u0005\u0002u\nA\"\\1y\u0013:$W\r_*ju\u0016,\u0012A\u0010\t\u0003/}J!\u0001\u0011\r\u0003\u0007%sG\u000f\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003?\u00035i\u0017\r_%oI\u0016D8+\u001b>fA!)A\t\u0001C\u0001\u000b\u00061A(\u001b8jiz\"BA\u0012%J\u0015B\u0011q\tA\u0007\u0002\u0005!)Qd\u0011a\u0001?!)Ag\u0011a\u0001m!9Ah\u0011I\u0001\u0002\u0004q\u0004b\u0002'\u0001\u0005\u0004%I!T\u0001\u0005Y>\u001c7.F\u0001O!\tye+D\u0001Q\u0015\t\t&+A\u0003m_\u000e\\7O\u0003\u0002T)\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Uc\u0011\u0001B;uS2L!a\u0016)\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u0019I\u0006\u0001)A\u0005\u001d\u0006)An\\2lA!91\f\u0001a\u0001\n\u0013a\u0016\u0001B7nCB,\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A2\t1A\\5p\u0013\t\u0011wL\u0001\tNCB\u0004X\r\u001a\"zi\u0016\u0014UO\u001a4fe\"9A\r\u0001a\u0001\n\u0013)\u0017\u0001C7nCB|F%Z9\u0015\u0005!2\u0007b\u0002\u0017d\u0003\u0003\u0005\r!\u0018\u0005\u0007Q\u0002\u0001\u000b\u0015B/\u0002\u000b5l\u0017\r\u001d\u0011\t\u000f)\u0004\u0001\u0019!C\u0005W\u0006!1/\u001b>f+\u0005a\u0007CA7q\u001b\u0005q'BA8S\u0003\u0019\tGo\\7jG&\u0011\u0011O\u001c\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\u000fM\u0004\u0001\u0019!C\u0005i\u0006A1/\u001b>f?\u0012*\u0017\u000f\u0006\u0002)k\"9AF]A\u0001\u0002\u0004a\u0007BB<\u0001A\u0003&A.A\u0003tSj,\u0007\u0005C\u0004z\u0001\u0001\u0007I\u0011A\u001f\u0002\u00155\f\u00070\u00128ue&,7\u000fC\u0004|\u0001\u0001\u0007I\u0011\u0001?\u0002\u001d5\f\u00070\u00128ue&,7o\u0018\u0013fcR\u0011\u0001& \u0005\bYi\f\t\u00111\u0001?\u0011\u0019y\b\u0001)Q\u0005}\u0005YQ.\u0019=F]R\u0014\u0018.Z:!Q\tq\b\u0007\u0003\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u00016\u0003)a\u0017m\u001d;PM\u001a\u001cX\r\u001e\u0005\n\u0003\u0013\u0001\u0001\u0019!C\u0001\u0003\u0017\ta\u0002\\1ti>3gm]3u?\u0012*\u0017\u000fF\u0002)\u0003\u001bA\u0001\u0002LA\u0004\u0003\u0003\u0005\rA\u000e\u0005\b\u0003#\u0001\u0001\u0015)\u00037\u0003-a\u0017m\u001d;PM\u001a\u001cX\r\u001e\u0011\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018\u0005i!/Z1e\u0019\u0006\u001cH/\u00128uef$\"!!\u0007\u0011\u0007\u001d\u000bY\"C\u0002\u0002\u001e\t\u0011ab\u00144gg\u0016$\bk\\:ji&|g\u000eC\u0004\u0002\"\u0001!\t!a\t\u0002\r1|wn[;q)\u0011\tI\"!\n\t\u000f\u0005\u001d\u0012q\u0004a\u0001m\u0005aA/\u0019:hKR|eMZ:fi\"9\u00111\u0006\u0001\u0005\n\u00055\u0012\u0001D5oI\u0016D8\u000b\\8u\r>\u0014H#\u0002 \u00020\u0005e\u0002\u0002CA\u0019\u0003S\u0001\r!a\r\u0002\u0007%$\u0007\u0010E\u0002_\u0003kI1!a\u000e`\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u0003O\tI\u00031\u00017\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007f\taB]3mCRLg/Z(gMN,G\u000fF\u0003?\u0003\u0003\n)\u0005\u0003\u0005\u0002D\u0005m\u0002\u0019AA\u001a\u0003\u0019\u0011WO\u001a4fe\"9\u0011qIA\u001e\u0001\u0004q\u0014!\u00018\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N\u0005A\u0001\u000f[=tS\u000e\fG\u000eF\u0003?\u0003\u001f\n\t\u0006\u0003\u0005\u0002D\u0005%\u0003\u0019AA\u001a\u0011\u001d\t9%!\u0013A\u0002yBq!!\u0016\u0001\t\u0003\t9&A\u0003f]R\u0014\u0018\u0010\u0006\u0003\u0002\u001a\u0005e\u0003bBA$\u0003'\u0002\rA\u0010\u0005\b\u0003;\u0002A\u0011AA0\u0003\u0019\t\u0007\u000f]3oIR)\u0001&!\u0019\u0002f!9\u00111MA.\u0001\u00041\u0014AB8gMN,G\u000fC\u0004\u0002h\u0005m\u0003\u0019\u0001 \u0002\u0011A|7/\u001b;j_:Dq!a\u001b\u0001\t\u0003\ti'\u0001\u0004jg\u001a+H\u000e\\\u000b\u0003\u0003_\u00022aFA9\u0013\r\t\u0019\b\u0007\u0002\b\u0005>|G.Z1o\u0011\u001d\t9\b\u0001C\u0001\u0003s\n\u0001\u0002\u001e:v]\u000e\fG/\u001a\u000b\u0002Q!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0014A\u0003;sk:\u001c\u0017\r^3U_R\u0019\u0001&!!\t\u000f\u0005\r\u00141\u0010a\u0001m!9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0015!\u0005;sk:\u001c\u0017\r^3U_\u0016sGO]5fgR\u0019\u0001&!#\t\u000f\u0005-\u00151\u0011a\u0001}\u00059QM\u001c;sS\u0016\u001c\bbBAH\u0001\u0011\u0005\u0011\u0011P\u0001\u0010iJLW\u000eV8WC2LGmU5{K\"9\u00111\u0013\u0001\u0005\u0002\u0005U\u0015A\u0002:fg&TX\rF\u0002)\u0003/Cq!!'\u0002\u0012\u0002\u0007a(A\u0004oK^\u001c\u0016N_3\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \u0006Qam\u001c:dKVsW.\u00199\u0015\u0007!\n\t\u000bC\u0004\u0002$\u0006m\u0005\u0019A/\u0002\u00035Dq!a*\u0001\t\u0003\tI(A\u0003gYV\u001c\b\u000eC\u0004\u0002,\u0002!\t!!,\u0002\r\u0011,G.\u001a;f)\t\ty\u0007C\u0004\u0002\f\u0002!\t!!-\u0015\u0003yBq!!.\u0001\t\u0003\t\t,A\u0006tSj,\u0017J\u001c\"zi\u0016\u001c\bbBA]\u0001\u0011\u0005\u0011\u0011P\u0001\u0006G2|7/\u001a\u0005\b\u0003{\u0003A\u0011AA`\u0003!\u0011XM\\1nKR{G\u0003BA8\u0003\u0003Dq!a1\u0002<\u0002\u0007q$A\u0001g\u0011\u001d\t9\r\u0001C\u0001\u0003s\n1b]1oSRL8\t[3dW\"9\u00111\u001a\u0001\u0005\n\u00055\u0017\u0001\u0006:pk:$Gk\\#yC\u000e$X*\u001e7uSBdW\rF\u0003?\u0003\u001f\f\u0019\u000eC\u0004\u0002R\u0006%\u0007\u0019\u0001 \u0002\r9,XNY3s\u0011\u001d\t).!3A\u0002y\naAZ1di>\u0014\bbBAm\u0001\u0011%\u00111\\\u0001\n[\u0006L(-\u001a'pG.,B!!8\u0002fR!\u0011q\u001cB\u0001)\u0011\t\t/a>\u0011\t\u0005\r\u0018Q\u001d\u0007\u0001\t!\t9/a6C\u0002\u0005%(!\u0001+\u0012\t\u0005-\u0018\u0011\u001f\t\u0004/\u00055\u0018bAAx1\t9aj\u001c;iS:<\u0007cA\f\u0002t&\u0019\u0011Q\u001f\r\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002z\u0006]G\u00111\u0001\u0002|\u0006\u0019a-\u001e8\u0011\u000b]\ti0!9\n\u0007\u0005}\bD\u0001\u0005=Eft\u0017-\\3?\u0011\u001da\u0015q\u001ba\u0001\u0005\u0007\u00012a\u0014B\u0003\u0013\r\u00119\u0001\u0015\u0002\u0005\u0019>\u001c7nB\u0005\u0003\f\t\t\t\u0011#\u0002\u0003\u000e\u0005YqJ\u001a4tKRLe\u000eZ3y!\r9%q\u0002\u0004\t\u0003\t\t\t\u0011#\u0002\u0003\u0012M!!q\u0002\u0005\u0017\u0011\u001d!%q\u0002C\u0001\u0005+!\"A!\u0004\t\u0015\te!qBI\u0001\n\u0003\u0011Y\"\u0001\bj]&$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tu!f\u0001 \u0003 -\u0012!\u0011\u0005\t\u0005\u0005G\u0011i#\u0004\u0002\u0003&)!!q\u0005B\u0015\u0003%)hn\u00195fG.,GMC\u0002\u0003,a\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yC!\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class OffsetIndex
implements Logging {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final ReentrantLock lock;
    private MappedByteBuffer kafka$log$OffsetIndex$$mmap;
    private AtomicInteger kafka$log$OffsetIndex$$size;
    private volatile int maxEntries;
    private long lastOffset;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final int init$default$3() {
        return OffsetIndex$.MODULE$.init$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File file) {
        this.file = file;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public final MappedByteBuffer kafka$log$OffsetIndex$$mmap() {
        return this.kafka$log$OffsetIndex$$mmap;
    }

    public final void kafka$log$OffsetIndex$$mmap_$eq(MappedByteBuffer mappedByteBuffer) {
        this.kafka$log$OffsetIndex$$mmap = mappedByteBuffer;
    }

    public final AtomicInteger kafka$log$OffsetIndex$$size() {
        return this.kafka$log$OffsetIndex$$size;
    }

    private void kafka$log$OffsetIndex$$size_$eq(AtomicInteger atomicInteger) {
        this.kafka$log$OffsetIndex$$size = atomicInteger;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public void maxEntries_$eq(int n) {
        this.maxEntries = n;
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public void lastOffset_$eq(long l) {
        this.lastOffset = l;
    }

    public OffsetPosition readLastEntry() {
        return (OffsetPosition)Utils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final OffsetPosition apply() {
                OffsetPosition offsetPosition;
                int n = this.$outer.kafka$log$OffsetIndex$$size().get();
                if (n == 0) {
                    offsetPosition = new OffsetPosition(this.$outer.baseOffset(), 0);
                } else {
                    int s = n;
                    offsetPosition = new OffsetPosition(this.$outer.baseOffset() + (long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(this.$outer.kafka$log$OffsetIndex$$mmap(), s - 1), this.$outer.kafka$log$OffsetIndex$$physical(this.$outer.kafka$log$OffsetIndex$$mmap(), s - 1));
                }
                return offsetPosition;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public OffsetPosition lookup(long targetOffset$1) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0)new Serializable(this, targetOffset$1){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;
            private final long targetOffset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final OffsetPosition apply() {
                ByteBuffer idx = this.$outer.kafka$log$OffsetIndex$$mmap().duplicate();
                int slot = this.$outer.kafka$log$OffsetIndex$$indexSlotFor(idx, this.targetOffset$1);
                return slot == -1 ? new OffsetPosition(this.$outer.baseOffset(), 0) : new OffsetPosition(this.$outer.baseOffset() + (long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, slot), this.$outer.kafka$log$OffsetIndex$$physical(idx, slot));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.targetOffset$1 = l;
            }
        });
    }

    public final int kafka$log$OffsetIndex$$indexSlotFor(ByteBuffer idx, long targetOffset) {
        long relOffset = targetOffset - this.baseOffset();
        if (this.entries() == 0) {
            return -1;
        }
        if ((long)this.kafka$log$OffsetIndex$$relativeOffset(idx, 0) > relOffset) {
            return -1;
        }
        int lo = 0;
        int hi = this.entries() - 1;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            int found = this.kafka$log$OffsetIndex$$relativeOffset(idx, mid);
            if ((long)found == relOffset) {
                return mid;
            }
            if ((long)found < relOffset) {
                lo = mid;
                continue;
            }
            hi = mid - 1;
        }
        return lo;
    }

    public final int kafka$log$OffsetIndex$$relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * 8);
    }

    public final int kafka$log$OffsetIndex$$physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * 8 + 4);
    }

    public OffsetPosition entry(int n$1) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0)new Serializable(this, n$1){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;
            private final int n$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final OffsetPosition apply() {
                if (this.n$1 >= this.$outer.entries()) {
                    throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from an index of size %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$1), BoxesRunTime.boxToInteger((int)this.$outer.entries())})));
                }
                ByteBuffer idx = this.$outer.kafka$log$OffsetIndex$$mmap().duplicate();
                return new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, this.n$1), this.$outer.kafka$log$OffsetIndex$$physical(idx, this.n$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.n$1 = n;
            }
        });
    }

    public void append(long offset$1, int position$1) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, offset$1, position$1){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;
            public final long offset$1;
            public final int position$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.require(!this.$outer.isFull(), (Function0)new Serializable(this){
                    public static final long serialVersionUID;
                    private final $anonfun$append$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Attempt to append to a full index (size = ").append((Object)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$size()).append((Object)").").toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                if (this.$outer.kafka$log$OffsetIndex$$size().get() == 0 || this.offset$1 > this.$outer.lastOffset()) {
                    this.$outer.debug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$append$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.position$1), this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().file().getName()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.kafka$log$OffsetIndex$$mmap().putInt((int)(this.offset$1 - this.$outer.baseOffset()));
                    this.$outer.kafka$log$OffsetIndex$$mmap().putInt(this.position$1);
                    this.$outer.kafka$log$OffsetIndex$$size().incrementAndGet();
                    this.$outer.lastOffset_$eq(this.offset$1);
                    Predef$.MODULE$.require(this.$outer.entries() * 8 == this.$outer.kafka$log$OffsetIndex$$mmap().position(), (Function0)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$append$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().entries()).append((Object)" entries but file position in index is ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$mmap().position())).append((Object)".").toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                throw new InvalidOffsetException(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to position %d no larger than the last offset appended (%d) to %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.entries()), BoxesRunTime.boxToLong((long)this.$outer.lastOffset()), this.$outer.file().getAbsolutePath()})));
            }

            public OffsetIndex kafka$log$OffsetIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offset$1 = l;
                this.position$1 = n;
            }
        });
    }

    public boolean isFull() {
        return this.entries() >= this.maxEntries();
    }

    public void truncate() {
        this.kafka$log$OffsetIndex$$truncateToEntries(0);
    }

    public void truncateTo(long offset$2) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, offset$2){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;
            private final long offset$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer idx = this.$outer.kafka$log$OffsetIndex$$mmap().duplicate();
                int slot = this.$outer.kafka$log$OffsetIndex$$indexSlotFor(idx, this.offset$2);
                int newEntries = slot < 0 ? 0 : ((long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, slot) == this.offset$2 - this.$outer.baseOffset() ? slot : slot + 1);
                this.$outer.kafka$log$OffsetIndex$$truncateToEntries(newEntries);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offset$2 = l;
            }
        });
    }

    public final void kafka$log$OffsetIndex$$truncateToEntries(int entries$1) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, entries$1){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;
            private final int entries$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$OffsetIndex$$size().set(this.entries$1);
                this.$outer.kafka$log$OffsetIndex$$mmap().position(this.$outer.kafka$log$OffsetIndex$$size().get() * 8);
                this.$outer.lastOffset_$eq(this.$outer.readLastEntry().offset());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.entries$1 = n;
            }
        });
    }

    public void trimToValidSize() {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.resize(this.$outer.entries() * 8);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void resize(int newSize$1) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, newSize$1){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;
            private final int newSize$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Buffer apply() {
                RandomAccessFile raf$2 = new RandomAccessFile(this.$outer.file(), "rws");
                int roundedNewSize = this.$outer.kafka$log$OffsetIndex$$roundToExactMultiple(this.newSize$1, 8);
                int position = this.$outer.kafka$log$OffsetIndex$$mmap().position();
                if (Os$.MODULE$.isWindows()) {
                    this.$outer.kafka$log$OffsetIndex$$forceUnmap(this.$outer.kafka$log$OffsetIndex$$mmap());
                }
                Buffer exceptionResult3 = null;
                try {
                    raf$2.setLength(roundedNewSize);
                    this.$outer.kafka$log$OffsetIndex$$mmap_$eq(raf$2.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                    this.$outer.maxEntries_$eq(this.$outer.kafka$log$OffsetIndex$$mmap().limit() / 8);
                    exceptionResult3 = this.$outer.kafka$log$OffsetIndex$$mmap().position(position);
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf$2){
                        public static final long serialVersionUID;
                        private final RandomAccessFile raf$2;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.raf$2.close();
                        }
                        {
                            this.raf$2 = randomAccessFile;
                        }
                    });
                    return exceptionResult3;
                }
                catch (Throwable throwable) {
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newSize$1 = n;
            }
        });
    }

    public final void kafka$log$OffsetIndex$$forceUnmap(MappedByteBuffer m) {
        try {
            if (m instanceof DirectBuffer) {
                ((DirectBuffer)((Object)m)).cleaner().clean();
            }
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Error when freeing index buffer";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable t$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = throwable;
                }
            });
        }
    }

    public void flush() {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final MappedByteBuffer apply() {
                return this.$outer.kafka$log$OffsetIndex$$mmap().force();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean delete() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Deleting index ").append((Object)this.$outer.file().getAbsolutePath()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        return this.file().delete();
    }

    public int entries() {
        return this.kafka$log$OffsetIndex$$size().get();
    }

    public int sizeInBytes() {
        return 8 * this.entries();
    }

    public void close() {
        this.trimToValidSize();
    }

    /*
     * WARNING - void declaration
     */
    public boolean renameTo(File f) {
        void var2_2;
        boolean success = this.file().renameTo(f);
        this.file_$eq(f);
        return (boolean)var2_2;
    }

    public void sanityCheck() {
        Predef$.MODULE$.require(this.entries() == 0 || this.lastOffset() > this.baseOffset(), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Corrupt index found, index file (%s) has non-zero size but the last offset is %d and the base offset is %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath(), BoxesRunTime.boxToLong((long)this.$outer.lastOffset()), BoxesRunTime.boxToLong((long)this.$outer.baseOffset())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        long len$1 = this.file().length();
        Predef$.MODULE$.require(len$1 % 8L == 0L, (Function0)new Serializable(this, len$1){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;
            private final long len$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Index file ").append((Object)this.$outer.file().getName()).append((Object)" is corrupt, found ").append((Object)BoxesRunTime.boxToLong((long)this.len$1)).append((Object)" bytes which is not positive or not a multiple of 8.").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.len$1 = l;
            }
        });
    }

    public final int kafka$log$OffsetIndex$$roundToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    private <T> T maybeLock(Lock lock2, Function0<T> fun) {
        if (Os$.MODULE$.isWindows()) {
            lock2.lock();
        }
        Object exceptionResult1 = null;
        try {
            return (T)fun.apply();
        }
        finally {
            if (Os$.MODULE$.isWindows()) {
                lock2.unlock();
            }
        }
    }

    private final MappedByteBuffer liftedTree1$1(boolean bl, RandomAccessFile randomAccessFile) {
        MappedByteBuffer exceptionResult2 = null;
        try {
            if (bl) {
                if (this.maxIndexSize() < 8) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxIndexSize())).toString());
                }
                randomAccessFile.setLength(this.kafka$log$OffsetIndex$$roundToExactMultiple(this.maxIndexSize(), 8));
            }
            long len = randomAccessFile.length();
            MappedByteBuffer idx = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, len);
            Buffer buffer = bl ? idx.position(0) : idx.position(this.kafka$log$OffsetIndex$$roundToExactMultiple(idx.limit(), 8));
            exceptionResult2 = idx;
            Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, randomAccessFile){
                public static final long serialVersionUID;
                private final RandomAccessFile raf$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.raf$1.close();
                }
                {
                    this.raf$1 = randomAccessFile;
                }
            });
            return exceptionResult2;
        }
        catch (Throwable throwable) {
            Utils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
    }

    public OffsetIndex(File file, long baseOffset, int maxIndexSize) {
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        Logging$class.$init$(this);
        this.lock = new ReentrantLock();
        boolean newlyCreated$1 = this.file().createNewFile();
        RandomAccessFile raf$1 = new RandomAccessFile(this.file(), "rw");
        this.kafka$log$OffsetIndex$$mmap = this.liftedTree1$1(newlyCreated$1, raf$1);
        this.kafka$log$OffsetIndex$$size = new AtomicInteger(this.kafka$log$OffsetIndex$$mmap().position() / 8);
        this.maxEntries = this.kafka$log$OffsetIndex$$mmap().limit() / 8;
        this.lastOffset = this.readLastEntry().offset();
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Loaded index file %s with maxEntries = %d, maxIndexSize = %d, entries = %d, lastOffset = %d, file position = %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.$outer.maxEntries()), BoxesRunTime.boxToInteger((int)this.$outer.maxIndexSize()), BoxesRunTime.boxToInteger((int)this.$outer.entries()), BoxesRunTime.boxToLong((long)this.$outer.lastOffset()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$mmap().position())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

